/**********************************************************/
/*  PopCliD.cmd - popclient Daemon                        */
/*  (C) Copyright Claudio Fahey, 1994                     */
/*  e-mail: claudio@uclink.berkeley.edu                   */
/**********************************************************/

/*********************************************************/
/* Edit the following lines to configure this program:   */
/*********************************************************/

host = 'myhost.berkeley.edu'        /* POP host name                */
loginname = 'myname'                /* Login name on the host       */
password = 'mypass'                 /* Password on the host         */
delay = 120                         /* Seconds between mail checks  */

/* If you're using LaMail, modify the INBOX path below as necessary */

    mda_path = value('COMSPEC',,'OS2ENVIRONMENT')
    mda_args = '/C LAMAILER.CMD -dest E:\TCPIP\ETC\MAIL -to $u'

/* If you're using Ultimedia Mail/2, uncomment the following two 
   lines and modify the INBOX path below as necessary               */
/*
    mda_path = 'UMAILER.EXE'
    mda_args = '-dest E:\TCPIP\UMail\Server\INBOX -to $u'
*/

/**********************************************************/
/* You should not need to modify anything below this line */
/**********************************************************/

signal on halt  /* don't display REXX error message when user breaks out */

/* Load RexxUtil for syssleep */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* When mail arrives, popclient runs the mail delivery agent
   specified by MDA_PATH with arguments MDA_ARGS.  This
   sets the environment to the correct MDA                      */
rc = value('MDA_PATH',mda_path,'OS2ENVIRONMENT')
rc = value('MDA_ARGS',mda_args,'OS2ENVIRONMENT')

do forever
    '@popclient -u' loginname '-p' password host

    /* If there's an error, just beep and continue */
    if rc > 1 then do
        say 'POPCLID.CMD: POPCLIENT.EXE returned error ('rc')'
        call beep 400, 500
        end

    /* wait for a specified number of seconds */
    call syssleep delay
    end

halt:

