This is Info file as.info, produced by Makeinfo-1.55 from the input
file ./as.texinfo.

START-INFO-DIR-ENTRY
* As: (as).                     The GNU assembler.
END-INFO-DIR-ENTRY

   This file documents the GNU Assembler "as".

   Copyright (C) 1991, 1992, 1993, 1994 Free Software Foundation, Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided that
the entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions.


File: as.info,  Node: VAX-branch,  Next: VAX-operands,  Prev: VAX-opcodes,  Up: Vax-Dependent

VAX Branch Improvement
----------------------

   Certain pseudo opcodes are permitted.  They are for branch
instructions.  They expand to the shortest branch instruction that
reaches the target.  Generally these mnemonics are made by substituting
`j' for `b' at the start of a DEC mnemonic.  This feature is included
both for compatibility and to help compilers.  If you do not need this
feature, avoid these opcodes.  Here are the mnemonics, and the code
they can expand into.

`jbsb'
     `Jsb' is already an instruction mnemonic, so we chose `jbsb'.
    (byte displacement)
          `bsbb ...'

    (word displacement)
          `bsbw ...'

    (long displacement)
          `jsb ...'

`jbr'
`jr'
     Unconditional branch.
    (byte displacement)
          `brb ...'

    (word displacement)
          `brw ...'

    (long displacement)
          `jmp ...'

`jCOND'
     COND may be any one of the conditional branches `neq', `nequ',
     `eql', `eqlu', `gtr', `geq', `lss', `gtru', `lequ', `vc', `vs',
     `gequ', `cc', `lssu', `cs'.  COND may also be one of the bit tests
     `bs', `bc', `bss', `bcs', `bsc', `bcc', `bssi', `bcci', `lbs',
     `lbc'.  NOTCOND is the opposite condition to COND.
    (byte displacement)
          `bCOND ...'

    (word displacement)
          `bNOTCOND foo ; brw ... ; foo:'

    (long displacement)
          `bNOTCOND foo ; jmp ... ; foo:'

`jacbX'
     X may be one of `b d f g h l w'.
    (word displacement)
          `OPCODE ...'

    (long displacement)
               OPCODE ..., foo ;
               brb bar ;
               foo: jmp ... ;
               bar:

`jaobYYY'
     YYY may be one of `lss leq'.

`jsobZZZ'
     ZZZ may be one of `geq gtr'.
    (byte displacement)
          `OPCODE ...'

    (word displacement)
               OPCODE ..., foo ;
               brb bar ;
               foo: brw DESTINATION ;
               bar:

    (long displacement)
               OPCODE ..., foo ;
               brb bar ;
               foo: jmp DESTINATION ;
               bar:

`aobleq'
`aoblss'
`sobgeq'
`sobgtr'
    (byte displacement)
          `OPCODE ...'

    (word displacement)
               OPCODE ..., foo ;
               brb bar ;
               foo: brw DESTINATION ;
               bar:

    (long displacement)
               OPCODE ..., foo ;
               brb bar ;
               foo: jmp DESTINATION ;
               bar:


File: as.info,  Node: VAX-operands,  Next: VAX-no,  Prev: VAX-branch,  Up: Vax-Dependent

VAX Operands
------------

   The immediate character is `$' for Unix compatibility, not `#' as
DEC writes it.

   The indirect character is `*' for Unix compatibility, not `@' as DEC
writes it.

   The displacement sizing character is ``' (an accent grave) for Unix
compatibility, not `^' as DEC writes it.  The letter preceding ``' may
have either case.  `G' is not understood, but all other letters (`b i l
s w') are understood.

   Register names understood are `r0 r1 r2 ... r15 ap fp sp pc'.  Upper
and lower case letters are equivalent.

   For instance
     tstb *w`$4(r5)

   Any expression is permitted in an operand.  Operands are comma
separated.


File: as.info,  Node: VAX-no,  Prev: VAX-operands,  Up: Vax-Dependent

Not Supported on VAX
--------------------

   Vax bit fields can not be assembled with `as'.  Someone can add the
required code if they really need it.


File: as.info,  Node: AMD29K-Dependent,  Next: H8/300-Dependent,  Prev: Vax-Dependent,  Up: Machine Dependencies

AMD 29K Dependent Features
==========================

* Menu:

* AMD29K Options::              Options
* AMD29K Syntax::               Syntax
* AMD29K Floating Point::       Floating Point
* AMD29K Directives::           AMD 29K Machine Directives
* AMD29K Opcodes::              Opcodes


File: as.info,  Node: AMD29K Options,  Next: AMD29K Syntax,  Up: AMD29K-Dependent

Options
-------

   `as' has no additional command-line options for the AMD 29K family.


File: as.info,  Node: AMD29K Syntax,  Next: AMD29K Floating Point,  Prev: AMD29K Options,  Up: AMD29K-Dependent

Syntax
------

* Menu:

* AMD29K-Chars::                Special Characters
* AMD29K-Regs::                 Register Names


File: as.info,  Node: AMD29K-Chars,  Next: AMD29K-Regs,  Up: AMD29K Syntax

Special Characters
..................

   `;' is the line comment character.

   `@' can be used instead of a newline to separate statements.

   The character `?' is permitted in identifiers (but may not begin an
identifier).


File: as.info,  Node: AMD29K-Regs,  Prev: AMD29K-Chars,  Up: AMD29K Syntax

Register Names
..............

   General-purpose registers are represented by predefined symbols of
the form `GRNNN' (for global registers) or `LRNNN' (for local
registers), where NNN represents a number between `0' and `127',
written with no leading zeros.  The leading letters may be in either
upper or lower case; for example, `gr13' and `LR7' are both valid
register names.

   You may also refer to general-purpose registers by specifying the
register number as the result of an expression (prefixed with `%%' to
flag the expression as a register number):
     %%EXPRESSION

--where EXPRESSION must be an absolute expression evaluating to a
number between `0' and `255'.  The range [0, 127] refers to global
registers, and the range [128, 255] to local registers.

   In addition, `as' understands the following protected
special-purpose register names for the AMD 29K family:

       vab    chd    pc0
       ops    chc    pc1
       cps    rbp    pc2
       cfg    tmc    mmu
       cha    tmr    lru

   These unprotected special-purpose register names are also recognized:
       ipc    alu    fpe
       ipa    bp     inte
       ipb    fc     fps
       q      cr     exop


File: as.info,  Node: AMD29K Floating Point,  Next: AMD29K Directives,  Prev: AMD29K Syntax,  Up: AMD29K-Dependent

Floating Point
--------------

   The AMD 29K family uses IEEE floating-point numbers.


File: as.info,  Node: AMD29K Directives,  Next: AMD29K Opcodes,  Prev: AMD29K Floating Point,  Up: AMD29K-Dependent

AMD 29K Machine Directives
--------------------------

`.block SIZE , FILL'
     This directive emits SIZE bytes, each of value FILL.  Both SIZE
     and FILL are absolute expressions.  If the comma and FILL are
     omitted, FILL is assumed to be zero.

     In other versions of the GNU assembler, this directive is called
     `.space'.

`.cputype'
     This directive is ignored; it is accepted for compatibility with
     other AMD 29K assemblers.

`.file'
     This directive is ignored; it is accepted for compatibility with
     other AMD 29K assemblers.

          *Warning:* in other versions of the GNU assembler, `.file' is
          used for the directive called `.app-file' in the AMD 29K
          support.

`.line'
     This directive is ignored; it is accepted for compatibility with
     other AMD 29K assemblers.

`.sect'
     This directive is ignored; it is accepted for compatibility with
     other AMD 29K assemblers.

`.use SECTION NAME'
     Establishes the section and subsection for the following code;
     SECTION NAME may be one of `.text', `.data', `.data1', or `.lit'.
     With one of the first three SECTION NAME options, `.use' is
     equivalent to the machine directive SECTION NAME; the remaining
     case, `.use .lit', is the same as `.data 200'.


File: as.info,  Node: AMD29K Opcodes,  Prev: AMD29K Directives,  Up: AMD29K-Dependent

Opcodes
-------

   `as' implements all the standard AMD 29K opcodes.  No additional
pseudo-instructions are needed on this family.

   For information on the 29K machine instruction set, see `Am29000
User's Manual', Advanced Micro Devices, Inc.


File: as.info,  Node: H8/300-Dependent,  Next: H8/500-Dependent,  Prev: AMD29K-Dependent,  Up: Machine Dependencies

H8/300 Dependent Features
=========================

* Menu:

* H8/300 Options::              Options
* H8/300 Syntax::               Syntax
* H8/300 Floating Point::       Floating Point
* H8/300 Directives::           H8/300 Machine Directives
* H8/300 Opcodes::              Opcodes


File: as.info,  Node: H8/300 Options,  Next: H8/300 Syntax,  Up: H8/300-Dependent

Options
-------

   `as' has no additional command-line options for the Hitachi H8/300
family.


File: as.info,  Node: H8/300 Syntax,  Next: H8/300 Floating Point,  Prev: H8/300 Options,  Up: H8/300-Dependent

Syntax
------

* Menu:

* H8/300-Chars::                Special Characters
* H8/300-Regs::                 Register Names
* H8/300-Addressing::           Addressing Modes


File: as.info,  Node: H8/300-Chars,  Next: H8/300-Regs,  Up: H8/300 Syntax

Special Characters
..................

   `;' is the line comment character.

   `$' can be used instead of a newline to separate statements.
Therefore *you may not use `$' in symbol names* on the H8/300.


File: as.info,  Node: H8/300-Regs,  Next: H8/300-Addressing,  Prev: H8/300-Chars,  Up: H8/300 Syntax

Register Names
..............

   You can use predefined symbols of the form `rNh' and `rNl' to refer
to the H8/300 registers as sixteen 8-bit general-purpose registers.  N
is a digit from `0' to `7'); for instance, both `r0h' and `r7l' are
valid register names.

   You can also use the eight predefined symbols `rN' to refer to the
H8/300 registers as 16-bit registers (you must use this form for
addressing).

   On the H8/300H, you can also use the eight predefined symbols `erN'
(`er0' ... `er7') to refer to the 32-bit general purpose registers.

   The two control registers are called `pc' (program counter; a 16-bit
register, except on the H8/300H where it is 24 bits) and `ccr'
(condition code register; an 8-bit register).  `r7' is used as the
stack pointer, and can also be called `sp'.


File: as.info,  Node: H8/300-Addressing,  Prev: H8/300-Regs,  Up: H8/300 Syntax

Addressing Modes
................

   as understands the following addressing modes for the H8/300:
`rN'
     Register direct

`@rN'
     Register indirect

`@(D, rN)'
`@(D:16, rN)'
`@(D:24, rN)'
     Register indirect: 16-bit or 24-bit displacement D from register
     N.  (24-bit displacements are only meaningful on the H8/300H.)

`@rN+'
     Register indirect with post-increment

`@-rN'
     Register indirect with pre-decrement

``@'AA'
``@'AA:8'
``@'AA:16'
``@'AA:24'
     Absolute address `aa'.  (The address size `:24' only makes sense
     on the H8/300H.)

`#XX'
`#XX:8'
`#XX:16'
`#XX:32'
     Immediate data XX.  You may specify the `:8', `:16', or `:32' for
     clarity, if you wish; but `as' neither requires this nor uses
     it--the data size required is taken from context.

``@'`@'AA'
``@'`@'AA:8'
     Memory indirect.  You may specify the `:8' for clarity, if you
     wish; but `as' neither requires this nor uses it.


File: as.info,  Node: H8/300 Floating Point,  Next: H8/300 Directives,  Prev: H8/300 Syntax,  Up: H8/300-Dependent

Floating Point
--------------

   The H8/300 family has no hardware floating point, but the `.float'
directive generates IEEE floating-point numbers for compatibility with
other development tools.


File: as.info,  Node: H8/300 Directives,  Next: H8/300 Opcodes,  Prev: H8/300 Floating Point,  Up: H8/300-Dependent

H8/300 Machine Directives
-------------------------

   `as' has only one machine-dependent directive for the H8/300:

`.h300h'
     Recognize and emit additional instructions for the H8/300H
     variant, and also make `.int' emit 32-bit numbers rather than the
     usual (16-bit) for the H8/300 family.

   On the H8/300 family (including the H8/300H) `.word' directives
generate 16-bit numbers.


File: as.info,  Node: H8/300 Opcodes,  Prev: H8/300 Directives,  Up: H8/300-Dependent

Opcodes
-------

   For detailed information on the H8/300 machine instruction set, see
`H8/300 Series Programming Manual' (Hitachi ADE-602-025).  For
information specific to the H8/300H, see `H8/300H Series Programming
Manual' (Hitachi).

   `as' implements all the standard H8/300 opcodes.  No additional
pseudo-instructions are needed on this family.

   The following table summarizes the H8/300 opcodes, and their
arguments.  Entries marked `*' are opcodes used only on the H8/300H.

              Legend:
                 Rs   source register
                 Rd   destination register
                 abs  absolute address
                 imm  immediate data
              disp:N  N-bit displacement from a register
             pcrel:N  N-bit displacement relative to program counter
     
        add.b #imm,rd              *  andc #imm,ccr
        add.b rs,rd                   band #imm,rd
        add.w rs,rd                   band #imm,@rd
     *  add.w #imm,rd                 band #imm,@abs:8
     *  add.l rs,rd                   bra  pcrel:8
     *  add.l #imm,rd              *  bra  pcrel:16
        adds #imm,rd                  bt   pcrel:8
        addx #imm,rd               *  bt   pcrel:16
        addx rs,rd                    brn  pcrel:8
        and.b #imm,rd              *  brn  pcrel:16
        and.b rs,rd                   bf   pcrel:8
     *  and.w rs,rd                *  bf   pcrel:16
     *  and.w #imm,rd                 bhi  pcrel:8
     *  and.l #imm,rd              *  bhi  pcrel:16
     *  and.l rs,rd                   bls  pcrel:8
     
     *  bls  pcrel:16                 bld  #imm,rd
        bcc  pcrel:8                  bld  #imm,@rd
     *  bcc  pcrel:16                 bld  #imm,@abs:8
        bhs  pcrel:8                  bnot #imm,rd
     *  bhs  pcrel:16                 bnot #imm,@rd
        bcs  pcrel:8                  bnot #imm,@abs:8
     *  bcs  pcrel:16                 bnot rs,rd
        blo  pcrel:8                  bnot rs,@rd
     *  blo  pcrel:16                 bnot rs,@abs:8
        bne  pcrel:8                  bor  #imm,rd
     *  bne  pcrel:16                 bor  #imm,@rd
        beq  pcrel:8                  bor  #imm,@abs:8
     *  beq  pcrel:16                 bset #imm,rd
        bvc  pcrel:8                  bset #imm,@rd
     *  bvc  pcrel:16                 bset #imm,@abs:8
        bvs  pcrel:8                  bset rs,rd
     *  bvs  pcrel:16                 bset rs,@rd
        bpl  pcrel:8                  bset rs,@abs:8
     *  bpl  pcrel:16                 bsr  pcrel:8
        bmi  pcrel:8                  bsr  pcrel:16
     *  bmi  pcrel:16                 bst  #imm,rd
        bge  pcrel:8                  bst  #imm,@rd
     *  bge  pcrel:16                 bst  #imm,@abs:8
        blt  pcrel:8                  btst #imm,rd
     *  blt  pcrel:16                 btst #imm,@rd
        bgt  pcrel:8                  btst #imm,@abs:8
     *  bgt  pcrel:16                 btst rs,rd
        ble  pcrel:8                  btst rs,@rd
     *  ble  pcrel:16                 btst rs,@abs:8
        bclr #imm,rd                  bxor #imm,rd
        bclr #imm,@rd                 bxor #imm,@rd
        bclr #imm,@abs:8              bxor #imm,@abs:8
        bclr rs,rd                    cmp.b #imm,rd
        bclr rs,@rd                   cmp.b rs,rd
        bclr rs,@abs:8                cmp.w rs,rd
        biand #imm,rd                 cmp.w rs,rd
        biand #imm,@rd             *  cmp.w #imm,rd
        biand #imm,@abs:8          *  cmp.l #imm,rd
        bild #imm,rd               *  cmp.l rs,rd
        bild #imm,@rd                 daa  rs
        bild #imm,@abs:8              das  rs
        bior #imm,rd                  dec.b rs
        bior #imm,@rd              *  dec.w #imm,rd
        bior #imm,@abs:8           *  dec.l #imm,rd
        bist #imm,rd                  divxu.b rs,rd
        bist #imm,@rd              *  divxu.w rs,rd
        bist #imm,@abs:8           *  divxs.b rs,rd
        bixor #imm,rd              *  divxs.w rs,rd
        bixor #imm,@rd                eepmov
        bixor #imm,@abs:8          *  eepmovw
     
     *  exts.w rd                     mov.w rs,@abs:16
     *  exts.l rd                  *  mov.l #imm,rd
     *  extu.w rd                  *  mov.l rs,rd
     *  extu.l rd                  *  mov.l @rs,rd
        inc  rs                    *  mov.l @(disp:16,rs),rd
     *  inc.w #imm,rd              *  mov.l @(disp:24,rs),rd
     *  inc.l #imm,rd              *  mov.l @rs+,rd
        jmp  @rs                   *  mov.l @abs:16,rd
        jmp  abs                   *  mov.l @abs:24,rd
        jmp  @@abs:8               *  mov.l rs,@rd
        jsr  @rs                   *  mov.l rs,@(disp:16,rd)
        jsr  abs                   *  mov.l rs,@(disp:24,rd)
        jsr  @@abs:8               *  mov.l rs,@-rd
        ldc  #imm,ccr              *  mov.l rs,@abs:16
        ldc  rs,ccr                *  mov.l rs,@abs:24
     *  ldc  @abs:16,ccr              movfpe @abs:16,rd
     *  ldc  @abs:24,ccr              movtpe rs,@abs:16
     *  ldc  @(disp:16,rs),ccr        mulxu.b rs,rd
     *  ldc  @(disp:24,rs),ccr     *  mulxu.w rs,rd
     *  ldc  @rs+,ccr              *  mulxs.b rs,rd
     *  ldc  @rs,ccr               *  mulxs.w rs,rd
     *  mov.b @(disp:24,rs),rd        neg.b rs
     *  mov.b rs,@(disp:24,rd)     *  neg.w rs
        mov.b @abs:16,rd           *  neg.l rs
        mov.b rs,rd                   nop
        mov.b @abs:8,rd               not.b rs
        mov.b rs,@abs:8            *  not.w rs
        mov.b rs,rd                *  not.l rs
        mov.b #imm,rd                 or.b #imm,rd
        mov.b @rs,rd                  or.b rs,rd
        mov.b @(disp:16,rs),rd     *  or.w #imm,rd
        mov.b @rs+,rd              *  or.w rs,rd
        mov.b @abs:8,rd            *  or.l #imm,rd
        mov.b rs,@rd               *  or.l rs,rd
        mov.b rs,@(disp:16,rd)        orc  #imm,ccr
        mov.b rs,@-rd                 pop.w rs
        mov.b rs,@abs:8            *  pop.l rs
        mov.w rs,@rd                  push.w rs
     *  mov.w @(disp:24,rs),rd     *  push.l rs
     *  mov.w rs,@(disp:24,rd)        rotl.b rs
     *  mov.w @abs:24,rd           *  rotl.w rs
     *  mov.w rs,@abs:24           *  rotl.l rs
        mov.w rs,rd                   rotr.b rs
        mov.w #imm,rd              *  rotr.w rs
        mov.w @rs,rd               *  rotr.l rs
        mov.w @(disp:16,rs),rd        rotxl.b rs
        mov.w @rs+,rd              *  rotxl.w rs
        mov.w @abs:16,rd           *  rotxl.l rs
        mov.w rs,@(disp:16,rd)        rotxr.b rs
        mov.w rs,@-rd              *  rotxr.w rs
     
     *  rotxr.l rs                 *  stc  ccr,@(disp:24,rd)
        bpt                        *  stc  ccr,@-rd
        rte                        *  stc  ccr,@abs:16
        rts                        *  stc  ccr,@abs:24
        shal.b rs                     sub.b rs,rd
     *  shal.w rs                     sub.w rs,rd
     *  shal.l rs                  *  sub.w #imm,rd
        shar.b rs                  *  sub.l rs,rd
     *  shar.w rs                  *  sub.l #imm,rd
     *  shar.l rs                     subs #imm,rd
        shll.b rs                     subx #imm,rd
     *  shll.w rs                     subx rs,rd
     *  shll.l rs                  *  trapa #imm
        shlr.b rs                     xor  #imm,rd
     *  shlr.w rs                     xor  rs,rd
     *  shlr.l rs                  *  xor.w #imm,rd
        sleep                      *  xor.w rs,rd
        stc  ccr,rd                *  xor.l #imm,rd
     *  stc  ccr,@rs               *  xor.l rs,rd
     *  stc  ccr,@(disp:16,rd)        xorc #imm,ccr

   Four H8/300 instructions (`add', `cmp', `mov', `sub') are defined
with variants using the suffixes `.b', `.w', and `.l' to specify the
size of a memory operand.  `as' supports these suffixes, but does not
require them; since one of the operands is always a register, `as' can
deduce the correct size.

   For example, since `r0' refers to a 16-bit register,
     mov    r0,@foo
is equivalent to
     mov.w  r0,@foo

   If you use the size suffixes, `as' issues a warning when the suffix
and the register size do not match.


File: as.info,  Node: H8/500-Dependent,  Next: HPPA-Dependent,  Prev: H8/300-Dependent,  Up: Machine Dependencies

H8/500 Dependent Features
=========================

* Menu:

* H8/500 Options::              Options
* H8/500 Syntax::               Syntax
* H8/500 Floating Point::       Floating Point
* H8/500 Directives::           H8/500 Machine Directives
* H8/500 Opcodes::              Opcodes


File: as.info,  Node: H8/500 Options,  Next: H8/500 Syntax,  Up: H8/500-Dependent

Options
-------

   `as' has no additional command-line options for the Hitachi H8/500
family.


File: as.info,  Node: H8/500 Syntax,  Next: H8/500 Floating Point,  Prev: H8/500 Options,  Up: H8/500-Dependent

Syntax
------

* Menu:

* H8/500-Chars::                Special Characters
* H8/500-Regs::                 Register Names
* H8/500-Addressing::           Addressing Modes


File: as.info,  Node: H8/500-Chars,  Next: H8/500-Regs,  Up: H8/500 Syntax

Special Characters
..................

   `!' is the line comment character.

   `;' can be used instead of a newline to separate statements.

   Since `$' has no special meaning, you may use it in symbol names.


File: as.info,  Node: H8/500-Regs,  Next: H8/500-Addressing,  Prev: H8/500-Chars,  Up: H8/500 Syntax

Register Names
..............

   You can use the predefined symbols `r0', `r1', `r2', `r3', `r4',
`r5', `r6', and `r7' to refer to the H8/500 registers.

   The H8/500 also has these control registers:

`cp'
     code pointer

`dp'
     data pointer

`bp'
     base pointer

`tp'
     stack top pointer

`ep'
     extra pointer

`sr'
     status register

`ccr'
     condition code register

   All registers are 16 bits long.  To represent 32 bit numbers, use two
adjacent registers; for distant memory addresses, use one of the segment
pointers (`cp' for the program counter; `dp' for `r0'-`r3'; `ep' for
`r4' and `r5'; and `tp' for `r6' and `r7'.


File: as.info,  Node: H8/500-Addressing,  Prev: H8/500-Regs,  Up: H8/500 Syntax

Addressing Modes
................

   as understands the following addressing modes for the H8/500:
`RN'
     Register direct

`@RN'
     Register indirect

`@(d:8, RN)'
     Register indirect with 8 bit signed displacement

`@(d:16, RN)'
     Register indirect with 16 bit signed displacement

`@-RN'
     Register indirect with pre-decrement

`@RN+'
     Register indirect with post-increment

`@AA:8'
     8 bit absolute address

`@AA:16'
     16 bit absolute address

`#XX:8'
     8 bit immediate

`#XX:16'
     16 bit immediate


File: as.info,  Node: H8/500 Floating Point,  Next: H8/500 Directives,  Prev: H8/500 Syntax,  Up: H8/500-Dependent

Floating Point
--------------

   The H8/500 family uses IEEE floating-point numbers.


File: as.info,  Node: H8/500 Directives,  Next: H8/500 Opcodes,  Prev: H8/500 Floating Point,  Up: H8/500-Dependent

H8/500 Machine Directives
-------------------------

   `as' has no machine-dependent directives for the H8/500.  However,
on this platform the `.int' and `.word' directives generate 16-bit
numbers.


File: as.info,  Node: H8/500 Opcodes,  Prev: H8/500 Directives,  Up: H8/500-Dependent

Opcodes
-------

   For detailed information on the H8/500 machine instruction set, see
`H8/500 Series Programming Manual' (Hitachi M21T001).

   `as' implements all the standard H8/500 opcodes.  No additional
pseudo-instructions are needed on this family.

   The following table summarizes H8/500 opcodes and their operands:

     Legend:
     abs8      8-bit absolute address
     abs16     16-bit absolute address
     abs24     24-bit absolute address
     crb       `ccr', `br', `ep', `dp', `tp', `dp'
     disp8     8-bit displacement
     ea        `rn', `@rn', `@(d:8, rn)', `@(d:16, rn)',
               `@-rn', `@rn+', `@aa:8', `@aa:16',
               `#xx:8', `#xx:16'
     ea_mem    `@rn', `@(d:8, rn)', `@(d:16, rn)',
               `@-rn', `@rn+', `@aa:8', `@aa:16'
     ea_noimm  `rn', `@rn', `@(d:8, rn)', `@(d:16, rn)',
               `@-rn', `@rn+', `@aa:8', `@aa:16'
     fp        r6
     imm4      4-bit immediate data
     imm8      8-bit immediate data
     imm16     16-bit immediate data
     pcrel8    8-bit offset from program counter
     pcrel16   16-bit offset from program counter
     qim       `-2', `-1', `1', `2'
     rd        any register
     rs        a register distinct from rd
     rlist     comma-separated list of registers in parentheses;
               register ranges `rd-rs' are allowed
     sp        stack pointer (`r7')
     sr        status register
     sz        size; `.b' or `.w'.  If omitted, default `.w'
     
     ldc[.b] ea,crb                 bcc[.w] pcrel16
     ldc[.w] ea,sr                  bcc[.b] pcrel8
     add[:q] sz qim,ea_noimm        bhs[.w] pcrel16
     add[:g] sz ea,rd               bhs[.b] pcrel8
     adds sz ea,rd                  bcs[.w] pcrel16
     addx sz ea,rd                  bcs[.b] pcrel8
     and sz ea,rd                   blo[.w] pcrel16
     andc[.b] imm8,crb              blo[.b] pcrel8
     andc[.w] imm16,sr              bne[.w] pcrel16
     bpt                            bne[.b] pcrel8
     bra[.w] pcrel16                beq[.w] pcrel16
     bra[.b] pcrel8                 beq[.b] pcrel8
     bt[.w] pcrel16                 bvc[.w] pcrel16
     bt[.b] pcrel8                  bvc[.b] pcrel8
     brn[.w] pcrel16                bvs[.w] pcrel16
     brn[.b] pcrel8                 bvs[.b] pcrel8
     bf[.w] pcrel16                 bpl[.w] pcrel16
     bf[.b] pcrel8                  bpl[.b] pcrel8
     bhi[.w] pcrel16                bmi[.w] pcrel16
     bhi[.b] pcrel8                 bmi[.b] pcrel8
     bls[.w] pcrel16                bge[.w] pcrel16
     bls[.b] pcrel8                 bge[.b] pcrel8
     
     blt[.w] pcrel16                mov[:g][.b] imm8,ea_mem
     blt[.b] pcrel8                 mov[:g][.w] imm16,ea_mem
     bgt[.w] pcrel16                movfpe[.b] ea,rd
     bgt[.b] pcrel8                 movtpe[.b] rs,ea_noimm
     ble[.w] pcrel16                mulxu sz ea,rd
     ble[.b] pcrel8                 neg sz ea
     bclr sz imm4,ea_noimm          nop
     bclr sz rs,ea_noimm            not sz ea
     bnot sz imm4,ea_noimm          or sz ea,rd
     bnot sz rs,ea_noimm            orc[.b] imm8,crb
     bset sz imm4,ea_noimm          orc[.w] imm16,sr
     bset sz rs,ea_noimm            pjmp abs24
     bsr[.b] pcrel8                 pjmp @rd
     bsr[.w] pcrel16                pjsr abs24
     btst sz imm4,ea_noimm          pjsr @rd
     btst sz rs,ea_noimm            prtd imm8
     clr sz ea                      prtd imm16
     cmp[:e][.b] imm8,rd            prts
     cmp[:i][.w] imm16,rd           rotl sz ea
     cmp[:g].b imm8,ea_noimm        rotr sz ea
     cmp[:g][.w] imm16,ea_noimm     rotxl sz ea
     Cmp[:g] sz ea,rd               rotxr sz ea
     dadd rs,rd                     rtd imm8
     divxu sz ea,rd                 rtd imm16
     dsub rs,rd                     rts
     exts[.b] rd                    scb/f rs,pcrel8
     extu[.b] rd                    scb/ne rs,pcrel8
     jmp @rd                        scb/eq rs,pcrel8
     jmp @(imm8,rd)                 shal sz ea
     jmp @(imm16,rd)                shar sz ea
     jmp abs16                      shll sz ea
     jsr @rd                        shlr sz ea
     jsr @(imm8,rd)                 sleep
     jsr @(imm16,rd)                stc[.b] crb,ea_noimm
     jsr abs16                      stc[.w] sr,ea_noimm
     ldm @sp+,(rlist)               stm (rlist),@-sp
     link fp,imm8                   sub sz ea,rd
     link fp,imm16                  subs sz ea,rd
     mov[:e][.b] imm8,rd            subx sz ea,rd
     mov[:i][.w] imm16,rd           swap[.b] rd
     mov[:l][.w] abs8,rd            tas[.b] ea
     mov[:l].b abs8,rd              trapa imm4
     mov[:s][.w] rs,abs8            trap/vs
     mov[:s].b rs,abs8              tst sz ea
     mov[:f][.w] @(disp8,fp),rd     unlk fp
     mov[:f][.w] rs,@(disp8,fp)     xch[.w] rs,rd
     mov[:f].b @(disp8,fp),rd       xor sz ea,rd
     mov[:f].b rs,@(disp8,fp)       xorc.b imm8,crb
     mov[:g] sz rs,ea_mem           xorc.w imm16,sr
     mov[:g] sz ea,rd


File: as.info,  Node: HPPA-Dependent,  Next: SH-Dependent,  Prev: H8/500-Dependent,  Up: Machine Dependencies

HPPA Dependent Features
=======================

* Menu:

* HPPA Notes::                Notes
* HPPA Options::              Options
* HPPA Syntax::               Syntax
* HPPA Floating Point::       Floating Point
* HPPA Directives::           HPPA Machine Directives
* HPPA Opcodes::              Opcodes


File: as.info,  Node: HPPA Notes,  Next: HPPA Options,  Up: HPPA-Dependent

Notes
-----

   As a back end for GNU CC `as' has been throughly tested and should
work extremely well.  We have tested it only minimally on hand written
assembly code and no one has tested it much on the assembly output from
the HP compilers.

   The format of the debugging sections has changed since the original
`as' port (version 1.3X) was released; therefore, you must rebuild all
HPPA objects and libraries with the new assembler so that you can debug
the final executable.

   The HPPA `as' port generates a small subset of the relocations
available in the SOM and ELF object file formats.  Additional relocation
support will be added as it becomes necessary.


File: as.info,  Node: HPPA Options,  Next: HPPA Syntax,  Prev: HPPA Notes,  Up: HPPA-Dependent

Options
-------

   `as' has no machine-dependent command-line options for the HPPA.


File: as.info,  Node: HPPA Syntax,  Next: HPPA Floating Point,  Prev: HPPA Options,  Up: HPPA-Dependent

Syntax
------

   The assembler syntax closely follows the HPPA instruction set
reference manual; assembler directives and general syntax closely
follow the HPPA assembly language reference manual, with a few
noteworthy differences.

   First, a colon may immediately follow a label definition.  This is
simply for compatibility with how most assembly language programmers
write code.

   Some obscure expression parsing problems may affect hand written
code which uses the `spop' instructions, or code which makes significant
use of the `!' line separator.

   `as' is much less forgiving about missing arguments and other
similar oversights than the HP assembler.  `as' notifies you of missing
arguments as syntax errors; this is regarded as a feature, not a bug.

   Finally, `as' allows you to use an external symbol without
explicitly importing the symbol.  *Warning:* in the future this will be
an error for HPPA targets.

   Special characters for HPPA targets include:

   `;' is the line comment character.

   `!' can be used instead of a newline to separate statements.

   Since `$' has no special meaning, you may use it in symbol names.


File: as.info,  Node: HPPA Floating Point,  Next: HPPA Directives,  Prev: HPPA Syntax,  Up: HPPA-Dependent

Floating Point
--------------

   The HPPA family uses IEEE floating-point numbers.


File: as.info,  Node: HPPA Directives,  Next: HPPA Opcodes,  Prev: HPPA Floating Point,  Up: HPPA-Dependent

HPPA Assembler Directives
-------------------------

   `as' for the HPPA supports many additional directives for
compatibility with the native assembler.  This section describes them
only briefly.  For detailed information on HPPA-specific assembler
directives, see `HP9000 Series 800 Assembly Language Reference Manual'
(HP 92432-90001).

   `as' does *not* support the following assembler directives described
in the HP manual:

     .endm           .liston
     .enter          .locct
     .leave          .macro
     .listoff

   Beyond those implemented for compatibility, `as' supports one
additional assembler directive for the HPPA: `.param'.  It conveys
register argument locations for static functions.  Its syntax closely
follows the `.export' directive.

   These are the additional directives in `as' for the HPPA:

`.block N'
`.blockz N'
     Reserve N bytes of storage, and initialize them to zero.

`.call'
     Mark the beginning of a procedure call.  Only the special case
     with *no arguments* is allowed.

`.callinfo [ PARAM=VALUE, ... ]  [ FLAG, ... ]'
     Specify a number of parameters and flags that define the
     environment for a procedure.

     PARAM may be any of `frame' (frame size), `entry_gr' (end of
     general register range), `entry_fr' (end of float register range),
     `entry_sr' (end of space register range).

     The values for FLAG are `calls' or `caller' (proc has
     subroutines), `no_calls' (proc does not call subroutines),
     `save_rp' (preserve return pointer), `save_sp' (proc preserves
     stack pointer), `no_unwind' (do not unwind this proc), `hpux_int'
     (proc is interrupt routine).

`.code'
     Assemble into the standard section called `$TEXT$', subsection
     `$CODE$'.

`.copyright "STRING"'
     In the SOM object format, insert STRING into the object code,
     marked as a copyright string.

`.copyright "STRING"'
     In the ELF object format, insert STRING into the object code,
     marked as a version string.

`.enter'
     Not yet supported; the assembler rejects programs containing this
     directive.

`.entry'
     Mark the beginning of a procedure.

`.exit'
     Mark the end of a procedure.

`.export NAME [ ,TYP ]  [ ,PARAM=R ]'
     Make a procedure NAME available to callers.  TYP, if present, must
     be one of `absolute', `code' (ELF only, not SOM), `data', `entry',
     `data', `entry', `millicode', `plabel', `pri_prog', or `sec_prog'.

     PARAM, if present, provides either relocation information for the
     procedure arguments and result, or a privilege level.  PARAM may be
     `argwN' (where N ranges from `0' to `3', and indicates one of four
     one-word arguments); `rtnval' (the procedure's result); or
     `priv_lev' (privilege level).  For arguments or the result, R
     specifies how to relocate, and must be one of `no' (not
     relocatable), `gr' (argument is in general register), `fr' (in
     floating point register), or `fu' (upper half of float register).
     For `priv_lev', R is an integer.

`.half N'
     Define a two-byte integer constant N; synonym for the portable
     `as' directive `.short'.

`.import NAME [ ,TYP ]'
     Converse of `.export'; make a procedure available to call.  The
     arguments use the same conventions as the first two arguments for
     `.export'.

`.label NAME'
     Define NAME as a label for the current assembly location.

`.leave'
     Not yet supported; the assembler rejects programs containing this
     directive.

`.origin LC'
     Advance location counter to LC. Synonym for the `{No Value For
     "as"}' portable directive `.org'.

`.param NAME [ ,TYP ]  [ ,PARAM=R ]'
     Similar to `.export', but used for static procedures.

`.proc'
     Use preceding the first statement of a procedure.

`.procend'
     Use following the last statement of a procedure.

`LABEL .reg EXPR'
     Synonym for `.equ'; define LABEL with the absolute expression EXPR
     as its value.

`.space SECNAME [ ,PARAMS ]'
     Switch to section SECNAME, creating a new section by that name if
     necessary.  You may only use PARAMS when creating a new section,
     not when switching to an existing one.  SECNAME may identify a
     section by number rather than by name.

     If specified, the list PARAMS declares attributes of the section,
     identified by keywords.  The keywords recognized are `spnum=EXP'
     (identify this section by the number EXP, an absolute expression),
     `sort=EXP' (order sections according to this sort key when linking;
     EXP is an absolute expression), `unloadable' (section contains no
     loadable data), `notdefined' (this section defined elsewhere), and
     `private' (data in this section not available to other programs).

`.spnum SECNAM'
     Allocate four bytes of storage, and initialize them with the
     section number of the section named SECNAM.  (You can define the
     section number with the HPPA `.space' directive.)

`.string "STR"'
     Copy the characters in the string STR to the object file.  *Note
     Strings: Strings, for information on escape sequences you can use
     in `as' strings.

     *Warning!* The HPPA version of `.string' differs from the usual
     `as' definition: it does *not* write a zero byte after copying STR.

`.stringz "STR"'
     Like `.string', but appends a zero byte after copying STR to object
     file.

`.subspa NAME [ ,PARAMS ]'
     Similar to `.space', but selects a subsection NAME within the
     current section.  You may only specify PARAMS when you create a
     subsection (in the first instance of `.subspa' for this NAME).

     If specified, the list PARAMS declares attributes of the
     subsection, identified by keywords.  The keywords recognized are
     `quad=EXPR' ("quadrant" for this subsection), `align=EXPR'
     (alignment for beginning of this subsection; a power of two),
     `access=EXPR' (value for "access rights" field), `sort=EXPR'
     (sorting order for this subspace in link), `code_only' (subsection
     contains only code), `unloadable' (subsection cannot be loaded
     into memory), `common' (subsection is common block), `dup_comm'
     (initialized data may have duplicate names), or `zero' (subsection
     is all zeros, do not write in object file).

`.version "STR"'
     Write STR as version identifier in object code.


File: as.info,  Node: HPPA Opcodes,  Prev: HPPA Directives,  Up: HPPA-Dependent

Opcodes
-------

   For detailed information on the HPPA machine instruction set, see
`PA-RISC Architecture and Instruction Set Reference Manual' (HP
09740-90039).


File: as.info,  Node: SH-Dependent,  Next: i960-Dependent,  Prev: HPPA-Dependent,  Up: Machine Dependencies

Hitachi SH Dependent Features
=============================

* Menu:

* SH Options::              Options
* SH Syntax::               Syntax
* SH Floating Point::       Floating Point
* SH Directives::           SH Machine Directives
* SH Opcodes::              Opcodes


File: as.info,  Node: SH Options,  Next: SH Syntax,  Up: SH-Dependent

Options
-------

   `as' has no additional command-line options for the Hitachi SH
family.


File: as.info,  Node: SH Syntax,  Next: SH Floating Point,  Prev: SH Options,  Up: SH-Dependent

Syntax
------

* Menu:

* SH-Chars::                Special Characters
* SH-Regs::                 Register Names
* SH-Addressing::           Addressing Modes


File: as.info,  Node: SH-Chars,  Next: SH-Regs,  Up: SH Syntax

Special Characters
..................

   `!' is the line comment character.

   You can use `;' instead of a newline to separate statements.

   Since `$' has no special meaning, you may use it in symbol names.


File: as.info,  Node: SH-Regs,  Next: SH-Addressing,  Prev: SH-Chars,  Up: SH Syntax

Register Names
..............

   You can use the predefined symbols `r0', `r1', `r2', `r3', `r4',
`r5', `r6', `r7', `r8', `r9', `r10', `r11', `r12', `r13', `r14', and
`r15' to refer to the SH registers.

   The SH also has these control registers:

`pr'
     procedure register (holds return address)

`pc'
     program counter

`mach'
`macl'
     high and low multiply accumulator registers

`sr'
     status register

`gbr'
     global base register

`vbr'
     vector base register (for interrupt vectors)


File: as.info,  Node: SH-Addressing,  Prev: SH-Regs,  Up: SH Syntax

Addressing Modes
................

   `as' understands the following addressing modes for the SH.  `RN' in
the following refers to any of the numbered registers, but *not* the
control registers.

`RN'
     Register direct

`@RN'
     Register indirect

`@-RN'
     Register indirect with pre-decrement

`@RN+'
     Register indirect with post-increment

`@(DISP, RN)'
     Register indirect with displacement

`@(R0, RN)'
     Register indexed

`@(DISP, GBR)'
     `GBR' offset

`@(R0, GBR)'
     GBR indexed

`ADDR'
`@(DISP, PC)'
     PC relative address (for branch or for addressing memory).  The
     `as' implementation allows you to use the simpler form ADDR
     anywhere a PC relative address is called for; the alternate form
     is supported for compatibility with other assemblers.

`#IMM'
     Immediate data


File: as.info,  Node: SH Floating Point,  Next: SH Directives,  Prev: SH Syntax,  Up: SH-Dependent

Floating Point
--------------

   The SH family uses IEEE floating-point numbers.


File: as.info,  Node: SH Directives,  Next: SH Opcodes,  Prev: SH Floating Point,  Up: SH-Dependent

SH Machine Directives
---------------------

   `as' has no machine-dependent directives for the SH.


File: as.info,  Node: SH Opcodes,  Prev: SH Directives,  Up: SH-Dependent

Opcodes
-------

   For detailed information on the SH machine instruction set, see
`SH-Microcomputer User's Manual' (Hitachi Micro Systems, Inc.).

   `as' implements all the standard SH opcodes.  No additional
pseudo-instructions are needed on this family.  Note, however, that
because `as' supports a simpler form of PC-relative addressing, you may
simply write (for example)

     mov.l  bar,r0

where other assemblers might require an explicit displacement to `bar'
from the program counter:

     mov.l  @(DISP, PC)

   Here is a summary of SH opcodes:

     Legend:
     Rn        a numbered register
     Rm        another numbered register
     #imm      immediate data
     disp      displacement
     disp8     8-bit displacement
     disp12    12-bit displacement
     
     add #imm,Rn                    lds.l @Rn+,PR
     add Rm,Rn                      mac.w @Rm+,@Rn+
     addc Rm,Rn                     mov #imm,Rn
     addv Rm,Rn                     mov Rm,Rn
     and #imm,R0                    mov.b Rm,@(R0,Rn)
     and Rm,Rn                      mov.b Rm,@-Rn
     and.b #imm,@(R0,GBR)           mov.b Rm,@Rn
     bf disp8                       mov.b @(disp,Rm),R0
     bra disp12                     mov.b @(disp,GBR),R0
     bsr disp12                     mov.b @(R0,Rm),Rn
     bt disp8                       mov.b @Rm+,Rn
     clrmac                         mov.b @Rm,Rn
     clrt                           mov.b R0,@(disp,Rm)
     cmp/eq #imm,R0                 mov.b R0,@(disp,GBR)
     cmp/eq Rm,Rn                   mov.l Rm,@(disp,Rn)
     cmp/ge Rm,Rn                   mov.l Rm,@(R0,Rn)
     cmp/gt Rm,Rn                   mov.l Rm,@-Rn
     cmp/hi Rm,Rn                   mov.l Rm,@Rn
     cmp/hs Rm,Rn                   mov.l @(disp,Rn),Rm
     cmp/pl Rn                      mov.l @(disp,GBR),R0
     cmp/pz Rn                      mov.l @(disp,PC),Rn
     cmp/str Rm,Rn                  mov.l @(R0,Rm),Rn
     div0s Rm,Rn                    mov.l @Rm+,Rn
     div0u                          mov.l @Rm,Rn
     div1 Rm,Rn                     mov.l R0,@(disp,GBR)
     exts.b Rm,Rn                   mov.w Rm,@(R0,Rn)
     exts.w Rm,Rn                   mov.w Rm,@-Rn
     extu.b Rm,Rn                   mov.w Rm,@Rn
     extu.w Rm,Rn                   mov.w @(disp,Rm),R0
     jmp @Rn                        mov.w @(disp,GBR),R0
     jsr @Rn                        mov.w @(disp,PC),Rn
     ldc Rn,GBR                     mov.w @(R0,Rm),Rn
     ldc Rn,SR                      mov.w @Rm+,Rn
     ldc Rn,VBR                     mov.w @Rm,Rn
     ldc.l @Rn+,GBR                 mov.w R0,@(disp,Rm)
     ldc.l @Rn+,SR                  mov.w R0,@(disp,GBR)
     ldc.l @Rn+,VBR                 mova @(disp,PC),R0
     lds Rn,MACH                    movt Rn
     lds Rn,MACL                    muls Rm,Rn
     lds Rn,PR                      mulu Rm,Rn
     lds.l @Rn+,MACH                neg Rm,Rn
     lds.l @Rn+,MACL                negc Rm,Rn
     
     nop                            stc VBR,Rn
     not Rm,Rn                      stc.l GBR,@-Rn
     or #imm,R0                     stc.l SR,@-Rn
     or Rm,Rn                       stc.l VBR,@-Rn
     or.b #imm,@(R0,GBR)            sts MACH,Rn
     rotcl Rn                       sts MACL,Rn
     rotcr Rn                       sts PR,Rn
     rotl Rn                        sts.l MACH,@-Rn
     rotr Rn                        sts.l MACL,@-Rn
     rte                            sts.l PR,@-Rn
     rts                            sub Rm,Rn
     sett                           subc Rm,Rn
     shal Rn                        subv Rm,Rn
     shar Rn                        swap.b Rm,Rn
     shll Rn                        swap.w Rm,Rn
     shll16 Rn                      tas.b @Rn
     shll2 Rn                       trapa #imm
     shll8 Rn                       tst #imm,R0
     shlr Rn                        tst Rm,Rn
     shlr16 Rn                      tst.b #imm,@(R0,GBR)
     shlr2 Rn                       xor #imm,R0
     shlr8 Rn                       xor Rm,Rn
     sleep                          xor.b #imm,@(R0,GBR)
     stc GBR,Rn                     xtrct Rm,Rn
     stc SR,Rn


File: as.info,  Node: i960-Dependent,  Next: M68K-Dependent,  Prev: SH-Dependent,  Up: Machine Dependencies

Intel 80960 Dependent Features
==============================

* Menu:

* Options-i960::                i960 Command-line Options
* Floating Point-i960::         Floating Point
* Directives-i960::             i960 Machine Directives
* Opcodes for i960::            i960 Opcodes


File: as.info,  Node: Options-i960,  Next: Floating Point-i960,  Up: i960-Dependent

i960 Command-line Options
-------------------------

`-ACA | -ACA_A | -ACB | -ACC | -AKA | -AKB | -AKC | -AMC'
     Select the 80960 architecture.  Instructions or features not
     supported by the selected architecture cause fatal errors.

     `-ACA' is equivalent to `-ACA_A'; `-AKC' is equivalent to `-AMC'.
     Synonyms are provided for compatibility with other tools.

     If you do not specify any of these options, `as' generates code
     for any instruction or feature that is supported by *some* version
     of the 960 (even if this means mixing architectures!).  In
     principle, `as' attempts to deduce the minimal sufficient
     processor type if none is specified; depending on the object code
     format, the processor type may be recorded in the object file.  If
     it is critical that the `as' output match a specific architecture,
     specify that architecture explicitly.

`-b'
     Add code to collect information about conditional branches taken,
     for later optimization using branch prediction bits.  (The
     conditional branch instructions have branch prediction bits in the
     CA, CB, and CC architectures.)  If BR represents a conditional
     branch instruction, the following represents the code generated by
     the assembler when `-b' is specified:

                  call    INCREMENT ROUTINE
                  .word   0       # pre-counter
          Label:  BR
                  call    INCREMENT ROUTINE
                  .word   0       # post-counter

     The counter following a branch records the number of times that
     branch was *not* taken; the differenc between the two counters is
     the number of times the branch *was* taken.

     A table of every such `Label' is also generated, so that the
     external postprocessor `gbr960' (supplied by Intel) can locate all
     the counters.  This table is always labelled `__BRANCH_TABLE__';
     this is a local symbol to permit collecting statistics for many
     separate object files.  The table is word aligned, and begins with
     a two-word header.  The first word, initialized to 0, is used in
     maintaining linked lists of branch tables.  The second word is a
     count of the number of entries in the table, which follow
     immediately: each is a word, pointing to one of the labels
     illustrated above.

           +------------+------------+------------+ ... +------------+
           |            |            |            |     |            |
           |  *NEXT     |  COUNT: N  | *BRLAB 1   |     | *BRLAB N   |
           |            |            |            |     |            |
           +------------+------------+------------+ ... +------------+
          
                         __BRANCH_TABLE__ layout

     The first word of the header is used to locate multiple branch
     tables, since each object file may contain one. Normally the links
     are maintained with a call to an initialization routine, placed at
     the beginning of each function in the file.  The GNU C compiler
     generates these calls automatically when you give it a `-b' option.
     For further details, see the documentation of `gbr960'.

`-norelax'
     Normally, Compare-and-Branch instructions with targets that require
     displacements greater than 13 bits (or that have external targets)
     are replaced with the corresponding compare (or `chkbit') and
     branch instructions.  You can use the `-norelax' option to specify
     that `as' should generate errors instead, if the target
     displacement is larger than 13 bits.

     This option does not affect the Compare-and-Jump instructions; the
     code emitted for them is *always* adjusted when necessary
     (depending on displacement size), regardless of whether you use
     `-norelax'.


File: as.info,  Node: Floating Point-i960,  Next: Directives-i960,  Prev: Options-i960,  Up: i960-Dependent

Floating Point
--------------

   `as' generates IEEE floating-point numbers for the directives
`.float', `.double', `.extended', and `.single'.

