;Module   : Flight Screen          File: FSCREEN.ASM
;Function : Draw and Update the Glide Slope Screen
;Input    : None
;Output   : None

TITLE   FSCREEN
.MODEL  SMALL


                .DATA
HL              DW      196d
VL              DW      179d
ULC             DW      218d
URC             DW      191d
LLC             DW      192d
LRC             DW      217d
Carrier         DW      207d
Glide_Slope     DW      174d
Space           DB      " "

        .CODE
        EXTRN   MOVCURS:PROC
        PUBLIC  FSCREEN
FSCREEN PROC
        
; **************************************************************************
; *                 Generate the Bottom of the Flight Screen               *
; **************************************************************************

      
BotmLn: mov     dh,15
        mov     dl,35
        call    movcurs

        mov     bx,1                     ; 1 - DOS Write Screen Function
        mov     cx,1                        ; Word Length set to one
        mov     dx,OFFSET LLC
        mov     ah,40h
        int     21h

        mov     cx,40

LngLn:  push    cx
        mov     cx,1
        mov     dx,OFFSET HL
        mov     ah,40h
        int     21h
        pop     cx
        loop    LngLn

        mov     cx,1
        mov     dx,OFFSET LRC
        mov     ah,40h
        int     21h

; **************************************************************************
; *                    Generate the body of the Flight Screen              *
; *                                                                        *
; * The following method was used for a future improvement that I didn't   *
; * have a chance to incorporate by the time the project was due.          *
; * Eventually the glideslope will consist of alternating colors to        *
; * symbolize a foward motion to the carrier.  Although the current method *
; * takes more processor time 1600 operations, next to a mear 40 if I were *
; * to have it write out the entire string in one pass,  this method       *
; * leaves the option open to me and any future programmers.               *
; *                                                                        *
; **************************************************************************

        sub     dx,dx
        mov     dh,14

body:   push    dx                              ; Save Current Row #
        mov     dl,35                           ; Everything is in Column 35
        call    movcurs

        mov     cx,1                            
        mov     dx,OFFSET vl                    
        mov     ah,40h
        int     21h

        mov     cx,40                           ; The Flight Screen is a 40 x 40 character display
                                                ; There's going to be 38 spaces inbetween vertical lines.

espace: push    cx                              ; Save the Character count onto the stack
        mov     cx,1                            ; We're once again writting one character
        mov     dx,OFFSET space
        mov     ah,40h
        int     21h
        pop     cx                              ; Restore the Character count to prepare for the loop
        LOOP    espace                          ; Loop until there are 38 spaces.

        mov     cx,1                            ; We are going to prepare to write one character
        mov     dx,OFFSET vl                    ; the rightmost Vertical line on the F Screen
        mov     ah,40h
        int     21h

        pop     dx
        cmp     dh,4                            ; We need to stop writing the display at row 4
                                                ; so we don't exceed the 40x40 display
        je      TopLn

        dec     dh
        jmp     body                            ; Loop until end of body

; **************************************************************************
; *                     Generate the Top of the Flight Screen              *
; **************************************************************************

TopLn:  mov     dh,3
        mov     dl,35
        call    movcurs

        mov     bx,1                        ; 1 - DOS Write Screen Function
        mov     cx,1                        ; Word Length set to one
        mov     dx,OFFSET ULC
        mov     ah,40h
        int     21h

        mov     cx,40

LongLn: push    cx
        mov     cx,1
        mov     dx,OFFSET HL
        mov     ah,40h
        int     21h
        pop     cx
        loop    LongLn

        mov     cx,1
        mov     dx,OFFSET URC
        mov     ah,40h
        int     21h

; **************************************************************************
; *      Place the Carrier and the Glide Path inside the FS                *
; *                                                                        *
; * The Carrier as you see from the finished product is just an ASCII      *
; * character, (207d).  I generated the glideslope just as I did the       *
; * flightbox from the bottom up using DX to contain the location of the   *
; * actual points.  This gave me the option of easily changing the slope   *
; * of the path if I felt neccesary. (Which I did several times.)          *
; *                                                                        *
; **************************************************************************
 
        mov     dh,15
        mov     dl,36
        call    movcurs
        
        mov     cx,1                            
        mov     dx,OFFSET Carrier               ; Print the Carrier Character
        mov     ah,40h
        int     21h

        mov     dh,14
        mov     dl,36                         ; Move to Row 14, Col 36

hghpth: push    dx
        call    movcurs
        mov     cx,1
        mov     dx,offset Glide_Slope
        mov     AH,40H
        int     21h
        pop     dx
        cmp     dh,04                           
        jle     lwst                            
               
        sub     dh,2                            ; The High Glide Slope
        add     dl,7                            ; is M = -2/7
        jmp     hghpth

lwst:   mov     dh,15
        mov     dl,38

lwpath: push    dx
        call    movcurs
        mov     cx,1
        mov     dx,offset Glide_Slope
        mov     AH,40H
        int     21h
        pop     dx
        cmp     dh,09d                          
        jle     Return                          
 
        sub     dh,1                            ; The Low Glide Slope 
        add     dl,6                            ; is  M= -1/6

        jmp     lwpath

Return: ret
FSCREEN ENDP
        END

INCLUDE MOVCURS.ASM                          ; Move to Location Module
