#include <stdio.h>
#include <graph.h>
#include <dos.h>     /* used for mouse and time/date functions.   */

#define RAT 0x33     /* define DOS interrupt for using the mouse  */
#define LBUTTON  2   /* AKA 'RAT', and defining mouse buttons.    */
#define RBUTTON  1
#define BBUTTON  3

#define ON      1
#define OFF     0

#define BLACK   0     /* let's define some colors...              */
#define BLUE    1
#define GREEN   2
#define CYAN    3
#define RED     4
#define MAGENTA 5
#define BROWN   6
#define WHITE   7
#define GRAY    8
#define LBLUE   9
#define LGREEN  10
#define LCYAN   11
#define LRED    12
#define LMAGENTA 13
#define YELLOW  14
#define BRWHITE 15

			/* define function prototypes  */                                      
int  main ( int argc, char *argv[] );
void DrawPlate (int d, int x, int y, int lx, int ly); 
void MainTextScreen (void);
void DrawMenu (void);  
void WaitForRat (void);
void SetRatLimits (int x, int y, int xmx, int ymx);
void DrawColoredPlate (int dir, int color, int x, int y, int lx, int ly);
void WaitForEntry(void);   
void StatusMessage(char *str);
void DrawLED( int id, int color, int state);
void DrawPushedButton(int selection); 
void TimeAndDay(int);

short  RatButtons;        /* 1, 2, or 3 buttons        */
short  RatOK;             /* true if mouse is found    */
short  VAMOS = 0;         /* Exit program flag         */
short selection = 8;      /* menu selection, default = invalid */
extern void exit (int);

/* used for register type function/call, e.g setting mouse parameters  */
union REGS inregs, outregs;
struct SREGS segregs;

int main( int argc, char *argv[] )
{
   short c, i, k, tx, ty;
   unsigned char list[20];
   struct _fontinfo fi;
  
   /* This is a 'frame' for handling arguments passed to the program    */
   /* not used in this program, but available...                        */
   if (argc >=2) 
   { 
     /* if 1 was passed, argc=2, if 2 were passed, argc=3, etc.         */
   }
 
   /* let's check for Hardware....   First: VGA card...                 */
   /* this program will ONLY work with VGA cards, but you may           */
   /* _setvideomode() to another resolution if desired. The best way    */
   /* is to test for available modes, then set as desired, that will be */
   /* an exercise 'left for the reader'. Actually, contact the author if*/
   /* you need help in that area.                                       */
   
   if ( !_setvideomode( _VRES16COLOR )) 
   {          
     printf("\nSorry, could not set VGA graphics mode!!");
     printf("\nprogram requires a VGA card/monitor.");
     exit (1);
   }


   /*Now check for RAT... (reset if present).                           */                
   inregs.x.ax = 0;
   int86 (RAT, &inregs, &outregs);
   RatOK = outregs.x.ax;         /* zero if mouse not installed...      */
   RatButtons = outregs.x.bx;        
				     
   /* Draw the 'desktop' and place title                                */                                        
   _setbkcolor( _WHITE );
   _settextwindow(1,1,44,80);
   DrawPlate(0, 2, 2, 636, 476);           
   _settextcolor( YELLOW ); 
   _settextposition( 3, 23 );
   _outtext("SAMPLE DESKTOP PROGRAM");
      
   /* place the 'text' screen.                                          */                                 
   MainTextScreen();
       
   /* draw the menu with buttons....                                    */                     
   DrawMenu();   
   
   
   /* Set Mouse limits for menu screen size.                            */                   
   if ( RatOK ) 
   {
     SetRatLimits(520, 155, 610, 380); 
     inregs.x.ax = 1;  /* show pointer                                  */                          
     int86 (RAT, &inregs, &outregs);
   }
   
   TimeAndDay(2);   /* display time and date on upper right area        */
       

   /* Draw a 'status' section with 'LEDs'.                              */
   DrawPlate(1, 510, 405, 110, 50);
   _settextcolor( GRAY );
   _settextposition(27,67);
   _outtext(" LED 1 ");
   _settextposition(28,67);
   _outtext(" LED 2 ");
   DrawLED( 0, LGREEN, ON );
   DrawLED( 1, LRED, OFF);  
      
  /* main menu LOOP... */

  while ( VAMOS == OFF )
  {
    WaitForEntry();
    /* decode mouse position, if mouse button was pushed                */
    if (outregs.x.bx & RatOK) 
    {
      /* check for location / function                                  */                    
      ty = outregs.x.dx; /* the y position for the RAT...               */  
      k = 8;  /* assume invalid responce                                */
      if ( ( ty > 155 ) & ( ty < 175) ) 
	 k = 1;  
      if ( ( ty > 190 ) && ( ty < 210) )
	 k = 2;     
      if ( ( ty > 220 ) && ( ty < 240) )
	 k = 3;
      if ( ( ty > 255 ) && ( ty < 275) )
	 k = 4;
      if ( ( ty > 285 ) && ( ty < 305) )
	 k = 5;   
      if ( ( ty > 320 ) && ( ty < 340) )
	 k = 6;     
      if ( ( ty > 352 ) && ( ty < 370) )
	 k = 7;   
     }
     else       /* check for key pressed                                */
     {
	c = toupper( _getch() );
	k = 8;  /* assume null/invalid selection                        */
	if ( c == '1')  /* Item 1, etc/                                 */
	   k = 1;
	if ( c == '2') 
	   k = 2;
	if ( c == '3')  
	   k = 3;
	if ( c == '4')  
	   k = 4;
	if ( c == '5')  
	   k = 5;
	if ( c == '6')  
	   k = 6;
	if ( c == 'Q')  /* Quit to 2                                    */
	   k = 7;
     }
	  
     switch (k)
     {   
	case 1:
	  StatusMessage( "  Description for Item 1 " );
	  DrawPushedButton( 1 );
	  DrawLED( 1, LRED, ON); 
	  break;
	case 2:
	  StatusMessage( "    Item 2 description  " );
	  DrawPushedButton( 2 );
	  DrawLED( 1, LRED, OFF); 
	  break;
	case 3:
	  StatusMessage( "  Description for Item 3" );
	  DrawPushedButton( 3 );
	  DrawLED( 1, LRED, ON); 
	  break;
	case 4:
	  StatusMessage( "   Item 4 description   " );
	  DrawPushedButton( 4 );
	  DrawLED( 1, LRED, OFF); 
	  break;
	case 5:
	  StatusMessage( "  Description for Item 5" );
	  DrawPushedButton( 5 );
	  DrawLED( 1, LRED, ON); 
	  break;
	case 6:
	  StatusMessage( "   Item 6 description   " );
	  DrawPushedButton( 6 );
	  DrawLED( 1, LRED, OFF); 
	  break;
	case 7:
	  StatusMessage( "       Quit to DOS      " );
	  DrawPushedButton( 7 );
	  VAMOS = ON;
	  break;
	case 8:
	  StatusMessage( " Select Desired Function" );
     }   

  }        
   
       _unregisterfonts();
       _setvideomode( _DEFAULTMODE );   
       

      return (0);             
}

/************************************************************************
 *  TimeAndDay          3.19.94 crd     Last Mod Date:                  *
 *  Purpose:    Displays the time and date on upper right screen area.  *
 *  Calls:      _dos_getdate/time                                       *
 *  Parameters: s = 0; none. s = 1; date only, s = 2; date and time.    *
 *  Returns:                                                            *
 *  Includes: dos.h                                                     *
 ************************************************************************/
void TimeAndDay(int s)
{
  struct _dosdate_t date;
  struct _dostime_t time;
  char d[10];
  char t[5];
  _settextcolor( GRAY );
  if (s) 
  {
    _dos_getdate( &date);
    _dos_gettime( &time);
    sprintf( d, "%d/%d/%d", date.month, date.day, date.year);
    _settextposition( 2, 66 );
    _outtext( d );
  }
  if ( s > 1 )
  {  
    sprintf( t, "%02d:%02d", time.hour, time.minute);
    _settextposition( 3, 68 );
    _outtext( t );
  }
}


/************************************************************************
 *  SetRatLimits        3.19.94 crd     Last Mod Date:                  *
 *  Purpose:    Set the limits to the mouse pointer on the screen.      *
 *  Calls:      int86()                                                 *
 *  Parameters: upper-left corner (x,y) and lower-right corner (xmx,ymx)*
 *  Returns:                                                            *
 *  Includes: dos.h                                                     *
 ************************************************************************/
void SetRatLimits(int x, int y, int xmx, int ymx) 
{
    inregs.x.ax = 7;
    inregs.x.cx = x;
    inregs.x.dx = xmx;
    int86 (RAT, &inregs, &outregs);
    inregs.x.ax = 8;
    inregs.x.cx = y;
    inregs.x.dx = ymx;
    int86 (RAT, &inregs, &outregs);
}


/************************************************************************
 *  WaitForEntry       3.21.94 crd     Last Mod Date:                   *
 *  Purpose: Waits for a key press or mouse button to be pressed.       *                                                  
 *  Calls:                                                              *
 *  Parameters:                                                         *
 *                                                                      *
 *  Returns: key pressed (getch) or button (outregs.s.bx) and location  *
 *           in outregs.x.cx and .dx.                                   *
 *  Includes: dos.h                                                     *
 ************************************************************************/
void WaitForEntry()
{
    do
    {
      inregs.x.ax = 3;
      int86 (RAT, &inregs, &outregs);
    } while (!(outregs.x.bx & BBUTTON) && !_kbhit() ) ;
}



/************************************************************************
 *  StatusMessage     3.13.94 crd     Last Mod Date:                    *
 *  Purpose:   Display status message at bottom of screen               *
 *  Calls:                                                              *
 *  Parameters:                                                         *
 *                                                                      *
 *  Returns:                                                            *
 *  Includes: graph.h                                                   *
 ************************************************************************/

void StatusMessage(char *str)
{
       _settextcolor( LCYAN );
       _settextposition(28,23); 
       _outtext(str);
}


/************************************************************************
 *  MainTextScreen     3.13.94 crd     Last Mod Date:                   *
 *  Copyright Carlos R. Diaz 1994                                       *
 *  Purpose:    Draws a screen (raised) containing the main text area   *
 *  Calls:      DrawColoredPlate                                        *
 *  Parameters: None (Hard-Wired)                                       *
 *                                                                      *
 *  Returns:                                                            *
 *  Includes: graph.h                                                   *
 ************************************************************************/
void MainTextScreen()
{
    /* large raised tablet                                              */                                                        
    DrawColoredPlate(0, GREEN, 90,  80, 360, 380);
    /* large indented text area.                                        */                                          
    DrawColoredPlate(1, WHITE, 100,  90, 340, 320);
    /* small indented message area at bottom.                           */                                  
    DrawColoredPlate(1, WHITE, 100, 425, 340, 25);
    _settextcolor( LCYAN );
    _settextposition(28,24);
    _outtext("Please Select Function");
}     


/************************************************************************
 *  DrawMenu           3.13.94 crd     Last Mod Date:                   *
 *  Copyright Carlos R. Diaz 1994                                       *
 *  Purpose:    draws menu buttons                                      *
 *  Calls:      DrawPlate                                               *
 *  Parameters:                                                         *
 *                                                                      *
 *  Returns:                                                            *
 *  Includes: graph.h                                                   *
 ************************************************************************/
void DrawMenu(void)
{
	int i, d;
	_settextcolor( LBLUE );
	_settextposition(11, 67);
	_outtext("  Item 1");
	_settextposition(13, 67);
	_outtext("  Item 2");
	_settextposition(15, 67);
	_outtext("  Item 3");
	_settextposition(17, 67);
	_outtext("  Item 4");
	_settextposition(19, 67);
	_outtext("  Item 5");
	_settextposition(21, 67);
	_outtext("  Item 6");
	_settextposition(23, 67);
	_settextcolor( LRED );   /* just 4 kicks, let's make this 1 red.*/
	_outtext("  QUIT ");
	 
	DrawPlate(1, 510, 140, 110, 140 + 15 * 7);   
	for ( i = 0; i < 7; i++) 
	{
	  DrawPlate(0, 520, 32 * i + 158, 90, 18);
       }
}


/************************************************************************
 *  DrawPushedButton   3.13.94 crd     Last Mod Date: 4.15.94           *
 *  Copyright Carlos R. Diaz 1994                                       *
 *  Purpose:    Draws button, either raised or indented (pushed)        *
 *  Calls:      DrawPlate, int(86)                                      *
 *  Parameters: k, the button selected                                  *
 *                                                                      *
 *  Returns:                                                            *
 *  Includes: graph.h                                                   *
 ************************************************************************/

void DrawPushedButton(int k)
{ 

      /* if you are using a mouse, turn the mouse pointer OFF           */ 
      inregs.x.ax = 2;     
      int86 (RAT, &inregs, &outregs);
      
      /* pop-out previous button if newly selected is different         */
      if ( ( k != selection ) && ( selection != 8 ) )
      DrawPlate(0, 520,  32 * ( selection - 1 ) + 158, 90, 18); 
      
      DrawPlate(1, 520,  32 * ( k - 1 ) + 158, 90, 18);
      inregs.x.ax = 1;    /* turn the mouse pointer back ON             */
      int86 (RAT, &inregs, &outregs);
      selection = k;
}


/*      The function DrawPlate is the key to the menu tools,            */
/*      with it, we can draw areas that appear raised or                */
/*      indented, such as buttons or 'plates'.                          */
/*      A 'button' can be drawn as raised, then indented                */
/*      when selected.                                                  */

/************************************************************************
 *  DrawPlate          3.13.94 crd     Last Mod Date:                   *
 *  Copyright Carlos R. Diaz 1994                                       *
 *  Purpose:    Draws a screen area, raised or indented.                *
 *  Calls:                                                              *
 *  Parameters: d, direction, 0 = indented                              *
 *              upper-left corner (x,y) and lengths: lx, ly             *
 *  Returns:                                                            *
 *  Includes: graph.h                                                   *
 ************************************************************************/
void DrawPlate(int d, int x, int y, int lx, int ly)
{
	short c1, c2;
	if (d) {
	c1 = 8 ;
	c2 = 15;
	} else {
	c1 = 15;
	c2 = 8 ;
	}
	_setcolor(c1);
	_moveto( x+lx, y    );
	_lineto( x   , y    );
	_lineto( x   , y+ly );
	_moveto( x+lx-1, y+1  );
	_lineto( x+1 , y+1  );
	_lineto( x+1 , y+ly-1 );
	_setcolor(c2);
	_lineto( x+lx-1, y+ly-1 );
	_lineto( x+lx-1, y+1  );
	_moveto( x+lx, y+1  );
	_lineto( x+lx, y+ly );
	_lineto( x+1 , y+ly );
}


/************************************************************************
 *  DrawColoredPlate   3.13.94 crd     Last Mod Date:                   *
 *  Copyright Carlos R. Diaz 1994                                       *
 *  Purpose:    Draws a screen area, raised or indented, color filled.  *
 *  Calls:      DrawPlate                                                        *
 *  Parameters: d, direction, 0 = indented; color                       *
 *              upper-left corner (x,y) and lengths: lx, ly             *
 *  Returns:                                                            *
 *  Includes: graph.h                                                   *
 ************************************************************************/
void DrawColoredPlate(int dir, int color, int x, int y, int lx, int ly)
{
	DrawPlate(dir,  x, y, lx, ly);
       _setcolor( color );
       _rectangle( _GFILLINTERIOR, x+2, y+2, x+lx-2, y+ly-2);
}


/************************************************************************
 *  DrawLED   3.23.94 crd     Last Mod Date:                            *
 *  Copyright Carlos R. Diaz 1994                                       *
 *  Purpose:    Draws an "LED", at one of 2 locations,in specified color*
 *  Calls:                                                              *
 *  Parameters: id = location, color, state: 1=on, 0=off                *
 *                                                                      *
 *  Returns:                                                            *
 *  Includes: graph.h                                                   *
 ************************************************************************/
void DrawLED( int id, int color, int state)
{
	int y, x = 600;

	/* determine which of two LED locations to draw, based on id    */
	/* you may change the x and y values as desired....             */
	if ( !id ) 
	y =  415;
	else
	y =  435;
	_setcolor(GRAY);
	_ellipse(_GBORDER,x, y, x+10, y+10);
	/* state = 1 (ON) then color it in...                           */
	if (state )
	{
	 _setcolor( color );
	 _ellipse(_GFILLINTERIOR, x+1, y+1, x+9, y+9);
	}
	else   /* state = 0 (OFF), don't draw in the specified color.  */
	{
	 _setcolor( WHITE );
	 _ellipse(_GFILLINTERIOR, x+1, y+1, x+9, y+9);
	}
}

