#ifndef __UW_DBG_H
#define __UW_DBG_H

#ifdef SOURCE_TRACE
#if defined(__TURBOC__) || defined(M_I86) || defined(__WATCOMC__)
#define UWDL        Dbg_line = __LINE__, Dbg_file = __FILE__
#else
#ifdef __POWERC
#define UWDL        Dbg_line = __LINE__
#else
#define UWDL        Dbg_line = 0
#endif
#endif
/*------------------------- Redefs for UW_WIN.C ------------------------*/
#define reset_all_masks()           (UWDL,reset_all_masks())
#define refresh_desktop()           (UWDL,refresh_desktop())
#define refresh_column(c)           (UWDL,refresh_column(c))
#define refresh_row(r)              (UWDL,refresh_row(r))
#define redisplay_rect(r)           (UWDL,refresh_rect(r))
#define add_wn_mask(wnp)            (UWDL,add_wn_mask(wnp))
#define remove_wn_mask(wnp)         (UWDL,remove_wn_mask(wnp))
#define col_wn_mask(a,b,c,d)        (UWDL,col_wn_mask(a,b,c,d))
#define row_wn_mask(a,b,c,d)        (UWDL,row_wn_mask(a,b,c,d))
#define set_window_attr()           (UWDL,set_window_attr())
#define end_window(wnp)             (UWDL,end_window(wnp))
#define cr_inwindow(c,r)            (UWDL,cr_inwindow(c,r))
#define link_window(wnp)            (UWDL,link_window(wnp))
#define unlink_window(wnp)          (UWDL,unlink_window(wnp))
#define remove_window_ll(d,wnp)     (UWDL,remove_window_ll(d,wnp))
#define pull_to_top(wnp)            (UWDL,pull_to_top(wnp))
#define make_top_window(wnp)        (UWDL,make_top_window(wnp))
#define move_wn_left(c,wnp)         (UWDL,move_wn_left(c,wnp))
#define move_wn_right(c,wnp)        (UWDL,move_wn_right(c,wnp))
#define move_wn_up(r,wnp)           (UWDL,move_wn_up(r,wnp))
#define move_wn_down(r,wnp)         (UWDL,move_wn_down(r,wnp))
#define set_rect(r,a,b,c,d)         (UWDL,set_rect(r,a,b,c,d))
#define is_rect_equal(r1,r2)        (UWDL,rect_equal(r1,r2))
#define rect_overlap(r1,r2)         (UWDL,rect_overlap(r1,r2))
#define offset_rect(r,a,b)          (UWDL,offset_rect(r,a,b))
#define col_row_inrect(a,b,r)       (UWDL,col_row_inrect(a,b,r))

/*------------------------- Redefs for UW_FONT.C ------------------------*/

#define encode_color(r,g,b)         (UWDL,encode_color(r,g,b))
#define decode_color(c,r,g,b)       (UWDL,decode_color(c,r,g,b))
#define write_palette(p,v)          (UWDL,write_palette(p,v))
#define write_palette_all(v)        (UWDL,write_palette_all(v))
#define read_palette(p)             (UWDL,read_palette(p))
#define read_palette_all(v)         (UWDL,read_palette_all(v))
#define set_block_ab(a,b)           (UWDL,set_block_ab(a,b))
#define blink_enable(s)             (UWDL,blink_enable(s))
#define replicate_enable(s)         (UWDL,replicate_enable(s))
#define load_font(f,n)              (UWDL,load_font(f,n))
#define save_font(f,n,s)            (UWDL,save_font(f,n,s))
#define rom8x8(b,s)                 (UWDL,rom8x8(b,s))
#define rom8x14(b,s)                (UWDL,rom8x14(b,s))
#define rom8x16(b,s)                (UWDL,rom8x16(b,s))

/*------------------------- Redefs for UW_ENTRY.C ------------------------*/

#define up_first_char(w,s,m)            (UWDL,up_first_char(w,s,m))
#define disp_entry(a,b,c,d,e,f,g,h,wnp) (UWDL,disp_entry(a,b,c,d,e,f,g,h,wnp))
#define g_insert(s,m,t,p)               (UWDL,g_insert(s,m,t,p))
#define g_delete(s,m,t,p)               (UWDL,g_delete(s,m,t,p))
#define g_rtl_insert(s,m,t,p)           (UWDL,g_rtl_insert(s,m,t,p))
#define g_rtl_delete(s,m,t,p)           (UWDL,g_rtl_delete(s,m,t,p))
#define add_mask(s,m,t)                 (UWDL,add_mask(s,m,t))
#define rmv_mask(s,t)                   (UWDL,rmv_mask(s,t))
#define validate(c,t)                   (UWDL,validate(c,t))
#define strip_entry(s,m)                (UWDL,strip_entry(s,m))
#define strip_end(s,m)                  (UWDL,strip_end(s,m))
#define strip_start(s,m)                (UWDL,strip_start(s,m))
#define strip_len(s,m)                  (UWDL,strip_len(s,m))
#define init_gets_str(s,m,t,w)          (UWDL,init_gets_str(s,m,t,w))
#define rev_init_gets_str(s,m,t,w)      (UWDL,rev_init_gets_str(s,m,t,w))
#define reverse_str(s)                  (UWDL,reverse_str(s))
#define wn_gets_ll(s,m,t,a,f,d,wnp)     (UWDL,wn_gets_ll(s,m,t,a,f,d,wnp))
#define wn_gets(s,m,t,a,r,wnp)          (UWDL,wn_gets(s,m,t,a,r,wnp))
#define set_validation_func(f)          (UWDL,set_validation_func(f))
#define set_gets_hook(f)                (UWDL,set_gets_hook(f))

/*------------------------- Redefs for UW_MENU.C ------------------------*/
#define menu_st(m,c,i)                          (UWDL,menu_st(m,c,i))
#define menu_create(a,b,c,d,e,f,g,h,i,j,k,wnp)  (UWDL,menu_create(a,b,c,d,e,f,g,h,i,j,k,wnp))
#define item_add(e,i,f,m)                       (UWDL,item_add(e,i,f,m))
#define menu_set(m)                             (UWDL,menu_set(m))
#define menu_restore(m)                         (UWDL,menu_restore(m))
#define menu_destroy(m)                         (UWDL,menu_destroy(m))
#define decrement_csr(c,i,x)                    (UWDL,decrement_csr(c,i,x))
#define increment_csr(c,i,x)                    (UWDL,increment_csr(c,i,x))
#define upkey(k)                                (UWDL,upkey(k))
#define menu_horiz(m,p)                         (UWDL,menu_horiz(m,p))
#define menu_vert(m,p)                          (UWDL,menu_vert(m,p))
#define do_menu(m,p)                            (UWDL,do_menu(m,p))
#define menu_system(t,d,p)                      (UWDL,menu_system(t,d,p))
#define menu_system_ll(t,d,w,f,e)               (UWDL,menu_system_ll(t,d,w,f,e))

/*------------------------- Redefs for UW_PRTF.C ------------------------*/
#ifndef __ZTC__
#define wn_printf                       (UWDL,wn_printf)
#endif

/*------------------------- Redefs for UW_RFSH.C ------------------------*/
#define move_n_to_f(a,b,c,d)            (UWDL,move_n_to_f(a,b,c,d))
#define move_f_to_n(a,b,c,d)            (UWDL,move_f_to_n(a,b,c,d))
#define wn_io(d,a,wnp)                  (UWDL,wn_io(d,a,wnp))
#define wn_rfsh_line(l,wnp)             (UWDL,wn_rfsh_line(l,wnp))
#define wn_rfsh_col(c,wnp)              (UWDL,wn_rfsh_col(c,wnp))

/*------------------------- Redefs for UW_WN.C  ------------------------*/
#define wn_create(a,b,c,d,e,f,wnp)      (UWDL,wn_create(a,b,c,d,e,f,wnp))
#define wn_destroy(wnp)                 (UWDL,wn_destroy(wnp))
#define wn_set(wnp)                     (UWDL,wn_set(wnp))
#define wn_clear(wnp)                   (UWDL,wn_clear(wnp))
#define wn_move(c,r,wnp)                (UWDL,wn_move(c,r,wnp))

/*------------------------- Redefs for UW_LL.C  ------------------------*/
#define _csr_adj(wnp)                   (UWDL,_csr_adj(wnp))
#define _wn_scroll(d,wnp)               (UWDL,_wn_scroll(d,wnp))
#define _calc_scr_addr(wnp)             (UWDL,_calc_scr_addr(wnp))
#define _calc_buff_addr(wnp)            (UWDL,_calc_buff_addr(wnp))
#define _calc_mask_addr(wnp)            (UWDL,_calc_mask_addr(wnp))
#define _calc_all_addr(s,b,m,wnp)       (UWDL,_calc_all_addr(s,b,m,wnp))
#define _fill_rect(a,v,r)               (UWDL,_fill_rect(a,v,r))

/*------------------------- Redefs for UW_BDR.C ------------------------*/
#define wn_co(t,c,wnp)                  (UWDL,wn_co(t,c,wnp))
#define wn_border(wnp)                  (UWDL,wn_border(wnp))
#define wn_hline(r,s,wnp)               (UWDL,wn_hline(r,s,wnp))
#define wn_vline(c,s,wnp)               (UWDL,wn_vline(c,s,wnp))

/*------------------------- Redefs for UW_MASK.C ------------------------*/
#define adjust_mask_col(a,b,c,d,wnp)    (UWDL,adjust_mask_col(a,b,c,d,wnp))
#define adjust_mask_row(a,b,c,d,wnp)    (UWDL,adjust_mask_row(a,b,c,d,wnp))
#define set_mask(m,wnp1,wnp2)           (UWDL,set_mask(m,wnp1,wnp2))
#define clear_mask(wnp)                 (UWDL,clear_mask(wnp))

/*------------------------- Redefs for UW_TERM.C ------------------------*/
#define wn_claol(wnp)                   (UWDL,wn_claol(wnp))
#define wn_cleol(wnp)                   (UWDL,wn_cleol(wnp))
#define wn_clbol(wnp)                   (UWDL,wn_clbol(wnp))
#define wn_cleos(wnp)                   (UWDL,wn_cleos(wnp))
#define wn_clbos(wnp)                   (UWDL,wn_clbos(wnp))
#define wn_claos(wnp)                   (UWDL,wn_claos(wnp))
#define wn_cln(q,wnp)                   (UWDL,wn_cln(q,wnp))
#define wn_clear_tabs(wnp)              (UWDL,wn_clear_tabs(wnp))
#define wn_init_tabs(s,wnp)             (UWDL,wn_init_tabs(s,wnp))
#define wn_set_tab(wnp)                 (UWDL,wn_set_tab(wnp))
#define wn_reset_tab(wnp)               (UWDL,wn_reset_tab(wnp))
#define wn_tab_right(c,wnp)             (UWDL,wn_tab_right(c,wnp))
#define wn_tab_left(c,wnp)              (UWDL,wn_tab_left(c,wnp))
#define wn_ins_del_chars(m,c,t,wnp)     (UWDL,wn_ins_del_chars(m,c,t,wnp))
#define wn_ins_del_lines(m,c,t,wnp)     (UWDL,wn_ins_del_lines(m,c,t,wnp))
#define wn_csr_dn(q,wnp)                (UWDL,wn_csr_dn(q,wnp))
#define wn_csr_up(q,wnp)                (UWDL,wn_csr_up(q,wnp))
#define wn_csr_left(q,wnp)              (UWDL,wn_csr_left(q,wnp))
#define wn_csr_right(q,wnp)             (UWDL,wn_csr_right(q,wnp))
#define wn_csr_pos(l,c,wnp)             (UWDL,wn_csr_pos(l,c,wnp))
#define wn_scroll_reg(s,e,wnp)          (UWDL,wn_scroll_reg(s,e,wnp))
#define wn_bksp(q,wnp)                  (UWDL,wn_bksp(q,wnp))

/*------------------------- Redefs for UW_GRAPH.C ------------------------*/
#define init_uw_graphics(x,y,f,s,g,o)   (UWDL,init_uw_graphics(x,y,f,s,g,o))
#define g_ch(c,r,v)                     (UWDL,g_ch(c,r,v))
#define install_font(f,b,o,c,s,m)       (UWDL,install_font(f,b,o,c,s,m))
#define get_font_info(t,s,r)            (UWDL,get_font_info(t,s,r))

/*------------------------- Redefs for UW_ST.C  ------------------------*/
#define wn_st(s,wnp)                    (UWDL,wn_st(s,wnp))
#define wn_st_qty(s,q,wnp)              (UWDL,wn_st_qty(s,q,wnp))
#define wn_plst(c,l,s,wnp)              (UWDL,wn_plst(c,l,s,wnp))
#define wn_st_fmt(s,wnp)                (UWDL,wn_st_fmt(s,wnp))

/*------------------------- Redefs for UW_CSR.C ------------------------*/
#define rd_csr(c,l)                     (UWDL,rd_csr(c,l))
#define mv_csr(c,l)                     (UWDL,mv_csr(c,l))
#define csr_style(s)                    (UWDL,csr_style(s))
#define csr_hide()                      (UWDL,csr_hide())
#define csr_show()                      (UWDL,csr_show())
#define pl_csr(wnp)                     (UWDL,pl_csr(wnp))

/*------------------------- Redefs for UW_CH.C  ------------------------*/
#define wn_ch(c,wnp)                    (UWDL,wn_ch(c,wnp))
#define wn_noatt_ch(c,wnp)              (UWDL,wn_noatt_ch(c,wnp))
#define wn_och(wnp)                     (UWDL,wn_och(wnp))
#define wn_oatt(wnp)                    (UWDL,wn_oatt(wnp))
#define wn_qch(t,c,wnp)                 (UWDL,wn_qch(t,c,wnp))

/*------------------------- Redefs for UW_PRINT.C ------------------------*/
#define init_printer(f,d,i,m,p)         (UWDL,init_printer(f,d,i,m,p))
#define end_printer(p)                  (UWDL,end_printer(p))
#define realloc_printer(n,p)            (UWDL,realloc_printer(n,p))
#define set_prt_xlat(s,x,p)             (UWDL,set_prt_xlat(s,x,p))
#define print_char(c,p)                 (UWDL,print_char(c,p))
#define print_str(s,p)                  (UWDL,print_str(s,p))
#ifndef __ZTC__
#define print_printf                    (UWDL,print_printf)
#endif
#define print_data(d,c,p)               (UWDL,print_data(d,c,p))
#define print_file(f,p)                 (UWDL,print_file(f,p))
#define print_window(wnp,p)             (UWDL,print_window(wnp,p))
#define print_screen(p)                 (UWDL,print_screen(p))
#define print_eol(p)                    (UWDL,print_eol(p))
#define print_in_bkgrnd()               (UWDL,print_in_bkgrnd())

/*------------------------- Redefs for UW_EVENT.C ------------------------*/
#define m_reset(m)                      (UWDL,m_reset(m))
#define m_colrange(i,x)                 (UWDL,m_colrange(i,x))
#define m_rowrange(i,x)                 (UWDL,m_rowrange(i,x))
#define init_mouse()                    (UWDL,init_mouse())
#define end_mouse()                     (UWDL,end_mouse())
#define m_show()                        (UWDL,m_show())
#define m_hide()                        (UWDL,m_hide())
#define m_pos(m)                        (UWDL,m_pos(m))
#define m_moveto(c,r)                   (UWDL,m_moveto(c,r))
#define m_pressed(b,m)                  (UWDL,m_pressed(b,m))
#define m_released(b,m)                 (UWDL,m_released(b,m))
#define m_textcursor(c,a,b)             (UWDL,m_textcursor(c,a,b))
#define m_motion(m)                     (UWDL,m_motion(m))
#define m_lpen_on()                     (UWDL,m_lpen_on())
#define m_lpen_off()                    (UWDL,m_lpen_off())
#define m_ratio(h,v)                    (UWDL,m_ratio(h,v))
#define wait_ticks(t)                   (UWDL,wait_ticks(t))
#define get_key()                       (UWDL,get_key())
#define check_key()                     (UWDL,check_key())
#define set_key_func(f)                 (UWDL,set_key_func)
#define event_pending()                 (UWDL,event_pending())
#define set_idle_func(f)                (UWDL,set_idle_func(f))
#define wait_event()                    (UWDL,wait_event())

/*------------------------- Redefs for UW_VID.C ------------------------*/
#define set_25_rows()                   (UWDL,set_25_rows())
#define get_num_rows()                  (UWDL,get_num_rows())
#define get_v_mode()                    (UWDL,get_v_mode())
#define init_video(c,r)                 (UWDL,init_video(c,r))

#define set_vid_addr(s,o)               (UWDL,set_vid_addr(s,o))
#define force_video(f,c,r)              (UWDL,force_video(f,c,r))
#define end_video()                     (UWDL,end_video())
#define swap_nibbles(c)                 (UWDL,swap_nibbles(c))
#define get_att(a)                      (UWDL,get_att(a))
#define check_desq()                    (UWDL,check_desq())
#define mode43()                        (UWDL,mode43())
#define mode25()                        (UWDL,mode25())
#define init_clock(s)                   (UWDL,init_clock(s))
#define end_clock()                     (UWDL,end_clock())
#define clock_speed(s)                  (UWDL,clock_speed(s))
#define tone(f,d)                       (UWDL,tone(f,d))
#define sound_off                       (UWDL,sound_off)

/*------------------------- Redefs for UW_DBG.C ------------------------*/
#define wn_att(a,wnp)            (UWDL,wn_att(a,wnp))
#define wn_color(f,b,wnp)        (UWDL,wn_color(f,b,wnp))
#define wn_bdratt(a,wnp)         (UWDL,wn_bdratt(a,wnp))
#define wn_bdr_color(f,b,wnp)    (UWDL,wn_bdr_color(f,b,wnp))
#define mv_cs(c,r,wnp)           (UWDL,mv_cs(c,r,wnp))
#define wn_rqty(wnp)             (UWDL,wn_rqty(wnp))
#define wn_sqty(wnp)             (UWDL,wn_sqty(wnp))
#define wn_cqty(wnp)             (UWDL,wn_cqty(wnp))
#define wn_name(n, wnp)          (UWDL,wn_name(n, wnp))
#define wn_name_loc(l, wnp)      (UWDL,wn_name_loc(l, wnp))
#define wn_save(wnp)             (UWDL,wn_save(wnp))
#define wn_restore(wnp)          (UWDL,wn_restore(wnp))
#define wn_rfsh(wnp)             (UWDL,wn_rfsh(wnp))
#define wn_read(wnp)             (UWDL,wn_read(wnp))

#define wn_get_csr_x(wnp)        (UWDL,wn_get_csr_x(wnp))
#define wn_get_csr_y(wnp)        (UWDL,wn_get_csr_y(wnp))
#define wn_get_att(wnp)          (UWDL,wn_get_att(wnp))
#define wn_get_bdratt(wnp)       (UWDL,wn_get_bdratt(wnp))
#define wn_get_rows(wnp)         (UWDL,wn_get_rows(wnp))
#define wn_get_cols(wnp)         (UWDL,wn_get_cols(wnp))
#define wn_get_bdr_style(wnp)    (UWDL,wn_get_bdr_style(wnp))
#define wn_get_name_loc(wnp)     (UWDL,wn_get_name_loc(wnp))

#define wn_is_hidden(wnp)        (UWDL,wn_is_hidden(wnp))
#define wn_is_overlapped(wnp)    (UWDL,wn_is_overlapped(wnp))
#define wn_is_csr_adv(wnp)       (UWDL,wn_is_csr_adv(wnp))
#define wn_is_inside(wnp)        (UWDL,wn_is_inside(wnp))
#define wn_is_mask_on(wnp)       (UWDL,wn_is_mask_on(wnp))
#define wn_is_popup(wnp)         (UWDL,wn_is_popup(wnp))
#define wn_is_scroll(wnp)        (UWDL,wn_is_scroll(wnp))
#define wn_is_bs_clear(wnp)      (UWDL,wn_is_bs_clear(wnp))
#define wn_is_eol_wrap(wnp)      (UWDL,wn_is_eol_wrap(wnp))
#define wn_is_mgr_flag(wnp)      (UWDL,wn_is_mgr_flag(wnp))
#define wn_is_set_flag(wnp)      (UWDL,wn_is_set_flag(wnp))
#define wn_is_cr_flag(wnp)       (UWDL,wn_is_cr_flag(wnp))
#define wn_is_lf_flag(wnp)       (UWDL,wn_is_lf_flag(wnp))
#define wn_is_cr_lf_flag(wnp)    (UWDL,wn_is_cr_lf_flag(wnp))
#define wn_is_bk_flag(wnp)       (UWDL,wn_is_bk_flag(wnp))
#define wn_is_tab_flag(wnp)      (UWDL,wn_is_tab_flag(wnp))
#define wn_is_bell_flag(wnp)     (UWDL,wn_is_bell_flag(wnp))
#define wn_is_w_wrap(wnp)        (UWDL,wn_is_w_wrap(wnp))

#define wn_set_csr_x(x,wnp)      (UWDL,wn_set_csr_x(x,wnp))
#define wn_set_csr_y(y,wnp)      (UWDL,wn_set_csr_y(y,wnp))
#define wn_set_bdr_style(s,wnp)  (UWDL,wn_set_bdr_style(s,wnp))
#define wn_set_name_loc(s,wnp)   (UWDL,wn_set_name_loc(s,wnp))
#define wn_set_hidden(s,wnp)     (UWDL,wn_set_hidden(s,wnp))
#define wn_set_overlapped(s,wnp) (UWDL,wn_set_overlapped(s,wnp))
#define wn_set_csr_adv(s,wnp)    (UWDL,wn_set_csr_adv(s,wnp))
#define wn_set_inside(s,wnp)     (UWDL,wn_set_inside(s,wnp))
#define wn_set_mask_on(s,wnp)    (UWDL,wn_set_mask_on(s,wnp))
#define wn_set_popup(s,wnp)      (UWDL,wn_set_popup(s,wnp))
#define wn_set_scroll(s,wnp)     (UWDL,wn_set_scroll(s,wnp))
#define wn_set_bs_clear(s,wnp)   (UWDL,wn_set_bs_clear(s,wnp))
#define wn_set_eol_wrap(s,wnp)   (UWDL,wn_set_eol_wrap(s,wnp))
#define wn_set_mgr_flag(s,wnp)   (UWDL,wn_set_mgr_flag(s,wnp))
#define wn_set_set_flag(s,wnp)   (UWDL,wn_set_set_flag(s,wnp))
#define wn_set_cr_flag(s,wnp)    (UWDL,wn_set_cr_flag(s,wnp))
#define wn_set_lf_flag(s,wnp)    (UWDL,wn_set_lf_flag(s,wnp))
#define wn_set_cr_lf_flag(s,wnp) (UWDL,wn_set_cr_lf_flag(s,wnp))
#define wn_set_bk_flag(s,wnp)    (UWDL,wn_set_bk_flag(s,wnp))
#define wn_set_tab_flag(s,wnp)   (UWDL,wn_set_tab_flag(s,wnp))
#define wn_set_bell_flag(s,wnp)  (UWDL,wn_set_bell_flag(s,wnp))
#define wn_set_w_wrap(s,wnp)     (UWDL,wn_set_w_wrap(s,wnp))

#endif /* SOURCE_TRACE */
#endif /* __UW_DBG_H */

/**** END OF FILE ****/
