/****************************************************************************/
/*                                                                          */
/* UW_DEMO.C                                                                */
/*                                                          Kevin Huck      */
/*                                                          Boyd Gafford    */
/*                                                                          */
/*   This demo program will show you many of the capabilities of UltraWin   */
/* version 2.60.  See the documentation for a complete function listing.    */
/*                                                                          */
/* NOTE:                                                                    */
/*   This file has a tab size of 2, and can be compiled and linked under    */
/*   small model.                                                           */
/*                                                                          */
/****************************************************************************/
#include <stdlib.h>
#include <dos.h>
#include <stdio.h>
#include <ctype.h>
#include <conio.h>
#include <time.h>
#if defined(M_I86) || defined(__WATCOMC__)
  #include <malloc.h>
#else
  #include <alloc.h>
#endif
#include "uw.h"

#define NUM_WINS 26

typedef struct fields_struct            /* structure for field input to the */
{                                       /* order form function!             */
  int   num_fields;                     /* total number of fields           */
  char  *input[10];                     /* strings for the result           */
  char  *mask[10];                      /* masks for display on the screen  */
  char  *t[10];                         /* templates for validation         */
  int   x[10];                          /* positions for the input          */
  int   y[10];
  int   strip[10];                      /* strip masks on result?           */
} FIELDS;

/*----------------- global variables for the demo program ------------------*/
WINDOW  Main_wn, Print_wn[2];
WINDOW  Back_wn, *Back_wnp = &Back_wn;
MENU    Top_menu, *Top_mnp = &Top_menu;
MENU    Terminal_menu, Setup_menu, Window_menu, Files_menu;
MENU    *Drop_mnps[4];

uchar   *Font8x14;
PRINT   Printer1, Printer2;
char    *Enque_strs[] =
        {
          "EnQue Software",
          "Route 1, Box 116C",
          "Pleasant Hill, MO, 64080",
          "24-Hour BBS (816) 353-0991",
          "Voice/Fax (816) 987-2515",
          "(Voice 5-10pm and weekends)"
        };
char    Name[40], Address[40], City[30], State[10],
        Zip[10], Phone[20], Password[10];
int     Wait_for_key = 1;


/*------------------------ prototypes for the program ----------------------*/
void wn_3d_plst( int c, int r, char *str, WINDOW *wnp );
void wn_line_demo( void );
void wn_entry_demo( void );
void wn_color_demo( void );
void wn_create_demo( void );
void wn_scroll_demo( void );
void wn_prompt( char *prompt, int mode );
void wait( int mode );
void title_screen( void );
int  wn_menu_demo( void );
int  background_func( void );
void wn_change_att( uchar new_att, uchar old_att, WINDOW *wnp );
void wn_font_demo( void );
void wn_print_demo( void );
void disp_print_stats( PRINT *p, int mode, WINDOW *wnp );


/*********/
/* ~main */
/*       ********************************************************************/
/****************************************************************************/
void main()
{
  int r, end_flag = 0;
  WINDOW *wnp;

  init_video(80, 25);
  init_mouse();
  init_clock(0x3333);
  wnp = &Main_wn;
  wn_create( 0, 3, V_cols-1, V_rows-1, NO_BDR, WN_NORMAL, wnp );
  wn_color( CYAN, BLUE, wnp );
  wn_bdr_color( YELLOW, BLUE, wnp );
  wn_name("Main_wn", wnp);
  link_window(wnp);
  title_screen();
  wn_plst( CENTERED, (V_rows / 2) - 1,
     "Welcome to the UltraWin Library!", wnp );
  if( Ega )
    wn_plst( CENTERED, 3,
       "UltraWin detects the presence of an EGA compatible board", wnp);
  else if( Vga )
    wn_plst( CENTERED, 3,
       "UltraWin detects the presence of a VGA compatible board", wnp);
  wait(0);

  wn_clear(wnp);
  wn_color( BLUE, LIGHTGRAY, wnp );

  wn_plst(1, 0, "    Speed it one of many features incorporated into the UltraWin Library.     ", wnp );
  wn_plst(1, 1, "   Here is a list of the main features, all of which will be demonstrated!    ", wnp );

  wn_color( YELLOW, BLUE, wnp );
  wn_hline(2,SGL_BDR,wnp);
  r = 3;
  wn_plst(0, r++, "1) Complete range of windowing functions to dynamically create, update,", wnp );
  wn_plst(0, r++, "   move, and destroy an unlimited number of windows.", wnp );
  wn_color( WHITE, BLUE, wnp );
  wn_plst(0, r++, "2) A Window Manager that will handle all the hard work when multiple", wnp );
  wn_plst(0, r++, "   windows are on the screen.", wnp );
  wn_color( YELLOW, BLUE, wnp );
  wn_plst(0, r++, "3) Each window is fully buffered. Output to a window can take place at any", wnp );
  wn_plst(0, r++, "   time, even if another window overlaps it.  This is perhaps, the", wnp );
  wn_plst(0, r++, "   most impressive feature. Windows can scroll output even if overlapped!", wnp );
  wn_color( WHITE, BLUE, wnp );
  wn_plst(0, r++, "4) Powerful string and data entry capabilities.", wnp );
  wn_color( YELLOW, BLUE, wnp );
  wn_plst(0, r++, "5) Powerful menuing capability with full mouse support!", wnp );
  wn_color( WHITE, BLUE, wnp );
  wn_plst(0, r++, "6) The library supports virtually any video board, including 43/50", wnp );
  wn_plst(0, r++, "   row EGA/VGA mode. It even works with non-standard modes i.e. 132*60.", wnp );
  wn_color( YELLOW, BLUE, wnp );
  wn_plst(0, r++, "7) UltraWin now works in EGA/VGA graphics mode and has user defined", wnp );
  wn_plst(0, r++, "   font capability in both text and graphics modes!", wnp );
  wn_color( WHITE, BLUE, wnp );
  wn_plst(0, r++, "8) EGA/VGA palette control and blink enable/disable to allow all 16", wnp );
  wn_plst(0, r++, "   background colors without foreground blinking.", wnp );
  wn_color( YELLOW, BLUE, wnp );
  wn_plst(0, r++, "9) UltraWin also has dynamic printer queues that can be either ram", wnp );
  wn_plst(0, r++, "   or disked based and can print to multiple devices in the background!", wnp );
  wn_hline(r,SGL_BDR,wnp);
  wait(0);

  while( !end_flag )
  {
    wn_clear(wnp);
    wn_color( BLUE, LIGHTGRAY, wnp );
    r = 3;
    wn_3d_plst(13, r++, "A) Color/Palette Control", wnp ), r++;
    wn_3d_plst(13, r++, "B) Window Creation      ", wnp ), r++;
    wn_3d_plst(13, r++, "C) Text Line Drawing    ", wnp ), r++;
    wn_3d_plst(13, r++, "D) Window Scrolling     ", wnp ), r++;
    wn_3d_plst(13, r++, "E) Data Entry           ", wnp ), r++;
    r = 3;
    wn_3d_plst(43, r++, "F) Drop-down Menus      ", wnp ), r++;
    wn_3d_plst(43, r++, "G) EGA/VGA Text Fonts   ", wnp ), r++;
    wn_3d_plst(43, r++, "H) Print Capabilities   ", wnp ), r++;
    wn_3d_plst(43, r++, "I) All of the Above     ", wnp ), r++;
    wn_color( RED, LIGHTGRAY, wnp );
    wn_3d_plst(43, r++, "J) Quit Demo  <<Esc>>   ", wnp ), r++;
    wn_color( BLUE, LIGHTGRAY, wnp );
    if( Wait_for_key )
      wn_3d_plst(13, r++, "K) Key press requirement between operations  : ON     ", wnp ), r++;
    else
      wn_3d_plst(13, r++, "K) Key press requirement between operations  : OFF    ", wnp ), r++;
    r++;

    wn_prompt("Select desired demo to execute...", 1);
    wn_color( LIGHTGRAY, BLUE, wnp );
    switch( toupper(Event.key) )
    {
      case 'Q': case 'J': case 27: end_flag = 1; break;

      case 'A': wn_color_demo();  break;
      case 'B': wn_create_demo(); break;
      case 'C': wn_line_demo();   break;
      case 'D': wn_scroll_demo(); break;
      case 'E': wn_entry_demo();  break;

      case 'F': wn_menu_demo();   break;
      case 'G': wn_font_demo();   break;
      case 'H': wn_print_demo();  break;

      case 'I':
        wn_color_demo();
        wn_create_demo();
        wn_line_demo();
        wn_scroll_demo();
        wn_entry_demo();
        wn_menu_demo();
        wn_font_demo();
        wn_print_demo();
        break;
      case 'K': Wait_for_key = !Wait_for_key; break;
    }
  }
  wn_destroy(wnp);
  end_clock();
  end_mouse();
  end_video();
  exit(0);
}
/*** end of main ***/

/***************/
/* ~wn_3d_plst */
/*             **************************************************************/
/* This is specifically for the demo menu....                               */
/****************************************************************************/
void wn_3d_plst( int c, int r, char *str, WINDOW *wnp )
{
  push(wnp->att);
  wn_color( BLACK, BLUE, wnp );
  mv_cs( c + 1, r + 1, wnp );
  wn_qch( strlen(str), 223, wnp );
  mv_cs( c + strlen(str), r, wnp );
  wn_ch(220, wnp);
  pop(wnp->att);
  wn_plst( c, r, str, wnp );
}
/*** end of wn_3d_plst ***/

/*****************/
/* ~wn_line_demo */
/*               ************************************************************/
/****************************************************************************/
void wn_line_demo( void )
{
  int i, t, x, y;
  WINDOW wn;


  wn_clear(&Main_wn);
  /*----------------- demonstrate line drawing capabilities ----------------*/
  wn_prompt("UltraWin has several border styles...",0);
  wn_create( 17, 7, 59, 19, SGL_BDR, WN_POPUP, &wn );
  wn_color( BLACK, CYAN, &wn );
  wn_bdr_color( BLACK, CYAN, &wn );
  link_window(&wn);
  for( t = 0; t < 3; t++ )
  {
    for( i = 0; i <= 4; i++ )
    {
      wn_set_bdr_style(i, &wn);
      wn_border(&wn);
      wait_ticks( 4L );
    }
  }
  wn_prompt("UltraWin has line drawing capabilities....",0);
  wn_set_bdr_style(SGL_BDR,&wn);
  wn_border(&wn);

  wn_hline(2,DBL_BDR,&wn);
  wait_ticks(  4L );
  wn_hline(4,SGL_BDR,&wn);
  wait_ticks(  4L );
  wn_vline(4,DBL_BDR,&wn);
  wait_ticks(  4L );
  wn_hline(8,DBL_BDR,&wn);
  wait_ticks(  4L );
  wn_vline(40,SGL_BDR,&wn);
  wait_ticks(  4L );
  wn_hline(6,SGL_BDR,&wn);
  wait_ticks(  4L );
  wn_vline(22,SGL_BDR,&wn);
  wait_ticks(  4L );
  wait(0);
  wn_clear(&wn);
  wn_border(&wn);
  wn_color( YELLOW, CYAN, &wn );
  wn_color( RED, CYAN, &wn );
  wn_plst( 0, 1, "  1     2     3     4     5     6     7 ", &wn );
  wn_plst( 0, 4, "  8     9    10    11    12    13    14 ", &wn );
  wn_plst( 0, 7, " 15     16   17    18    19    20    21 ", &wn );
  wn_plst( 0,10, " 22     23   24    25    26    27    28 ", &wn );
  wn_color( BLACK, CYAN, &wn );
  for( x = 5; x < 40; x += 6 )
    wn_vline(x, SGL_BDR, &wn);
  for( y = 2; y < 11; y += 3 )
    wn_hline(y, SGL_BDR, &wn);
  wn_color( BLUE, LIGHTGRAY, &wn );
  wn_set_inside(0, &wn);
  wn_plst( 0, 0, "   S     M     T     W     T     F     S   ", &wn );
  wn_set_inside(1, &wn);
  wait(0);
  unlink_window(&wn);
  wn_destroy(&wn);
}
/*** end of wn_line_demo ***/

/******************/
/* ~wn_entry_demo */
/*                ***********************************************************/
/****************************************************************************/
void wn_entry_demo( void )
{
  int     i, stat, end_flag = OFF;
  uchar   m_att = ((CYAN << 4) | YELLOW),
          w_att = ((CYAN << 4) | WHITE),
          bdr_att = ((CYAN << 4) | BLACK);
  WINDOW  wn, *wnp = &wn;
  FIELDS  f;

  wn_clear(&Main_wn);
  /*--------------------- demonstrate entry capabilities -------------------*/
  wn_prompt("UltraWin has flexible data entry support...",0);

  f.input[0]    = Name;
  f.x[0]        = 23, f.y[0] = 10, f.strip[0] = ON;
  f.mask[0]     = "___________________________________";
  f.t[0]        = "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
  f.input[1]    = Address;
  f.x[1]        = 23, f.y[1] = 11, f.strip[1] = ON;
  f.mask[1]     = "___________________________________";
  f.t[1] =        "***********************************";
  f.input[2]    = City;
  f.x[2]        = 23, f.y[2] = 12, f.strip[2] = ON;
  f.mask[2]     = "____________________";
  f.t[2]        = "UAAAAAAAAAAAAAAAAAAA";
  f.input[3]    = State;
  f.x[3]        = 52, f.y[3] = 12, f.strip[3] = ON;
  f.mask[3]     = "__";
  f.t[3]        = "UU";
  f.input[4]    = Zip;
  f.x[4]        = 62, f.y[4] = 12, f.strip[4] = ON;
  f.mask[4]     = "_____";
  f.t[4]        = "#####";
  f.input[5]    = Phone;
  f.x[5]        = 23, f.y[5] = 13, f.strip[5] = OFF;
  f.mask[5]     = "(___) ___-____";
  f.t[5]        = " ###  ### ####";
  f.input[6]    = Password;
  f.x[6]        = 23, f.y[6] = 14, f.strip[6] = ON;
  f.mask[6]     = "________";
  f.t[6]        = "AAAAAAAA";

  wn_create(2, 4, 77, 23, DBL_BDR, WN_NORMAL, wnp);
  wn_bdratt(bdr_att,wnp);
  wn_att(w_att,wnp);
  wn_name("< UltraWin Order Form >", wnp);
  m_hide();
  link_window(wnp);
  for (i=0; i<6; i++)
    wn_plst(2, i + 1, Enque_strs[i], wnp);

  wn_plst(4,   8, "Yes, I want to order UltraWin at $99.95.  Please mail to:", wnp);
  wn_plst(10, 10, "        Name:", wnp);
  wn_plst(10, 11, "     Address:", wnp);
  wn_plst(10, 12, "        City:                      State:    Zip:", wnp);
  wn_plst(10, 13, "       Phone:", wnp);
  wn_plst(10, 14, "BBS Password:", wnp);

  wn_att(m_att,wnp);
  for (i=0; i<7; i++)
  {
    wn_plst(f.x[i], f.y[i], f.mask[i], wnp);
    wn_plst(f.x[i], f.y[i], f.input[i], wnp);
  }
  wn_plst(6, 17, "Please enter the following fields, pressing PgDn when complete", wnp);
  wn_att(m_att,wnp);
  f.num_fields = 7;
  wn_att(bdr_att,wnp);
  wn_plst(38, 1, "UltraWin Libraries + Source", wnp);
  wn_plst(38, 2, "  1) Large Model Libraries", wnp);
  wn_plst(38, 3, "  2) Printed Documentation", wnp);
  wn_plst(38, 4, "  3) Example Programs", wnp);
  wn_plst(38, 5, "  4) Support Via the EnQue BBS", wnp);
  wn_plst(38, 6, "  5) Full Source Code!", wnp);
  wn_att(w_att,wnp);
  m_show();
  i = 0;
  while (!end_flag)
  {
    mv_cs(f.x[i], f.y[i], wnp);
    stat = wn_gets(f.input[i], f.mask[i], f.t[i], m_att, f.strip[i], wnp);
    switch( stat )
    {
      case KEY_UP:
        if (--i < 0)
          i = f.num_fields - 1;
        break;
      case KEY_ENTER:
        if (++i >= f.num_fields)
          end_flag = ON;
        break;
      case KEY_DN: case KEY_TAB:
        if (++i >= f.num_fields)
          i = 0;
        break;
      case KEY_PGUP: case KEY_PGDN:
      case KEY_ESC: case -1:
        end_flag = ON;
        break;
    }
  }
  m_hide();
  unlink_window(wnp);
  wn_destroy(wnp);
  m_show();
}
/*** end of wn_entry_demo ***/

/******************/
/* ~wn_color_demo */
/*                ***********************************************************/
/****************************************************************************/
void wn_color_demo( void )
{
  int i, x, xs, ys;
  char buff[81];
  uchar palette[16], new_att, old_att;
  WINDOW *wns[8], *wnp;
  static char *names[8] = { "<< Window 0 >>", "<< Window 1 >>",
   "<< Window 2 >>", "<< Window 3 >>", "<< Window 4 >>",
   "<< Window 5 >>", "<< Window 6 >>", "<< Window 7 >>" };

  wn_clear(&Main_wn);
  wn_prompt("Let's demonstrate UltraWin's color capabilities...",0);
  for( i = 0; i < 8; i++ )
    wns[i] = (WINDOW *) calloc(1, sizeof(WINDOW));
  for( i = 0; i < 8; i++ )
  {
    wnp = wns[i];
    xs = i * 3 + 12, ys = i + 5;
    wn_create( xs, ys, xs + 31, ys + 9, SGL_BDR, WN_NORMAL, wnp );
    wn_color( WHITE,  i % 8, wnp );
    wn_bdr_color( WHITE, i % 8, wnp );
    sprintf(buff, "<< Window %d >>", i + 1 );
    wn_name(names[i], wnp);
    link_window(wnp);
    for( x = 0; x < 8; x++ )
    {
      sprintf(buff, "Window %d, Line %d", i, x );
      wn_plst( 0, x, buff, wnp );
    }
  }
  for( x = 0; x < 32; x++ )
  {
    for( i = 0; i < 8; i++ )
    {
      new_att = ((((x + i + 1) % 8)) << 4) | WHITE;
      old_att = (((x + i) % 8) << 4) | WHITE;
      wn_bdratt(new_att, wns[i]);
      wn_change_att( new_att, old_att, wns[i] );
    }
  }
  wn_prompt("We can bring any window to the Top...",0);
  for( i = 7; i >= 0; i-- )
    make_top_window(wns[rand()%7]);
  for( i = 7; i >= 0; i-- )
    make_top_window(wns[i]);
  if( EgaVga )
  {
    wn_prompt("We can change the EGA/VGA palette registers...",0);
    read_palette_all(palette);
    for( i = 0; i < 32; i++ )
      write_palette(rand() % 16, (uchar) (rand() % 64)), wait_ticks(2L);
    write_palette_all(palette);
  }
  for( i = 0; i < 8; i++ )
  {
    unlink_window(wns[i]);
    wn_destroy(wns[i]);
  }
}
/*** end of wn_color_demo ***/

/*******************/
/* ~wn_create_demo */
/*                 **********************************************************/
/****************************************************************************/
char Ww_str[320];
char *Ww_strs[] =
{
"UltraWin has powerful text output support including word wrap and special ",
"character processing.  Newlines, carriage returns, tabs, backspaces, and ",
"the bell character can all be independently enabled.  For improved ",
"performance, output routines that do not perform these tasks are available."
};
void wn_create_demo( void )
{
  int i, j, x, xs, ys, xe, ye;
  char buff[81];
  WINDOW *wns[NUM_WINS], *wnp;
  WINDOW wn;

  for( i = 0; i < 4; i++ )
    strcat(Ww_str, Ww_strs[i]);
  wn_color( YELLOW, BLUE, &Main_wn );
  wn_clear(&Main_wn);
  for( i = 0; i < 10; i++ )
  {
    mv_cs(20, i + 4, &Main_wn);
    wn_printf(&Main_wn, "This is line %d........", i + 1 );
  }
  wn_prompt("Let's dynamically allocate, create, and set 26 POPUP windows.",0);
  for( x = 0; x < NUM_WINS; x++ )
    if( (wns[x] = (WINDOW *) calloc(1, sizeof(WINDOW))) == NULL )
      return;
  x = 0;
  for( i = 0; i < 5; i++ )
  {
    for( j = 0; j < 4; j++, x++ )
    {
      switch( j )
      {
        case 0: xs =      i * 6; ys =      i + 3; break;
        case 1: xs = 60 - i * 6; ys =      i + 3; break;
        case 2: xs =      i * 6; ys = 20 - i;     break;
        case 3: xs = 60 - i * 6; ys = 20 - i;     break;
      }
      wnp = wns[x];
      wn_create( xs, ys, xs + 19, ys + 5, SGL_BDR, WN_POPUP,wnp );
      wn_color( WHITE, j + 2, wnp );
      wn_bdr_color( WHITE, j + 2, wnp );
      sprintf(buff, "<< Window %d >>", x + 1 );
      wn_name(buff, wnp);
      wn_set(wnp);
      wn_plst(CENTERED, 0, buff, wnp);
    }
  }
  for( i = 0; i < 12; i += 2, x++ )
  {
    wnp = wns[x];
    xs = 32 - i * 2, ys = 12 - i / 2;
    xe = 47 + i * 2, ye = 15 + i / 2;
    wn_create(xs, ys, xe, ye, SGL_BDR, WN_POPUP, wnp);
    wn_color( WHITE, i % 8, wnp );
    wn_bdr_color( WHITE, i % 8, wnp );
    sprintf(buff, "<< Window %d >>", x + 1 );
    wn_name(buff, wnp);
    wn_set(wnp);
  }
  wn_plst( CENTERED, 5, "Note that these are POPUP windows.", wnp );
  wn_plst( CENTERED, 6, "Everything below them is saved.", wnp );
  wn_plst( CENTERED, 7, "Watch closely as they are removed.", wnp );
  wn_plst( CENTERED, 9, "<<< Don't blink or you will miss it >>>!", wnp );
  wait(0);
  while( x-- > 0 )
    wn_destroy(wns[x]);
  wn_color( LIGHTGRAY, BLUE, &Main_wn );
  wn_clear(&Main_wn);
  wn_prompt("Let's create and resize a window...",0);
  wnp = &wn;
  wn_create( 10, 4, V_cols - 11, V_rows - 5, SGL_BDR, WN_POPUP, wnp );
  wn_set(wnp);
  wn_set_w_wrap(1,wnp);
  for( i = 0; i < 24; i+=2 )
  {
    wait_ticks(4L);
    wn_size(10, 4, V_cols - 11 - i, V_rows - 5 - i/2, wnp );
    mv_cs(0,0,wnp);
    wn_st_fmt(Ww_str, wnp);
  }
  for( i = 23; i >= 0; i-=2 )
  {
    wait_ticks(4L);
    wn_size(10, 4, V_cols - 11 - i, V_rows - 5 - i/2, wnp );
    mv_cs(0,0,wnp);
    wn_st_fmt(Ww_str, wnp);
  }
  wait(0);
  wn_destroy(wnp);
}
/*** end of wn_create_demo ***/

/*******************/
/* ~wn_scroll_demo */
/*                 **********************************************************/
/****************************************************************************/
void wn_scroll_demo( void )
{
  int i, t, x, r;
  WINDOW wn, wn1, wn2;

  wn_clear(&Main_wn);
  /*--------------------- demonstrate scrolling speed ----------------------*/
  wn_prompt("UltraWin has full window scrolling capabilities....",0);
  wn_create( 15, 9, 59, 17, SGL_BDR, WN_NORMAL, &wn );
  wn_color( YELLOW, RED, &wn );
  wn_bdr_color( YELLOW, RED, &wn );
  wn_name("Scrolling Window 1", &wn);
  link_window(&wn);
  for( t = 0; t < 2; t++ )
  {
    for( i = 0; i < 100; i++ )
    {
      wn_att(wn_get_att(&wn) & 0xf0, &wn);
      wn_att(wn_get_att(&wn) | rand()%16, &wn);
      wn_st("UltraWin Library ", &wn );
      if( t == 0 )
      wait_ticks( 1L );
    }
    if( t == 0 )
      wn_prompt("Too slow? Let's try it at full speed!",0);
  }
  /*------------------------- scroll up and down ---------------------------*/
  wn_prompt("There's more. UltraWin can scroll down...",0);
  wn_color( YELLOW, RED, &wn );
  wn_clear(&wn);
  for( i = 0; i < 7; i++ )
  {
    mv_cs( 0, i, &wn );
    wn_printf(&wn, "Line %d.....", i + 1 );
  }
  mv_cs(0,0,&wn);
  for( i = 0; i < 7; i++ )
  {
    wn_csr_up(1,&wn);
    wait_ticks(  2L );
  }
  wn_prompt("or UltraWin can scroll up.",0);
  wn_clear(&wn);
  for( i = 0; i < 7; i++ )
  {
    mv_cs( 0, i, &wn );
    wn_printf(&wn, "Line %d.....", i + 1 );
  }
  for( i = 0; i < 7; i++ )
  {
    wn_csr_dn(1,&wn);
    wait_ticks(  2L );
  }
  /*-------------------------- scrolling regions ---------------------------*/
  wn_prompt("You can also set a scrolling region within a window...",0);
  wn_color( YELLOW, RED, &wn );
  wn_clear(&wn);
  for( i = 0; i < 7; i++ )
  {
    mv_cs( 0, i, &wn );
    wn_printf(&wn, "Line %d.....", i + 1 );
  }
  wn_scroll_reg( 3, 6, &wn );
  wn_color(WHITE, RED, &wn);
  mv_cs(0, 3, &wn);
  for( i = 0; i < 50; i++ )
  {
    wn_st("UltraWin ", &wn );
    wait_ticks(  2L );
  }

  /*-------------------------- scroll multiples ---------------------------*/
  wn_prompt("UltraWin can scroll multiple windows concurrently!",0);
  wn_create( 12, 12, 49, 18, SGL_BDR, WN_NORMAL, &wn1 );
  wn_color( WHITE, GREEN, &wn1 );
  wn_bdr_color( WHITE, GREEN, &wn1 );
  wn_name("Scrolling Window 2", &wn1);
  wn_create( 18, 4, 69, 14, SGL_BDR, WN_NORMAL, &wn2 );
  wn_color( RED, BLACK, &wn2 );
  wn_bdr_color( RED, BLACK, &wn2 );
  wn_name("Scrolling Window 3", &wn2);

  link_window(&wn1);
  link_window(&wn2);
  for( t = 0; t < 2; t++ )
  {
    for( i = 0; i < 100; i++ )
    {
      wn_st("Window 1 output ",&wn);
      wn_st("Window 2 output ",&wn1);
      wn_st("Window 3 output ",&wn2);
      if( t == 0 )
        wait_ticks(  1L );
    }
    if( t == 0 )
      wn_prompt("Too slow? Let's try it at full speed!",0);
  }
  /*----------------- scroll multiples while moving! -----------------------*/
  wn_prompt("UltraWin can scroll multiple windows while moving!",0);
  for( i = 0; i < 50; i++ )
  {
    wn_st("Window 1 output ",&wn);
    wn_st("Window 2 output ",&wn1);
    wn_st("Window 3 output ",&wn2);
    x = rand()%10;
    if( x == 1 )
    {
      if( wn.pane.x_min > 0 )
        wn.pane.x_min--, wn.pane.x_max--, r = 1;
    }
    else if( x == 2 )
    {
      if( wn1.pane.y_min > 4 )
        wn1.pane.y_min--, wn1.pane.y_max--, r = 1;
      if( wn1.pane.x_max < V_cols )
        wn1.pane.x_min++, wn1.pane.x_max++, r = 1;
    }
    else if( x == 3 )
    {
      if( wn2.pane.y_max < V_rows )
        wn2.pane.y_min++, wn2.pane.y_max++, r = 1;
      if( wn2.pane.x_max < V_cols )
        wn2.pane.x_min++, wn2.pane.x_max++, r = 1;
    }
    if( r )
    {
      reset_all_masks();          /* reset all masks and redraw all windows */
      refresh_desktop();          /* since we are moving windows NOT on top */
    }                             /* if the window was always on top, we can*/
  }                               /* simply use move_wn_up, etc...          */
  unlink_window(&wn);
  unlink_window(&wn1);
  unlink_window(&wn2);
  wn_destroy(&wn);
  wn_destroy(&wn1);
  wn_destroy(&wn2);
}
/*** end of wn_scroll_demo ***/

/**************/
/* ~wn_prompt */
/*            ***************************************************************/
/****************************************************************************/
void wn_prompt( char *prompt, int mode )
{
  WINDOW wn;

  wn_create( 0, 0, 79, 2, DBL_BDR, WN_NORMAL, &wn );
  wn_color( RED, LIGHTGRAY, &wn );
  wn_bdr_color( LIGHTGRAY, BLACK, &wn );
  wn_set(&wn);
  wn_plst( CENTERED, 0, prompt, &wn );
  wait(mode);
  wn_destroy(&wn);
}
/*** end of wn_prompt ***/

/*********/
/* ~wait */
/*       ********************************************************************/
/****************************************************************************/
void wait(int mode)
{
  push(Main_wn.att);
  wn_color( LIGHTGRAY, RED, &Main_wn );
  mv_cs(0,21,&Main_wn);
  wn_cleol(&Main_wn);
  if( mode || Wait_for_key )
  {
    wn_plst(CENTERED, 21, "Hit any key to continue...", &Main_wn);
    wait_event();
  }else
    wait_ticks(36L), Event.key = 0;
  pop(Main_wn.att);
  mv_cs(0,21,&Main_wn);
  wn_cleol(&Main_wn);
}
/*** end of wn_prompt ***/

/*****************/
/* ~title_screen */
/*               ************************************************************/
/* This routine does the UltraCom title screen, logo and subscription info  */
/****************************************************************************/
char  *Title_strs[10] =
{
"                                                               ",
" ۱   ۱  ۱    ۱                        ۱    ۱                  ",
" ۱  ۱ ۱           ۱   ۱         ",
" ۱  ۱ ۱ ۱        ۱   ۱ ۰  ۱  ",
" ۱  ۱ ۱  ۱۱  ۱  ۱   ۱ ۱  ۱ ۱ ",
" ۱  ۱ ۱   ۱   ۱     ۱۱ ۱   ۱ ۱ ۱    ۱ ",
" ۱  ۱ ۱   ۱   ۱     ۱۱ ۱ ۱ ۱ ۱    ۱ ",
"  ۱       ۱       ۱  ۱۱ ۱ ۱    ۱ ",
"                                ",
"                                         "
};
char  *Wave_strs[7] =
{
"        Source Available          Extended Mode Support      Timer Control  ",
"  Sound Support       EGA/VGA Downloadable Fonts             Small          ",
" Ŀ       Menusͻ     [Data Entry]                              ",
"  Windows       1) Small        $12.34              FastFlexible ",
"       2) Fast         09/29/90                               ",
"                  ͼ     (123) 555-1212            Compatible       ",
"   Buffered Windows    Background Printing     Mouse Support                "
};
char  *Info_strs[6] =
{
"                      UltraWin V2.60 by EnQue Software                      ",
"   To order large model libraries, source code, and manual, send $99.95 to: ",
"                               EnQue Software                               ",
"                             Route #1, Box 116C                             ",
"                           Pleasant Hill, Mo. 64080                         ",
"              Voice/Fax 816-987-2515    24 Hour BBS 816-353-0991            "
};
void title_screen( void )
{
  static    int offsets[6] = { 79,79,79,79,79,79 };
  int       i, r, c, c1 = 7, c2 = (c1 + 9) % 16, sinx = 0;
  int       x_off = (V_cols / 2) - 39;
  int       y_off = (V_rows / 2) - 8;
  int       len = strlen(Wave_strs[0]);
  int       w_off = 0;
  WINDOW    u_wn, b_wn;
  uchar     b = 0, *mask, *src;

  wn_create(x_off, y_off, x_off + 77, y_off + 13, DBL_BDR, WN_POPUP, &b_wn);
  wn_att((c1 << 4) | WHITE, &b_wn);
  wn_bdratt((c1 << 4) | WHITE, &b_wn);
  wn_set( &b_wn);
  wn_create(x_off, y_off, x_off + 77, y_off + 13, NO_BDR, WN_NORMAL, &u_wn);
  wn_att((c1 << 4) | WHITE, &u_wn);
  wn_bdratt((c1 << 4) | WHITE, &u_wn);
  wn_set( &u_wn);
  wn_border(&b_wn);
  wn_set_scroll(OFF,&u_wn);
  wn_set_scroll(OFF,&b_wn);
  mv_cs(1, 1, &u_wn);
  wn_qch(len, ' ', &u_wn);
  for (i=0; i<10; i++)
    wn_plst(1, i + 2, Title_strs[i], &u_wn);
  mv_cs(1, 12, &u_wn);
  wn_qch(len, ' ', &u_wn);

  mask = b_wn.mask;
  src =  u_wn.buff;
  for( r = 0; r < wn_get_rows(&b_wn); r++ )
    for( c = 0; c < wn_get_cols(&b_wn); c++, mask++, src+=2 )
      if ( ((*src != ' ') && (*src != 0)) )
        *mask += 1;
  wn_set_mask_on(ON,&b_wn);
  while ( !check_key() )
  {
    if( !(Tics % 5) )
    {
      if( sinx < 6 )
      {
        if( offsets[sinx] >= 0 )
        {
          mv_cs(offsets[sinx]--, 15 + sinx,  &Main_wn);
          wn_st_qty(Info_strs[sinx], 79 - offsets[sinx], &Main_wn);
        }else
          sinx++;
      }
      if ((++b) >= (uchar) len)
      {
        b = 0;
        c1 = (c1 + 1) % 8;
        c2 = (c1 + 9) % 16;
        wn_att((c1 << 4) | WHITE, &b_wn);
        wn_bdratt((c1 << 4) | WHITE, &b_wn);
        wn_border(&b_wn);
        wn_att((c1 << 4) | c2, &u_wn);
        mv_cs(1, 1, &u_wn);
        wn_qch(len, ' ', &u_wn);
        for (i=0; i<10; i++)
          wn_plst(1, i + 2, Title_strs[i], &u_wn);
        mv_cs(1, 12, &u_wn);
        wn_qch(len, ' ', &u_wn);
        if( ++w_off >= 6 )
          w_off = 0;
      }
      for( i = 0; i < 7; i++ )
      {
        mv_cs(0, i + w_off, &b_wn);
        if (len - b)
          wn_st_qty(&Wave_strs[i][b], len - b, &b_wn);
        if (b)
          wn_st_qty(&Wave_strs[i][0], b, &b_wn);
      }
    }
  }
  for (i=0; i<6; i++)
    wn_plst(0, 15 + i, Info_strs[i], &Main_wn);
  wait_event();
  wn_clear(&u_wn);
  wn_border(&b_wn);
  for( i = 0; i < 7; i++ )
    wn_plst(1, i + 3, &Wave_strs[i][0], &u_wn);
  wait(0);
  wn_clear(&Main_wn);
  wn_destroy(&u_wn);
  wn_destroy(&b_wn);
}
/*** end of title_screen ***/

/*****************/
/* ~wn_menu_demo */
/*               ************************************************************/
/* This routine demonstrates UltraWin's menuing capabilities...             */
/* the main polling loop!                                                   */
/****************************************************************************/
int wn_menu_demo( void )
{
  int id, i;
  uchar back_att  = (LIGHTGRAY << 4) | BLACK,
        bdr_att   = (LIGHTGRAY << 4) | BLACK,
        csr_att   = (CYAN << 4) | YELLOW,
        first_att = (LIGHTGRAY << 4) | RED;

  wn_clear(&Main_wn);
  /*-------------------- demonstrate menuing capabilities ------------------*/
  wn_prompt("Use the arrow keys or your mouse to traverse the menu tree!",0);

  /*------------------------- create top menu ------------------------------*/
  menu_create(0, 4, V_cols - 1, 3, M_HORIZONTAL,
              back_att, bdr_att, csr_att, first_att,
              NO_BDR, WN_NORMAL, Top_mnp);
  item_add( "   Files   ", 1, 3, &Top_menu );
  item_add( " Terminals ", 2, 1, &Top_menu );
  item_add( "   Setup   ", 3, 3, &Top_menu );
  item_add( "  Windows  ", 4, 2, &Top_menu );

  Drop_mnps[0] = &Files_menu;
  Drop_mnps[1] = &Terminal_menu;
  Drop_mnps[2] = &Setup_menu;
  Drop_mnps[3] = &Window_menu;
  /*------------------------ create file menu ------------------------------*/
  menu_create(0, 5, 21, 12, M_VERTICAL,
    back_att, bdr_att, csr_att, first_att,
    SGL_BDR, WN_NORMAL, Drop_mnps[0]);
  item_add( " Text Editor   Alt-E", 5, 6, &Files_menu );
  item_add( " Hex Editor    Alt-H", 6, 1, &Files_menu );
  item_add( " File Manager  Alt-F", 7, 1, &Files_menu );
  item_add( " Calculator    Alt-C", 8, 1, &Files_menu );
  item_add( " Dos Shell     Alt-O", 9, 5, &Files_menu );
  item_add( " Quit          Alt-Q",10, 1, &Files_menu );

  /*----------------------- create terminal menu ---------------------------*/
  menu_create(11, 5, 32, 11, M_VERTICAL,
   back_att, bdr_att, csr_att, first_att, SGL_BDR, WN_NORMAL, Drop_mnps[1]);
  item_add( " Add Terminal  Alt-T",  11, 1, &Terminal_menu );
  item_add( " Settings      Alt-F6", 12, 1, &Terminal_menu );
  item_add( " Receive File  Alt-F7", 13, 1, &Terminal_menu );
  item_add( " Transmit File Alt-F8", 14, 1, &Terminal_menu );
  item_add( " Comm Status   Alt-S",  15, 6, &Terminal_menu );

  /*-------------------------- create setup menu ---------------------------*/
  menu_create(22, 5, 43,10, M_VERTICAL,
    back_att, bdr_att, csr_att, first_att, SGL_BDR, WN_NORMAL, Drop_mnps[2]);
  item_add( " Mouse Setup        ", 16, 1, &Setup_menu);
  item_add( " Video Mode    Alt-V", 17, 1, &Setup_menu );
  item_add( " Window Color  Alt-W", 18, 1, &Setup_menu );
  item_add( " Border Color  Alt-B", 19, 1, &Setup_menu );

  /*-------------------------- create window menu --------------------------*/
  menu_create(33, 5, 48, 9, M_VERTICAL,
    back_att, bdr_att, csr_att, first_att,  SGL_BDR, WN_NORMAL, Drop_mnps[3]);
  item_add( " Delete  Alt-D", 20, 1, &Window_menu );
  item_add( " Size    Alt-S", 21, 1, &Window_menu );
  item_add( " Move    Alt-M", 22, 1, &Window_menu );

  /*----------------------------- let's roll -------------------------------*/
  wn_create( 0, 4, V_cols - 1, V_rows - 4, SGL_BDR, WN_NORMAL, Back_wnp );
  wn_color( WHITE, RED, Back_wnp );
  wn_bdr_color( WHITE, RED, Back_wnp );
  link_window(Back_wnp);
  menu_set(Top_mnp);
  m_show();
  set_idle_func(background_func);
  id = menu_system(Top_mnp, Drop_mnps, 0);
  set_idle_func(NULL);
  m_hide();
  menu_restore(Top_mnp);
  unlink_window(Back_wnp);
  wn_destroy(Back_wnp);
  menu_destroy(Top_mnp);                            /* destroy all menus!   */
  for( i = 0; i < 4; i++ )
    menu_destroy(Drop_mnps[i]);
  return(id);
}
/*** end of wn_menu_demo ***/

/********************/
/* ~background_func */
/*                  *********************************************************/
/* This is the function we pass set_idle_func to do the background stuff!   */
/* We just output to the Back_wnp global window piointer some colored text. */
/****************************************************************************/
int background_func( void )
{
  int att;

  if( !(Tics % 10) )
  {
    att = wn_get_att(Back_wnp) & 0x0f;              /* roll through colors  */
    att = (att + 1) % 16;
    if( att == RED )
      att = (att + 1) % 16;
    wn_att(wn_get_att(Back_wnp) & 0xf0, Back_wnp);
    wn_att(wn_get_att(Back_wnp) | att,  Back_wnp);
    m_hide();
    wn_st("UltraWin Library. Power, Speed, Ease!   ", Back_wnp );
    m_show();
  }
  return(1);
}
/*** end of background_func ***/

/******************/
/* ~wn_change_att */
/*                ***********************************************************/
/* This routine changes the color of a window...                            */
/* This demonstrates low level window control...                            */
/****************************************************************************/
void wn_change_att( uchar new_att, uchar old_att, WINDOW *wnp )
{
  int i, cnt;
  uchar *dest = wnp->buff;

  old_att  = get_att(old_att);
  new_att  = get_att(new_att);
  cnt = wn_get_rows(wnp) * wn_get_cols(wnp);
  dest++;
  for( i = 0; i < cnt; i++, dest += 2 )
    if( *dest == (uchar) old_att )
      *dest = new_att;
  wn_border( wnp );
  wn_rfsh( wnp );
}
/*** end of wn_change_att ***/

/*****************/
/* ~wn_font_demo */
/*               ************************************************************/
/* This routine shows the various font capabilities in EGA/VGA...           */
/****************************************************************************/
void wn_font_demo( void )
{
  int i, r, c, x;
  WINDOW wn;

  wn_clear(&Main_wn);
  if( (Font8x14 = (uchar *) calloc(256,14)) == NULL )
  {
    wn_printf(&Main_wn,"Sorry, not enough memory to allocate font!");
    wait(0);
    return;
  }
  if( !EgaVga )
  {
    wn_plst( CENTERED, 3,
      "Sorry, cannot demonstrate fonts on a non-EGA/VGA compatible adapter",
      &Main_wn );
    wait_ticks(18L*3L);
    return;
  }
  push(Font_spacing);
  /*------------------- demonstrate font capabilities... -------------------*/
  wn_prompt("UltraWin has multiple text font capabilities....",0);
  wn_create( 30, 4, 50, 23, SGL_BDR, WN_NORMAL, &wn );
  wn_color( YELLOW, RED, &wn );
  wn_bdr_color( LIGHTGRAY, RED, &wn );
  wn_name("Font Window", &wn);
  link_window(&wn);

  for( i = 0; i < 4; i++ )
  {
    wn_clear(&wn);
    switch( i )
    {
      case 1:
        setmem( Font8x14, 256*14, 0 );
        install_font( Font8x14, 0, 0, 256, 14, 0 );
        rom8x8(0,0);
        break;
      case 2:
        rom8x14(0,0);
        break;
      case 3:
        wn_plst(CENTERED, 0, "Now we have 512 unique characters on the screen at one time!", &Main_wn);
        load_font( Font8x14, "8x14icon.fnt" );
        if( Vga )
          rom8x14(0,1), rom8x14(1,1), mv_csr(0,80);
        install_font( Font8x14, 1, 0, 256, 14, 0 );
        set_block_ab(0,1);
        break;
    }
    Font_spacing = 14;
    for( x = r = 0; r < 16; r++ )
      for( c = 0; c < 16; c++,x++ )
        mv_cs( c, r, &wn ), wn_ch((uchar) x, &wn);
    wait(0);
  }
  if( Vga )
    rom8x16(0,1), rom8x16(1,1), mv_csr(0,80);
  else
    rom8x14(0,0);
  set_block_ab(0,0);
  free(Font8x14);
  unlink_window(&wn);
  wn_destroy(&wn);
  pop(Font_spacing);
}
/*** end of wn_font_demo ***/

/******************/
/* ~wn_print_demo */
/*                ***********************************************************/
/*                                                                          */
/* Here we demostrate the capabilities of the background/dynamic printing   */
/* routines...                                                              */
/*                                                                          */
/* NOTE: All output will be directed to DOS files "out1.prt" & "out2.prt"   */
/*                                                                          */
/*                                                                          */
/* 1) First we set up a 1k ram based print queue that is allowed to "grow"  */
/*    up to 8k.  As the queue is emptied, it automatically shrinks,        */
/*    thereby minimizing memory usage. Note that the queue can be setup     */
/*    with an initial size equal to it's maximum size so that the dynamic   */
/*    sizing does not occur.                                                */
/*                                                                          */
/* 2) Next, we use a 128k disk based queue, requiring no memory, save a     */
/*    small amount of stack space, and print out the exact same data...     */
/*                                                                          */
/* 3) Last, but not least, we will output to both the ram based and disk    */
/*    based queues at the same time!                                        */
/****************************************************************************/
void wn_print_demo( void )
{
  int i, c, x;
  char buffer[81];
  ulong start, end;
  long secs;
  PRINT *p[2];

  wn_clear(&Main_wn);
  wn_prompt("UltraWin has background printing support!",0);

  wn_plst( CENTERED, 2, "Welcome to the UltraWin Printer Facilities!", &Main_wn );
  wn_plst( CENTERED, 4, "This demo will setup two printers, both    ", &Main_wn );
  wn_plst( CENTERED, 5, "outputting to DOS files.  The first one is ", &Main_wn );
  wn_plst( CENTERED, 6, "a dynamically sizing ram queue that will   ", &Main_wn );
  wn_plst( CENTERED, 7, "grow up to 8k, and shrink back to 1k when  ", &Main_wn );
  wn_plst( CENTERED, 8, "drained.  Ram based queues can be up to    ", &Main_wn );
  wn_plst( CENTERED, 9, "64k.  The second is a 32k disk based queue ", &Main_wn );
  wn_plst( CENTERED,10, "that requires virtually no memory at all.  ", &Main_wn );
  wn_plst( CENTERED,11, "Queues of this nature can be of any size up", &Main_wn );
  wn_plst( CENTERED,12, "to 2 Gigabytes!  First we will print 8k    ", &Main_wn );
  wn_plst( CENTERED,13, "to each queue separately, then to both     ", &Main_wn );
  wn_plst( CENTERED,14, "concurrently.  Watch the status update as  ", &Main_wn );
  wn_plst( CENTERED,15, "the data is printed in the background.     ", &Main_wn );

/*--------- initialize both a ram based and disk based print queue ---------*/
  if( !init_printer("out1.prt", NULL, 1024L, 8192L, &Printer1) )
  {
    tone(1024,10);
    return;
  }
  if( !init_printer("out2.prt", "disk.buf", 32768L, 32768L, &Printer2) )
  {
    tone(1024,10);
    return;
  }
  p[0] = &Printer1;
  p[1] = &Printer2;
  set_idle_func(print_in_bkgrnd);       /* wait event will call this for us */
  wait(0);

  for( i = 0; i < 2; i++ )
  {
    wn_create( 2, 6 + (i*8) + i, V_cols-3, 12 + (i*8) + i, SGL_BDR, WN_POPUP, &Print_wn[i] );
    wn_color( LIGHTGRAY, RED, &Print_wn[i] );
    wn_bdr_color( LIGHTGRAY, RED, &Print_wn[i] );
    sprintf( buffer, "Printer %d", i + 1 );
    wn_name(buffer, &Print_wn[i]);
    link_window(&Print_wn[i]);
  }
/*----------------------------- perform steps 1&2 --------------------------*/
  for( x = 0; x < 2; x++ )
  {
    wn_clear( &Main_wn);
    start = Tics;
    wn_plst( CENTERED, 2, "Queueing 8K bytes of data...", &Main_wn );
    p[x]->block_mode = 1;
    i = 0;
    disp_print_stats( p[x], 1, &Print_wn[x] );
    while( p[x]->cnt < 8000L )
    {
      sprintf( buffer, "This is line %4d \r", i++ );
      print_str( (uchar *) buffer, p[x] ), print_eol( p[x] );
      if( i % 100 )
        disp_print_stats( p[x], 0, &Print_wn[x] );
      else
        disp_print_stats( p[x], 1, &Print_wn[x] );
    }
    wn_st( "done!", &Main_wn );
    wn_plst( CENTERED, 3, "Now lets print the data...", &Main_wn );
    c = 0;
    while( (p[x]->cnt > 0L)  )
    {
      if( check_key() )
      {
        get_key();
        mv_cs( c++, 4, &Main_wn );
        wn_ch( (uchar) Event.key, &Main_wn );
      }
      print_in_bkgrnd();      /* this would be called automatically if we   */
                              /* called wait event. Otherwise, call it as   */
                              /* often as you can to perform printer output.*/
      disp_print_stats( p[x], 0, &Print_wn[x] );
    }
    disp_print_stats( p[x], 1, &Print_wn[x] );
    wn_plst( CENTERED, 3, "  Now lets print the data...done!  ", &Main_wn );
    end = Tics;
    mv_cs( 20, 1, &Main_wn );
    secs = ((end - start) * 100L) / 91L;
    wn_printf( &Main_wn, "Time: = ~%ld.%02ld seconds  ~%-5d bytes/sec",
      secs / 100L, secs % 100L, (int)(800000L/secs) );
    wait(0);
  }
/*------------------------------- perform steps 3 --------------------------*/
  wn_clear( &Main_wn);
  start = Tics;
  wn_plst( CENTERED, 2, "Queueing 8K bytes of data...", &Main_wn );
  i = 0;
  disp_print_stats( p[0], 1, &Print_wn[0] );
  disp_print_stats( p[1], 1, &Print_wn[1] );
  while( p[0]->cnt < 8000L )
  {
    sprintf( buffer, "This is line %4d \r", i++ );
    print_str( (uchar *) buffer, p[0] ), print_eol( p[0] );
    print_str( (uchar *) buffer, p[1] ), print_eol( p[1] );
    if( i % 100 )
    {
      disp_print_stats( p[0], 0, &Print_wn[0] );
      disp_print_stats( p[1], 0, &Print_wn[1] );
    }else{
      disp_print_stats( p[0], 1, &Print_wn[0] );
      disp_print_stats( p[1], 1, &Print_wn[1] );
    }
  }
  wn_st( "done!", &Main_wn );
  wn_plst( CENTERED, 3, "Now lets print the data...", &Main_wn );
  c = 0;
  while( (p[0]->cnt > 0L) || (p[1]->cnt > 0L) )
  {
    if( check_key() )
    {
      get_key();
      mv_cs( c++, 1, &Main_wn );
      wn_ch( (uchar) Event.key, &Main_wn );
    }
    print_in_bkgrnd();        /* this would be called automatically if we   */
                              /* called wait event. Otherwise, call it as   */
                              /* often as you can to perform printer output.*/
    disp_print_stats( p[0], 0, &Print_wn[0] );
    disp_print_stats( p[1], 0, &Print_wn[1] );
  }
  disp_print_stats( p[0], 1, &Print_wn[0] );
  disp_print_stats( p[1], 1, &Print_wn[1] );
  wn_plst( CENTERED, 3, "  Now lets print the data...done!  ", &Main_wn );
  end = Tics;
  mv_cs( 20, 1, &Main_wn );
  secs = ((end - start) * 100L) / 91L;
  wn_printf( &Main_wn, "Time: = ~%ld.%02ld seconds  ~%-5d bytes/sec",
    secs / 100L, secs % 100L, (int)(1600000L/secs) );
  wait(0);
  /*------------------------------------------------------------------------*/

  unlink_window(&Print_wn[0]);
  wn_destroy(&Print_wn[0]);
  unlink_window(&Print_wn[1]);
  wn_destroy(&Print_wn[1]);
  end_printer( &Printer1 );
  end_printer( &Printer2 );
  wn_clear(&Main_wn);
}
/*** end of wn_print_demo ***/

/*********************/
/* ~disp_print_stats */
/*                   *******************************************************/
/*  This routine prints important variables in the printer structure to the*/
/*  desired window and is used primarily for debugging.  If the mode is    */
/*  1, all variables are printed, if 0, only the Read, Write, and Cnt are  */
/*  printed for speed.                                                     */
/*                                                                         */
/* Device:lpt1                                  Buffer:   disk.buf         */
/* Read  :    4343     Init Size:     2000      Active:1      CR  :1       */
/* Write :    6648     Max  Size:    32000      Halt  :1      LF  :2       */
/* Cnt   :    2345     Curr Size:    16000      Block :1      Xlat:0       */
/***************************************************************************/
void disp_print_stats( PRINT *p, int mode, WINDOW *wnp )
{
  mv_cs( 0, 1, wnp );
  wn_printf( wnp, "Read  :%8ld", p->read  );
  mv_cs( 0, 2, wnp );
  wn_printf( wnp, "Write :%8ld", p->write );
  mv_cs( 0, 3, wnp );
  wn_printf( wnp, "Cnt   :%8ld", p->cnt   );
  if( mode )
  {
    mv_cs( 0, 0, wnp );
    wn_printf( wnp, "Device:%-20s   Buffer:%-20s", p->device, p->buffer );
    mv_cs( 20, 1, wnp );
    wn_printf( wnp, "Init Size:%8ld    Active:%d    CR  :%d",
      p->init_que_size, p->active, p->cr_cnt );
    mv_cs( 20, 2, wnp );
    wn_printf( wnp, "Max  Size:%8ld    Halt  :%d    LF  :%d",
      p->max_que_size, p->halt, p->lf_cnt  );
    mv_cs( 20, 3, wnp );
    wn_printf( wnp, "Curr Size:%8ld    Block :%d    Xlat:%d",
      p->curr_que_size, p->block_mode, p->xlat_flag );
  }
}
/*** end of disp_print_stats ***/

/**** END OF FILE ****/

