
/****************************************************************************/
/*                                                                          */
/* UW_GLOBX.H                                                               */
/*                                                                          */
/* This module contains all the externs used by the UltraWIN library.       */
/*                                                                          */
/*                                                          Kevin Huck      */
/*                                                          Boyd Gafford    */
/*                                                                          */
/****************************************************************************/
#ifndef __UW_GLOB_H
#ifndef __UW_GLOBX_H
#define __UW_GLOBX_H
#include <conio.h>

extern uchar UW_FAR *Screen;            /* pointer to physical screen loc   */

extern int    Num_windows;              /* number of open windows on desk!  */
extern int    V_cols;                   /* columns on the video screen      */
extern int    V_rows;                   /* rows on the video screen         */
extern int    V_mode;                   /* old video mode!                  */

extern int    DV_seg;                   /* Desqview variables               */
extern int    DV_off;
extern int    DV_flag;
extern int    DV_upd;

extern uchar  Dflt_att;
extern uchar  Dflt_bdr_att;

extern int    Stack[64];
extern int    Stack_ptr;                /* stack to save wn states          */
extern int    Csr_visible;              /* is the cursor visible            */
extern int    Csr_in_use;               /* is the cursor used by a popup?   */
extern char   Hide_entry_mask;          /* the mask for passwords, etc      */
extern EVENT  Event;                    /* the global event variable        */
extern int    Mouse_exists;             /* is the mouse available or not?   */

extern WINDOW *First_window;            /* manager first window pointer     */
extern WINDOW *Last_window;             /* manager last window pointer      */

extern int (*Idle_func)(void);          /* global function pointer          */
extern int (*Key_func)(int, int);       /* background key function pointer  */
                                        /* validation function pointer      */
extern int (*Vld_func)(char*, char*, char*, int, int, WINDOW*);
                                        /* gets hook function pointer       */
extern int (*Gets_hook_func)(char*, char*, char*, int, int, int, EVENT*, WINDOW*);

extern void (*Graphic_func)(int, int, uchar); /* single char output function*/
extern uchar  Fgnd, Bkgnd;              /* fore/background for graphics mode*/
extern int    X_res, Y_res;             /* x, y, res for graphics mode      */
extern int    Font_rows, Font_spacing;  /* rows in font, font spacing       */
extern int    Gseg, Goff;               /* graphics screen segment, offset  */
extern int    Bytes_per_row;            /* bytes per graphics row           */
extern int    Ega, Vga, EgaVga;         /* 1 if present (mutually exclusive)*/
extern int    G_csrx, G_csry;
extern int    G_csr_char, G_opt;
extern PRINT  *Printers[MAX_PRINTERS];  /* printer queue structure pointers */

extern volatile int Uw_timers[4];       /* user timers - decrement to 0     */
extern volatile int Sys_timers[2];
extern volatile int Sound_timer;        /* system/sound timers              */
extern int    Clock_init;               /* 1 if we have clock vector        */
extern int    Sound_on;                 /* 1 when sound is on               */
extern ulong  Tics;                     /* total clock interrupts           */
extern int    Tics_per_sec;             /* clock tics per second            */  
extern int    Video_init;               /* 1 if we have init'd video (V2.5) */
extern int    Mouse_init;               /* 1 if we have init'd mouse (V2.5) */

extern int    Dbg_log_on, Dbg_stack_on; /* internal debug support           */
extern int    Dbg_line;
extern char  *Dbg_file;

#endif /* __UW_GLOBX_H */
#endif /* __UW_GLOB_H  */

/**** END OF FILE ****/
