/****************************************************************************/
/* UW_TUT3.C                                                                */
/*                                                                          */
/* NOTE: THIS FILE IS PUBLIC DOMAIN AND MAY BE MODIFIED AND USED AT WILL    */
/*                                                                          */
/* Next, we setup a fullscreen background or desktop window and demonstrate */
/* the use of the window manager.                                           */
/*                                                         Dr. Boyd Gafford */
/*                                                         Kevin Huck       */
/*                                                         EnQue Software   */
/*                                                         08/31/92         */
/****************************************************************************/
#include <ctype.h>
#include "uw.h"                           /* include the necessary headers  */

/*----------------------- global window variables --------------------------*/
WINDOW   Desk_window, Window1;

/*********/
/* ~main */
/*       ********************************************************************/
/*  Demonstrate window manager...                                           */
/****************************************************************************/
int main()
{
  WINDOW *wnp;
  
  wnp = &Window1;                         /* set local window pointer       */
  init_video(80, 25);                     /* init video for 80 x 25 screen  */
  init_clock(0x3333);                     /* init clock irq at 91 tics/sec  */

/*-------- Here we create a fullscreen desktop window and add it -----------*/
/*-------- to the window manager using link_window. This sets it -----------*/
/*-------- on the screen and puts it under the manager's control -----------*/ 
  wn_create(0, 0, V_cols-1, V_rows-1, NO_BDR, WN_NORMAL, &Desk_window);
  link_window(&Desk_window);
  wn_plst( CENTERED, 12, "This is the background window", &Desk_window);
  wait_event();
  
/*-------- Do the same for the other window.  Note that this     -----------*/
/*-------- window does not need to be a popup as the window      -----------*/
/*-------- manager will automatically restore the area under the -----------*/ 
/*-------- window when removed by the function unlink_window     -----------*/ 
  wn_create(20, 5, 60, 20, SLD_BDR, WN_NORMAL, wnp);
  wn_color(YELLOW, BLUE, wnp);            /* change the window colors       */
  wn_bdr_color(WHITE, BLUE, wnp);         /* change the border's colors     */
  link_window(wnp);
  
  wn_plst( CENTERED, 7, "This is the top window", wnp);
  wait_event();                           /* wait for a keystroke           */

/*-------- Now, here's the slick part.  The top window is        -----------*/
/*-------- "over" the first string we wrote; however, we will    -----------*/
/*-------- write another string below the first one.  You will   -----------*/ 
/*-------- not see the output until the top window is removed.   -----------*/ 
/*-------- In this way, using the manager, you never have to     -----------*/ 
/*-------- worry about wether a window is overlapped or not!     -----------*/ 
  wn_plst( CENTERED,  8, "Writing to background window", wnp);
  wn_plst( CENTERED, 13, "------------- This was written while overlapped! ------------", &Desk_window);
  wn_plst( CENTERED,  9, "Done - hit a key to remove window", wnp);
  wait_event(); 
  unlink_window(wnp);                     /* remove the window from screen, */
  wn_destroy(wnp);                        /* and destroy it                 */
  wait_event();
  unlink_window(&Desk_window);            /* remove the window from screen  */
  wn_destroy(&Desk_window);               /* and destroy it                 */
  end_video();                            /* clean up before we exit        */
  return(1);
}
/*** end of main ***/

/*** END OF FILE ***/
