/****************************************************************************/
/* UW_TUT4.C                                                                */
/*                                                                          */
/* NOTE: THIS FILE IS PUBLIC DOMAIN AND MAY BE MODIFIED AND USED AT WILL    */
/*                                                                          */
/* Now we add a real-time clock that updates in the background!  This       */
/* demonstrates the use of the UltraWin timer interrupt facility and        */
/* the "background" idle function. We'll use the background function        */
/* later to print data...                                                   */
/*                                                         Dr. Boyd Gafford */
/*                                                         Kevin Huck       */
/*                                                         EnQue Software   */
/*                                                         08/31/92         */
/****************************************************************************/
#include <time.h>
#include <ctype.h>
#include "uw.h"                           /* include the necessary headers  */

/*----------------------- global window variables --------------------------*/
WINDOW   Desk_window, Window1;

/*-------------------------------- prototypes ------------------------------*/
int disp_time( void );

/*********/
/* ~main */
/*       ********************************************************************/
/*  Demonstrate background function and timer interrupt facility...         */
/****************************************************************************/
int main()
{
  WINDOW *wnp;
  
  wnp = &Window1;                         /* set local window pointer       */
  init_video(80, 25);                     /* init video for 80 x 25 screen  */
  init_clock(0x3333);                     /* init clock irq at 91 tics/sec  */

  wn_create(0, 0, V_cols-1, V_rows-1, NO_BDR, WN_NORMAL, &Desk_window);
  link_window(&Desk_window);

  set_idle_func(disp_time);               /* set background clock function  */

  wn_plst( CENTERED, 12, "This is the background window", &Desk_window);
  wait_event();

  wn_create(20, 5, 60, 20, SLD_BDR, WN_POPUP, wnp);
  wn_color(YELLOW, BLUE, wnp);            /* change the window colors       */
  wn_bdr_color(WHITE, BLUE, wnp);         /* change the border's colors     */
  link_window(wnp);
  
  wn_plst( CENTERED, 6, "This is the popup window", wnp);
  wn_plst( CENTERED, 7, "Notice the clock in the lower right", wnp);
  wn_plst( CENTERED, 8, "hand corner, updating in the background", wnp);
  wait_event();                           /* wait for a keystroke           */

  unlink_window(wnp);                     /* remove the window from screen  */
  wn_destroy(wnp);
  wait_event();
  set_idle_func(NULL);                    /* remove background function     */
  unlink_window(&Desk_window);            /* remove the window from screen  */
  wn_destroy(&Desk_window);
  end_clock();
  end_video();                            /* clean up before we exit        */
  return(1);
}
/*** end of main ***/

/**************/
/* ~disp_time */
/*            ***************************************************************/
/*  This routine is called in the background by wait_event and will display */
/*  the time once per second.  Notice the use of the global variables       */
/*  Uw_timers.  There is an array of four "countdown" timers that are user  */
/*  accessible.  Each "timer tic" will decrement the counts by one, until   */
/*  0 is reached.  By "reloading" the timer with "Tics_per_sec", we only    */
/*  display the time of day once per second.  "Tics_per_sec" is set         */
/*  by init_clock.                                                          */
/****************************************************************************/
int disp_time( void )
{
  time_t t;
  if( !Uw_timers[0] )                           /* has one second passed?   */
  {
    Uw_timers[0] = Tics_per_sec;                /* if so, reload timer      */
    t = time(NULL);                             /* get time                 */
    mv_cs(55, V_rows-1, &Desk_window);          /* move window cursor       */
    wn_st_qty(ctime(&t), 24, &Desk_window);     /* output 24 characters     */
    return(1);
  }
  return(0);
}
/*** end of disp_time ***/

/*** END OF FILE ***/
