VERSION 2.00
Begin Form CalSel 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "New File Date"
   ClientHeight    =   4980
   ClientLeft      =   2745
   ClientTop       =   1095
   ClientWidth     =   3525
   ControlBox      =   0   'False
   Height          =   5385
   Icon            =   0
   Left            =   2685
   LinkMode        =   1  'Source
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4980
   ScaleWidth      =   3525
   Top             =   750
   Width           =   3645
   Begin HScrollBar HScroll1 
      Height          =   255
      LargeChange     =   50
      Left            =   240
      Max             =   2107
      Min             =   1980
      TabIndex        =   3
      Top             =   3360
      Value           =   1980
      Width           =   3015
   End
   Begin Spin Spin3 
      BackColor       =   &H00C0C0C0&
      BoundaryBeep    =   0   'False
      ChangeValue     =   1
      Height          =   375
      Left            =   240
      Max             =   2107
      Min             =   1980
      Top             =   2880
      Value           =   1980
      Width           =   255
      WrapAround      =   -1  'True
   End
   Begin Spin Spin2 
      BackColor       =   &H00C0C0C0&
      BoundaryBeep    =   0   'False
      ChangeValue     =   1
      Height          =   375
      Left            =   240
      Max             =   12
      Min             =   1
      Top             =   3840
      Value           =   1
      Width           =   255
      WrapAround      =   -1  'True
   End
   Begin Spin Spin1 
      BackColor       =   &H00C0C0C0&
      BoundaryBeep    =   0   'False
      ChangeValue     =   10
      Height          =   375
      Left            =   1440
      Max             =   2107
      Min             =   1980
      Top             =   2880
      Value           =   1980
      Width           =   255
      WrapAround      =   -1  'True
   End
   Begin PictureBox PicCal 
      BorderStyle     =   0  'None
      Height          =   2055
      Left            =   240
      ScaleHeight     =   2055
      ScaleWidth      =   3015
      TabIndex        =   2
      Top             =   720
      Width           =   3015
   End
   Begin CommandButton CmdOkay 
      BackColor       =   &H00C0C0C0&
      Caption         =   "O &K A Y"
      Default         =   -1  'True
      Height          =   375
      Left            =   1920
      TabIndex        =   0
      Top             =   4440
      Width           =   1335
   End
   Begin CommandButton CmdCancel 
      BackColor       =   &H00C0C0C0&
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   375
      Left            =   1080
      TabIndex        =   4
      Top             =   4440
      Width           =   855
   End
   Begin CommandButton CmdToday 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Today"
      Height          =   375
      Left            =   240
      TabIndex        =   1
      Top             =   4440
      Width           =   855
   End
   Begin Label Label7 
      BackStyle       =   0  'Transparent
      Caption         =   "Sat"
      Height          =   200
      Left            =   2880
      TabIndex        =   16
      Top             =   525
      Width           =   375
   End
   Begin Label Label6 
      BackStyle       =   0  'Transparent
      Caption         =   "Fri"
      Height          =   200
      Left            =   2465
      TabIndex        =   15
      Top             =   525
      Width           =   375
   End
   Begin Label Label5 
      BackStyle       =   0  'Transparent
      Caption         =   "Thr"
      Height          =   200
      Left            =   2010
      TabIndex        =   14
      Top             =   525
      Width           =   375
   End
   Begin Label Label4 
      BackStyle       =   0  'Transparent
      Caption         =   "Wed"
      Height          =   195
      Left            =   1560
      TabIndex        =   10
      Top             =   525
      Width           =   390
   End
   Begin Label Label3 
      BackStyle       =   0  'Transparent
      Caption         =   "Tue"
      Height          =   200
      Left            =   1150
      TabIndex        =   13
      Top             =   525
      Width           =   375
   End
   Begin Label Label2 
      BackStyle       =   0  'Transparent
      Caption         =   "Mon"
      Height          =   200
      Left            =   720
      TabIndex        =   12
      Top             =   525
      Width           =   375
   End
   Begin Label Label1 
      BackStyle       =   0  'Transparent
      Caption         =   "Sun"
      Height          =   200
      Left            =   275
      TabIndex        =   11
      Top             =   525
      Width           =   375
   End
   Begin Label LblHeader 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      Caption         =   "Label1"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00000080&
      Height          =   300
      Left            =   240
      TabIndex        =   9
      Top             =   180
      Width           =   3015
   End
   Begin Label LblMonthValue 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      Caption         =   "Label1"
      ForeColor       =   &H00000080&
      Height          =   195
      Left            =   2040
      TabIndex        =   8
      Top             =   3960
      Width           =   1215
   End
   Begin Label LblYearValue 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      Caption         =   "Label2"
      ForeColor       =   &H00000080&
      Height          =   195
      Left            =   2040
      TabIndex        =   7
      Top             =   3000
      Width           =   1215
   End
   Begin Label LblYear 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Year"
      ForeColor       =   &H00800000&
      Height          =   195
      Left            =   600
      TabIndex        =   5
      Top             =   3000
      Width           =   615
   End
   Begin Label LblMonth 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Month"
      ForeColor       =   &H00800000&
      Height          =   195
      Left            =   600
      TabIndex        =   6
      Top             =   3960
      Width           =   615
   End
End
'You can DBL-CLICK to select a date

Dim TempYear As Integer
Dim TempMonth As Integer
Dim TempDate As Integer
Dim FirstTime As Integer
Dim FirstTime2 As Integer
Dim PaintOnce As Integer

Dim PicMouseX, PicMouseY

Dim NoNewCal As Integer

Sub CmdCancel_Click ()
    Unload Me
End Sub

Sub CmdOkay_Click ()
    Header = DateSerial(TempYear, TempMonth, TempDate)
    TheYear = Format$(Header, "yyyy")
    TheMonth = Format$(Header, "m")
    TheDate = Format$(Header, "d")
    Unload Me
End Sub

Sub CmdToday_Click ()
    OldYear = TempYear
    OldMonth = TempMonth
    OldDate = TempDate
    TempYear = Val(Format$(Now, "yyyy"))
    TempMonth = Val(Format$(Now, "mm"))
    TempDate = Val(Format$(Now, "dd"))
    Spin1.Value = TempYear
    Spin3.Value = TempYear
    Hscroll1.Value = TempYear
    Spin2.Value = TempMonth
    
    If (OldYear = TempYear) And (OldMonth = TempMonth) Then
        If OldDate = TempDate Then Exit Sub
        NewDate = TempDate
        TempDate = OldDate
        HiliteDate
        TempDate = NewDate
        HiliteDate
        Exit Sub
        Else
        Header = DateSerial(TempYear, TempMonth, 1)
        LblMonthValue.Caption = Format$(Header, "mmmm")
        LblYearValue.Caption = Format$(TempYear, "####")
        End If
End Sub

Sub DoNewCalendar ()
    SerialThis = DateSerial(TempYear, TempMonth, 1)
    SerialNext = DateSerial(TempYear, TempMonth + 1, 1)
    NbrDays = SerialNext - SerialThis
    If TempDate > NbrDays Then TempDate = NbrDays
    Header = DateSerial(TempYear, TempMonth, TempDate)
    LblHeader.Caption = Format$(Header, "mmmm yyyy")
    If FirstTime = True Then
    'draw the lines
        PicCal.AutoRedraw = True
        'right & bottom borders
        PicCal.DrawMode = 13
        PicCal.Scale
        PicCal.Line (PicCal.Width - 20, 0)-(PicCal.Width - 20, PicCal.Height)
        PicCal.Line (0, PicCal.Height - 20)-(PicCal.Width - 20, PicCal.Height - 20)
        PicCal.Scale (0, 0)-(7, 6)
        'vertical lines
        For X = 0 To 6
            PicCal.Line (X, 0)-(X, 6)
        Next X
        'horizontal lines
        For Y = 0 To 7
            PicCal.Line (0, Y)-(7, Y)
        Next Y
        PicCal.AutoRedraw = False
        FirstTime = False
        End If
    'Fill the calendar dates
    Offset = Weekday(SerialThis) - 1
    For i% = 1 To NbrDays
        StampDate i% + Offset, i%
    Next i%
End Sub

Sub Form_Load ()
    FormCenterForm Me, FileTD
    FirstTime = True
    FirstTime2 = True
    PaintOnce = True
    NoNewCal = False
    TempYear = Val(TheYear)
    TempMonth = Val(TheMonth)
    Spin1.Value = TempYear
    Spin3.Value = TempYear
    Hscroll1.Value = TempYear
    Spin2.Value = TempMonth
    TempDate = Val(TheDate)
    
    Header = DateSerial(TempYear, TempMonth, 1)
    LblMonthValue.Caption = Format$(Header, "mmmm")
    LblYearValue.Caption = Trim$(Str$(TempYear))
    
    Screen.MousePointer = 0
End Sub

Sub Form_Paint ()
    PaintOnce = Not (PaintOnce)
    DoForm3D Me, sunken, 3, 0
    DoForm3D Me, raised, 1, 3
    DoControl3D LblHeader, sunken, 1
    DoControl3D LblYearValue, sunken, 1
    DoControl3D LblMonthValue, sunken, 1
    DoControl3D Spin1, raised, 1
    DoControl3D Spin2, raised, 1
    DoControl3D Spin3, raised, 1
    
    If FirstTime2 = True Then
        FirstTime2 = False
        PaintOnce = Not (PaintOnce)
        DoNewCalendar
        HiliteDate
        Exit Sub
        End If
    If PaintOnce = False Then Exit Sub
    DoNewCalendar
    HiliteDate
End Sub

Sub HiliteDate ()
    Serial = DateSerial(TempYear, TempMonth, 1)
    DayBox = Weekday(Serial) + TempDate - 1
    X% = ((DayBox - 1) Mod 7) + 1
    Y% = ((DayBox - 1) \ 7) + 1
    x1 = (X% - 1) * PicCal.ScaleWidth / 7
    y1 = (Y% - 1) * PicCal.ScaleHeight / 6
    x2 = x1 + PicCal.ScaleWidth / 7
    y2 = y1 + PicCal.ScaleHeight / 6
    PicCal.DrawMode = 7
    PicCal.Line (x1, y1)-(x2, y2), QBColor(11), BF
End Sub

Sub HScroll1_Change ()
    If NoNewCal = True Then
        NoNewCal = False
        Exit Sub
        End If
    TempYear = Hscroll1.Value
    Spin1.Value = Hscroll1.Value
    Spin3.Value = Hscroll1.Value
    LblYearValue.Caption = Format$(TempYear, "####")
    PicCal.Cls
    DoNewCalendar
    HiliteDate
End Sub

Sub PicCal_Click ()
    X% = Int(PicMouseX) + 1
    Y% = Int(PicMouseY) + 1
    DateBox% = X% + (Y% - 1) * 7
    Header = DateSerial(TempYear, TempMonth, 1)
    LastDay% = DateSerial(TempYear, TempMonth + 1, 1) - Header
    FirstDay% = Weekday(Header)
    NewDay = DateBox% - FirstDay% + 1
    
    If DateBox% < FirstDay% Then Exit Sub
    If DateBox% - FirstDay% + 1 > LastDay% Then Exit Sub
    
    HiliteDate
    TempDate = NewDay
    HiliteDate
End Sub

Sub PicCal_DblClick ()
    X% = Int(PicMouseX) + 1
    Y% = Int(PicMouseY) + 1
    DateBox% = X% + (Y% - 1) * 7
    Header = DateSerial(TempYear, TempMonth, 1)
    LastDay% = DateSerial(TempYear, TempMonth + 1, 1) - Header
    FirstDay% = Weekday(Header)
    NewDay = DateBox% - FirstDay% + 1
    If DateBox% < FirstDay% Then Exit Sub
    If DateBox% - FirstDay% + 1 > LastDay% Then Exit Sub
    
    CmdOkay_Click
End Sub

Sub PicCal_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
    PicMouseX = X
    PicMouseY = Y
End Sub

Sub Spin1_Change ()
    TempYear = Spin1.Value
    Spin3.Value = Spin1.Value
    NoNewCal = True
    Hscroll1.Value = Spin1.Value
    LblYearValue.Caption = Format$(TempYear, "####")
    PicCal.Cls
    DoNewCalendar
    HiliteDate
End Sub

Sub Spin2_Change ()
    TempMonth = Spin2.Value
    Header = DateSerial(TempYear, TempMonth, 1)
    LblMonthValue.Caption = Format$(Header, "mmmm")
    PicCal.Cls
    DoNewCalendar
    HiliteDate
End Sub

Sub Spin3_Change ()
    TempYear = Spin3.Value
    Spin1.Value = Spin3.Value
    NoNewCal = True
    Hscroll1.Value = Spin3.Value
    LblYearValue.Caption = Format$(TempYear, "####")
    PicCal.Cls
    DoNewCalendar
    HiliteDate
End Sub

Sub StampDate (Square As Integer, Num As Integer)
    'Build string of day-number digits
    n$ = LTrim$(Str$(Num))

    'Calculate location of box
    X% = ((Square - 1) Mod 7) + 1
    Y% = (Square - 1) \ 7 + 1

    'Set print position
    PicCal.CurrentX = X% - .5 - PicCal.TextWidth(n$) / 2
    PicCal.CurrentY = Y% - .5 - PicCal.TextHeight(n$) / 2

    'Display day number
    PicCal.Print n$
End Sub

