Option Explicit

'---------------------------------------------------------------'
' VB-ASM, Version 1.00                                          '
' Copyright (c) 1994 SoftCircuits Programming                   '
' Redistributed by Permission.                                  '
'                                                               '
' SoftCircuits Programming                                      '
' P.O. Box 16262                                                '
' Irvine, CA 92713                                              '
' CompuServe: 72134,263                                         '
'                                                               '
' This program may be used and distributed freely on the        '
' condition that it is distributed in full and unchanged, and   '
' that no fee is charged for such use and distribution with the '
' exception or reasonable media and shipping charges.           '
'                                                               '
' You may also incorporate any or all portions of this program, '
' and/or include the VB-ASM DLL, as part of your own programs   '
' and distribute such programs without payment of royalties on  '
' the condition that such program do not duplicate the overall  '
' functionality of VB-ASM and/or any of its demo programs, and  '
' that you agree to the following disclaimer.                   '
'                                                               '
' WARNING: Accessing the low-level services of Windows, DOS and '
' the ROM-BIOS using VB-ASM is an extremely powerful technique  '
' that, if used incorrectly, can cause possible permanent       '
' damage and/or loss of data. You are responsible for           '
' determining appropriate use of any and all files included in  '
' this package. SoftCircuits will not be held liable for any    '
' damages resulting from the use of these files.                '
'                                                               '
' SOFTCIRCUITS SPECIFICALLY DISCLAIMS ALL WARRANTIES,           '
' INCLUDING, WITHOUT LIMITATION, ALL IMPLIED WARRANTIES OF      '
' MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND        '
' NON-INFRINGEMENT OF THIRD PARTY RIGHTS.                       '
'                                                               '
' UNDER NO CIRCUMSTANCES WILL SOFTCIRCUITS BE LIABLE FOR        '
' SPECIAL, INCIDENTAL, CONSEQUENTIAL, INDIRECT, OR ANY OTHER    '
' DAMAGES OR CLAIMS ARISING FROM THE USE OF THIS PRODUCT,       '
' INCLUDING LOSS OF PROFITS OR ANY OTHER COMMERCIAL DAMAGES,    '
' EVEN IF WE HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH       '
' DAMAGES.                                                      '
'                                                               '
' Please contact SoftCircuits Programming if you have any       '
' questions concerning these conditions.                        '
'                                                               '
' This demo program shows how to determine various system       '
' information. Many of the items detected do not require        '
' VB-ASM so this program serves as a general-purpose demo       '
' program.                                                      '
'---------------------------------------------------------------'

'VB-ASM DLL declarations
Type REGS
    AX As Integer
    BX As Integer
    CX As Integer
    DX As Integer
    BP As Integer
    SI As Integer
    DI As Integer
    Flags As Integer
    DS As Integer
    ES As Integer
End Type

'REGS Flags bit values
Global Const FLAGS_CARRY = &H1
Global Const FLAGS_PARITY = &H4
Global Const FLAGS_AUX = &H10
Global Const FLAGS_ZERO = &H40
Global Const FLAGS_SIGN = &H80

Declare Function vbGetCtrlModel Lib "VBASM.DLL" (ByVal Ctrl As Long) As Long
Declare Sub vbGetData Lib "VBASM.DLL" (ByVal Pointer As Long, Variable As Any, ByVal nCount As Integer)
Declare Function vbGetLongPtr Lib "VBASM.DLL" (nVariable As Any) As Long
Declare Function vbHiByte Lib "VBASM.DLL" (ByVal nValue As Integer) As Integer
Declare Function vbHiWord Lib "VBASM.DLL" (ByVal nValue As Long) As Integer
Declare Function vbInp Lib "VBASM.DLL" (ByVal nPort As Integer) As Integer
Declare Function vbInpw Lib "VBASM.DLL" (ByVal nPort As Integer) As Integer
Declare Sub vbInterrupt Lib "VBASM.DLL" (ByVal IntNum As Integer, InRegs As REGS, OutRegs As REGS)
Declare Sub vbInterruptX Lib "VBASM.DLL" (ByVal IntNum As Integer, InRegs As REGS, OutRegs As REGS)
Declare Function vbLoByte Lib "VBASM.DLL" (ByVal nValue As Integer) As Integer
Declare Function vbLoWord Lib "VBASM.DLL" (ByVal nValue As Long) As Integer
Declare Function vbMakeLong Lib "VBASM.DLL" (ByVal nLoWord As Integer, ByVal nHiWord As Integer) As Long
Declare Function vbMakeWord Lib "VBASM.DLL" (ByVal nLoByte As Integer, ByVal nHiByte As Integer) As Integer
Declare Sub vbOut Lib "VBASM.DLL" (ByVal nPort As Integer, ByVal nData As Integer)
Declare Sub vbOutw Lib "VBASM.DLL" (ByVal nPort As Integer, ByVal nData As Integer)
Declare Function vbPeek Lib "VBASM.DLL" (ByVal nSegment As Integer, ByVal nOffset As Integer) As Integer
Declare Function vbPeekw Lib "VBASM.DLL" (ByVal nSegment As Integer, ByVal nOffset As Integer) As Integer
Declare Sub vbPoke Lib "VBASM.DLL" (ByVal nSegment As Integer, ByVal nOffset As Integer, ByVal nValue As Integer)
Declare Sub vbPokew Lib "VBASM.DLL" (ByVal nSegment As Integer, ByVal nOffset As Integer, ByVal nValue As Integer)
Declare Function vbRealModeIntX Lib "VBASM.DLL" (ByVal IntNum As Integer, InRegs As REGS, OutRegs As REGS) As Integer
Declare Function vbRecreateCtrl Lib "VBASM.DLL" (ByVal Ctrl As Long) As Integer
Declare Function vbSAdd Lib "VBASM.DLL" (Variable As String) As Integer
Declare Sub vbSetData Lib "VBASM.DLL" (ByVal Pointer As Long, Variable As Any, ByVal nCount As Integer)
Declare Function vbShiftLeft Lib "VBASM.DLL" (ByVal nValue As Integer, ByVal nBits As Integer) As Integer
Declare Function vbShiftRight Lib "VBASM.DLL" (ByVal nValue As Integer, ByVal nBits As Integer) As Integer
Declare Function vbSSeg Lib "VBASM.DLL" (Variable As String) As Integer
Declare Function vbVarPtr Lib "VBASM.DLL" (Variable As Any) As Integer
Declare Function vbVarSeg Lib "VBASM.DLL" (Variable As Any) As Integer


'Windows declarations
Declare Function SendMessage Lib "User" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, lParam As Any) As Long
Declare Function GetVersion Lib "Kernel" () As Long
Declare Function GetWinFlags Lib "Kernel" () As Long
Declare Function GetDeviceCaps Lib "GDI" (ByVal hDC As Integer, ByVal nIndex As Integer) As Integer
Declare Function GetDriveType Lib "Kernel" (ByVal nDrive As Integer) As Integer
Declare Function GetFreeSystemResources Lib "User" (ByVal fuSysResource As Integer) As Integer
Declare Function GetWindowsDirectory Lib "Kernel" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer
Declare Function GetSystemDirectory Lib "Kernel" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer
Declare Function GetFreeSpace Lib "Kernel" (ByVal wFlags As Integer) As Long
Declare Function GlobalCompact Lib "Kernel" (ByVal dwMinFree As Long) As Long
Declare Function GetKeyboardType Lib "Keyboard" (ByVal nTypeFlag As Integer) As Integer
Declare Function GetCaretBlinkTime Lib "User" () As Integer
Declare Function GetSysColor Lib "User" (ByVal nIndex As Integer) As Long
Declare Function GetTimerResolution Lib "User" () As Long
Declare Function SystemParametersInfo Lib "User" (ByVal uAction As Integer, ByVal uParam As Integer, ByVal lpvParam As Long, ByVal fuWinIni As Integer) As Integer
Declare Function GetSystemMetrics Lib "User" (ByVal nIndex As Integer) As Integer
Declare Function SetCapture Lib "User" (ByVal hWnd As Integer) As Integer
Declare Sub ReleaseCapture Lib "User" ()
Declare Function WindowFromPoint Lib "User" (ByVal ptScreen As Any) As Integer
Declare Function GetMessagePos Lib "User" () As Long
Declare Function GetWindowText Lib "User" (ByVal hWnd As Integer, ByVal lpString As String, ByVal aint As Integer) As Integer
Declare Function GetClassName Lib "User" (ByVal hWnd As Integer, ByVal lpClassName As String, ByVal nMaxCount As Integer) As Integer
Declare Function GetParent Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function GetWindowLong Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer) As Long

Global Const WM_USER = &H400
Global Const EM_SETREADONLY = (WM_USER + 31)

Global Const WF_ENHANCED = &H20
Global Const WF_CPU286 = &H2
Global Const WF_CPU386 = &H4
Global Const WF_CPU486 = &H8
Global Const WF_80x87 = &H400

Global Const GFSR_SYSTEMRESOURCES = &H0
Global Const GFSR_GDIRESOURCES = &H1
Global Const GFSR_USERRESOURCES = &H2

Global Const GWL_STYLE = (-16)
Global Const GWL_EXSTYLE = (-20)

Global Const LF_FACESIZE = 32

Type LOGFONT
    lfHeight As Integer
    lfWidth As Integer
    lfEscapement As Integer
    lfOrientation As Integer
    lfWeight As Integer
    lfItalic As String * 1
    lfUnderline As String * 1
    lfStrikeOut As String * 1
    lfCharSet As String * 1
    lfOutPrecision As String * 1
    lfClipPrecision As String * 1
    lfQuality As String * 1
    lfPitchAndFamily As String * 1
    lfFaceName As String * LF_FACESIZE
End Type

'Visual Basic-specific declarations
Global Const ATTR_VOLUME = &H8

'Application-specific declarations
Global Const CATEGORY_WINDOWSINFO = 0
Global Const CATEGORY_DOSINFO = 1
Global Const CATEGORY_HARDWAREINFO = 2
Global Const CATEGORY_DISPLAYINFO = 3
Global Const CATEGORY_PRINTERINFO = 4
Global Const CATEGORY_DRIVESINFO = 5
Global Const CATEGORY_INTVECTORS = 6
Global Const CATEGORY_AUTOEXECBAT = 7
Global Const CATEGORY_CONFIGSYS = 8
Global Const CATEGORY_WININI = 9

Global newLine As String

Function GetColorString (color As Long) As String
    Dim buffer As String

    'Create string to show individual color components
    buffer = "Red=" & CStr(color And &HFF)
    buffer = buffer & ", Green=" & CStr((color And &HFF00&) / &H100)
    buffer = buffer & ", Blue=" & CStr((color And &HFF0000) / &H10000)
    GetColorString = buffer

End Function

Function GetDeviceInfo (hDC As Integer) As String
'Returns a string with detailed information about the given device context
    Dim buffer As String, i As Long

    'Device technology
    buffer = buffer & "Device Technology: "
    Select Case GetDeviceCaps(hDC, 2)
	Case 0
	    buffer = buffer & "Vector Plotter"
	Case 1
	    buffer = buffer & "Raster Display"
	Case 2
	    buffer = buffer & "Raster Printer"
	Case 3
	    buffer = buffer & "Raster Camera"
	Case 4
	    buffer = buffer & "Character Stream"
	Case 5
	    buffer = buffer & "Metafile"
	Case 6
	    buffer = buffer & "Display File"
	Case 7
	    buffer = buffer & "Unknown"
    End Select
    buffer = buffer & newLine

    'Measurements
    buffer = buffer & "Width in Millimeters: " & CStr(GetDeviceCaps(hDC, 4)) & newLine
    buffer = buffer & "Height in Millimeters: " & CStr(GetDeviceCaps(hDC, 6)) & newLine
    buffer = buffer & "Width in Pixels: " & CStr(GetDeviceCaps(hDC, 8)) & newLine
    buffer = buffer & "Height in Pixels: " & CStr(GetDeviceCaps(hDC, 10)) & newLine
    buffer = buffer & "Pixels Per Inch X: " & CStr(GetDeviceCaps(hDC, 88)) & newLine
    buffer = buffer & "Pixels Per Inch Y: " & CStr(GetDeviceCaps(hDC, 90)) & newLine

    'Capabilities
    buffer = buffer & "Number of Bits Per Pixel: " & CStr(GetDeviceCaps(hDC, 12)) & newLine
    buffer = buffer & "Number of Color Planes: " & CStr(GetDeviceCaps(hDC, 14)) & newLine
    buffer = buffer & "Number of Brushes: " & CStr(GetDeviceCaps(hDC, 16)) & newLine
    buffer = buffer & "Number of Pens: " & CStr(GetDeviceCaps(hDC, 18)) & newLine
    buffer = buffer & "Number of Markers: " & CStr(GetDeviceCaps(hDC, 20)) & newLine
    buffer = buffer & "Number of Fonts: " & CStr(GetDeviceCaps(hDC, 22)) & newLine
    buffer = buffer & "Number of Entries in Color Table: " & CStr(GetDeviceCaps(hDC, 24)) & newLine

    'Aspect
    buffer = buffer & "Relative Pixel Width: " & CStr(GetDeviceCaps(hDC, 40)) & newLine
    buffer = buffer & "Relative Pixel Height: " & CStr(GetDeviceCaps(hDC, 42)) & newLine
    buffer = buffer & "Diagonal Pixel Width: " & CStr(GetDeviceCaps(hDC, 44)) & newLine

    'Clipping capabilities
    buffer = buffer & "Clipping Capabilities: "
    Select Case GetDeviceCaps(hDC, 36)
	Case 0
	    buffer = buffer & "None"
	Case 1
	    buffer = buffer & "Rectangle"
	Case 2
	    buffer = buffer & "Region"
	Case Else
	    buffer = buffer & "Unknown"
    End Select
    buffer = buffer & newLine & newLine

    'Raster Capabilites
    i = GetDeviceCaps(hDC, 38)
    buffer = buffer & "Raster Capabilities:" & newLine
    buffer = buffer & "Banding: " & GetYesNo(i And &H2) & newLine
    buffer = buffer & "Fonts > 64K: " & GetYesNo(i And &H400) & newLine
    buffer = buffer & "Bitmaps: " & GetYesNo(i And &H1) & newLine
    buffer = buffer & "Bitmaps > 64K: " & GetYesNo(i And &H8) & newLine
    buffer = buffer & "Device Bitmaps: " & GetYesNo(i And &H8000) & newLine
    buffer = buffer & "Supports SetDIBits() & GetDIBits(): " & GetYesNo(i And &H80) & newLine
    buffer = buffer & "Supports SetDIBitsToDevice(): " & GetYesNo(i And &H200) & newLine
    buffer = buffer & "Performs Flood Fills: " & GetYesNo(i And &H1000) & newLine
    buffer = buffer & "Dev Opaque and DX Array: " & GetYesNo(i And &H4000) & newLine
    buffer = buffer & "Palette-Based Device: " & GetYesNo(i And &H100) & newLine
    buffer = buffer & "Saves Bitmaps Locally: " & GetYesNo(i And &H40) & newLine
    buffer = buffer & "Scaling: " & GetYesNo(i And &H4) & newLine
    buffer = buffer & "Supports StretchBlt(): " & GetYesNo(i And &H800) & newLine
    buffer = buffer & "Supports StretchDIBits(): " & GetYesNo(i And &H2000) & newLine
    buffer = buffer & newLine
    'Curve Capabilites
    i = GetDeviceCaps(hDC, 28)
    buffer = buffer & "Curve Capabilities:" & newLine
    buffer = buffer & "Circles: " & GetYesNo(i And &H1) & newLine
    buffer = buffer & "Pie Wedges: " & GetYesNo(i And &H2) & newLine
    buffer = buffer & "Chords: " & GetYesNo(i And &H4) & newLine
    buffer = buffer & "Ellipses: " & GetYesNo(i And &H8) & newLine
    buffer = buffer & "Wide Borders: " & GetYesNo(i And &H10) & newLine
    buffer = buffer & "Styled Borders: " & GetYesNo(i And &H20) & newLine
    buffer = buffer & "Wide, Styled Borders: " & GetYesNo(i And &H40) & newLine
    buffer = buffer & "Interiors: " & GetYesNo(i And &H80) & newLine
    buffer = buffer & "Rectangles with Rounded Corners: " & GetYesNo(i And &H100) & newLine
    buffer = buffer & newLine

    'Line Capabilites
    i = GetDeviceCaps(hDC, 30)
    buffer = buffer & "Line Capabilities:" & newLine
    buffer = buffer & "Polylines: " & GetYesNo(i And &H2) & newLine
    buffer = buffer & "Markers: " & GetYesNo(i And &H4) & newLine
    buffer = buffer & "Polymarkers: " & GetYesNo(i And &H8) & newLine
    buffer = buffer & "Wide Lines: " & GetYesNo(i And &H10) & newLine
    buffer = buffer & "Styled Lines: " & GetYesNo(i And &H20) & newLine
    buffer = buffer & "Wide, Styled Lines: " & GetYesNo(i And &H40) & newLine
    buffer = buffer & "Interiors: " & GetYesNo(i And &H80) & newLine
    buffer = buffer & newLine

    'Polygonal Capabilites
    i = GetDeviceCaps(hDC, 32)
    buffer = buffer & "Polygonal Capabilities:" & newLine
    buffer = buffer & "Alternate Fill Polygons: " & GetYesNo(i And &H1) & newLine
    buffer = buffer & "Rectangles: " & GetYesNo(i And &H2) & newLine
    buffer = buffer & "Winding Number Fill Polygons: " & GetYesNo(i And &H4) & newLine
    buffer = buffer & "Scan Lines: " & GetYesNo(i And &H8) & newLine
    buffer = buffer & "Wide Borders: " & GetYesNo(i And &H10) & newLine
    buffer = buffer & "Styled Borders: " & GetYesNo(i And &H20) & newLine
    buffer = buffer & "Wide, Styled Borders: " & GetYesNo(i And &H40) & newLine
    buffer = buffer & "Interiors: " & GetYesNo(i And &H80) & newLine
    buffer = buffer & newLine

    'Text Capabilites
    i = GetDeviceCaps(hDC, 34)
    buffer = buffer & "Text Capabilities:" & newLine
    buffer = buffer & "Character Output Precision: " & GetYesNo(i And &H1) & newLine
    buffer = buffer & "Stroke Output Precision: " & GetYesNo(i And &H2) & newLine
    buffer = buffer & "Stroke Clip Precision: " & GetYesNo(i And &H4) & newLine
    buffer = buffer & "90-Degree Rotation: " & GetYesNo(i And &H8) & newLine
    buffer = buffer & "Any-Degree Rotation: " & GetYesNo(i And &H10) & newLine
    buffer = buffer & "Independant X and Y Scaling: " & GetYesNo(i And &H20) & newLine
    buffer = buffer & "Doubled Character Scaling: " & GetYesNo(i And &H40) & newLine
    buffer = buffer & "Integer Character Scaling: " & GetYesNo(i And &H80) & newLine
    buffer = buffer & "Multiples Character Scaling: " & GetYesNo(i And &H100) & newLine
    buffer = buffer & "Double-Weight Characters: " & GetYesNo(i And &H200) & newLine
    buffer = buffer & "Italics: " & GetYesNo(i And &H400) & newLine
    buffer = buffer & "Underlining: " & GetYesNo(i And &H800) & newLine
    buffer = buffer & "Strikeouts: " & GetYesNo(i And &H1000) & newLine
    buffer = buffer & "Raster Fonts: " & GetYesNo(i And &H2000) & newLine
    buffer = buffer & "Vector Fonts: " & GetYesNo(i And &H4000) & newLine

    GetDeviceInfo = buffer

End Function

Function GetDiskSpace (driveNum As Integer, totalSpace As Long, freeSpace As Long) As Integer
'Returns the total and available disk space for the specified drive
'driveNum specifies which drive (0 = default, 1 = A, 2 = B, etc.)
    Dim registers As REGS, bytesPerCluster As Long

    'Request drive allocation information from DOS services
    registers.AX = &H3600
    registers.DX = driveNum
    Call vbInterrupt(&H21, registers, registers)

    'Test for error condition
    If registers.AX = -1 Then
	'Exit with error
	GetDiskSpace = False
	Exit Function
    End If

    'Calculate free and total space
    bytesPerCluster = registers.AX * registers.CX
    totalSpace = (CLng(registers.DX) And &HFFFF&) * bytesPerCluster
    freeSpace = (CLng(registers.BX) And &HFFFF&) * bytesPerCluster

    'Indicate success
    GetDiskSpace = True

End Function

Function GetFileText (filename As String) As String
'Returns a multi-line string that contains the specified file
    Dim buffer As String, tmpBuff As String

    'Open and read specified file
    On Error Resume Next
    Open filename For Input As #1
    If Err Then
	MsgBox "Unable to open " & filename & " : " & Error$
    Else
	On Error GoTo 0
	Do Until EOF(1)
	    Line Input #1, tmpBuff
	    buffer = buffer & tmpBuff & newLine
	Loop
	Close #1
    End If

    GetFileText = buffer

End Function

Function GetYesNo (Value As Integer) As String
'Returns a Yes or No string that indicates if value in nonzero
    If Value Then GetYesNo = "Yes" Else GetYesNo = "No"
End Function

Sub ShowAutoExecBat ()
    Dim buffer As String, i As Long
    Dim myRegs As REGS

    'Determine boot drive
    i = GetVersion() \ &H10000
    If i >= &H400 Then
	'If DOS version 4 or higher, get boot drive from DOS
	myRegs.AX = &H3305
	Call vbInterrupt(&H21, myRegs, myRegs)
	buffer = Chr$(Asc("A") + ((myRegs.DX And &HFF) - 1))
    Else
	'Else assume boot drive is drive C:
	buffer = "C"
    End If
    buffer = buffer & ":\AUTOEXEC.BAT"

    'Open and read AUTOEXEC.BAT
    buffer = GetFileText(buffer)

    frmMain.txtDetails = buffer

End Sub

Sub ShowConfigSys ()
    Dim buffer As String, i As Long
    Dim myRegs As REGS

    'Determine boot drive
    i = GetVersion() \ &H10000
    If i >= &H400 Then
	'If DOS version 4 or higher, get boot drive from DOS
	myRegs.AX = &H3305
	Call vbInterrupt(&H21, myRegs, myRegs)
	buffer = Chr$(Asc("A") + ((myRegs.DX And &HFF) - 1))
    Else
	'Assume boot drive is drive C:
	buffer = "C"
    End If
    buffer = buffer & ":\CONFIG.SYS"

    'Open and read CONFIG.SYS
    buffer = GetFileText(buffer)

    frmMain.txtDetails = buffer

End Sub

Sub ShowDisplayInfo ()
    Dim buffer As String, i As Long

    'Driver version
    buffer = buffer & "Driver Version: "
    i = GetDeviceCaps(frmMain.hDC, 0)
    buffer = buffer & CStr(i \ &H100) & "." & Format(i And &HFF, "00")
    buffer = buffer & newLine
    'Number of colors
    i = (2 ^ GetDeviceCaps(frmMain.hDC, 12)) ^ GetDeviceCaps(frmMain.hDC, 14)
    buffer = buffer & "Colors: " & CStr(i) & newLine
    'Other
    buffer = buffer & GetDeviceInfo(CInt(frmMain.hDC))

    frmMain.txtDetails = buffer

End Sub

Sub ShowDOSInfo ()
    Dim buffer As String, i As Long
    Dim myRegs As REGS, j As Integer

    'DOS version
    i = GetVersion() \ &H10000
    buffer = "DOS Version: "
    buffer = buffer & CStr(i \ &H100) & "." & Format(i And &HFF, "00")
    buffer = buffer & newLine & newLine

    'DOS Boot drive
    i = GetVersion() \ &H10000
    If i >= &H400 Then
	'If DOS version 4 or higher, get boot drive from DOS
	myRegs.AX = &H3305
	Call vbInterrupt(&H21, myRegs, myRegs)
	buffer = buffer & "Boot Drive: " & Chr$(Asc("@") + (myRegs.DX And &HFF)) & ":" & newLine
    End If

    'DOS Break flag
    myRegs.AX = &H3300
    Call vbInterrupt(&H21, myRegs, myRegs)
    If (myRegs.DX And &HFF) Then
	buffer = buffer & "Break Flag: " & "On" & newLine
    Else
	buffer = buffer & "Break Flag: " & "Off" & newLine
    End If

    'DOS Verify flag
    myRegs.AX = &H5400
    Call vbInterrupt(&H21, myRegs, myRegs)
    If (myRegs.AX And &HFF) Then
	buffer = buffer & "Verify Flag: " & "On" & newLine
    Else
	buffer = buffer & "Verify Flag: " & "Off" & newLine
    End If
    
    'Environment variables
    buffer = buffer & newLine & "Environment variables:" & newLine
    i = 1
    Do While Environ$(i) <> ""
	buffer = buffer & Environ$(i) & newLine
	i = i + 1
    Loop
    buffer = buffer & newLine

    frmMain.txtDetails = buffer
End Sub


Sub ShowDrivesInfo ()
    Dim buffer As String, i As Integer, j As Integer, tmpBuff As String
    Dim totalSpace As Long, freeSpace As Long

    On Error Resume Next

    'Try all 26 drive letters
    For i = Asc("A") To Asc("Z")
	'Attempt to read volume label
	tmpBuff = Dir$(Chr$(i) & ":*.*", ATTR_VOLUME)
	'If error, assume drive is not a value drive
	If Err = False Then
	    'Display drive letter
	    buffer = buffer & Chr$(i) & ":"
	    'Display volume label if any
	    If Len(tmpBuff) > 0 Then
		'Strip period from volume label
		j = InStr(tmpBuff, ".")
		If j <> 0 Then
		    tmpBuff = Left$(tmpBuff, j - 1) & Mid$(tmpBuff, j + 1)
		End If
		buffer = buffer & " [" & tmpBuff & "]"
	    End If
	    buffer = buffer & newLine
	    'Total and free disk space
	    If GetDiskSpace((i - Asc("A")) + 1, totalSpace, freeSpace) Then
		buffer = buffer & "Total disk space: "
		buffer = buffer & Format$(totalSpace, "#,##0") & " bytes" & newLine
		buffer = buffer & "Available disk space: "
		buffer = buffer & Format$(freeSpace, "#,##0") & " bytes" & newLine
	    End If
	    buffer = buffer & newLine
	Else
	    'Reset error for next drive
	    Err = 0
	End If
    Next i

    frmMain.txtDetails = buffer

End Sub

Sub ShowHardwareInfo ()
    Dim buffer As String, i As Long
    Dim myRegs As REGS

    'Processor type
    buffer = "Processor: "
    i = GetWinFlags()
    If i And WF_CPU286 Then
	buffer = buffer & "80286"
    ElseIf i And WF_CPU386 Then
	buffer = buffer & "80386"
    ElseIf i And WF_CPU486 Then
	buffer = buffer & "i486"
    Else
	buffer = buffer & "Unknown"
    End If
    buffer = buffer & newLine

    'Coprocessor
    buffer = buffer & "Math Coprocessor: "
    i = GetWinFlags()
    If i And WF_80x87 Then
	buffer = buffer & "Yes"
    Else
	buffer = buffer & "No"
    End If
    buffer = buffer & newLine

    'Keyboard
    buffer = buffer & "Keyboard Type: "
    Select Case GetKeyboardType(0)
	Case 1
	    buffer = buffer & "IBM PC/XT"
	Case 2
	    buffer = buffer & "Olivetti ICO"
	Case 3
	    buffer = buffer & "IBM AT"
	Case 4
	    buffer = buffer & "IBM Enhanced"
	Case 5
	    buffer = buffer & "Nokia 1050"
	Case 6
	    buffer = buffer & "Nokia 9140"
	Case 7
	    buffer = buffer & "Standard Japanese"
	Case Else
	    buffer = buffer & "Unknown"
    End Select
    buffer = buffer & newLine
    buffer = buffer & "Number of Function Keys: "
    buffer = buffer & CStr(GetKeyboardType(2))
    buffer = buffer & newLine & newLine

    'ROM BIOS Equipment List
    buffer = buffer & "ROM BIOS Reports:" & newLine
    Call vbInterrupt(&H11, myRegs, myRegs)
    buffer = buffer & "One or More Floppy Drives: " & GetYesNo(myRegs.AX And &H1) & newLine
    buffer = buffer & "Math Coprocessor: " & GetYesNo(myRegs.AX And &H2) & newLine
    buffer = buffer & "Startup Video Mode: "
    Select Case (vbShiftRight(myRegs.AX, 4) And &H3)
	Case &H0
	    buffer = buffer & "Unknown" & newLine
	Case &H1
	    buffer = buffer & "40x25 Color" & newLine
	Case &H2
	    buffer = buffer & "80x25 Color" & newLine
	Case &H3
	    buffer = buffer & "80x25 Monochrome" & newLine
    End Select
    If myRegs.AX And &H1 Then
	buffer = buffer & "Number of Floppy Drives: "
	buffer = buffer & CStr((vbShiftRight(myRegs.AX, 6) And &H3) + 1) & newLine
    End If
    buffer = buffer & "Number of RS-232 Serial Ports: "
    buffer = buffer & CStr(vbShiftRight(myRegs.AX, 9) And &H7) & newLine
    buffer = buffer & "Game Adapter: " & GetYesNo(myRegs.AX And &H1000) & newLine
    buffer = buffer & "Number of Printers: "
    buffer = buffer & CStr(vbShiftRight(myRegs.AX, 14) And &H3) & newLine

    frmMain.txtDetails = buffer

End Sub

Sub ShowIntVectors ()
    Dim buffer As String, i As Integer

    'Show vector address for each interrupt
    For i = 0 To &HFF
	buffer = buffer & "Interrupt " & Right$("0" & Hex$(i), 2)
	buffer = buffer & "h = " & Right$("000" & Hex$(vbPeekw(0, i)), 4)
	buffer = buffer & ":" & Right$("000" & Hex$(vbPeekw(0, i + 2)), 4)
	buffer = buffer & newLine
    Next i

    frmMain.txtDetails = buffer

End Sub

Sub ShowPrinterInfo ()
    Dim buffer As String, i As Long

    'Driver version
    buffer = buffer & "Driver Version: "
    i = GetDeviceCaps(Printer.hDC, 0)
    buffer = buffer & CStr(i \ &H100) & "." & Format(i And &HFF, "00")
    buffer = buffer & newLine

    'Number of colors
    i = (2 ^ GetDeviceCaps(Printer.hDC, 12)) ^ GetDeviceCaps(Printer.hDC, 14)
    buffer = buffer & "Colors: " & CStr(i) & newLine

    'Other
    buffer = buffer & GetDeviceInfo(CInt(Printer.hDC))

    frmMain.txtDetails = buffer

End Sub

Sub ShowWindowsInfo ()
    Dim buffer As String, i As Long, tmpBuff As String
    Dim Pointer As Long, j As Integer
    Dim myLogFont As LOGFONT

    'Windows version
    i = GetVersion() And &HFFFF&
    buffer = "Windows Version: "
    buffer = buffer & CStr(i And &HFF) & "." & Format(i \ &H100, "00")
    buffer = buffer & newLine

    'Windows mode
    buffer = buffer & "Mode: "
    i = GetWinFlags()
    If i And WF_ENHANCED Then
	buffer = buffer & "Enhanced"
    Else
	buffer = buffer & "Standard"
    End If
    buffer = buffer & newLine
    buffer = buffer & newLine

    'Windows and Windows system directory
    tmpBuff = Space$(256)
    i = GetWindowsDirectory(tmpBuff, 256)
    buffer = buffer & "Windows Directory: " & Left$(tmpBuff, i) & newLine
    i = GetSystemDirectory(tmpBuff, 256)
    buffer = buffer & "System Directory: " & Left$(tmpBuff, i) & newLine
    tmpBuff = Environ$("TEMP")
    If Len(tmpBuff) > 0 Then
	buffer = buffer & "Temporary Directory: " & tmpBuff & newLine
    End If
    buffer = buffer & newLine
    
    'Available memory
    buffer = buffer & "Available Memory: " & Format$(GetFreeSpace(0), "#,###") & " bytes" & newLine
    buffer = buffer & "Largest Free Memory Object: " & Format$(GlobalCompact(0), "#,###") & " bytes" & newLine
    buffer = buffer & newLine
    
    'System resources
    buffer = buffer & "Free System Resources: " & CStr(GetFreeSystemResources(GFSR_SYSTEMRESOURCES)) & "%" & newLine
    buffer = buffer & "Free GDI Resources: " & CStr(GetFreeSystemResources(GFSR_GDIRESOURCES)) & "%" & newLine
    buffer = buffer & "Free User Resources: " & CStr(GetFreeSystemResources(GFSR_USERRESOURCES)) & "%" & newLine
    buffer = buffer & newLine
    
    'SystemsParametersInfo
    buffer = buffer & "System Information:" & newLine
    buffer = buffer & "Mouse Present: " & GetYesNo(GetSystemMetrics(19)) & newLine
    buffer = buffer & "Swapped Mouse Buttons: " & GetYesNo(GetSystemMetrics(23)) & newLine
    buffer = buffer & "Caret Blink Time: " & GetCaretBlinkTime() & " ms." & newLine
    buffer = buffer & "Windows Debug Version: " & GetYesNo(GetSystemMetrics(22)) & newLine
    Pointer = vbGetLongPtr(myLogFont)   'Assign to long for syntax checker
    If SystemParametersInfo(31, Len(myLogFont), Pointer, False) Then
	buffer = buffer & "Icon Title Font: " & Left$(myLogFont.lfFaceName, InStr(myLogFont.lfFaceName, Chr$(0)) - 1) & newLine
    End If
    Pointer = vbGetLongPtr(j)   'Pointer to j
    If SystemParametersInfo(1, 0, Pointer, False) Then
	buffer = buffer & "Warning Beeps: " & GetYesNo(j) & newLine
    End If
    If SystemParametersInfo(5, 0, Pointer, False) Then
	buffer = buffer & "Border Multiplying Factor: " & CStr(j) & newLine
    End If
    If SystemParametersInfo(35, 0, Pointer, False) Then
	buffer = buffer & "Fast Task Switching: " & GetYesNo(j) & newLine
    End If
    If SystemParametersInfo(18, 0, Pointer, False) Then
	buffer = buffer & "Grid Granularity: " & CStr(j) & newLine
    End If
    If SystemParametersInfo(25, 0, Pointer, False) Then
	buffer = buffer & "Icon Title Word Wrap: " & GetYesNo(j) & newLine
    End If
    If SystemParametersInfo(22, 0, Pointer, False) Then
	buffer = buffer & "Keyboard Repeat-Delay: " & CStr(j) & newLine
    End If
    If SystemParametersInfo(10, 0, Pointer, False) Then
	buffer = buffer & "Keyboard Repeat-Speed: " & CStr(j) & newLine
    End If
    If SystemParametersInfo(27, 0, Pointer, False) Then
	buffer = buffer & "Right-Align Pop-up Menus: " & GetYesNo(j) & newLine
    End If
    If SystemParametersInfo(16, 0, Pointer, False) Then
	buffer = buffer & "Screen Saver Active: " & GetYesNo(j) & newLine
    End If
    If SystemParametersInfo(14, 0, Pointer, False) Then
	buffer = buffer & "Screen-Saver Time-Out: " & CStr(j / 60) & " seconds" & newLine
    End If
    If SystemParametersInfo(13, 0, Pointer, False) Then
	buffer = buffer & "Horizontal Icon Spacing: " & CStr(j) & newLine
    End If
    If SystemParametersInfo(24, 0, Pointer, False) Then
	buffer = buffer & "Vertical Icon Spacing: " & CStr(j) & newLine
    End If
    buffer = buffer & "Microseconds Per Timer Tick: " & CStr(GetTimerResolution()) & newLine
    buffer = buffer & newLine

    'System Metrics
    buffer = buffer & "System Metrics (Pixels):" & newLine
    buffer = buffer & "Screen Width: " & GetSystemMetrics(0) & newLine
    buffer = buffer & "Screen Height: " & GetSystemMetrics(1) & newLine
    buffer = buffer & "Width of Arrow Bitmap on Vertical Scroll Bar: " & GetSystemMetrics(2) & newLine
    buffer = buffer & "Height of Arrow Bitmap on Vertical Scroll Bar: " & GetSystemMetrics(20) & newLine
    buffer = buffer & "Width of Arrow Bitmap on Horizontal Scroll Bar: " & GetSystemMetrics(21) & newLine
    buffer = buffer & "Height of Arrow Bitmap on Horizontal Scroll Bar: " & GetSystemMetrics(3) & newLine
    buffer = buffer & "Height of Thumb Scroll on Vertical Scroll Bar: " & GetSystemMetrics(9) & newLine
    buffer = buffer & "Width of Thumb Scroll on Horizontal Scroll Bar: " & GetSystemMetrics(10) & newLine
    buffer = buffer & "Width of Window Frame That Can Be Sized: " & GetSystemMetrics(32) & newLine
    buffer = buffer & "Height of Window Frame That Can Be Sized: " & GetSystemMetrics(33) & newLine
    buffer = buffer & "Width of Window Frame That Cannot Be Sized: " & GetSystemMetrics(5) & newLine
    buffer = buffer & "Height of Window Frame That Cannot Be Sized: " & GetSystemMetrics(6) & newLine
    buffer = buffer & "Width of Dialog Frame: " & GetSystemMetrics(7) & newLine
    buffer = buffer & "Height of Dialog Frame: " & GetSystemMetrics(8) & newLine
    buffer = buffer & "Menu Bar Height: " & GetSystemMetrics(15) & newLine
    buffer = buffer & "Window Caption Height: " & GetSystemMetrics(4) & newLine
    buffer = buffer & "Minimum Window Width: " & GetSystemMetrics(28) & newLine
    buffer = buffer & "Minimum Window Height: " & GetSystemMetrics(29) & newLine
    buffer = buffer & "Icon Width: " & GetSystemMetrics(11) & newLine
    buffer = buffer & "Icon Height: " & GetSystemMetrics(12) & newLine
    buffer = buffer & "Cursor Width: " & GetSystemMetrics(13) & newLine
    buffer = buffer & "Cursor Height: " & GetSystemMetrics(14) & newLine
    buffer = buffer & newLine

    'System Colors
    buffer = buffer & "System Colors:" & newLine
    buffer = buffer & "Title Bar Text: " & GetColorString(GetSysColor(9)) & newLine
    buffer = buffer & "Active Window Caption: " & GetColorString(GetSysColor(2)) & newLine
    buffer = buffer & "Active Window Border: " & GetColorString(GetSysColor(10)) & newLine
    buffer = buffer & "Inactive Window Title Text: " & GetColorString(GetSysColor(19)) & newLine
    buffer = buffer & "Inactive Window Title: " & GetColorString(GetSysColor(3)) & newLine
    buffer = buffer & "Inactive Window Border: " & GetColorString(GetSysColor(11)) & newLine
    buffer = buffer & "Window Background: " & GetColorString(GetSysColor(5)) & newLine
    buffer = buffer & "Window Frame: " & GetColorString(GetSysColor(6)) & newLine
    buffer = buffer & "Window Text: " & GetColorString(GetSysColor(8)) & newLine
    buffer = buffer & "MDI Background: " & GetColorString(GetSysColor(12)) & newLine
    buffer = buffer & "Desktop: " & GetColorString(GetSysColor(1)) & newLine
    buffer = buffer & "Menu Text: " & GetColorString(GetSysColor(7)) & newLine
    buffer = buffer & "Menu Background: " & GetColorString(GetSysColor(4)) & newLine
    buffer = buffer & "Button Text: " & GetColorString(GetSysColor(18)) & newLine
    buffer = buffer & "Button Face: " & GetColorString(GetSysColor(15)) & newLine
    buffer = buffer & "Button Highlight: " & GetColorString(GetSysColor(20)) & newLine
    buffer = buffer & "Button Shadow: " & GetColorString(GetSysColor(16)) & newLine
    buffer = buffer & "Control Selection Text: " & GetColorString(GetSysColor(14)) & newLine
    buffer = buffer & "Control Selection Background: " & GetColorString(GetSysColor(13)) & newLine
    buffer = buffer & "Dimmed Text: " & GetColorString(GetSysColor(17)) & newLine
    buffer = buffer & "Scroll Bar: " & GetColorString(GetSysColor(0)) & newLine

    frmMain.txtDetails = buffer

End Sub

Sub ShowWinIni ()
    Dim buffer As String, i As Long
    Dim myRegs As REGS, tmpBuff As String * 256

    'Determine Windows system directory
    i = GetWindowsDirectory(tmpBuff, 256)
    buffer = buffer & Left$(tmpBuff, i) & "\WIN.INI"

    'Open and read WIN.INI
    buffer = GetFileText(buffer)

    frmMain.txtDetails = buffer

End Sub

