{$A+,B-,D+,E+,F-,I+,L+,N-,O-,R-,S+,V-}
Unit Scrn;

INTERFACE

Type ScrnWord = Record
       Ch: Char;
       Attr: Byte;
     end;
     XY = Record
       X,Y: Byte;
     end;
     ScrnPointer = Array [1..80,1..25] Of ScrnWord;
     ScreenObj = Object
       Scrn: ScrnPointer;
       Loc: XY;
       WinMin,
       WinMax: Word;
       Attr: Byte;
       CursorS: Boolean;

       Procedure Save;
       Procedure Plot;
     end;

Var Screen: ^ScrnPointer;

IMPLEMENTATION

Uses Crt,Dos,CC;

  Procedure ScreenObj.Save;
  begin
    Scrn:=Screen^;
    Loc.X:=WhereX;
    Loc.Y:=WhereY;
    WinMin:=WindMin;
    WinMax:=WindMax;
    Attr:=TextAttr;
    CursorS:=CStatus;
  end;

  Procedure ScreenObj.Plot;
  begin
    TextAttr:=Attr;
    WindMin:=WinMin;
    WindMax:=WinMax;
    GotoXY(Loc.X,Loc.Y);
    Cursor(CursorS);
    Repeat Until (Port[$3DA] And $08) = 0;
    Repeat Until (Port[$3DA] And $08) <> 0;
    Screen^:=Scrn;
  end;

Var Regs: Registers;

begin
  Regs.AH := $F;
  Intr($10,Regs);
  Case Regs.AL Of
    0,1,2,3: Screen := Ptr($B800,0000);
    7: Screen := Ptr($B000,0000);
  else
    Writeln('ERROR: Unsupported video mode ',Regs.Al);
    Halt(1);
  end;
end.