Unit SFANSI;

INTERFACE
Uses Crt;

Procedure Ans_Write_Ch(Ch: Char);
Procedure Ans_Write(S: String);
Procedure Ans_Writeln(S: String);

IMPLEMENTATION

Type CmdType=(Up,Down,Right,Left,Loc,Cls,Cleol,Color,SavePos,LoadPos,Unsup);
     AnsRecord=Record
       Cmd: CmdType;
       Def: Byte;
     end;
     AnsParams=Record
       Num: Byte;
       Dat: Array[1..40] of Byte;
     end;
Var AnsRec: AnsRecord;
    Param: AnsParams;
    oX,oY: Byte;
    oS: Boolean;

Var InANSI: Boolean;
    Buf: String;

Procedure Ans_Write_Ch(Ch: Char);
Var I,B: Integer;
    T: String;
begin
  If (Ch=#27) Or (InANSI) Then
  begin
    InANSI:=True;
    Buf:=Buf+Ch;
    If Not (Ch In ['A'..'Z','a'..'z',#14]) Then Exit;
    With AnsRec Do Case Buf[Length(Buf)] Of
      'A': Cmd:=Up;
      'B': Cmd:=Down;
      'C': Cmd:=Right;
      'D': Cmd:=Left;
      'H': Cmd:=Loc;
      'J': Cmd:=Cls;
      'K': Cmd:=Cleol;
      'f': Cmd:=Loc;
      'm': Cmd:=Color;
      's': Cmd:=SavePos;
      'u': Cmd:=LoadPos;
      else Cmd:=UnSup;
    end;
    With AnsRec Do Case Cmd Of
      Up,Down,Left,Right,Loc,Cls,Cleol,SavePos,LoadPos: Def:=1;
      Color: Def:=0;
    end;
    Delete(Buf,1,2);
    Delete(Buf,Length(Buf),1);
    For I:=1 to 40 Do Param.Dat[I]:=AnsRec.Def;
    Param.Num:=0;
    If Not(Buf='') Then
    begin
    While Pos(';',Buf)<>0 Do
    begin
      Inc(Param.Num);
      T:=Buf;
      Delete(T,Pos(';',T),Length(T)-(Pos(';',T)-1));
      Val(T,Param.Dat[Param.Num],I);
      Delete(Buf,1,Pos(';',Buf));
    end;
    Inc(Param.Num);
    Val(Buf,Param.Dat[Param.Num],I);
    end;
    Case AnsRec.Cmd Of
      Up: begin
        With Param Do If Num=0 Then Num:=1;
        For I:=1 to Param.Num Do GotoXY(WhereX,WhereY-Param.Dat[Param.Num]);
      end;
      Down: begin
        With Param Do If Num=0 Then Num:=1;
        For I:=1 to Param.Num Do GotoXY(WhereX,WhereY+Param.Dat[Param.Num]);
      end;
      Right: begin
        With Param Do If Num=0 Then Num:=1;
        For I:=1 to Param.Num Do GotoXY(WhereX+Param.Dat[Param.Num],WhereY);
      end;
      Left: begin
        With Param Do If Num=0 Then Num:=1;
        For I:=1 to Param.Num Do GotoXY(WhereX-Param.Dat[Param.Num],WhereY);
      end;
      Loc: GotoXY(Param.Dat[2],Param.Dat[1]);
      Cls: ClrScr;
      Cleol: ClrEol;
      SavePos: begin
        oS:=True;
        oX:=WhereX;
        oY:=WhereY;
      end;
      LoadPos: If oS Then GotoXY(oX,oY);
      Color: begin
        With Param Do If Num=0 Then Num:=1;
        For I:=1 to Param.Num Do
          Case Param.Dat[I] of
              0: TextAttr:=7;
              1: If (TextAttr mod 16)<8 Then TextAttr:=TextAttr+8;
              2: If (TextAttr mod 16)>7 Then TextAttr:=TextAttr-8;
              4: {Underline};
           5,6: If (TextAttr<128) Then TextAttr:=TextAttr+128;
              7: TextAttr:=TextAttr XOR 255;
              8: TextAttr:=(TextAttr DIV 16)*16+(TextAttr DIV 16);
             30: TextAttr:=(TextAttr DIV 16)*16+((TextAttr MOD 16) DIV 8)*8;
             31: TextAttr:=(TextAttr DIV 16)*16+4+((TextAttr MOD 16) DIV 8)*8;
             32: TextAttr:=(TextAttr DIV 16)*16+2+((TextAttr MOD 16) DIV 8)*8;
             33: TextAttr:=(TextAttr DIV 16)*16+6+((TextAttr MOD 16) DIV 8)*8;
             34: TextAttr:=(TextAttr DIV 16)*16+1+((TextAttr MOD 16) DIV 8)*8;
             35: TextAttr:=(TextAttr DIV 16)*16+5+((TextAttr MOD 16) DIV 8)*8;
             36: TextAttr:=(TextAttr DIV 16)*16+3+((TextAttr MOD 16) DIV 8)*8;
             37: TextAttr:=(TextAttr DIV 16)*16+7+((TextAttr MOD 16) DIV 8)*8;
             40: TextAttr:=TextAttr MOD 16;
             41: TextAttr:=64+(TextAttr MOD 16)+(TextAttr DIV 128)*128;
             42: TextAttr:=32+(TextAttr MOD 16)+(TextAttr DIV 128)*128;
             43: TextAttr:=96+(TextAttr MOD 16)+(TextAttr DIV 128)*128;
             44: TextAttr:=16+(TextAttr MOD 16)+(TextAttr DIV 128)*128;
             45: TextAttr:=80+(TextAttr MOD 16)+(TextAttr DIV 128)*128;
             46: TextAttr:=48+(TextAttr MOD 16)+(TextAttr DIV 128)*128;
             47: TextAttr:=112+(TextAttr MOD 16)+(TextAttr DIV 128)*128;
          end;
      end;
    end;
    Buf:='';
    InANSI:=False;
  end else
  begin
    If (Ch=#9) Then
    begin
      B:=WhereX;
      For I:=1 to 9-(B MOD 9) Do Ans_Write_Ch(' ');
    end
    else
    begin
      If (Ch=#10) Then Write(#13);
      Write(ch);
    end;
  end;
end;

Procedure Ans_Write(S: String);
Var I: Byte;
begin
  For I:=1 to Length(S) Do Ans_Write_Ch(S[I]);
end;

Procedure Ans_Writeln(S: String);
begin
  Ans_Write(S); Writeln;
end;

begin
  Buf:=''; oS:=False;
end.