Unit SFConfig;

INTERFACE

Procedure Setup(St,Fn: String);

IMPLEMENTATION
Uses Crt,OMenu,CC,Boxes;

Type Config = Record
       BBSTypeN: Byte;
       BBSTypeS: String[8];
       BBSTypeF: String[12];
       BBSPath: String[79];
       SysopName: String[40];
       BBSName: String[40];
       SSSec: Word;
       Fossil: Boolean;
     end;

Procedure Setup(St,Fn: String);
Var C: Config;
    F: File of Config;
    Menu: FMenu;
    N: Byte;
    Quit: Boolean;
    S: String;
    I: Integer;
begin
  Assign(F,Fn); Cursor(off);
  {$I-} Reset(F); {$I+}
  If (IOResult=1) Then
  begin
    Read(F,C);
    Close(F);
  end else With (C) Do
  begin
    BBSTypeN:=1;
    BBSTypeS:='Door.Sys';
    BBSTypeF:='DOOR.SYS';
    BBSPath:='C:\BBS\';
    SysOpName:='SysOp';
    BBSName:='BBS Name';
    SSSec:=255;
    Fossil:=False;
  end;

  TextColor(0); TextBackground(7); GotoXy(1,1);
  Write(St,' Setup (SF/2 v1.0)');
  For N:=1 to (80-(Length(St)+42)) Do Write(' ');
  Writeln('Written by Andrew Turner');
  GotoXY(1,25);
  Clreol;
  Window(1,2,80,24);
  TextAttr:=23;
  Clrscr; Quit:=False; Menu.Cmd:=1;
  Window(1,1,80,25);
  Repeat
    With (Menu) Do
    begin
      With (Loc) Do
      begin
        Tx:=14;
        Ty:=9;
        Bx:=66;
        By:=17;
      end;
      With (Color) Do
      begin
        BorderFore:=14;
        BorderBack:=4;
        OptFore:=15;
        OptBack:=4;
        HelpFore:=0;
        HelpBack:=7;
        BarFore:=15;
        BarBack:=1;
      end;
      Box:=2;
      Bar:=True;
      Center:=False;
      HelpLine:=25;
      HLTX:=1; HLBX:=80;
      CmdNm[1]:='  BBS Type: '+C.BBSTypeS+'  ';
      Help[1]:='Change the door information file that this door reads in';
      CmdNm[2]:='  Location of '+C.BBSTypeF+': '+C.BBSPath+'  ';
      Help[2]:='Change where the door looks for it''s information file';
      Str(C.SSSec,S);
      CmdNm[3]:='  SysOp Security Level: '+S+'  ';
      Help[3]:='Change the security level required to access SysOp functions';
      If (C.Fossil) Then S:='Yes' Else S:='No';
      CmdNm[4]:='  Use a fossil driver: '+S+'  ';
      Help[4]:='Use internal COM routines, or a fossil driver (like X00 or BNU)';
      If (C.BBSTypeN<>2) Then
      begin
        NumCmds:=7;
        CmdNm[5]:='  SysOp Name: '+C.SysOpName+'  ';
        Help[5]:='The name you want displayed as the system operator';
        CmdNm[6]:='  BBS Name: '+C.BBSName+'  ';
        Help[6]:='The name of your bulletin board system';
        CmdNm[7]:='  Quit'+'  ';
        Help[7]:='Save any changes and exit config';
      end else
      begin
        NumCmds:=5;
        CmdNm[5]:='  Quit'+'  ';
        Help[5]:='Save any changes and exit config';
      end;
      Menu;
      Case (Cmd) Of
        1: begin
          With C Do
          Case (BBSTypeN) Of
            1: If (BBSTypeS='Door.Sys') Then Cmd:=1 Else
               If (BBSTypeS='Gap') Then Cmd:=2 Else
               If (BBSTypeS='Telegard') Then Cmd:=3 Else
               If (BBSTypeS='Renegade') Then Cmd:=4 Else
               If (BBSTypeS='TAG') Then Cmd:=5 Else Cmd:=1;
            2: If (BBSTypeS='TriTel') Then Cmd:=11 Else
               If (BBSTypeS='TriBBS') Then Cmd:=12 Else Cmd:=12;
            3: Cmd:=6;
            4: Cmd:=7;
            5: Cmd:=8;
            6: If (BBSTypeS='Wildcat!') Then Cmd:=9 Else
               If (BBSTypeS='Genesis') Then Cmd:=10 Else Cmd:=9;
            7: Cmd:=10;
          end;
          With (Loc) Do
          begin
            Tx:=27;
            Ty:=6;
            Bx:=53;
            By:=19;
          end;
          With (Color) Do
          begin
            BorderFore:=14;
            BorderBack:=4;
            OptFore:=15;
            OptBack:=4;
            HelpFore:=0;
            HelpBack:=7;
            BarFore:=15;
            BarBack:=1;
          end;
          Box:=2;
          Bar:=True;
          Center:=False;
          HelpLine:=0;
          HLTX:=1; HLBX:=80;
          NumCmds:=12;
          CmdNm[1]:='Door.Sys (DOOR.SYS    )';
          CmdNm[2]:='Gap      (DOOR.SYS    )';
          CmdNm[3]:='Telegard (DOOR.SYS    )';
          CmdNm[4]:='Renegade (DOOR.SYS    )';
          CmdNm[5]:='TAG      (DOOR.SYS    )';
          CmdNm[6]:='Spitfire (SFDOORS.DAT )';
          CmdNm[7]:='RBBS     (DORINFO1.DEF)';
          CmdNm[8]:='WWIV     (CHAIN.TXT   )';
          CmdNm[9]:='WILDCAT! (CALLINFO.BBS)';
          CmdNm[10]:='Genesis  (CALLINFO.BBS)';
          CmdNm[11]:='TriTel   (TRITEL.SYS  )';
          CmdNm[12]:='TriBBS   (TRIBBS.SYS  )';
          Menu;
          With C Do
          Case Cmd Of
             1: begin BBSTypeN:=1; BBSTypeS:='Door.Sys'; BBSTypeF:='DOOR.SYS'; end;
             2: begin BBSTypeN:=1; BBSTypeS:='Gap'; BBSTypeF:='DOOR.SYS'; end;
             3: begin BBSTypeN:=1; BBSTypeS:='Telegard'; BBSTypeF:='DOOR.SYS'; end;
             4: begin BBSTypeN:=1; BBSTypeS:='Renegade'; BBSTypeF:='DOOR.SYS'; end;
             5: begin BBSTypeN:=1; BBSTypeS:='TAG'; BBSTypeF:='DOOR.SYS'; end;
             6: begin BBSTypeN:=3; BBSTypeS:='Spitfire'; BBSTypeF:='SFDOORS.DAT'; end;
             7: begin BBSTypeN:=4; BBSTypeS:='RBBS'; BBSTypeF:='DORINFO1.DEF'; end;
             8: begin BBSTypeN:=5; BBSTypeS:='WWIV'; BBSTypeF:='CHAIN.TXT'; end;
             9: begin BBSTypeN:=6; BBSTypeS:='Wildcat!'; BBSTypeF:='CALLINFO.BBS'; end;
            10: begin BBSTypeN:=7; BBSTypeS:='Genesis'; BBSTypeF:='CALLINFO.BBS'; end;
            11: begin BBSTypeN:=2; C.BBSTypeS:='TriTel'; BBSTypeF:='TRITEL.SYS'; end;
            12: begin BBSTypeN:=2; C.BBSTypeS:='TriBBS'; BBSTypeF:='TRIBBS.SYS'; end;
          end;
          Cmd:=1;
        end;
        2: Dialog2('Where is '+C.BBSTypeF+' located (your BBS directory usually)',C.BBSPath,60,14,15,15,4,2);
        3: begin
          Str(C.SSSec,S);
          Dialog('What is the minimum security level to allow SysOp access? ',S,3,14,15,15,4,2);
          Val(S,C.SSSec,I);
        end;
        4: begin
          If (C.Fossil) Then S:='Y' Else S:='N';
          Dialog('Do you want to use a fossil driver? ',S,1,14,15,15,4,2);
          If (upcase(S[1])='Y') Then C.Fossil:=True Else C.Fossil:=False;
        end;
        5: If (C.BBSTypeN=2) Then Quit:=True Else
          Dialog2('What name do you want the door to show as the system operator?',C.SysOpName,40,14,15,15,4,2);
        6: Dialog('What is the name of your BBS? ',C.BBSName,40,14,15,15,4,2);
        7: Quit:=True;
      end;
    end;
  Until (Quit); Cursor(On);
  Rewrite(F);
  Write(F,C);
  Close(F);
  TextAttr:=7; Clrscr;
end;

end.