//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1994
//


#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>

#include "cthugha.h"

unsigned int map;

#define M_PI 3.14159265358979323846
#define RADEG (180.0/M_PI)

char *maptabfile="MOLES.TAB";

int main(int argc, char **argv)
{
	int x,y,map_x,map_y;
	double polar_r,polar_a;
	double delta_r=2.0,delta_a=0.1;
	double temp_y,temp_x;
	double cent_y,cent_x;

	FILE *fp;

	argc--; argv++;
	if (argc) {
		delta_r=atof(*argv);
	}
	argc--; argv++;
	if (argc) {
		delta_a=atof(*argv);
	}


	if ((fp=fopen(maptabfile,"wb"))!=NULL) {
		printf("Writing mapping table: %s\n",maptabfile);
		for (y=0; y<BUFF_HEIGHT; y++) {
			printf("%3d/%3d \r",y+1,BUFF_HEIGHT);

			for (x=0; x<BUFF_WIDTH; x++) {
				if (((x==BUFF_WIDTH/4) && (y==BUFF_HEIGHT/2)) ||
				    ((x==3*BUFF_WIDTH/4) && (y==BUFF_HEIGHT/2))) {
					map=0;
				} else {
					cent_y=BUFF_HEIGHT/2;
					if (x>BUFF_WIDTH/2) {
						cent_x=3*BUFF_WIDTH/4;
						temp_x=abs(x-cent_x);
					} else {
						cent_x=BUFF_WIDTH/4;
						temp_x=abs(x-cent_x);
					}
					temp_y=abs(y-cent_y);

					polar_r=sqrt(temp_x*temp_x + temp_y*temp_y);
					polar_a=atan2((double)(x-cent_x),(double)(y-cent_y));

					polar_r += delta_r;

					if (polar_r<0)
						polar_r=0.0;

					if (x>BUFF_WIDTH/2) {
						polar_a += delta_a;
					} else {
						polar_a -= delta_a;
					}

					temp_y=polar_r*(cosl(polar_a));
					temp_x=polar_r*(sinl(polar_a));

					map_x=temp_x+cent_x;
					map_y=temp_y+cent_y;

					if ((map_y>=BUFF_HEIGHT) || (map_y<0) ||
						(map_x>=BUFF_WIDTH) || (map_x<0) ) {
						map_x=0;
						map_y=0;
					}

					map_x=max(map_x,0);
					map_y=max(map_y,0);

					map=map_y*BUFF_WIDTH+map_x;

				}
				fwrite(&map,sizeof(int),1,fp);
			}
		}

		fclose(fp);
	}

}


