//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1994
//


// Why PETE.C ??
// 'cause late one Saturday night, Pete wanted to write some code
// and I let him do a couple of functions (only one survives, I 
// took over the others :-)


#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>

#include "cthugha.h"
#include "charset.h"
#include "pete.h"

/* Defines for Soundblaster and Soundblaster Pro IO address */

int sine[320];


// #define N 16 /* number of FFT terms, do not change this!!! See also LOG2N */
#define N 64 /* number of FFT terms, do not change this!!! See also LOG2N */
/*----------------------------------- FFT ------------------------------------*/

#define S0  0 /* corresponds to 0.0 */
#define S1  3
#define S2  6
#define S3  9 /* sin() table with 4 bit precision */
#define S4 11 /* increasing precision will cause short integer overflows... */
#define S5 13 /* too bad, I really would have liked more precision */
#define S6 15
#define S7 16
#define S8 16 /* corresponds to 1.0 */
// #define SCALE 11 /* scale FFT with 2**SCALE from big values to low */
#define SCALE 7 /* scale FFT with 2**SCALE from big values to low */

static int s[N+N],c[N+N];
static int FFTenable=FALSE; /* Maximum sampling rate for initial SW tuning */
static int waitfactor=3; /* Best initial sampling rate for my 12MHz 286 */
static int fft[N],oldfft[N];

#include <math.h>
#define CTEPI (3.14159265358979323846/(float)N)
#define TRIG  16 /* trig table lookup precision compatible with S? way above */

void init_pete(void)
{
	int i;
  static float xx,ss,cc;
  static int k;

	for (i=0; i<320; i++)
		sine[i]=(int)(128*sin((float)i*0.03927));


  for (k=0 ; k<(N+N) ; k++) {
    xx=CTEPI*k;
    ss=TRIG*sin(xx);
    cc=TRIG*cos(xx);
    if (ss>0.0) ss+=0.5; else ss-=0.5;
    if (cc>0.0) cc+=0.5; else cc-=0.5;
    s[k]=(int)ss; /* truncate */
    c[k]=(int)cc; /* truncate */
  }


}
void pete_0(void)
{
	int temp,temp2,x;
	static int xoff0=BUFF_WIDTH/2,yoff0=BUFF_HEIGHT/2;
	static int xoff1=BUFF_WIDTH/2,yoff1=BUFF_HEIGHT/2;

	xoff0 += stereo[0][0]%9-4;
	yoff0 += stereo[1][0]%9-4;

	xoff1 += stereo[0][1]%9-4;
	yoff1 += stereo[1][1]%9-4;

	if (xoff0<0)
		xoff0+=BUFF_WIDTH;
	if (yoff0<0)
		yoff0+=BUFF_BOTTOM;

	if (xoff1<0)
		xoff1+=BUFF_WIDTH;
	if (yoff1<0)
		yoff1+=BUFF_BOTTOM;

	xoff0=xoff0%BUFF_WIDTH;
	xoff1=xoff1%BUFF_WIDTH;

	yoff0=yoff0%BUFF_HEIGHT;
	yoff1=yoff1%BUFF_HEIGHT;

	for (x=0; x<BUFF_WIDTH; x++) {
		temp=stereo[x][0];
		temp2=stereo[(x+80)%BUFF_WIDTH][0];

		buff[((temp>>2)+yoff0)%BUFF_BOTTOM][((temp2>>2)+xoff0)%BUFF_WIDTH]=table[curtable][temp];

		temp=stereo[x][1];
		temp2=stereo[(x+80)%BUFF_WIDTH][1];

		buff[((temp>>2)+yoff1)%BUFF_BOTTOM][((temp2>>2)+xoff1)%BUFF_WIDTH]=table[curtable][temp];

	}

}

void pete_1(void)
{
	int temp,x,left=0,right=0;

	for (x=0; x<BUFF_WIDTH; x++) {
		left += abs(stereo [x][0] - 128);
		right += abs(stereo [x][1] - 128);
	}

	left = left / (160);
	right = right / (160);

	left=min(left,199);
	right=min(right,199);

	for (x=0; x<160; x++) {
		temp=stereo[x][0];
		buff[200-(abs((left)*sine[x])>>8)][(x)]=table[curtable][temp];
	}
	for	(x=160; x<320; x++) {
		temp=stereo[x][1];
		buff[200-(abs((right)*sine[x])>>8)][(x)]=table[curtable][temp];
	}

}

void pete_2(void)
{
	int temp,x;

	for (x=0; x<200; x++) {
		temp=stereo[x][0];
		buff[x][160-(temp>>2)]=table[curtable][sine[temp]];
		temp=stereo[x][1];
		buff[x][160+(temp>>2)]=table[curtable][sine[temp]];
	}

}


void moles_fract(void)
{
	int temp,x;
	static int xoff0=BUFF_WIDTH/2,yoff0=BUFF_HEIGHT/2;
	static int xoff1=BUFF_WIDTH/2,yoff1=BUFF_HEIGHT/2;

	temp=stereo[0][0];
	for (x=0; x<BUFF_WIDTH-2; x+=2) {
		xoff0 += (stereo[x][0]-temp)>>1;
		temp=stereo[x][0];


		if (xoff0<0)
			xoff0=BUFF_WIDTH-1;

		xoff0=xoff0%BUFF_WIDTH;

		buff[yoff0][xoff0]=table[curtable][temp];

		yoff0 += (stereo[x+1][0]-temp)>>1;
		temp=stereo[x+1][0];

		if (yoff0<0)
			yoff0=BUFF_HEIGHT-1;

		yoff0=yoff0%BUFF_HEIGHT;

		buff[yoff0][xoff0]=table[curtable][temp];

	}

	temp=stereo[0][1];
	for (x=0; x<BUFF_WIDTH-2; x+=2) {
		xoff1 += (stereo[x][1]-temp)>>1;
		temp=stereo[x][1];


		if (xoff1<0)
			xoff1=BUFF_WIDTH-1;

		xoff1=xoff1%BUFF_WIDTH;

		buff[yoff1][xoff1]=table[curtable][temp];

		yoff1 -= (stereo[x+1][1]-temp)>>1;
		temp=stereo[x+1][1];

		if (yoff1<0)
			yoff1=BUFF_HEIGHT-1;

		yoff1=yoff1%BUFF_HEIGHT;

		buff[yoff1][xoff1]=table[curtable][temp];

	}
}

void moles_fract2(void)
{
	int temp,x;
	static int xoff0=BUFF_WIDTH/2,yoff0=BUFF_HEIGHT/2;
	static int xoff1=BUFF_WIDTH/2,yoff1=BUFF_HEIGHT/2;

	temp=stereo[0][0];
	for (x=0; x<BUFF_WIDTH-2; x+=2) {
		xoff0 += (stereo[x][0]-temp);
		temp=stereo[x][0];


		if (xoff0<0)
			xoff0=BUFF_WIDTH-1;

		xoff0=xoff0%BUFF_WIDTH;

		buff[yoff0][xoff0]=table[curtable][temp];

		yoff0 += (stereo[x+1][0]-temp);
		temp=stereo[x+1][0];

		if (yoff0<0)
			yoff0=BUFF_HEIGHT-1;

		yoff0=yoff0%BUFF_HEIGHT;

		buff[yoff0][xoff0]=table[curtable][temp];

	}

	temp=stereo[0][1];
	for (x=0; x<BUFF_WIDTH-2; x+=2) {
		xoff1 += (stereo[x][1]-temp);
		temp=stereo[x][1];


		if (xoff1<0)
			xoff1=BUFF_WIDTH-1;

		xoff1=xoff1%BUFF_WIDTH;

		buff[yoff1][xoff1]=table[curtable][temp];

		yoff1 -= (stereo[x+1][1]-temp);
		temp=stereo[x+1][1];

		if (yoff1<0)
			yoff1=BUFF_HEIGHT-1;

		yoff1=yoff1%BUFF_HEIGHT;

		buff[yoff1][xoff1]=table[curtable][temp];

	}
}


void FFT(int channel)
{ /* compute fast short integer FT */
	static int data,kl,a[N],b[N],fff[N];
	static int k,l,f[N+N];
	static int level,oldlevel,line,column;

	for (k=0 ; k<(N+N) ; k++) {
		f[k]=stereo[k*2][channel]-128;
	}

	for (l=1 ; l<N ; l++)
		a[l]=b[l]=0;
	for (k=0 ; k<(N+N) ; k++) 
		for (l=1 ; l<N ; l++) {
			kl=(l*k)%(N+N);
			a[l]+=f[k]*c[kl];
			b[l]+=f[k]*s[kl];
		}
	for (l=1 ; l<N ; l++) {
		fff[l]=(abs(a[l])>>SCALE)+(abs(b[l])>>SCALE);
	}

	for (k=N*4-3; k<BUFF_WIDTH; k++)  // Clean stuff past the end of the fft
		stereo[k][channel]=128;
	stereo[0][channel]=128;

	for (l=1; l<N ; l++) {
		level=fff[l];

		if (level>127) { // Expand the loops!!
			for (k=0; k<4; k++)
				stereo[l*4+k][channel]=255;
		} else {
			for (k=0; k<4; k++)
				stereo[l*4+k][channel]=level+128;
		}
  }
}
