/***************************************************************************/
/*                              CD SOUND OFF                               */
/***************************************************************************/
/*

    CD SoundOff is an audio CD player that is provided for your enjoyment.  
If you like CD SoundOff, feel free to show me by helping with the 
development costs.  Any and all donations will be greatly appreciated.

    CD SoundOff is provided as is with the C source code.  This software was 
developed using the Microsoft Windows 3.1 SDK and Microsoft C 7.0.  Feel free 
to add your own enhancements to CD SoundOff and please send me a copy
so that I can keep up with all of the new and exciting CD bells and 
whistles.  

                              NickleWare
                              P.O. Box 393
                              Orem, UT. 84059



NickleWare 
CompuServe: 72730,1002
Copyright (C) 93 Bradley Nicholes 

This documentation must accompany the CD SoundOff software. 

NickleWare or Bradley Nicholes shall not be liable for any damages, whether 
direct, indirect, special or consequential arising from the use or failure 
of this program to operate in the manner desired by the user.

*/

/***************************************************************************/
/*                      I N C L U D E   F I L E S                          */
/***************************************************************************/

#define NOGDICAPMASKS
#define NOVIRTUALKEYCODES
#define NONCMESSAGES
#define NODRAWFRAME
#define NOKEYSTATE
#define NORASTEROPS


#include <WINDOWS.H>
#include <mmsystem.h>
#include "soundoff.h"
#include <stdlib.h>
#include <string.h>

/***************************************************************************/
/*      T H E   P R O G R A M ' S   G L O B A L   V A R I A B L E S        */
/***************************************************************************/

HINSTANCE hInst;

/***************************************************************************/
/*                           FORWARD REFERENCES                            */
/***************************************************************************/

BOOL CALLBACK SoundOffDlgProc (HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK AboutboxWindowProc (HWND, UINT, WPARAM, LPARAM);

/***************************************************************************/
/*                       M A I N   P R O G R A M                           */
/***************************************************************************/


int FAR PASCAL WinMain (hInstance, hPrevInstance, lpszCmdLine, cmdShow)
HANDLE hInstance, hPrevInstance;
LPSTR  lpszCmdLine;                       /*  Length of the command line.  */
int    cmdShow;                           /*  Iconic or Tiled when start.  */
{

   FARPROC  lpprocSoundOff;      
   HWND  hwndDlg;
   MSG   msg;

   hInst = hInstance;

   // Create the main dialog window as a modeless dialog.
   lpprocSoundOff = (FARPROC)MakeProcInstance( SoundOffDlgProc, hInstance);
   hwndDlg = CreateDialog (hInstance, "SoundOffDlg", GetDesktopWindow(), 
      lpprocSoundOff);

   // If the dialog was created correctly then contine to the main message
   //  loop.  Otherwise exit the program.
   if (hwndDlg == 0)
      return 1;

   while (GetMessage(&msg, NULL, 0, 0))          /*  The main loop:         */
   {                                             /*  (terminated by a QUIT) */
      if (!IsDialogMessage(hwndDlg, &msg))
      {
         TranslateMessage(&msg);              /*  Have Windows translate */
         DispatchMessage(&msg);               /*  Have Windows give message */
      }                                       /*  to the window proc.    */
   }

   // Destroy the dialog and exit the program.
   DestroyWindow (hwndDlg);
   FreeProcInstance ( lpprocSoundOff);
   return(0);
}

/***************************************************************************/
/*    T H E   A B O U T   B O X   H A N D L I N G   P R O C E D U R E      */
/***************************************************************************/

/*   This is the window procedure for the main CD SoundOff control panel. */


BOOL CALLBACK SoundOffDlgProc (HWND hDlg, UINT message, WPARAM wParam, 
   LPARAM lParam)
{

   DRAWITEMSTRUCT FAR *pDrawItem;   // Passed in from the WM_DRAWITEM message.
   HICON    hIcon;                  // Button Icon.
   char     szBuffer[128];          // CD Audio command buffer.
   char     szReturn[128];          // CD Audio return buffer.
   static BOOL bContinuous = FALSE; // Auto-Repeat flag.
   static BOOL bPlay = FALSE;       // CD Audio currently playing flag.
   static BOOL bPause = FALSE;      // CD Audio currently paused flag.
   static WORD wTracks;             // Total number of tracks.
   static WORD wCurrTrack;          // Currently playing track.
   static HICON hTrackIcon;         // Track icon.
   HICON    hOldIcon;               // Previous track icon.
   PAINTSTRUCT ps;                  // Paint structure.
   RECT rc;                         // Window rectangle structure.
   HMENU hSysMenu;                  // System menu.
   FARPROC  lpprocAbout;            // About dialog proc.

   switch (message ) {

      case WM_INITDIALOG:

         // Open the cdaudio device to query the current status.
         mciSendString("open cdaudio", NULL, 0, hDlg);

         // Set the cdaudio device time format.
         mciSendString("set cdaudio time format tmsf", NULL, 0, hDlg);

         // Query the current state of the device.
         mciSendString("status cdaudio mode", szReturn, sizeof(szReturn), 
            hDlg);

         // If the cdaudio device is playing then initiallize the status
         //  to the current state.
         if (_stricmp (szReturn, "playing") == 0) {

            bPlay = TRUE;

            // Tell the device to notify the dialog of any events.
            mciSendString("play cdaudio notify", NULL, 0, hDlg);

            // Start the status polling timer.
            SetTimer(hDlg, CD_TIMER, 500, NULL);
         }

         // If the cdaudio device is paused then initialize the status to
         //  the current state.
         if (_stricmp (szReturn, "paused") == 0) {

            bPause = TRUE;
         }

         // Load and display the default track indicator icon.
         hTrackIcon = LoadIcon (hInst, "NONE");

         // Add the control panel commands to the system menu.
         hSysMenu = GetSystemMenu (hDlg, FALSE);

         AppendMenu (hSysMenu, MF_SEPARATOR, 0, NULL);
         AppendMenu (hSysMenu, MF_STRING, IDB_PREVIOUS, "Pre&vious");
         AppendMenu (hSysMenu, MF_STRING, IDB_PLAY, "&Play");
         AppendMenu (hSysMenu, MF_STRING, IDB_PAUSE, "P&ause");
         AppendMenu (hSysMenu, MF_STRING, IDB_STOP, "S&top");
         AppendMenu (hSysMenu, MF_STRING, IDB_NEXT, "&Next");
         AppendMenu (hSysMenu, MF_STRING, IDB_CONTINUOUS, "A&uto-Repeat");
         AppendMenu (hSysMenu, MF_SEPARATOR, 0, NULL);
         AppendMenu (hSysMenu, MF_STRING, IDM_ABOUT, "About!");

         return TRUE;

      case WM_TIMER:

         // Query the cdaudio device for the current track.
         mciSendString("status cdaudio current track", szReturn, 
            sizeof(szReturn), hDlg);

         // If the current track has changed then update the display.
         if (wCurrTrack != (WORD)atoi(szReturn)) {
         
            wCurrTrack = atoi(szReturn);

            // Load and display the new track display icon.
            switch (wCurrTrack) {

               case 0:
                  hTrackIcon = LoadIcon (hInst, "NONE");
                  break;
               case 1:
                  hTrackIcon = LoadIcon (hInst, "ONE");
                  break;
               case 2:
                  hTrackIcon = LoadIcon (hInst, "TWO");
                  break;
               case 3:
                  hTrackIcon = LoadIcon (hInst, "THREE");
                  break;
               case 4:
                  hTrackIcon = LoadIcon (hInst, "FOUR");
                  break;
               case 5:
                  hTrackIcon = LoadIcon (hInst, "FIVE");
                  break;
               case 6:
                  hTrackIcon = LoadIcon (hInst, "SIX");
                  break;
               case 7:
                  hTrackIcon = LoadIcon (hInst, "SEVEN");
                  break;
               case 8:
                  hTrackIcon = LoadIcon (hInst, "EIGHT");
                  break;
               case 9:
                  hTrackIcon = LoadIcon (hInst, "NINE");
                  break;
               case 10:
                  hTrackIcon = LoadIcon (hInst, "TEN");
                  break;
               case 11:
                  hTrackIcon = LoadIcon (hInst, "ELEVEN");
                  break;
               case 12:
                  hTrackIcon = LoadIcon (hInst, "TWELVE");
                  break;
               case 13:
                  hTrackIcon = LoadIcon (hInst, "THIRTEEN");
                  break;
               case 14:
                  hTrackIcon = LoadIcon (hInst, "FOURTEEN");
                  break;
               case 15:
                  hTrackIcon = LoadIcon (hInst, "FIFTEEN");
                  break;
               case 16:
                  hTrackIcon = LoadIcon (hInst, "SIXTEEN");
                  break;
               case 17:
                  hTrackIcon = LoadIcon (hInst, "SEVENTEEN");
                  break;
               case 18:
                  hTrackIcon = LoadIcon (hInst, "EIGHTEEN");
                  break;
               case 19:
                  hTrackIcon = LoadIcon (hInst, "NINETEEN");
                  break;
               case 20:
                  hTrackIcon = LoadIcon (hInst, "TWENTY");
                  break;

            }

            // Display the new track icon and destroy the previous one.
            hOldIcon = (HICON)SendDlgItemMessage (hDlg, IDS_TRACK, 
               STM_SETICON, hTrackIcon, 0);
            DestroyIcon (hOldIcon);

            // If the dialog is iconized then force the icon to repaint.
            if (IsIconic(hDlg)) {

               InvalidateRect (hDlg, NULL, FALSE);
            }
         }
         break;

      case MM_MCINOTIFY:
         switch(wParam) {

            case MCI_NOTIFY_SUCCESSFUL:

               // Stop the cdaudio device after it has successfully played
               //  through the entire CD and reset the state.
               SendMessage (hDlg, WM_COMMAND, IDB_STOP, 0L);

               // If the auto-repeat flag is set the restart the device.
               if (bContinuous) {

                  PostMessage (hDlg, WM_COMMAND, IDB_PLAY, 0L);
               }
               break;
         }
         break;


      case WM_PAINT:
         BeginPaint (hDlg, &ps);

         // Paint the dialog background with a dark gray.
         FillRect (ps.hdc, &ps.rcPaint, GetStockObject(GRAY_BRUSH));

         // If the dialog is iconized then center the current track display
         //  in the icon area.
         if (IsIconic(hDlg)) {

            DrawIcon (ps.hdc, 2, 2, hTrackIcon);
         }
         EndPaint (hDlg, &ps);
         return FALSE;


      case WM_SYSCOMMAND:
      case WM_COMMAND:

         switch(wParam) {

            case IDM_ABOUT:  

               // Display the about box as a modal dialog.
               lpprocAbout = (FARPROC)MakeProcInstance (AboutboxWindowProc, 
                  hInst);
               DialogBox (hInst, "AboutBox", hDlg, lpprocAbout);
               FreeProcInstance (lpprocAbout);
               break;

            case IDB_PREVIOUS: 
 
               // if the cdaudio device is not stopped then seek to the
               //  previous track.
               if (bPlay) {

                  // Clear the paused flag
                  bPause = FALSE;

                  // Force the pause button to repaint the new state.
                  InvalidateRect (GetDlgItem (hDlg, IDB_PAUSE), NULL, FALSE);

                  // Get the current track and increment it by one.
                  mciSendString("status cdaudio current track", szReturn, 
                     sizeof(szReturn), hDlg);

                  // Seek to the previous track.
                  _itoa (atoi(szReturn)-1, szReturn, 10);
                  lstrcpy (szBuffer, "seek cdaudio to ");
                  lstrcat (szBuffer, szReturn);
                  mciSendString(szBuffer, NULL, 0, hDlg);

                  // Play the new track.
                  mciSendString("play cdaudio notify", NULL, 0, hDlg);
               }
               return TRUE;

            case IDB_PLAY: 
     
               // If the cdaudio device is not playing or paused then start
               //  playing the CD
               if (!bPlay || bPause) {

                  // Set the state flags.
                  bPlay = TRUE;
                  bPause = FALSE;

                  // Force the buttons to display the new states.
                  InvalidateRect (GetDlgItem (hDlg, IDB_PLAY), NULL, FALSE);
                  InvalidateRect (GetDlgItem (hDlg, IDB_PAUSE), NULL, FALSE);

                  // If the device is not paused then open it, set the time
                  //  format and query the number of tracks on the CD.
                  if (!bPause) {
                     mciSendString("open cdaudio", NULL, 0, hDlg);
                     mciSendString("set cdaudio time format tmsf", NULL, 0, hDlg);
                     mciSendString("status cdaudio number of tracks", 
                        szReturn, sizeof(szReturn), hDlg);
                     wTracks = (WORD)atoi(szReturn);
                  }

                  // Start playing the CD
                  mciSendString("play cdaudio notify", NULL, 0, hDlg);

                  // Start the status polling timer.
                  SetTimer(hDlg, CD_TIMER, 500, NULL);

               }
               return TRUE;

            case IDB_PAUSE: 
 
               // if the cdaudio device is not stopped then seek to the
               //  previous track.
               if (bPlay) {

                  // Set the state flags.
                  bPause = TRUE;

                  // Force the buttons to display the new states.
                  InvalidateRect (GetDlgItem (hDlg, IDB_PAUSE), NULL, FALSE);

                  // Pause the cdaudio device.
                  mciSendString("pause cdaudio", NULL, 0, hDlg);
               }
               return TRUE;

            case IDB_STOP:      
 
               // if the cdaudio device is not stopped then seek to the
               //  previous track.
               if (bPlay) {

                  // Set the state flags.
                  bPlay = FALSE;
                  bPause = FALSE;

                  // Force the buttons to display the new states.
                  InvalidateRect (GetDlgItem (hDlg, IDB_PLAY), NULL, FALSE);
                  InvalidateRect (GetDlgItem (hDlg, IDB_PAUSE), NULL, FALSE);

                  // Stop and close the cdaudio device.
                  mciSendString("stop cdaudio", NULL, 0, hDlg);
                  mciSendString("close cdaudio", NULL, 0, hDlg);

                  // Kill the status polling timer.
                  KillTimer (hDlg, CD_TIMER);
               }
               return TRUE;

            case IDB_NEXT:      
 
               // if the cdaudio device is not stopped then seek to the
               //  previous track.
               if (bPlay) {

                  // Set the state flags.
                  bPause = FALSE;

                  // Force the buttons to display the new states.
                  InvalidateRect (GetDlgItem (hDlg, IDB_PAUSE), NULL, FALSE);

                  // Get the current track and decrement it by one.
                  mciSendString("status cdaudio current track", szReturn, 
                     sizeof(szReturn), hDlg);

                  // Seek to the next track.
                  _itoa (atoi(szReturn)+1, szReturn, 10);
                  lstrcpy (szBuffer, "seek cdaudio to ");
                  lstrcat (szBuffer, szReturn);
                  mciSendString(szBuffer, NULL, 0, hDlg);

                  // Play the new track.
                  mciSendString("play cdaudio notify", NULL, 0, hDlg);
               }
               return TRUE;

            case IDB_CONTINUOUS:

               // Set the state flags.
               bContinuous = !bContinuous;

               // Force the buttons to display the new states.
               InvalidateRect (GetDlgItem (hDlg, IDB_CONTINUOUS), NULL, FALSE);

               CheckMenuItem (GetSystemMenu (hDlg, FALSE), IDB_CONTINUOUS, 
                  MF_BYCOMMAND | (bContinuous ? MF_CHECKED : MF_UNCHECKED));
               return TRUE;

         }
         break;

      case WM_DRAWITEM:

         // Get the draw item information.
         pDrawItem = (DRAWITEMSTRUCT FAR*)lParam;

         CopyRect (&rc, &pDrawItem->rcItem);
         rc.top = rc.bottom - 3;
         FillRect (pDrawItem->hDC, &rc, GetStockObject(GRAY_BRUSH));

         // Don't do anything on a focus change.
         if (pDrawItem->itemAction & ODA_FOCUS)
            return FALSE;

         // Load and display the current state icon of the appropriate button.
         switch(wParam) {

            case IDB_PREVIOUS:  

               // If the button is selected then load the pressed icon
               //  Otherwise load the non-pressed icon.
               if (pDrawItem->itemState & ODS_SELECTED) {

                  hIcon = LoadIcon (hInst, "PREVIN");
               }
               else {

                  hIcon = LoadIcon (hInst, "PREVOUT");
               }
               break;

            case IDB_PLAY:      

               // If the button is selected then load the pressed icon
               //  Otherwise load the non-pressed icon.
               if (pDrawItem->itemState & ODS_SELECTED) {

                  hIcon = LoadIcon (hInst, "PLAYIN");
               }
               else {

                  if (bPlay)
                     hIcon = LoadIcon (hInst, "PLAYON");
                  else 
                     hIcon = LoadIcon (hInst, "PLAYOUT");
               }
               break;

            case IDB_PAUSE:     

               // If the button is selected then load the pressed icon
               //  Otherwise load the non-pressed icon.
               if (pDrawItem->itemState & ODS_SELECTED) {

                  hIcon = LoadIcon (hInst, "PAUSEIN");
               }
               else {

                  if (bPause)
                     hIcon = LoadIcon (hInst, "PAUSEON");
                  else 
                     hIcon = LoadIcon (hInst, "PAUSEOUT");
               }
               break;

            case IDB_STOP:      

               // If the button is selected then load the pressed icon
               //  Otherwise load the non-pressed icon.
               if (pDrawItem->itemState & ODS_SELECTED) {

                  hIcon = LoadIcon (hInst, "STOPIN");
               }
               else {

                  hIcon = LoadIcon (hInst, "STOPOUT");
               }
               break;

            case IDB_NEXT:      

               // If the button is selected then load the pressed icon
               //  Otherwise load the non-pressed icon.
               if (pDrawItem->itemState & ODS_SELECTED) {

                  hIcon = LoadIcon (hInst, "NEXTIN");
               }
               else {

                  hIcon = LoadIcon (hInst, "NEXTOUT");
               }
               break;

            case IDB_CONTINUOUS:

               // If the button is selected then load the pressed icon
               //  Otherwise load the non-pressed icon.
               if (pDrawItem->itemState & ODS_SELECTED) {

                  hIcon = LoadIcon (hInst, "CONTIIN");
               }
               else {

                  // If the auto-repeat flag is set then load the 
                  //  appropriate icon.
                  if (bContinuous)
                     hIcon = LoadIcon (hInst, "CONTINON");
                  else 
                     hIcon = LoadIcon (hInst, "CONTIOUT");
               }
               break;

         }

         // Display the new state icon and destroy the old one.
         DrawIcon (pDrawItem->hDC, pDrawItem->rcItem.left, 
            pDrawItem->rcItem.top, hIcon);
         DestroyIcon (hIcon);
         return TRUE;

      case WM_MEASUREITEM:
         break;

      case WM_CLOSE:

         // Post a quit message to close the application.
         PostQuitMessage (0);
         break;
   }

   return FALSE;
}

/***************************************************************************/
/*    T H E   A B O U T   B O X   H A N D L I N G   P R O C E D U R E      */
/***************************************************************************/

/*   (This is the window procedure for the About dialog box.)              */


static char SndOffInfo[] = 

"    CD SoundOff is an audio CD player that is provided for your enjoyment. \
If you like CD SoundOff, feel free to show me by helping with the \
development costs.  Any and all donations will be greatly appreciated.\
  CD SoundOff is provided as is with the C source code.  This software was \
developed using the Microsoft Windows 3.1 SDK and Microsoft C 7.0.  Feel free \
to add your own enhancements to CD SoundOff and please send me a copy \
so that I can keep up with all of the new and exciting CD bells and \
whistles.  The documentation and source must accompany the CD SoundOff \
software.";


BOOL CALLBACK AboutboxWindowProc (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{

   switch (message) {

      case WM_INITDIALOG:
         SetDlgItemText (hDlg, ID_INFO, SndOffInfo);
         return TRUE;

      case WM_COMMAND:
         if (wParam == IDOK) {

            EndDialog (hDlg, TRUE);
            return TRUE;
         }
         break;
    }

    return FALSE;
}




