#    Copyright (C) 1994 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# makefile for Independent JPEG Group code.

# NOTE: this makefile works only with version 5beta1 or later of the IJG code.
# You can get the current version by Internet anonymous FTP from
# ftp.uu.net:/graphics/jpeg.  As of July 29, 1994, the current version
# is 5beta1, and the IJG files are named:
#	jpegsrc.v5beta1.tar.gz		Standard distribution
#	jpeg-5b1.zip			DOS-style archive
# You may find more recent files on the FTP server.
#
# For version 5alpha3, set INT=llm.  (This is probably no longer relevant.)
# For version 5alpha4, 5beta1, or later, set INT=int.
INT=int

# We keep all of the IJG code in a separate directory so as not to
# inadvertently mix it up with Aladdin Enterprises' own code.
# However, we need our own version of jconfig.h, and our own "wrapper" for
# jmorecfg.h.

JSRC=$(JPEGSRC)$(D)

CCCJ=$(CCC) -I. -I$(JPEGSRC)

jconfig_h=jconfig.h $(std_h)
jmorecfg_h=jmorecfg.h jmcorig.h

jconfig.h: gsjconf.h
	cp gsjconf.h jconfig.h

jmorecfg.h: gsjmorec.h
	cp gsjmorec.h jmorecfg.h

jmcorig.h: $(JSRC)jmorecfg.h
	cp $(JSRC)jmorecfg.h jmcorig.h

# To ensure that the compiler finds our versions of jconfig.h and jmorecfg.h,
# regardless of the compiler's search rule, we must copy up all .c files,
# and all .h files that include either of these files, directly or
# indirectly.  The only such .h files currently are jinclude.h and jpeglib.h.
# Also, to avoid including the JPEGSRC directory name in our source files,
# we must also copy up any other .h files that our own code references.
# Currently, the only such .h file is jerror.h.

JHCOPY=jerror.h jinclude.h jpeglib.h

jerror.h: $(JSRC)jerror.h
	cp $(JSRC)jerror.h jerror.h

jinclude.h: $(JSRC)jinclude.h
	cp $(JSRC)jinclude.h jinclude.h

jpeglib.h: $(JSRC)jpeglib.h
	cp $(JSRC)jpeglib.h jpeglib.h

# In order to avoid having to keep the dependency lists for the IJG code
# accurate, we simply make all of them depend on the only files that
# we are ever going to change, and on all the .h files that must be copied up.
# This is too conservative, but only hurts us if we are changing our own
# j*.h files, which happens only rarely during development.

JDEP=$(AK) $(jconfig_h) $(jmorecfg_h) $(JHCOPY)

# Code common to compression and decompression.

DCT1=jcomapi.$(OBJ) jutils.$(OBJ) jerror.$(OBJ) jmemmgr.$(OBJ)

jcomapi.$(OBJ): $(JSRC)jcomapi.c $(JDEP)
	cp $(JSRC)jcomapi.c .
	$(CCCJ) jcomapi.c
	rm jcomapi.c

jutils.$(OBJ): $(JSRC)jutils.c $(JDEP)
	cp $(JSRC)jutils.c .
	$(CCCJ) jutils.c
	rm jutils.c

jerror.$(OBJ): $(JSRC)jerror.c $(JDEP)
	cp $(JSRC)jerror.c .
	$(CCCJ) jerror.c
	rm jerror.c

jmemmgr.$(OBJ): $(JSRC)jmemmgr.c $(JDEP)
	cp $(JSRC)jmemmgr.c .
	$(CCCJ) jmemmgr.c
	rm jmemmgr.c

# Compression code.

DCTE1=jcapi.$(OBJ) jccoefct.$(OBJ) jccolor.$(OBJ) jcdctmgr.$(OBJ) 
DCTE2=jchuff.$(OBJ) jcmainct.$(OBJ) jcmarker.$(OBJ) jcmaster.$(OBJ)
DCTE3=jcparam.$(OBJ) jcprepct.$(OBJ) jcsample.$(OBJ) jfdct$(INT).$(OBJ)

jcapi.$(OBJ): $(JSRC)jcapi.c $(JDEP)
	cp $(JSRC)jcapi.c .
	$(CCCJ) jcapi.c
	rm jcapi.c

jccoefct.$(OBJ): $(JSRC)jccoefct.c $(JDEP)
	cp $(JSRC)jccoefct.c .
	$(CCCJ) jccoefct.c
	rm jccoefct.c

jccolor.$(OBJ): $(JSRC)jccolor.c $(JDEP)
	cp $(JSRC)jccolor.c .
	$(CCCJ) jccolor.c
	rm jccolor.c

jcdctmgr.$(OBJ): $(JSRC)jcdctmgr.c $(JDEP)
	cp $(JSRC)jcdctmgr.c .
	$(CCCJ) jcdctmgr.c
	rm jcdctmgr.c

jchuff.$(OBJ): $(JSRC)jchuff.c $(JDEP)
	cp $(JSRC)jchuff.c .
	$(CCCJ) jchuff.c
	rm jchuff.c

jcmainct.$(OBJ): $(JSRC)jcmainct.c $(JDEP)
	cp $(JSRC)jcmainct.c .
	$(CCCJ) jcmainct.c
	rm jcmainct.c

jcmarker.$(OBJ): $(JSRC)jcmarker.c $(JDEP)
	cp $(JSRC)jcmarker.c .
	$(CCCJ) jcmarker.c
	rm jcmarker.c

jcmaster.$(OBJ): $(JSRC)jcmaster.c $(JDEP)
	cp $(JSRC)jcmaster.c .
	$(CCCJ) jcmaster.c
	rm jcmaster.c

jcparam.$(OBJ): $(JSRC)jcparam.c $(JDEP)
	cp $(JSRC)jcparam.c .
	$(CCCJ) jcparam.c
	rm jcparam.c

jcprepct.$(OBJ): $(JSRC)jcprepct.c $(JDEP)
	cp $(JSRC)jcprepct.c .
	$(CCCJ) jcprepct.c
	rm jcprepct.c

jcsample.$(OBJ): $(JSRC)jcsample.c $(JDEP)
	cp $(JSRC)jcsample.c .
	$(CCCJ) jcsample.c
	rm jcsample.c

jfdct$(INT).$(OBJ): $(JSRC)jfdct$(INT).c $(JDEP)
	cp $(JSRC)jfdct$(INT).c .
	$(CCCJ) jfdct$(INT).c
	rm jfdct$(INT).c

# Decompression code

DCTD1=jdapi.$(OBJ) jdcoefct.$(OBJ) jdcolor.$(OBJ)
DCTD2=jddctmgr.$(OBJ) jdhuff.$(OBJ) jdmainct.$(OBJ) jdmarker.$(OBJ)
DCTD3=jdmaster.$(OBJ) jdpostct.$(OBJ) jdsample.$(OBJ) jidct$(INT).$(OBJ)

jdapi.$(OBJ): $(JSRC)jdapi.c $(JDEP)
	cp $(JSRC)jdapi.c .
	$(CCCJ) jdapi.c
	rm jdapi.c

jdcoefct.$(OBJ): $(JSRC)jdcoefct.c $(JDEP)
	cp $(JSRC)jdcoefct.c .
	$(CCCJ) jdcoefct.c
	rm jdcoefct.c

jdcolor.$(OBJ): $(JSRC)jdcolor.c $(JDEP)
	cp $(JSRC)jdcolor.c .
	$(CCCJ) jdcolor.c
	rm jdcolor.c

jddctmgr.$(OBJ): $(JSRC)jddctmgr.c $(JDEP)
	cp $(JSRC)jddctmgr.c .
	$(CCCJ) jddctmgr.c
	rm jddctmgr.c

jdhuff.$(OBJ): $(JSRC)jdhuff.c $(JDEP)
	cp $(JSRC)jdhuff.c .
	$(CCCJ) jdhuff.c
	rm jdhuff.c

jdmainct.$(OBJ): $(JSRC)jdmainct.c $(JDEP)
	cp $(JSRC)jdmainct.c .
	$(CCCJ) jdmainct.c
	rm jdmainct.c

jdmarker.$(OBJ): $(JSRC)jdmarker.c $(JDEP)
	cp $(JSRC)jdmarker.c .
	$(CCCJ) jdmarker.c
	rm jdmarker.c

jdmaster.$(OBJ): $(JSRC)jdmaster.c $(JDEP)
	cp $(JSRC)jdmaster.c .
	$(CCCJ) jdmaster.c
	rm jdmaster.c

jdpostct.$(OBJ): $(JSRC)jdpostct.c $(JDEP)
	cp $(JSRC)jdpostct.c .
	$(CCCJ) jdpostct.c
	rm jdpostct.c

jdsample.$(OBJ): $(JSRC)jdsample.c $(JDEP)
	cp $(JSRC)jdsample.c .
	$(CCCJ) jdsample.c
	rm jdsample.c

jidct$(INT).$(OBJ): $(JSRC)jidct$(INT).c $(JDEP)
	cp $(JSRC)jidct$(INT).c .
	$(CCCJ) jidct$(INT).c
	rm jidct$(INT).c

### DCT filters

jpeg.dev: jpeg.mak $(DCT1) $(DCT2) $(DCT3) \
  $(DCTE1) $(DCTE2) $(DCTE3) $(DCTD1) $(DCTD2) $(DCTD3)
	$(SETMOD) jpeg $(DCT1)
	$(ADDMOD) jpeg -obj $(DCT2)
	$(ADDMOD) jpeg -obj $(DCT3)
	$(ADDMOD) jpeg -obj $(DCTE1)
	$(ADDMOD) jpeg -obj $(DCTE2)
	$(ADDMOD) jpeg -obj $(DCTE3)
	$(ADDMOD) jpeg -obj $(DCTD1)
	$(ADDMOD) jpeg -obj $(DCTD2)
	$(ADDMOD) jpeg -obj $(DCTD3)
