:: RUNNING TIME (dedicated environment on 486DX2/50 VLB):  5 1/2 minutes
::              (3 DIRs out of 61 had duplicates within the DIR)

:: This batch file is completed.  It removes duplicates from the individual
:: DIRS (merges the DIRs on themselves) and should be run BEFORE any of the
:: CRSDUPE?.BAT's, which are for removing cross file duplicates.

:: NOTE:  I would highly recommend using the "log" and vl1 "verbose" options.
:: After finding a LOT of files with the same name that are not duplicates, I
:: expanded the line written to the log so it contains the entire first line
:: of the description (vl1 now writes the first occurrence to the log when a
:: file is merged on itself).  There is also a new /1t "compare" option that
:: writes the first occurrence description of a cross file duplicate to the
:: trash file so it can be easily compared.  A "happy face" (^A) is added to
:: the end of its key line (the line with the file name) if the first merge key
:: field is ascending order; if descending, a "block" (ASCII 254).  This batch
:: file is also set up so the first occurrence is added to the trash file even
:: when merging a DIR on itself.  The commands shown are written for MERGESYS.
:: See the notes for changes if using MERGEPRO (/s will always have to be added
:: to the command line and /f1 if no other field options are shown).  If the
:: DIR headings are still in place, /b??? will have to be added where needed.

@echo off

::
:: GET READY
:: Sort each list in name ascending order.  NOTE:  remember our conversation
:: that PCBFiler will not always keep the latest date of a duplicate name first
:: after you sort on name ascending from date descending.  You may want to do
:: an extra step to insure that the latest date is always first (this batch
:: file was written before the "/EF" switch, so also see BATNOTES for fixing
:: date sequence errors).  Run MERGE on each file with the command line:

:: MERGE dir?? /f1 /f3ddt /ea /o /terror+n /k /v
:: (add /s for MERGEPRO and use /k so you will keep duplicates if there are
:: any; you don't want to strip duplicates until the next step).  Any errors,
:: like stray parts of descriptions or an earlier date preceding a later date
:: on the same file name, will be stripped from the merged DIR and written to
:: the trash file (you can name it whatever).  Then, if there were errors, you
:: can check out the trash file, edit it to remove any garbage, and remerge any
:: descriptions that were stripped because a date was out of sequence:

:: MERGE error dir?? /f1 /f3ddt /o /ea /ternew+n /k /v
:: (add /s for MERGEPRO).  If you do this for every DIR, this batch file can be
:: used as is, otherwise some steps below will need to be modified as indicated
:: when merging each DIR on itself.

::
:: ALSO, once your regular DIRs are fixed the first time, they won't need any
:: thing done to them again until you combine them with a new CD-ROM's DIRs.
:: REMEMBER, it's a lot quicker to MERGE two DIRs together than to copy them
:: together, run PCBFiler, and then merge each one on itself.  Assuming you
:: choose to merge them, you can write a batch file based on the example below.
:: However, you should still read everything here, since there is information
:: that you may need.  To merge each set of DIRs, use something like:

:: MERGE /ea /tcd_trash+n /lcd_dupe.log /vl1 bbs_dir cd_dir combined.dir
:: or
:: MERGE /ea /tcd_trash+n /lcd_dupe.log /vl1 cd_dir bbs_dir /o
:: if you want to use the CD-ROM description when there is a duplicate.  You
:: should check the log to see if all names removed as duplicates really are.
:: If not and you want to keep both descriptions, move the one in CD_TRASH to
:: your "misc" or "uploads" DIR after all the batch files are finished (don't
:: do it now or the description will get stripped again during the "compares").

:: To keep the latest date of a duplicate regardless whether it came from the
:: CD-ROM or your existing DIR, you can use the command line shown below (the
:: trash file will only get errors since all duplicates are kept):

:: MERGE /ea /tcd_error+n /lcd_error.log /vl cd_dir bbs_dir /o /k /f1 /f3ddt
:: Then, go ahead and merge each BBS_DIR on itself, which will remove any dupes
:: to the trash file and keep the latest (if any duplicates have the same date,
:: whichever file was in the first position will be the one that is kept).  You
:: can also use this batch file to merge each DIR on itself (read on).

::
:: An alternative to going to the log to check on duplicates, then getting the
:: needed description out of the trash file, is to create different trash files
:: for each set of merged DIRs and have the description that was kept precede
:: the description that was stripped.  However, MERGE can't do this by itself
:: except when comparing, so some additional steps need to be taken.  For all
:: this to really work right (and be automated), both the bbs and CD-ROM DIRs
:: should be error free, i.e., each should already be merged on itself with the
:: /ea /t /f1 /f3ddt options as described above.

:: Your DIRs are all ok now, but I don't know about a CD-ROM's (I am thinking
:: more of stray description parts of the type PCBFiler is good at creating if
:: a description line is too long, but the sorting could be a problem too).
:: The steps shown below use /ea, but whether they will still work as intended
:: if there's an error would depend on the type of error and where it occurs.
:: Although some steps below do not show a log, it's always a good idea to use
:: one in an unattended batch file in case something unexpected happens, e.g.,
:: a DIR wasn't processed because of a typo in the name (you don't need to use
:: "verbose" if the log is only to check that everything worked; you could also
:: probably just use log's new "+N", which eliminates the header and statistics
:: and only writes errors; if there aren't any, there's no log).  As mentioned
:: above, if you want to get the latest date of a dupe regardless which DIR it
:: is in, replace the first line below with (this also catches date errors):

:: MERGE /o /k /ea /f1 /f3ddt /tcd_dir1.err+n /lcd_error.log /vl cd-dir1 dir1
:: then follow it with:  MERGE /o /lcd_dupe.log /vl1 /tcd_dir1.dup+n dir1

:: MERGE /o /ea /lcd_dupe.log /vl1 /tcd_dir1.dup+n cd-dir1 dir1
:: if not exist cd_dir1.dup goto DIR2   (do the next DIR if there are no dupes)
:: MERGE /o /k /e /1t /tcd_1st.dup+n dir1 cd_dir1.dup(write 1st occur to trash)
:: MERGE /o /k /ea /terror cd_1st.dup cd_dir1.dup   (both dupe descriptions are
::                                                   now in CD_DIR1.DUP and the
::                                                   first is still in the DIR)
:: del cd_1st.dup             (get rid of the file; you don't need it any more)
:: MERGE /o /k cd_dir1.dup cd_dir.dup  (optional, or can also do when all DIR's
::                                      are merged: makes a master of all dupe
::                                      descriptions between the CDs and DIRs)

:: If you've already checked for errors, you can eliminate a step (as described
:: previously, to always get the latest date, replace the first line below with
:: MERGE /o /k /f1 /f3ddt /lcd_dir.log cd-dir1 dir1
:: then follow it with MERGE /o /lcd_dupe.log /vl1 /ttemp.dup+n dir1):

:: MERGE /o /lcd_dupe.log /vl1 /ttemp.dup+n cd-dir1 dir1
:: if not exist temp.dup goto DIR2
:: MERGE /o /1t /lcd_dupe.log /tcd_dir1.dup+n dir1 temp.dup
:: del temp.dup

:: The first method assumes there may be some errors besides any duplicates in
:: the original trash file, CD_DIR1.DUP, so it is compared with /k to keep its
:: duplicates, but the /1t still writes the first occurrence in DIR1 to the new
:: trash file, CD_1ST.DUP (the first occurrence is not stripped from DIR1, but
:: the matching description would have been stripped from CD_DIR1.DUP if the /k
:: wasn't used).  The new trash file is then merged with the first trash file,
:: which now contains both the kept "happy face" descriptions followed by their
:: corresponding stripped descriptions.  The second method, because it is known
:: beforehand that there will be no errors, strips only duplicates to the first
:: trash file, TEMP.DUP.  Since every name in TEMP.DUP will be a duplicate when
:: compared to DIR1 (and since /1t is used again to write the first occurrence
:: to the new trash file, CD_DIR1.DUP), by not using /k, all duplicates will be
:: written to CD_DIR1.DUP (every description is stripped from TEMP.DUP, but it
:: will still need to be deleted because as a precaution, MERGE does not erase
:: an input file that is also the output file if its size would be 0).

::
:: SUMMARIZING ALL THE ABOVE AND MY RECOMMENDATIONS:
:: Your bbs DIRs don't need any more special treatment; just sort with PCBFiler
:: on name ascending when you're ready to add a new CD-ROM (assuming the CD-ROM
:: is also name ascending).  After deciding which of your bbs and CD-ROM DIRs
:: should be combined (you can also exchange the positions of the CD-ROM and
:: bbs DIR files to keep the bbs description if duplicate names happen to have
:: the same date), merge them individually from the command line with:

:: MERGE /o /k /ea /f1 /f3ddt /tcd_error+n /lcd_error.log /vl cd_dir bbs_dir
:: The latest date of a duplicate will then always be first (and all will be in
:: BBS_DIR).  Any errors in the CD-ROM DIR will be in the trash file CD_ERROR,
:: which you can edit and remerge if necessary until there are no more errors:

:: MERGE /o /k /ea /f1 /f3ddt /terror.new+n /lcd_error.log /vl cd_error bbs_dir
:: If ERROR.NEW has any new errors (it won't have unless you missed something),
:: edit it and MERGE ERROR.NEW BBS_DIR, etc.  If the CD-ROM DIRs are not name
:: ascending, append (copy) each CD-ROM and bbs DIR together.  After sorting
:: with PCBFiler on name ascending, merge the DIRs individually using:

:: MERGE /o /k /ea /f1 /f3ddt /tdirerror+n /ldirerror.log /vl bbs_dir
:: and repeat the same kind of steps described above until there are no errors.
:: After all the DIRs are done, they are ready to be processed using this batch
:: file.  The steps below use the equivalent of the second method shown above
:: for merging the bbs and CD-ROM DIRs when it is known there are no errors.
:: Even though PCBFiler can be made to sort your DIRs from the command line, I
:: would not recommend trying to automate this whole process because you can't
:: be certain what the CD-ROM DIRs will need done to them if they have errors.

:: Since the commands will be the same for every DIR, except for the file names
:: to merge, you can use "command recall", or you could just write a one line
:: batch file with replaceable parameters for the file names.  Another way
:: would be to write a configuration file with all the commands except the file
:: names (you can enter "MERGE commands /wname.cfg" and MERGE will write it),
:: then use MERGE's /r switch and add the file names to the command line.

:: WARNING:  I have discovered some cases where the date was NOT a date, e.g.,
:: 4-31-92 (April has only 30 days) or 00-00-00.  How or where these came from,
:: I have no idea, but if they are not corrected, CRSDUPE1.BAT will fail when
:: it makes the "master" list using /f1 /f3ddt to get the latest date first.
:: And it's always a good idea to use "verbose" mode when looking for errors.
:: I tried remerging the DIR with the 4-31 date two times and couldn't figure
:: out what was wrong (the first time I just assumed it was out of sequence).
:: Then on the third try I used /v, which very nicely told me it was a date
:: conversion error, and my birthday is April 30th, so I SHOULD have caught it!

::
:: LET'S GET STARTED!
:: Merge each list on itself.  If there is still a DIR heading in place, to the
:: first line of each group add:  /b114h (if they start on line 14 and you want
:: to write the old heading to the merged list, "h"; if you don't use "h", the
:: merge starts on line 14, but the heading is removed; when a DIR is compared
:: to the former trash file in line 3 of each group below, add both /b114 /b21
:: if the DIR heading is still attached).  If you are not using MERGESYS, also
:: add:  /s /f1.  If you want a "verbose" log, use:  /l /vl or /l /v for screen
:: also (screen can slow it down).  If you want to see both of the file names
:: with their sizes, dates, and first line of the description for evaluating if
:: two files are really duplicates (as in the case of two different programs
:: with the same name, e.g., SERIAL.ZIP), use vl1 or v1.  The commands below do
:: not create a "master" trash file of all dupes from the individual DIRs.  If
:: you want to make one as you go along, add to each group as the last command:

:: MERGE /o /k /ld:\temp\mst_dupe.log d:\temp\dir??.dup d:\temp\dir.dup
:: The master trash file created this way will keep each DIR's first occurrence
:: description with the matching description that is stripped.  However, if
:: different DIRs have the same name duplicated so that the trash file will get
:: duplicates, the latest date may not come first (the first will always be
:: from the last DIR file that was in file 1's position).  If you want a master
:: dupe list that will always have the latest date of a stripped description
:: first (also see the comments at the end of the CRSDUPE?.BATs), use:

:: MERGE /o /k /f1 /f3ddt /ld:\temp\mst_dupe.log d:\temp\dir??.dup d:\temp\dir.dup
:: The difference here is that the "happy face" description may not immediately
:: precede its corresponding stripped description if the same description was
:: stripped from different DIRs.  Depending on the dates, the same named first
:: occurrences could all be together, followed by the stripped descriptions, or
:: even a first occurrence from one DIR followed by a description stripped from
:: another (ALL dates would be in descending order; if both the name and date
:: are the same, the description from the last DIR in file 1's place is first).
:: If you don't care to check on dupes or think a log file will be enough, you
:: can eliminate the "multi-steps" shown below and simply use for each DIR:

:: MERGE /o /ea /td:\temp\trash+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir??
:: As mentioned above, if you have NOT checked each DIR so there are no errors,
:: you will have to change the steps on every DIR below and use (the "echo" is
:: just my preference for spacing DOS's "file deleted" message if you watch):

:: MERGE /o /ea /td:\temp\dir?.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir?
:: if not exist d:\temp\dir?.dup goto DIR?+1 (whatever number is next)
:: MERGE /o /k /e /1t /td:\temp\dir_1st.dup+n /ld:\temp\dir_1st.log d:\pcb\dirc\dir? d:\temp\dir?.dup
:: MERGE /o /k /ea /td:\temp\error.dir+n /ld:\temp\dir_1st.log d:\temp\dir_1st.dup d:\temp\dir?.dup
:: echo.
:: del d:\temp\dir_1st.dup
:: Another way, which may even be safer (it catches date errors) and easier, is
:: just add the line below as the first line to each group:

:: MERGE /o /k /ea /f1 /f3ddt /td:\temp\dir?.err+n /ld:\temp\direrror.log /vl d:\pcb\dirc\dir?

:DIR1
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir1
if not exist d:\temp\temp.dup goto DIR2
MERGE /o /1t /td:\temp\dir1.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir1 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR2
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir2
if not exist d:\temp\temp.dup goto DIR3
MERGE /o /1t /td:\temp\dir2.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir2 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR3
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir3
if not exist d:\temp\temp.dup goto DIR4
MERGE /o /1t /td:\temp\dir3.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir3 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR4
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir4
if not exist d:\temp\temp.dup goto DIR5
MERGE /o /1t /td:\temp\dir4.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir4 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR5
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir5
if not exist d:\temp\temp.dup goto DIR6
MERGE /o /1t /td:\temp\dir5.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir5 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR6
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir6
if not exist d:\temp\temp.dup goto DIR7
MERGE /o /1t /td:\temp\dir6.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir6 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR7
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir7
if not exist d:\temp\temp.dup goto DIR8
MERGE /o /1t /td:\temp\dir7.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir7 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR8
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir8
if not exist d:\temp\temp.dup goto DIR9
MERGE /o /1t /td:\temp\dir8.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir8 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR9
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir9
if not exist d:\temp\temp.dup goto DIR10
MERGE /o /1t /td:\temp\dir9.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir9 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR10
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir10
if not exist d:\temp\temp.dup goto DIR11
MERGE /o /1t /td:\temp\dir10.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir10 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR11
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir11
if not exist d:\temp\temp.dup goto DIR12
MERGE /o /1t /td:\temp\dir11.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir11 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR12
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir12
if not exist d:\temp\temp.dup goto DIR13
MERGE /o /1t /td:\temp\dir12.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir12 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR13
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir13
if not exist d:\temp\temp.dup goto DIR14
MERGE /o /1t /td:\temp\dir13.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir13 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR14
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir14
if not exist d:\temp\temp.dup goto DIR15
MERGE /o /1t /td:\temp\dir14.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir14 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR15
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir15
if not exist d:\temp\temp.dup goto DIR16
MERGE /o /1t /td:\temp\dir15.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir15 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR16
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir16
if not exist d:\temp\temp.dup goto DIR17
MERGE /o /1t /td:\temp\dir16.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir16 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR17
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir17
if not exist d:\temp\temp.dup goto DIR18
MERGE /o /1t /td:\temp\dir17.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir17 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR18
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir18
if not exist d:\temp\temp.dup goto DIR19
MERGE /o /1t /td:\temp\dir18.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir18 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR19
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir19
if not exist d:\temp\temp.dup goto DIR20
MERGE /o /1t /td:\temp\dir19.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir19 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR20
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir20
if not exist d:\temp\temp.dup goto DIR21
MERGE /o /1t /td:\temp\dir20.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir20 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR21
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir21
if not exist d:\temp\temp.dup goto DIR22
MERGE /o /1t /td:\temp\dir21.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir21 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR22
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir22
if not exist d:\temp\temp.dup goto DIR23
MERGE /o /1t /td:\temp\dir22.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir22 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR23
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir23
if not exist d:\temp\temp.dup goto DIR24
MERGE /o /1t /td:\temp\dir23.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir23 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR24
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir24
if not exist d:\temp\temp.dup goto DIR25
MERGE /o /1t /td:\temp\dir24.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir24 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR25
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir25
if not exist d:\temp\temp.dup goto DIR26
MERGE /o /1t /td:\temp\dir25.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir25 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR26
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir26
if not exist d:\temp\temp.dup goto DIR27
MERGE /o /1t /td:\temp\dir26.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir26 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR27
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir27
if not exist d:\temp\temp.dup goto DIR28
MERGE /o /1t /td:\temp\dir27.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir27 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR28
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir28
if not exist d:\temp\temp.dup goto DIR29
MERGE /o /1t /td:\temp\dir28.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir28 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR29
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir29
if not exist d:\temp\temp.dup goto DIR30
MERGE /o /1t /td:\temp\dir29.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir29 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR30
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir30
if not exist d:\temp\temp.dup goto DIR31
MERGE /o /1t /td:\temp\dir30.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir30 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR31
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir31
if not exist d:\temp\temp.dup goto DIR32
MERGE /o /1t /td:\temp\dir31.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir31 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR32
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir32
if not exist d:\temp\temp.dup goto DIR33
MERGE /o /1t /td:\temp\dir32.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir32 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR33
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir33
if not exist d:\temp\temp.dup goto DIR34
MERGE /o /1t /td:\temp\dir33.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir33 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR34
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir34
if not exist d:\temp\temp.dup goto DIR35
MERGE /o /1t /td:\temp\dir34.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir34 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR35
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir35
if not exist d:\temp\temp.dup goto DIR36
MERGE /o /1t /td:\temp\dir35.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir35 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR36
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir36
if not exist d:\temp\temp.dup goto DIR37
MERGE /o /1t /td:\temp\dir36.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir36 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR37
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir37
if not exist d:\temp\temp.dup goto DIR38
MERGE /o /1t /td:\temp\dir37.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir37 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR38
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir38
if not exist d:\temp\temp.dup goto DIR39
MERGE /o /1t /td:\temp\dir38.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir38 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR39
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir39
if not exist d:\temp\temp.dup goto DIR40
MERGE /o /1t /td:\temp\dir39.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir39 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR40
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir40
if not exist d:\temp\temp.dup goto DIR41
MERGE /o /1t /td:\temp\dir40.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir40 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR41
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir41
if not exist d:\temp\temp.dup goto DIR42
MERGE /o /1t /td:\temp\dir41.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir41 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR42
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir42
if not exist d:\temp\temp.dup goto DIR43
MERGE /o /1t /td:\temp\dir42.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir42 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR43
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir43
if not exist d:\temp\temp.dup goto DIR44
MERGE /o /1t /td:\temp\dir43.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir43 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR44
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir44
if not exist d:\temp\temp.dup goto DIR45
MERGE /o /1t /td:\temp\dir44.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir44 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR45
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir45
if not exist d:\temp\temp.dup goto DIR46
MERGE /o /1t /td:\temp\dir45.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir45 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR46
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir46
if not exist d:\temp\temp.dup goto DIR47
MERGE /o /1t /td:\temp\dir46.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir46 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR47
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir47
if not exist d:\temp\temp.dup goto DIR48
MERGE /o /1t /td:\temp\dir47.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir47 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR48
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir48
if not exist d:\temp\temp.dup goto DIR49
MERGE /o /1t /td:\temp\dir48.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir48 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR49
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir49
if not exist d:\temp\temp.dup goto DIR50
MERGE /o /1t /td:\temp\dir49.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir49 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR50
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir50
if not exist d:\temp\temp.dup goto DIR51
MERGE /o /1t /td:\temp\dir50.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir50 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR51
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir51
if not exist d:\temp\temp.dup goto DIR52
MERGE /o /1t /td:\temp\dir51.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir51 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR52
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir52
if not exist d:\temp\temp.dup goto DIR53
MERGE /o /1t /td:\temp\dir52.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir52 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR53
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir53
if not exist d:\temp\temp.dup goto DIR54
MERGE /o /1t /td:\temp\dir53.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir53 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR54
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir54
if not exist d:\temp\temp.dup goto DIR55
MERGE /o /1t /td:\temp\dir54.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir54 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR55
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir55
if not exist d:\temp\temp.dup goto DIR56
MERGE /o /1t /td:\temp\dir55.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir55 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR56
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir56
if not exist d:\temp\temp.dup goto DIR57
MERGE /o /1t /td:\temp\dir56.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir56 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR57
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir57
if not exist d:\temp\temp.dup goto DIR58
MERGE /o /1t /td:\temp\dir57.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir57 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR58
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir58
if not exist d:\temp\temp.dup goto DIR59
MERGE /o /1t /td:\temp\dir58.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir58 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR59
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir59
if not exist d:\temp\temp.dup goto DIR60
MERGE /o /1t /td:\temp\dir59.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir59 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR60
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir60
if not exist d:\temp\temp.dup goto DIR61
MERGE /o /1t /td:\temp\dir60.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir60 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:DIR61
MERGE /o /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\dir61
if not exist d:\temp\temp.dup goto END
MERGE /o /1t /td:\temp\dir61.dup+n /ld:\temp\dir_dupe.log d:\pcb\dirc\dir61 d:\temp\temp.dup
echo.
del d:\temp\temp.dup

:END
