/*** xyerror.c ***/

#include <windows.h>
#include <string.h>
#include "xyerror.h"
#include "errcodes.h"

char *ErrorText[16] = {
  "No error",
  "Already active",
  "Cannot open file",
  "File is empty",
  "Expected startup character (NAK,'C','G') not received",
  "Startup character was not NAK, 'C', or 'G'",
  "Disk read error",
  "Expected EOT character not received",
  "Internal error",
  "Cancelled by other end",
  "Out of sync",
  "Retry limit exceeded",
  "Bad packet number",
  "Timed out awaiting incoming character",
  "No such file",
  "Not active"};

void xyError(int Code,char *ErrorMsg)
{
 if((Code>=0)||(Code<UNKNOWN_ERROR)) strcpy(ErrorMsg,ErrorText[Code]);
 else strcpy(ErrorMsg,"Unknown error");
} /* end xyError */
