/*
     Library PMIO: A library for stdio/pcio on a PM screen
     Copyright (C) 1994  Colin Jensen
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     Contact addresses:
	Colin Jensen
	email: cjensen@netcom.com
	US mail: 4902 Esguerra Terrace, Fremont CA, 94555
*/
#ifndef include_pmio1_h
#define include_pmio1_h

#define MAXH 25
class TextView
{
  char text[80 * MAXH];
  char text_attr[80 * MAXH];
  void set_cell(int ax, int ay, char c)
    {
      int p = width () * (wymin+ay-1) + (wxmin+ax-1);
      text[p] = c;
      text_attr[p] = attr;
    }
  char dirty_flags[MAXH];
  char dirty_max[MAXH];
  char dirty_min[MAXH];
  int wxmin, wxmax, wymin, wymax;
  int x, y;
  char attr;
protected:
  /* Allow descendant classes to aid us in scrolling.  Without this aid,
     we will be forced to redraw the entire view on every scroll.
     This method tells the descendant how much to scroll.  If the
     descendant performs the required assistance, it should return 1. */
  virtual int physical_scroll (int count) { return 0; }
public:
  void set_window (int awxmin, int awymin, int awxmax, int awymax);
  char getdirt (int y, char *min = 0, char *max = 0);
  void dirty (int y, int min = 1, int max = 80);
  char *line(int row) { return text + row * 80; }
  char *attrs(int row) { return text_attr + row * 80; }
  int width() { return 80; }
  int height() { return MAXH; }
  int win_width () { return wxmax - wxmin + 1; }
  int win_height () { return wymax - wymin + 1; }
  void gotoxy(int ax, int ay)
    {
      if (1 <= ax && ax <= win_width()
	  && 1 <= ay && ay <= win_height())
	{
	  x = ax;
	  y = ay;
	}
    }
  int getx() { return y; }
  int gety() { return x; }
  void write(int count, const char *data)
    {
      dirty(y, x, x+count-1);
      while (count--)
	{
	  set_cell (x++, y, *data++);
	  if (x > win_width())
	    {
	      x = 1;
	      if (y < win_height ())
		y++;
	      else
		scroll (1);
	      dirty(y, 1, count);
	    }
	}
    }
  void write_tty (int count, const char *data)
    {
      while (count)
	{
	  if (*data == '\r')
	    {
	      cr ();
	      count--; data++;
	    }
	  else if (*data == '\n')
	    {
	      nl ();
	      count--; data++;
	    }
	  else 
	    {
	      int n;
	      for (n=1; n < count && data[n] != '\r' && data[n] != '\n'; n++)
		;
	      write (n, data);
	      count -= n;
	      data += n;
	    }
	}
    }
  void write_stdio (int count, const char *data);
  void scroll (int count);
  void clreol ()
    {
      int x2 = x;
      if (y <= height())
	while (x2 <= width())
	  set_cell (x2++, y, ' ');
      dirty(y, x, width());
    }
  void clrscr ();
  void textcolor (int color) { attr = (attr & 0xF0) | (color & 0x0F); }
  void textbackground (int color) { attr = (attr & 0x0F) | (color << 4); }
  void gettextinfo (struct text_info *);
  void settextinfo (const text_info *);
  void nl () { if (y < height ()) y++; else scroll (1); }
  void cr () { x = 1; }
  TextView();
};

#endif /* include_pmio1_h */

