/*
     Library PMIO: A library for stdio/pcio on a PM screen
     Copyright (C) 1994  Colin Jensen
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     Contact addresses:
	Colin Jensen
	email: cjensen@netcom.com
	US mail: 4902 Esguerra Terrace, Fremont CA, 94555
*/

#include "pmio1.h"
#include "pmio2.h"
#include "pmio.h"

#define MAXEVENTS 128

class MyWin: public TextView, StdWinPlus
{
    int char_width, char_height, char_descender;
    int client_height;
    int client_width;
    int client_char_height;
    int scroll_position;
    int max_scroll_position;
    HWND vscrollbar;
    TextView * const view;
    FontList font_list;
    int font_id;

    Event eventq[MAXEVENTS];
    int eventq_size;
    int eventq_head;
    int eventq_tail;

    virtual int physical_scroll (int count);

    void recalc_max_scroll_position(void)
    {
	max_scroll_position = view->height() - client_char_height;
	if (max_scroll_position < 0) max_scroll_position = 0;
	if (scroll_position > max_scroll_position) {
	    scroll_position = max_scroll_position;
	}
    }
    void recalc_scrollbar(void);
    void GetFontInfo();

    unsigned int delay_output;
    void flush_dirty_lines();

    IO_Interface * const interface;
    Frame frame_control;

public:
    virtual MRESULT MsgPaint(int *);
    virtual MRESULT MsgSize(SHORT, SHORT, SHORT, SHORT, int *);
    virtual MRESULT MsgCreate(PVOID, PCREATESTRUCT, int *);
    virtual MRESULT MsgVscroll(USHORT, SHORT, USHORT, int *);
    virtual MRESULT MsgPresParamChanged(MPARAM, MPARAM, int *);
    virtual MRESULT MsgChar(MPARAM, MPARAM, int *);
    virtual MRESULT MsgApp1(MPARAM, MPARAM, int *);
    void RefreshLine(int line, int min, int max);
    void Init(HAB);
    MyWin(IO_Interface *ainterface);
};
