/*
     Library PMIO: A library for stdio/pcio on a PM screen
     Copyright (C) 1994  Colin Jensen
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     Contact addresses:
	Colin Jensen
	email: cjensen@netcom.com
	US mail: 4902 Esguerra Terrace, Fremont CA, 94555
*/
#define INCL_DOSSEMAPHORES
#define INCL_WIN
#define INCL_DOSPROCESS
#include <os2.h>

#include "stdwin.h"
#include "font.h"
#include "frame.h"
#include "pmio3.h"
#include "pmio4.h"
#include "pmio6.h"

void main_io(long unsigned ainterface)
{
  IO_Interface *interface = (IO_Interface *) ainterface;
  HAB hab = WinInitialize (0);
  HMQ hmq = WinCreateMsgQueue (hab, 0);
  MyWin win (interface);
  win.Init (hab);
  QMSG qmsg;
  while (WinGetMsg (hab, &qmsg, 0, 0, 0))
    WinDispatchMsg (hab, &qmsg);
  win.Destroy();
  WinDestroyMsgQueue (hmq);
  WinTerminate (hab);
  // This wipes out the calling thread too
  // there should be a better way to deal with this
  // Ideally, we should raise SIGTERM on the calling thread
  DosExit (EXIT_PROCESS, 0);
}

class FakeObject
{
  TID tid;
  HAB hab;
  HMQ hmq;
public:
  FakeObject();
  ~FakeObject();
};

IO_Interface *interface = 0;

FakeObject::FakeObject()
{
  interface = new IO_Interface;
  DosCreateThread (&tid, main_io, (unsigned long) interface, 0, 1000000);
  interface->wait ();
  hab = WinInitialize (0);
  hmq = WinCreateMsgQueue (hab, 0);
  pmio_attach_stdio ();
}

FakeObject::~FakeObject()
{
  WinSendMsg (interface->window, WM_CLOSE, 0, 0);
  DosWaitThread (&tid, DCWW_WAIT);
  WinDestroyMsgQueue (hmq);
  WinTerminate (hab);
}

FakeObject fake_me;

