
/*
     Program PM-Info: a program for viewing GNU-style hypertext info
     documentation files.
     Copyright (C) 1992,1993,1994  Colin Jensen
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     Contact addresses:
	Colin Jensen
	email: cjensen@netcom.com
	US mail: 4902 Esguerra Terrace, Fremont CA, 94555
*/

class View
{
public:
    TextAttributes attr;
    virtual int length() = 0;
    virtual const char *line(int) = 0;
    virtual void append(const char *);
    virtual void append_allocated(char *) = 0;
    virtual ~View();
};

class SimpleView: public View
{
    int current_allocation;
    int current_length;
    char **view;
public:
    virtual int length();
    virtual const char *line(int);
    virtual void append_allocated(char *);
    void delete_trailing_blank_lines();
    SimpleView();
    virtual ~SimpleView();
};

class StaticView: public View
{
    const int view_length;
    const char **view;
    virtual void append_allocated(char *);
public:
    virtual int length();
    virtual const char *line(int);
    StaticView(int, const char **);
};
