#if !defined(__test_h)              // Sentry, use file only if it's not already included.
#define __test_h

/*  Project tooltest
    
    Copyright  1994. All Rights Reserved.

    SUBSYSTEM:    tooltest.exe Application
    FILE:         test.h
    AUTHOR:       


    OVERVIEW
    ========
    Class definition for TooltipApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include <owl\statusba.h>
#include <owl\controlb.h>
#include <owl\buttonga.h>
#include <owl\editfile.h>
#include <owl\opensave.h>

#include "test.rh"            	// Definition of all resources.

#include "tooltip.h"			// tooltip definition

//{{TApplication = TooltipApp}}
class TooltipApp : public TApplication
{
	TToolTip		tooltip;

private:
    TEditFile *Client;                                 // Client window for the frame.
    TOpenSaveDialog::TData FileData;                    // Data to control open/saveas standard dialog.

public:
    TooltipApp ();
    virtual ~TooltipApp ();

    void OpenFile (const char *fileName = 0);
//{{TooltipAppVIRTUAL_BEGIN}}
public:
    virtual void InitMainWindow();
//{{TooltipAppVIRTUAL_END}}

//{{TooltipAppRSP_TBL_BEGIN}}
protected:
    void CmFileNew ();
    void CmFileOpen ();
    void CmFileClose ();
    void CmHelpAbout ();
//{{TooltipAppRSP_TBL_END}}
  DECLARE_RESPONSE_TABLE(TooltipApp);
};    //{{TooltipApp}}


#endif                                      // __test_h sentry.
