/* WildFilt.H -- sample Callback filter functions */

/* presumes Wild.H has been previously included, as well as
 * dos.h */

/* ************************************** */

BOOL NormsOnly(ATTRIB Attrib)
/* TRUE if attribute describes a normal file -- not
 * Dir Vol Hid System, possibly Archive, possibly Readonly */
    {
    return (Wild_AttribPatternMatch("?0000?", /* ADVSHR */
      Attrib));
    }

/* ************************************** */

BOOL WriteablesOnly(ATTRIB Attrib)
/* TRUE if attribute describes a normal writeable file -- not
 * Dir Vol Hid System ReadOnly, possibly Archive */
    {
    return ( Wild_AttribPatternMatch("?00000", /* ADVSHR */
      Attrib));
    }

/* ************************************** */

BOOL WeirdFilesOnly(ATTRIB Attrib)
/* TRUE if attribute describes a weird file file -- not Dir Vol,
 * possibly Archive must be one or more of hidden, system or
 * read-only */
    {
    return ( Wild_AttribPatternMatch("?00+++", /* ADVSHR */
      Attrib));
    }

/* ************************************** */

BOOL HiddenFilesOnly(ATTRIB Attrib)
/* TRUE if attribute describes a hidden file. not Dir Vol,
 * system, possibly Archive, read-only must be hidden */
    {
    return ( Wild_AttribPatternMatch("?0001?", /* ADVSHR */
      Attrib));
    }

/* ************************************** */

BOOL ReadOnlyFilesOnly(ATTRIB Attrib)
/* TRUE if attribute describes a read-only file. not Dir Vol,
 * system, hidden, possibly Archive must be read-only */
    {
    return ( Wild_AttribPatternMatch("?00001", /* ADVSHR */
      Attrib));
    }

/* ************************************** */

BOOL DirsOnly(ATTRIB Attrib)
/* TRUE if attribute describes a directory entry not Vol,
 * system, hidden, possibly Archive must be Dir */

    { /* could do it the easy way:
       * return
       * Wild_AttribPatternMatch("?1000
       * 0", Attrib)); but for practice
       * we will do it directly the
       * hard way. */
    return ( (BOOL)( (Attrib & _A_SUBDIR) &&
      !(Attrib &
      (_A_RDONLY | _A_HIDDEN | _A_SYSTEM | _A_VOLID))));
    }

/* ************************************** */
/* -30- end wildfilt.h */
