/** WildSam3.C version 1.1 Sample Use of Wildcard Processor
 * used in form:   WildSam3  C:\*.C/S  D:\*.txt
 * prints files with positive and negative wildcards.
 * Dos print.exe must live in C:\DOS.  WATCH OUT! PRINT
 * is a TSR and must be loaded first.  Only prints *.txt files */

/* I N C L U D E S */

#include <stdlib.h>  /* toupper */
#include <stdio.h>   /* fopen fread  */
#include <string.h>  /* strcmp strcpy */
#include <process.h> /* spawn */
#include "wild.h"    /* Wildcard processing code */

/* ************************************** */

local void   ProcessWilds(WORD argc, char **argv)
/* process list of expanded wildcards This routine mimics the
 * way you would process individual filenames on the command
 * line in a mainline routine. You can do pretty well what you
 * like with the pointers and strings passed you.  You can
 * sort them. You can set some to null.  You can free the
 * pointers and or strings. */

    {
    WORD	     i, len;

    for (i = 0; i < argc; i++)
      {
      /* last minute filter out anything except *.txt files */
      /* in real life you would let a lot more through. */
      if ((len = strlen(argv[i]) > 4) &&
	strncmp(argv[i] + len - 4, ".TXT", 4)==0)
	{
	/* make DOS print do the work, simulate C:\DOS\PRINT.EXE X.TXT */
	(void) spawnl(_P_WAIT,	       /* mode */
	  "C:\\DOS\\PRINT.EXE", /* cmd */
	  "PRINT",		/* arg0, what user would have
				 * typed */
	  argv[i], NULL);	/* parm, one file at a
				 * time */
	printf("\n%s queued for printing", argv[i]);
	}
      else
	printf("\n%s ignored.  Only *.TXT files will be printed.", argv[i]);
      }

    Wild_Free();
    /* Free up the pointers and strings to the expanded
     * Wildcards */
    }

/* ************************************** */

local BOOL NormsOnly(ATTRIB Attrib)
/* TRUE if attribute describes a normal file -- not
 * Dir Vol Hid System, possibly Archive, possibly Readoly */
    {
    return (Wild_AttribPatternMatch("?0000?", /* ADVSHR */
      Attrib));
    }

/* ************************************** */

/* M A I N */

int   main(int argc, char **argv)

/* Ask Wild to process all parms but not 0, the progname.  We
 * give it two callback functions -- one to filter attribs and
 * one to process the wildcards. ProcessWilds is our user
 * routine that does all the work. The list of wildcards could
 * come from anywhere, not just argv. */
    {
    Wild(NormsOnly, ProcessWilds, (unsigned int) (argc - 1), argv + 1);
    return (0) /* DOS ERRORLEVEL */;
    }

/* ************************************** */

/* -30- */
