       PBBack 2.0  (c) 1990-1994  Thomas G. Hanlin III

Name  : AddMatI              (Add Matrix Integer)
Class : Array management
Level : Any

This routine adds an integer to as many elements of an integer
array as you like, starting at a specified place in the array.
It can also be used to subtract (just specify a negative
value).  If there was a numeric overflow at any point in the
operation, an error code will be returned.

   CALL AddMatI (DSeg%, DOfs%, Elements%, Value%, ErrCode%)

DSeg%      segment of the first array element to add
DOfs%      offset of the first array element to add
Elements%  number of array elements to which to add
Value%     value to add to each array element
-------
ErrCode%   error code: 0 if no error

Name  : AndSt                (AND String)
Class : String
Level : Any

This routine ANDs each byte in one string with the
corresponding byte in a second string.  The strings must be the
same length.

   CALL AndSt (St1$, St2$)

St1$      string to AND
St2$      string to AND with
-------
St1$      result

Name  : ArrayPtr             (Array Pointer)
Class : Array_Mgmt
Level : Any

This routine returns a pointer to an array, in the form of a
segment and offset.  It works only for STATIC arrays.  Since
the QB 4.x and QBX editor/environments only support DYNAMIC
arrays, it will not work in those environments.

String arrays are stored in an unusual format and must not be
used with this routine.  Numeric arrays of any type are fine.

This routine is typically used to pass an array to a PBBack
routine.

   CALL ArrayPtr (Array%(1), DSeg%, DOfs%)

Array%(1)   name of first array element
-------
DSeg%       segment of start of array
DOfs%       offset of start of array

Name  : Bickel               (Bickel comparison)
Class : String
Level : Any

A string comparison routine, Bickel allows you to see how
closely two strings match.  The better the match, the larger
the returned value will be.  Since there is no constant minimum
or maximum value, this routine is best used for applications
involving dictionary searches.  You would scan the dictionary
and make a list of the best matches.  This is appropriate for a
spelling checker, for instance.

   CALL Bickel (St1$, St2$, Result%)

St1$      first string to compare
St2$      second string to compare
-------
Result%   resulting "match magnitude" value

Name  : BigPrint             (Big Print)
Class : Display
Level : BIOS

As the name suggests, this routine displays text in large
characters.  How large?  Eight times as high and as wide as
normal!  Each "big character" will be composed of many
normal-sized characters.  You may choose the normal character
used to create the big characters (the default is a CHR$(219)
solid block character, if you pass a null string here).

You should avoid using CHR$(128) to CHR$(255) when in either of
the CGA graphics modes, as many CGAs are unable to display
these characters when in graphics mode.

   CALL BigPrint (St$, FormCh$, Row%, Column%, VAttr%)

St$       string to display in big characters
FormCh$   character used to compose the big characters
Row%      starting row
Column%   starting column
VAttr%    color/attribute of big characters (see CalcAttr)

Name  : BIOSInkey            (BIOS INKEY$)
Class : Input
Level : BIOS

BIOSInkey works like INKEY$, but it gets its key directly by
asking the BIOS. The primary advantage of this is that you get
the "scan" code as well as the ASCII code of the key.  The scan
code is independent of the shift status-- for instance, the
scan code for "A" is the same as the scan code for "a" or
Control-A or Alt-A.  This can be very handy.

If there is no key available, both the scan code and ASCII code
will be zero.

   CALL BIOSInkey (AscCode%, ScanCode%)

-------
AscCode%    ASCII code of the key, if any
ScanCode%   scan code of the key, if any

Name  : BkScroll             (Backward Scroll)
Class : Display
Level : BIOS

This routine scrolls any selected part of the display down-- it
does a backwards scroll.  You may scroll as many times as you
like, or scroll "zero" times to totally clear the selected part
of the display.

Note that BIOS-level scrolling can cause the screen to flicker
on some CGAs due to a combination of unfortunate design factors.

   CALL BkScroll (TopRow%, LeftCol%, BotRow%, RtCol%, Times%)

TopRow%    top row of the area to scroll
LeftCol%   left column of the area to scroll
BotRow%    top row of the area to scroll
RtCol%     left column of the area to scroll
Times%     number of times (or rows) to scroll

Name  : BkSpace              (Backspace)
Class : Display
Level : BIOS

Although CHR$(8) is supposed to mean "backspace", it shows up
as a graphics character when BASIC prints it.  This routine
does an actual backspace with full wrap-- if it's at the
beginning of the line, it will move back to the previous line
(if there is one).  It backspaces destructively (erasing the
previous character) from the current cursor position.  The new
cursor is returned to you, since QuickBASIC may ignore the new
status.

   CALL BkSpace (Row%, Column%)     ' do the backspace
   LOCATE Row%, Column%             ' inform QuickBASIC

-------
Row%      new row
Column%   new column

Name  : Blink                (Blink toggle)
Class : Display
Level : BIOS / Clone (see text)

It is possible to make characters in text mode blink by giving
them an appropriate "color".  I wouldn't mention something so
obvious but for another possibility which is less widely known:
blinking can be turned off, in which case the characters that
would have otherwise blinked will instead have a bright
background.  In other words, turn off blinking, and you double
the possible number of background colors.

This technique will always work with EGA and VGA displays.  It
can also be used with MDA/Hercules and CGA displays, on which
it will almost always work... unfortunately, on some
less-than-perfect PC clones, it will cause the computer to lock
up instead.  So, be careful with this one!

   CALL Blink (SetBlink%)

SetBlink%    use blink (-1) or intense backgrounds (0)

Name  : BlockMove            (Block memory Move)
Class : Memory
Level : Clone

This routine allows you to copy or "move" a block of data from
one memory location to another.  It isn't very bright, so if
the memory areas overlap, you will have to tell the routine to
"move backwards" instead of forwards. In that case, you will
also have to change the offsets to point to the ends of the
memory areas instead of the beginnings.

Normally, you can use forward moves.  In that case, the offsets
you specify are those of the beginning of the memory areas.  If
backward moves are required, the offsets specified are those of
the end of the memory areas.

If you are familiar with assembly language, you may recognize
this as a straightforward implementation of the "REP MOVSB"
instruction.

You may move up to 65,520 bytes at a time, provided that the
addresses are in normalized form (if you don't know what this
means, you probably don't need to worry about it).

This routine can be used to copy information to an array from
any area of memory (the BIOS data area, the screen, another
array, etc), or vice versa. It can also be used to do things
like insert/delete elements from an array, scroll the screen,
fill the screen with a specified character, and so on.

   CALL BlockMove (FromSeg%, FromOfs%, ToSeg%, ToOfs%, _
     Bytes%, Dirn%)

FromSeg%    segment of the area from which to copy
FromOfs%    offset of the area from which to copy
ToSeg%      segment of the area to which to copy
ToOfs%      offset of the area to which to copy
Bytes%      number of bytes to copy (0-32,767)
Dirn%       direction to copy (0 if forward, else backward)

Name  : BootDrive            (get Boot Drive)
Class : Disk
Level : DOS 4.0+

This routine tells you which drive was used to boot the
system.

One use for BootDrive would be in installation programs, to
determine the most likely destination drive for your software.

   Drive$ = "x"
   CALL BootDrive (Drive$)

-------
Drive$   boot drive-- set it to at least one char beforehand!

Name  : BRead                (Byte Read)
Class : Disk
Level : DOS

This routine reads a byte from a file into an integer.  The
byte is zero-extended into the integer, providing a value that
may range from 0-255.

The file must have been opened using FCreate or FOpen1.

   CALL BRead (Handle%, Value%, ErrCode%)

Handle%    file handle
-------
Value%     byte read from file
ErrCode%   DOS error code (0 if no error)

Name  : BSq                  (Blank Squeeze)
Class : String
Level : Any

A simple compression routine, BSq "squeezes" the blank spaces
in a string. It is designed expressly for use with text data.
The text may not contain more than 131 spaces in a row, or
CHR$(128) through CHR$(255), which are used in the compression.

Average text files are liable to be compressed by around 16%.
Files that contain more spaces, such as structured programs,
will benefit more.  The compression algorithm is simple but
extremely fast, adding no noticeable overhead to string
processing.

See also BUsq, BUsqLen.

   CALL BSq (St$, StLen%)
   St$ = LEFT$(St$, StLen%)

St$     string to compress
-------
St$     compressed string
StLen%  length of the compressed string

Name  : BUsq                 (Blank Unsqueeze)
Class : String
Level : Any

This routine is used to uncompress strings that were processed
by BSq. Before uncompression, the BUsqLen routine must be used
to find out how long the resulting string will be.

See also BSq, BUsqLen.

   CALL BUsqLen (St$, StLen%)
   IF StLen% < 0 THEN _
      PRINT "Error in compressed string" _
   ELSE _
      Result$ = SPACE$(StLen%): _
      BUsq St$, Result$

St$      string to uncompress
-------
Result$  uncompressed string

Name  : BUsqLen              (Blank Unsqueeze Length)
Class : String
Level : Any

This routine is used in coordination with BUsq to uncompress
strings that were processed by BSq.  It determines what the
length of the uncompressed string will be, which is necessary
to initialize the string for BUsq.

See also BSq, BUsq.

   CALL BUsqLen (St$, StLen%)
   IF StLen% < 0 THEN _
      PRINT "Error in compressed string" _
   ELSE _
      Result$ = SPACE$(StLen%): _
      BUsq St$, Result$

St$      string to uncompress
-------
StLen%   length of the uncompressed string

Name  : BWrite               (Byte Write)
Class : Disk
Level : DOS

This routine writes a byte to a file from an integer.  The
least significant byte of the integer is written.

The file must have been opened using FCreate or FOpen1.

   CALL BWrite (Handle%, Value%, ErrCode%)

Handle%    file handle
Value%     byte to write to file
-------
ErrCode%   DOS error code (0 if no error)

Name  : CalcAttr             (Calculate Attribute)
Class : Display
Level : Any

Many of the display routines in this library require an
"attribute" rather than foreground and background colors.  An
attribute is a combination of the foreground and background
colors in a format which is used by all types of displays when
in text mode.

Foreground colors are usually specified as 0-31, with
backgrounds as 0-7.  If you turn blinking off (see Blink), it
may be more convenient to express the same thing as foreground
0-15, background 0-15.  The CalcAttr routine will accept either
way of expressing it.

Note, however, that UnCalcAttr will always return the former
pair of results, since it has no way of knowing whether Blink
has been used (foreground 0-31, background 0-15).  See
UnCalcAttr for more details and a solution.

   CALL CalcAttr (Foreground%, Background%, VAttr%)

Foreground%  foreground color
Background%  background color
-------
VAttr%       color "attribute"

Name  : CalcSize             (Calculate array Size)
Class : Display
Level : Any

This routine calculates the necessary DIM size for an integer
array, assuming that you intend to store display data in the
array.  This is most useful in conjunction with DGetScreen and
GetScreen.

If your version of the BASIC compiler does not support dynamic
arrays, you will need to calculate the size in advance and
hard-code it into your program.

   CALL CalcSize (TopRow%, LftCol%, BotRow%, RtCol%, Elements%)
   DIM Array%(1 TO Elements%)

TopRow%     top row of the display area
LftCol%     left column of the display area
BotRow%     top row of the display area
RtCol%      left column of the display area
-------
Elements%   required size of the integer array

Name  : Carrier              (detect Carrier)
Class : Serial
Level : Clone

If you write communications programs, particularly things like
doors and BBSes, you probably want to keep an eye on the
carrier.  BASIC won't do it, but we will!

   CALL Carrier (CommPort%, CarrierHigh%)

CommPort%     serial port (1-4, though BASIC only handles 1-2)
-------
CarrierHigh%  zero if no carrier

Name  : CDROM                (check for CD-ROM)
Class : Disk / Equipment
Level : DOS

This routine tells you whether the Microsoft CD-ROM Extensions
are installed. If so, it tells you what the letter of the first
CD-ROM logical drive is and how many logical drives exist.

Note: The CD-ROM installation check conflicts with the
GRAPHICS.COM installation check for DOS 4.0, due to some
screw-up at IBM or Microsoft. This may cause unexpected
results.  I'm not yet sure whether DOS 5.0 is similarly
afflicted.

   FirstDrive$ = "x"
   CALL CDROM (FirstDrive$, Drives%)

-------
FirstDrive$   letter of first logical drive (init to >= 1 char)
Drives%       number of logical drives (0 if no CD-ROM)

Name  : CheckDisk            (Check Disk readiness)
Class : Disk
Level : DOS

The CheckDisk routine determines whether a disk is ready. About
the only thing it won't tell you is if a disk is write-
protected or out of space.  Since the PBBack disk routines all
contain critical error handling, which reports back an
appropriate error code for all such problems, this routine
isn't really needed any more.  It's included for compatibility
with older ProBas programs.

Results will normally be returned as one of the following,
although not all DOS versions report the exact cause of the
error, in which case the error number may not mean what you
expect.

   0   no error
   1   unformatted disk
   2   open drive door
   3   bad drive spec

   CALL CheckDisk (Drive$, ErrCode%)

Drive$    letter of the drive to check
-------
ErrCode%  0 if no error, nonzero for error (see above)

Name  : CheckKey             (Check for Key or mouse)
Class : Input, Mouse
Level : BIOS

This routine is kind of an extended version of INKEY$.  It
checks the keyboard to see if any key is available and gets the
key if it is.  At your option, it can also check the mouse to
see if a button has been pressed.

   CALL CheckKey (Mouse%, ASCIIcode%, ScanCode%, LButton%, _
      RButton%)

Mouse%        whether to check the mouse (0: no)
-------
ASCIIcode%    ASCII code of the key pressed
ScanCode%     scan code of the key pressed (0 if none)
LButton%      whether the left  mouse button was pressed
RButton%      whether the right mouse button was pressed

Name  : CheckKey3            (Check for Key or 3-button mouse)
Class : Input, Mouse
Level : BIOS

This routine is kind of an extended version of INKEY$.  It
checks the keyboard to see if any key is available and gets the
key if it is.  At your option, it can also check the mouse to
see if a button has been pressed.

   CALL CheckKey3 (Mouse%, ASCIIcode%, ScanCode%, LButton%, _
      MButton%, RButton%)

Mouse%        whether to check the mouse (0: no)
-------
ASCIIcode%    ASCII code of the key pressed
ScanCode%     scan code of the key pressed (0 if none)
LButton%      whether the left   mouse button was pressed
MButton%      whether the middle mouse button was pressed
RButton%      whether the right  mouse button was pressed

Name  : CheckShare           (Check for SHARE)
Class : Disk
Level : DOS

The CheckShare routine determines whether SHARE.EXE is active.
This is particularly helpful before using the BASIC OPEN
statement, which will fail if you request file sharing when
it's not available.  The PBBack file routines handle such
situations automatically, so CheckShare is not needed for them.

   CALL CheckShare (ShareActive%)

-------
ShareActive%   whether SHARE is active (0 if no)

Name  : Checksum             (calculate Checksum)
Class : String / Serial
Level : Any

The Checksum routine calculates a checksum on a string.  The
resulting number is compatible with Xmodem and Ymodem checksum
routines and will vary from 0-255.  This checksum provides a
minimal, but fast, check of what characters are contained in
the string.  See also CRC1.

   CALL Checksum (St$, ChkSum%)

St$       string to process
-------
ChkSum%   checksum of the characters in the string

Name  : Cipher               (Cipher)
Class : String
Level : Any

This is a very simple text encryption routine.  It isn't
particularly hard to crack, but will provide a basic level of
security for undemanding applications.  The same routine can be
used either to encrypt or decrypt text.  The original text may
contain any character; likewise, the resulting text.  This is
not well suited for use with sequential files-- if such is
required, see CipherP.

I'd suggest using a long password composed of an unlikely
string of characters, e.g. "#*@@!A^%x{.'".

   CALL Cipher (St$, Password$)

St$        string to encrypt or decrypt
Password$  password
-------
St$        encrypted or decrypted string

Name  : CipherP              (Cipher Printable)
Class : String
Level : Any

This is a very simple text encryption routine.  It isn't
particularly hard to crack, but will provide a basic level of
security for undemanding applications.  The same routine can be
used either to encrypt or decrypt text.  The original text may
contain any character below CHR$(128), as may the password.
The resulting text will be printable, if bizarre (all
characters will be above CHR$(127)), and may be used with
sequential files.

This routine is potentially less secure than the Cipher routine
(see).

I'd suggest using a long password composed of an unlikely
string of characters, e.g. "#*@@!A^%x{.'".

   CALL CipherP (St$, Password$)

St$        string to encrypt or decrypt
Password$  password
-------
St$        encrypted or decrypted string

Name  : Clock                (Clock)
Class : Display / Time
Level : Clone

This routine allows you to turn a visible time display on or
off.  When on, the time will be continuously displayed at a
selected location while your program continues processing.  The
clock is managed as a background process, in effect doing some
simple multitasking.

You should turn the clock off before you terminate your
program, including any time you execute another program with
RUN.  The clock can be safely kept on when you SHELL to another
program, however, as long as you can be sure that control will
return to your program when the other is done.

The clock must also be turned off if you change any of its
parameters with the ClockSet routine (see).

The clock will only be visible when the display is in text
mode.  The use of PLAY or SOUND statements may shut off the
clock, depending on your version of the BASIC compiler.

   CALL Clock (DisplayOn%)

DisplayOn%   whether to display the clock (0 if no)

Name  : ClockSet             (Clock Settings)
Class : Display / Time
Level : Clone

The ClockSet routine is used in conjunction with Clock (see).
It should only be used when the clock is turned off.

This routine allows you to set 12-hour or 24-hour time, whether
to display the seconds or not, how often to update the clock
display (in 1/18th seconds; 9 is usually the best choice),
where to display the clock and in what color, and whether to
use flicker-free displays (needed for cheap CGAs only).  The
defaults are 12-hour time, display seconds, put the time (in
white on black) in the upper right corner, and display quickly
(may flicker on some CGAs).

   CALL ClockSet (Hours24%, Seconds%, Updates%, Row%, _
      Column%, VAttr%, Fast%)

Hours24%   whether to display 24-hour time (0 if no)
Seconds%   whether to display seconds (0 if no)
Updates%   display update frequency in 1/18th seconds
Row%       row on which to display the clock
Col%       column at which to display the clock
VAttr%     color/attribute to use (see CalcAttr)
Fast%      whether to use fast mode (0 no)

Name  : ClrCols              (Clear Columns)
Class : Display
Level : BIOS

This routine clears the current row between the specified
columns, inclusive. It does not affect the cursor position.

   CALL ClrCols (StartCol%, EndCol%)

StartCol%  starting column
EndCol%    ending column

Name  : ClrEOL               (Clear to End Of Line)
Class : Display
Level : BIOS

This routine clears from the cursor to the end of the line,
inclusive.  It does not affect the current cursor position.

   CALL ClrEOL

Name  : ClrEOP               (Clear to End Of Page)
Class : Display
Level : BIOS

This routine clears from the cursor to the end of the display,
inclusive.  It does not affect the current cursor position.

   CALL ClrEOP

Name  : ClrKbd               (Clear Keyboard buffer)
Class : Input
Level : DOS

ClrKbd clears the keyboard buffer, discarding any keys that may
be waiting. This is a good idea for situations where an
unexpected input is made and you don't want to chance it being
answered accidentally by keys that were typed beforehand-- for
instance, in the event of an error or other condition where it
is important that the user see a message or take an action
before pressing a key.

   CALL ClrKbd

Name  : ClrSOL               (Clear to Start Of Line)
Class : Display
Level : BIOS

This routine clears from the start of the line to the cursor,
inclusive.  It does not affect the current cursor position.

   CALL ClrSOL

Name  : ClrSOP               (Clear to Start Of Page)
Class : Display
Level : BIOS

This routine clears from the start of the display to the
cursor, inclusive. It does not affect the current cursor
position.

   CALL ClrSOP

Name  : CopyFile             (Copy a File)
Class : Disk
Level : DOS

This works like the DOS COPY command, although it does not
allow wildcards. One file is copied to another, retaining the
same date and time.  Full path specifications are supported,
including drive and subdirectory specs.

   CALL CopyFile (FromFile$, ToFile$, ErrCode%)

FromFile$   name of file to copy
ToFile$     name of new file to create
-------
ErrCode%    0 if no error, else DOS Error

Name  : CPrintScreen1        (CGA Print Screen [SCREEN 1])
Class : Display / Printer
Level : Clone

This routine dumps a SCREEN 1 display (CGA 320x200) to the
printer.  It uses the stdprn device (normally PRN or LPT1) by
default, although this can be altered with the PrtSwap routine.

   CALL CPrintScreen1

Name  : CPrintScreen2        (CGA Print Screen [SCREEN 2])
Class : Display / Printer
Level : Clone

This routine dumps a SCREEN 2 display (CGA 640x200) to the
printer.  It uses the stdprn device (normally PRN or LPT1) by
default, although this can be altered with the PrtSwap routine.

   CALL CPrintScreen2

Name  : CRC                  (calculate CRC)
Class : String / Serial
Level : Any

This routine has become obsolete; the CRC1 routine is much
faster.  However, CRC is still included for backwards
compatibility.

This routine calculates a complex 16-bit checksum, called a
Cyclical Redundancy Check (or CRC) on a string.  The results
are compatible with Xmodem and Ymodem CRC routines.  The CRC
provides a fairly reliable check of what characters are
contained in the string.  See also Checksum.

If you are using this routine for Xmodem or Ymodem, note that
the string should be padded with two null characters before
calculating a "send" CRC: St$ = St$ + STRING$(2, 0).  On
receive, you should calculate the CRC on the entire data block,
plus the received CRC; if the block was received correctly, the
calculated CRC will be zero in both lsb and msb.

Although Intel notation uses "lsb, msb" order, the
Xmodem/Ymodem CRC uses the opposite format, which is why the
parameters are ordered in this fashion.

   CALL CRC (St$, CRCmsb%, CRClsb%)

St$       string to process
-------
CRCmsb%   most significant byte of CRC
CRClsb%   least significant byte of CRC

Name  : CRC1                 (calculate CRC)
Class : String / Serial
Level : Any

This routine calculates a complex 16-bit checksum, called a
Cyclical Redundancy Check (or CRC) on a string.  The results
are compatible with Xmodem and Ymodem CRC routines.  The CRC
provides a fairly reliable check of what characters are
contained in the string.  See also Checksum.

Note that CRC1 does not work like the older CRC routine.  You
should not pad outgoing strings with a STRING$(2, 0) sequence.

Although Intel notation uses "lsb, msb" order, the
Xmodem/Ymodem CRC uses the opposite format, which is why the
parameters are ordered in this fashion.

   CALL CRC1 (St$, CRCmsb%, CRClsb%)

St$       string to process
-------
CRCmsb%   most significant byte of CRC
CRClsb%   least significant byte of CRC

Name  : Crunch               (Crunch repeated characters)
Class : String
Level : Any

It was hard to decide on a name for this routine, and I don't
know if I've done the best job.  What Crunch does is to
eliminate repeated sequences of the same character.  For
instance, if you gave it "This    is a   test" and asked it to
crunch spaces, it would return "This is a test".  I use this to
filter information from the COMMAND$ function, but it's a good
general purpose input filter.

   CALL Crunch (St$, Ch$, StLen%)
   St$ = LEFT$(St$, StLen%)

St$       string to be processed
Ch$       character to crunch out of the string
-------
St$       crunched string
StLen%    length of the crunched string

Name  : CursorInfo           (Cursor Information)
Class : Input
Level : Clone

While BASIC allows you to set the size and shape of the cursor
with LOCATE, it's fairly hazardous to do so.  There is no way
to find out the maximum size of the cursor, so your cursor may
end up a peculiar shape on some adapters. If you change the
cursor size or visibility in a subprogram, you may be screwing
up the main program.

CursorInfo offers a solution to these problems.  It returns the
current cursor visibility and size, plus the maximum size
possible with the current video adapter.  The minimum size will
always be zero, so it is not reported.

   CALL CursorInfo (Visible%, StartLine%, EndLine%, MaxLine%)

-------
Visible%      whether the cursor is visible (0 no, 1 yes)
StartLine%    starting scan line of cursor
EndLine%      ending scan line of cursor
MaxLine%      maximum possible scan line for cursor

Name  : DataSeg              (Data Segment)
Class : Memory
Level : Any

It's rare that you need to know the data segment used by BASIC,
but it does happen.  DataSeg tells you that value.  This is the
segment used by (near) strings, static arrays (except in the
editor/environment, if any), some COMMON data, BASIC internal
variables and so forth.  It is also the area specified by a
plain "DEF SEG", though not (usually) by "DEF SEG=xxxx".

   CALL DataSeg (DSeg%)

-------
DSeg%     data segment for BASIC

Name  : Date2Int             (Date to Integer)
Class : Time
Level : Any

This routine compresses a date into a single integer.  Note
that this integer is not in a format that lends itself to
simple computation-- you cannot subtract one from another to
find out the length of time between them. However, as long as
the year is in the range 1980-2042, you can compare the two
integers to see if one date is before or after another.

You may express the year as either a two-digit or four-digit
number.

The ProBas and PBBack versions of this routine do not work the
same way in regards to the year.  ProBas assumed that any
two-digit year was in the 1900s.  In contrast, PBBack assumes
that years 80-99 should be converted to 1980-1999 and that 0-79
should be converted to 2000-2079.  I consider the PBBack method
more appropriate, with the turn of the century moving closer.
The date format used does not allow dates before 1980 anyway,
so nothing is being lost by this change.

   CALL Date2Int (MonthNr%, DayNr%, YearNr%, IntDate%)

MonthNr%     month number (1-12)
DayNr%       day (1-31)
YearNr%      year (1980-2079; see above for two-digit years)
-------
IntDate%     date compressed into an integer

Name  : DateN2S              (Date Numbers to String)
Class : Time
Level : Any / DOS

Many of the PBBack routines return the date as a set of
numbers.  This routine provides an easy way to convert those
numbers into string form.  The date format used (year length
and delimiter) will be based on the string which you pass to
the routine.  For instance, "xx-xx-xxxx" will return a date
like "11-26-1990", whereas "xx.xx.xxxx" would return
"11.26.1990", and "xx/xx/xx" would return "11/26/90".

If you pass zeroes for the MonthNr%, DayNr%, and YearNr%
values, the current date will be returned in the format that
you specified.

The ProBas and PBBack versions of this routine do not work the
same way in regards to the year.  ProBas assumed that any
two-digit year was in the 1900s.  In contrast, PBBack assumes
that years 80-99 should be converted to 1980-1999 and that 0-79
should be converted to 2000-2079.

   DateSt$ = "xx-xx-xxxx"
   CALL DateN2S (MonthNr%, DayNr%, YearNr%, DateSt$)

MonthNr%  month
DayNr%    day
YearNr%   year
-------
DateSt$   date string.  Init to 8 or 10 chars (see above).

Name  : DateS2N              (Date String to Numbers)
Class : Time
Level : Any

Many of the PBBack routines need to be passed the date as a set
of numbers. This routine provides an easy way to convert a date
from string form into numbers.  You may use either "xx/xx/xx"
or "xx-xx-xxxx" form to specify the date (the string length is
important, but the delimiter and contents of the string are
ignored).

The ProBas and PBBack versions of this routine do not work the
same way in regards to the year.  ProBas assumed that any
two-digit year was in the 1900s.  By contrast, PBBack assumes
that years 80-99 should be converted to 1980-1999 and that 0-79
should be converted to 2000-2079.

   CALL DateS2N (MonthNr%, DayNr%, YearNr%, DateSt$)

DateSt$   date string.  Init to 8 or 10 characters (see above).
-------
MonthNr%  month
DayNr%    day
YearNr%   year

Name  : DClear               (Direct-to-memory Clear)
Class : Display
Level : Any

The DClear routine allows you to clear a text-mode display.

This routine does not necessarily work on the display itself.
Instead, it allows you to specify the memory location (segment
and offset) of the "screen", which may be an actual screen, a
saved screen in an array, a multitasker's virtual screen, etc.
Among other things, this makes it easy to work with two
displays at once: use a segment of &HB000 for the mono display
and &HB800 for the color display (the offset in each case is
zero).

   CALL DClear (DSeg%, DOfs%, VAttr%)

DSeg%    segment of "screen" memory
DOfs%    offset of "screen" memory
VAttr%   color/attribute to use (see CalcAttr)

Name  : DClearSS             (Direct Clear for Specified Size)
Class : Display
Level : Any

Like the CLS statement, this routine allows you to clear a text
display. However, rather than clearing the actual screen,
DClearSS clears a screen that is stored in an array.  This
allows you to design a screen in memory, then flash it onto the
display using PutScreen or a similar routine.

This routine is designed for a text screen of any specified
size.

   CALL DClearSS (DSeg%, DOfs%, VAttr%, Rows%, Columns%)

DSeg%     segment of the array that holds the screen
DOfs%     offset of the array that holds the screen
VAttr%    color/attribute to use (see CalcAttr)
Rows%     length of the screen
Columns%  width of the screen

Name  : Dec2Any              (Decimal to Any base)
Class : Numeric
Level : Any

This routine converts a normal integer to a number in any
base.  It works like the HEX$ function in BASIC, but rather
than working only in hexadecimal (base 16), it can be used for
binary, octal, or almost anything else.

The result will be right-justified in the string you provide.
If you use zeroes, this allows you to ignore the NumberLen%
spec and just trim the string to the desired length, leaving
nothing worse than possible leading zeroes.

The length needed by the return string will vary according to
the number, with a maximum length depending on the number base
chosen.  For integers, this will be at most 16 characters
(worst case: base 2 or binary).

   Number$ = STRING$(16, "0")
   CALL Dec2Any (DecimalNr%, NrBase%, Number$, NumberLen%)
   Number$ = RIGHT$(Number$, NumberLen%)

DecimalNr   integer to convert to another base
NrBase%     desired number base (2-31)
-------
Number$     resulting number in desired base (init >= 16 chars)
NumberLen%  length of the result (-1 if string too short)

Name  : Delay                (Delay for seconds)
Class : Time
Level : Clone

This routine delays for a given number of seconds.  The timing
will be the same from an 8088 PC through an 80486 AT-- it's
entirely independent of the processor.  See also Delay18th.

   CALL Delay (Seconds%)

Seconds%   number of seconds for which to delay

Name  : Delay18th            (Delay for 1/18th seconds)
Class : Time
Level : Clone

This routine delays for a given number of 18ths of seconds.
The timing will be the same from an 8088 PC through an 80486
AT-- it's entirely independent of the processor.  See also
Delay.

   CALL Delay (WaitTime%)

WaitTime%  number of 18ths of seconds for which to delay

Name  : DelayV               (Delay based on Video timing)
Class : Time
Level : Clone

This routine delays for a given number of milliseconds.  The
timing is based on a signal from the video adapter and may vary
somewhat depending on the adapter.  The delay is largely
independent of the cpu type and speed, however.

For anyone unfamiliar with the metric system: there are 1000
milliseconds in one second.  Depending on the specific display
adapter, this routine may well be fairly inaccurate; it is
intended for providing small delays for animation and similar
purposes, not as a reliable timer.

   CALL DelayV (MilliSeconds%)

MilliSeconds%   number of milliseconds for which to delay

Name  : DelChr               (Delete Character)
Class : Display
Level : Clone

The DelChr routine deletes the character at the specified
screen location.

   CALL DelChr (Row%, Column%)

Row%      row of character
Column%   column of character

Name  : DelFile              (Delete File)
Class : Disk
Level : DOS

This works like the DOS DEL (or ERASE) command, although it
does not allow wildcards.  The specified file is deleted.  Full
path specifications are supported, including drive and
subdirectory specs.

   CALL DelFile (FileName$, ErrCode%)

FileName$   name of the file to delete
-------
ErrCode%    0 if no error, else DOS Error

Name  : DelLine              (Delete Line)
Class : Display
Level : BIOS

This routine deletes the specified row from the screen.

   CALL DelLine (Row%, VAttr%)

Row%      row to delete
VAttr%    color/attr to use on new bottom row (see CalcAttr)

Name  : DelSub               (Delete Subdirectory)
Class : Disk
Level : DOS

This works like the DOS RD (or RMDIR) command.  It does not
allow wildcards. The specified subdirectory is deleted.  Note
that you may not delete a subdirectory that you're located in,
or a subdirectory which contains files, or the root directory.

   CALL DelSub (SubDir$, ErrCode%)

SubDir$     name of the subdirectory to delete
-------
ErrCode%    0 if no error, else DOS Error

Name  : DFRead               (Direct-to-memory File Read)
Class : Disk
Level : DOS

This routine reads data into an array from a file that was
opened by FOpen1 or FCreate.  If it wasn't possible to read it
all from the file, an error code will be returned and the
BytesRead% value will tell you how many bytes were actually
read.

   CALL DFRead (Handle%, DSeg%, DOfs%, Bytes%, BytesRead%, _
      ErrCode%)

Handle%     handle of the file from which to read
DSeg%       segment of the array into which to read the file
DOfs%       offset of the array into which to read the file
Bytes%      number of bytes to read
-------
BytesWrit%  # of bytes actually read from the file (if error)
ErrCode%    error code: 0 if no error, else DOS Error

Name  : DFWrite              (Direct-from-memory File Write)
Class : Disk
Level : DOS

This routine writes data from an array to a file that was
opened by FOpen1 or FCreate.  If it wasn't possible to write it
all to the file, an error code will be returned and the
BytesWrit% value will tell you how many bytes were actually
written.

   CALL DFWrite (Handle%, DSeg%, DOfs%, Bytes%, BytesWrit%, _
      ErrCode%)

Handle%     handle of the file to which to write
DSeg%       segment of the data to write to the file
DOfs%       offset of the data to write to the file
Bytes%      number of bytes to write
-------
BytesWrit%  # of bytes actually written to the file (if error)
ErrCode%    error code: 0 if no error, else DOS Error

Name  : DGClear              (Direct-to-memory Graphics Clear)
Class : Display
Level : Any

This routine works like the CLS statement, clearing a CGA
graphics display. However, rather than clearing the actual
screen, DClearSS clears a screen that is stored in an array.
This allows you to design a screen in memory, then flash it
onto the display using GrafRest.

This routine is designed for use with SCREEN 1 or SCREEN 2 (CGA
graphics).

   CALL DGClear (DSeg%, DOfs%, Colour%)

DSeg%     segment of the array that holds the screen
DOfs%     offset of the array that holds the screen
Colour%   color to use

Name  : DGetRec              (Direct-from-memory Get Record)
Class : String
Level : Clone

The DGetRec routine allows you to get a string from a specified
area of memory (numeric array, BIOS data area, display memory,
or whatever).  The string should be initialized to the desired
record length in advance.

This works somewhat like an array of fixed length strings or a
random file, treating memory as a contiguous series of records
of a specified length.

   CALL DGetRec (DSeg%, DOfs%, RecNr%, St$)

DSeg%      segment of the array to read from
DOfs%      offset of the array to read from
RecNr%     record number (starting at 1)
-------
St$        returned string.  Init to record length (see above).

Name  : DGetScreen           (Direct memory Get Screen image)
Class : Display
Level : Clone

This routine saves any portion of the display to an array.
Only text modes are supported.  If your program uses multiple
display pages, you can get an image from any of those pages.  A
special "slow" mode is supported for the CGA, to prevent
flickering (a problem only with some CGAs).

The size of the integer array needed to store a specific area
of the screen can be calculated using the CalcSize routine
(see).

The GetScreen routine works the same way as this, but has a
simpler calling convention.  Also, if you wish to save the
entire screen, you may find ScrSave easier.

   CALL DGetScreen (DSeg%, DOfs%, TRow%, LCol%, BRow%, RCol%, _
      Page%, Fast%)

DSeg%      segment of the array in which to store the image
DOfs%      offset of the array in which to store the image
TRow%      top row of the desired screen area
LCol%      left column of the desired screen area
BRow%      bottom row of the desired screen area
RCol%      right column of the desired screen area
Page%      page from which to get the display area
Fast%      whether to use fast mode (0 no)

Name  : DGQPrint             (Direct Graphics Quick Print)
Class : Display
Level : Any

This is a simple high-speed replacement for the PRINT statement
which works on a CGA virtual graphics screen (SCREEN 2).  It
does not interpret control codes or support graphics characters
(ASCII 128-255).

DGQPrint allows you to display to a CGA even if it isn't the
active display (use a segment of &HB800 and offset of 0).  Its
intended use, however, is to display to a virtual screen kept
in an array or other memory area.  The results can then be
displayed using GrafRest.

   CALL DGQPrint (DSeg%, DOfs%, St$, Row%, Column%)

DSeg%    segment of CGA virtual screen
DOfs%    offset of CGA virtual screen
St$      string to display
Row%     row (1-25)
Column%  column (1-80)

Name  : DGXQPrint            (Direct Graphics Extended Q Print)
Class : Display
Level : Any

This is a simple high-speed replacement for the PRINT statement
which works on a CGA virtual graphics screen (SCREEN 1).  It
does not interpret control codes or support graphics characters
(ASCII 128-255).

This routine can also be used on a SCREEN 2 display, where it
will display the string in shades instead of in color (using 40
columns/row).

DGXQPrint allows you to display to a CGA even if it isn't the
active display (use a segment of &HB800 and offset of 0).  Its
intended use, however, is to display to a virtual screen kept
in an array or other memory area.  The results can then be
displayed using GrafRest.

   CALL DGXQPrint (DSeg%, DOfs%, St$, Row%, Column%, Fore%)

DSeg%    segment of CGA virtual screen
DOfs%    offset of CGA virtual screen
St$      string to display
Row%     row (1-25)
Column%  column (1-40)
Fore%    foreground color (0-3)

Name  : DGXQPrint1           (Direct Graphics Extended Q Print)
Class : Display
Level : Any

This is a high-speed replacement for the PRINT statement which
works on a CGA virtual graphics screen (SCREEN 1). It does not
interpret control codes.

This routine can also be used on a SCREEN 2 display, where it
will display the string in shades instead of in color (using 40
columns/row).

DGXQPrint1 allows you to display to a CGA even if it isn't the
active display (use a segment of &HB800 and offset of 0).  Its
intended use, however, is to display to a virtual screen kept
in an array or other memory area.  The results can then be
displayed using GrafRest.

   CALL DGXQPrint1 (DSeg%, DOfs%, St$, Row%, Column%, _
      Fore%, Back%)

DSeg%    segment of CGA virtual screen
DOfs%    offset of CGA virtual screen
St$      string to display
Row%     row (1-25)
Column%  column (1-40)
Fore%    foreground color (0-3)
Back%    background color (0-3)

Name  : Dissolve             (Dissolve)
Class : Display
Level : Clone

Like CLS, but a bit more fancy, this routine provides an
interesting way to clear the screen.  See also FadeOut.

This routine may cause heavy flickering on some CGA displays.

   CALL Dissolve (VAttr%)

VAttr%   color/attribute to which to clear (see CalcAttr)

Name  : DMPrint              (DOS Message Print)
Class : Display
Level : DOS

This routine is similar to PRINT, but goes through DOS output
services, which allows your program to support output
redirection, filters, CTTY and other handy things.  See
DOSInkey for a DOS input service.

Note that the use of DMPrint means that you should avoid using
BASIC display handling (CLS, INPUT, LINE INPUT, PRINT, LOCATE,
CSRLIN, POS, etc).  Instead, you should use ANSI escape
sequences to control the display.  This requires that an ANSI
driver (like ANSI.SYS, DVANSI.SYS, NANSI.SYS, or ZANSI.SYS) be
installed on your system.  See your DOS manual for details on
ANSI sequences, or grab the documentation on ANSI from one of
your friendly local BBSes.

It is -possible- to use BASIC display handling in conjunction
with DMPrint, but that tends to defeat the purpose of using
DMPrint in the first place.

Note that the DMPrint routine does not add a carriage
return/linefeed to the end of a string.  If you want that, add
CHR$(13) + CHR$(10) to the end of the string.

   CALL DMPrint (St$)

St$    string to display

Name  : DOSClrEol            (DOS Clear to End Of Line)
Class : Display
Level : DOS

This routine clears from the cursor position to the end of the
row using DOS output functions.  It requires that ANSI.SYS or
another ANSI driver be installed.

   CALL DOSClrEol

Name  : DOSCls               (DOS Clear Screen)
Class : Display
Level : DOS

This routine clears the screen using DOS output functions.  It
requires that ANSI.SYS or another ANSI driver be installed.

   CALL DOSCls

Name  : DOSColor             (DOS Color)
Class : Display
Level : DOS

This routine sets the screen colors using DOS output
functions.  It requires that ANSI.SYS or another ANSI driver be
installed.

   CALL DOSColor (Fore%, Back%)

Fore%    foreground color
Back%    background color

Name  : DOSInkey             (DOS INKEY$)
Class : Input
Level : DOS

This routine is similar to INKEY$, but goes through DOS input
services, which allows your program to support input
redirection, filters, CTTY and other handy things.  See DMPrint
for a DOS output service.  See also DOSInky$.

   CALL DOSInkey (CharCode%, CharType%)

-------
CharType%    0 if no key, 1 if normal key, 2 if extended key
CharCode%    ASCII code if normal key, scan code if extended key

Name  : DOSLocate            (DOS Locate)
Class : Display
Level : DOS

This routine sets the cursor position using DOS output
functions.  It requires that ANSI.SYS or another ANSI driver be
installed.

Note that many ANSI drivers do not fully support EGA or VGA
modes in that they are limited to a maximum of 25 rows.

   CALL DOSLocate (Row%, Column%)

Row%      row
Column%   column

Name  : DPutRec              (Direct-to-memory Put Record)
Class : String
Level : Clone

The DPutRec routine allows you to put a string into a specified
area of memory (numeric array, BIOS data area, display memory,
or whatever).  The string should be initialized to the desired
record length in advance.

This works somewhat like an array of fixed length strings or a
random file, treating memory as a contiguous series of records
of a specified length.

   CALL DPutRec (DSeg%, DOfs%, RecNr%, St$)

DSeg%      segment of the array to write into
DOfs%      offset of the array to write into
RecNr%     record number (starting at 1)
St$        string to write.  Init to record length (see above).

Name  : DPutScreen           (Direct-from-memory Put Screen)
Class : Display
Level : Clone

This routine restores a portion of the display (which was saved
to an array by DGetScreen or GetScreen) to the screen.  Only
text modes are supported. If your program uses multiple display
pages, you can put the image onto any of those pages.  A
special "slow" mode is supported for the CGA, to prevent
flickering (a problem only with some CGAs).

The PutScreen routine works the same way as this, but has a
simpler calling convention.  Also, if you wish to restore the
entire screen, you may find ScrRest easier (see).

   CALL DPutScreen (DSeg%, DOfs%, TRow%, LCol%, BRow%, RCol%, _
      Page%, Fast%)

DSeg%      segment of the array from which to restore the image
DOfs%      offset of the array from which to restore the image
TRow%      top row of the desired screen area
LCol%      left column of the desired screen area
BRow%      bottom row of the desired screen area
RCol%      right column of the desired screen area
Page%      page on which to restore the display
Fast%      whether to use fast mode (0 no)

Name  : DRecDel              (Direct-to-memory Record Deletion)
Class : Array management
Level : Any

This routine allows you to delete an item from an array.  The
item may consist of one or more array elements.  The size of
the array isn't actually changed, but the array elements are
moved as if a deletion took place.

   CALL DRecDel (DSeg%, DOfs%, RecNr%, RecLen%, Records%)

DSeg%      segment of the array
DOfs%      offset of the array
RecNr%     record/element number (starting at 1)
RecLen%    record/element length in bytes
Records%   total number of records/elements in the array

Name  : DRecIns              (Direct-to-mem Record Insertion)
Class : Array management
Level : Any

This routine allows you to insert an item into an array.  The
item may consist of one or more array elements.  The size of
the array isn't actually changed, but the array elements are
moved as if an insertion took place.  You must of course make
sure that the array is DIMed large enough to handle this.

   CALL DRecIns (DSeg%, DOfs%, RecNr%, RecLen%, Records%)

DSeg%      segment of the array
DOfs%      offset of the array
RecNr%     record/element number (starting at 1)
RecLen%    record/element length in bytes
Records%   total number of records/elements in the array

Name  : DRecolor             (Direct-to-memory Recolor)
Class : Display
Level : Any

The DRecolor routine changes all text in one color to another
color.  It works only in text modes.  The colors are specified
as attributes (see CalcAttr).

This routine does not necessarily work on the display itself.
Instead, it allows you to specify the memory location (segment
and offset) of the "screen", which may be an actual screen, a
saved screen in an array, a multitasker's virtual screen, etc.
Among other things, this makes it easy to work with two
displays at once: use a segment of &HB000 for the mono display
and &HB800 for the color display (the offset in each case is
zero).

   CALL DRecolor (DSeg%, DOfs%, OldAttr%, NewAttr%)

DSeg%      segment of "screen" memory
DOfs%      offset of "screen" memory
OldAttr%   color to be changed
NewAttr%   color to which to change

Name  : DRecolorArea         (Direct-to-memory Recolor Area)
Class : Display
Level : Clone

The DRecolorArea routine changes a specified area of the screen
to a specified color.  It works only in text modes.  The color
is specified as an attribute (see CalcAttr).

One of the more common applications for this routine is marking
an area of the screen, e.g. menu highlight bars.

   CALL DRecolorArea (DSeg%, DOfs%, TRow%, LCol%, BRow%, _
      RCol%, VAttr%)

This routine does not necessarily work on the display itself.
Instead, it allows you to specify the memory location (segment
and offset) of the "screen", which may be an actual screen, a
saved screen in an array, a multitasker's virtual screen, etc.
Among other things, this makes it easy to work with two
displays at once: use a segment of &HB000 for the mono display
and &HB800 for the color display (the offset in each case is
zero).

DSeg%       segment of "screen" memory
DOfs%       offset of "screen" memory
TRow%       top row of area to recolor
LCol%       left column of area to recolor
BRow%       bottom row of area to recolor
RCol%       right column of area to recolor
VAttr%      desired color

Name  : DrvType              (Drive Type)
Class : Disk
Level : DOS 3.1+

The DrvType routine tells you whether a specified drive is
fixed or removeable, and whether it is local or remote (network
drive).

   CALL DrvType (Drive$, Removeable%, Remote%, ErrCode%)

Drive$       letter of the drive to examine
-------
Removeable%  whether the disk can be removed (0 if no)
Remote%      whether this is a remote drive (0 if no)
ErrCode%     error code: 0 if none, else bad DOS version

Name  : DScrRest             (Direct-from-mem Screen Restore)
Class : Display
Level : Clone

The DScrRest routine restores a display that was saved using
ScrSave or a similar routine.  It only works in text modes.
See also ScrRest.

   CALL DScrRest (DSeg%, DOfs%, Page%, Fast%)

DSeg%      segment of info to restore to the screen
DOfs%      offset of info to restore to the screen
Page%      page on which to restore the display
Fast%      whether to use fast mode (0 no)

Name  : DScrSave             (Direct-from-memory Screen Save)
Class : Display
Level : Clone

The DScrSave routine saves the display to an array or other
storage area. Only text modes are supported.  For an 80x25
display, the array must hold 4,000 bytes (4,000 string
characters or 2,000 integers).  See also ScrSave.

   CALL DScrSave (DSeg%, DOfs%, Page%, Fast%)

DSeg%      segment of place to store the display
DOfs%      offset of place to store the display
Page%      page from which to get the display
Fast%      whether to use fast mode (0 no)

Name  : DTR                  (Data Terminal Ready signal)
Class : Serial
Level : Clone

Just as IBM provided the standard for personal computers, Hayes
provided the standard for modem commands.  Unfortunately, the
command method of dropping carrier (hanging up the phone) was
badly designed, and all Hayes-compatible modems have a hard
time recognizing that command under certain line conditions.

Fortunately, there's a more reliable way of hanging up: the DTR
serial signal.  Turning this signal off will cause the modem to
hang up very quickly.  Most Hayes-compatible modems are
factory-set to pay attention to the DTR; those that aren't can
be made to do so either by flipping a hardware switch or with a
special initialization command.  See your modem manual for
details.

BASIC will drop the DTR when you CLOSE the comm port, but this
isn't always a convenient way to do it.  As a matter of fact,
this can be a decided nuisance, so many people have patched
their version of BASIC to avoid it.  If you would like to do
so, check your local BBS for the method!  With the PBBack DTR
routine, you can get full control over the DTR without having
to CLOSE the comm port.

Note: it may be wise to include a brief delay after dropping
the DTR, to give the modem a chance to react.  Try Delay18th
with a wait of around 4.

   CALL DTR (CommPort%, TurnOn%)

CommPort%    serial port (1-4, though BASIC only handles 1-2)
TurnOn%      whether to raise (turn on) the DTR (0 if no)

Name  : DXQPrint             (Direct Extended Quick Print)
Class : Display
Level : Any

This routine provides a rather crude, but very fast, display
capability.  It works like the PRINT statement in BASIC, except
that it doesn't move the cursor or process control codes.  It
works only in text modes.

This routine does not necessarily work on the display itself.
Instead, it allows you to specify the memory location (segment
and offset) of the "screen", which may be an actual screen, a
saved screen in an array, a multitasker's virtual screen, etc.
Among other things, this makes it easy to work with two
displays at once: use a segment of &HB000 for the mono display
and &HB800 for the color display (the offset in each case is
zero).

   CALL DXQPrint (DSeg%, DOfs%, St$, Row%, Column%, VAttr%)

DSeg%     segment of "screen" memory
DOfs%     offset of "screen" memory
St$       string to display
Row%      starting row
Column%   starting column
VAttr%    color/attribute (see CalcAttr)

Name  : EGARest7             (EGA Restore for SCREEN 7)
Class : Display
Level : Clone

This routine allows you to restore a SCREEN 7 (EGA, 320x200, 16
color) display that was saved using EGASave7.

   CALL EGARest7 (DSeg%, DOfs%)

DSeg%        segment of storage array
DOfs%        offset  of storage array

Name  : EGARest8             (EGA Restore for SCREEN 8)
Class : Display
Level : Clone

This routine allows you to restore a SCREEN 8 (EGA, 640x200, 16
color) display that was saved using EGASave8.

   CALL EGARest8 (DSeg%, DOfs%)

DSeg%        segment of storage array
DOfs%        offset  of storage array

Name  : EGARest9             (EGA Restore for SCREEN 9)
Class : Display
Level : Clone

This routine allows you to restore a SCREEN 9 (EGA, 640x350, 16
color) display that was saved using EGASave9.

   CALL EGARest9 (DSeg1%, DOfs1%, DSeg2%, DOfs2%)

DSeg1%       segment of storage array #1
DOfs1%       offset  of storage array #1
DSeg2%       segment of storage array #2
DOfs2%       offset  of storage array #2

Name  : EGASave7             (EGA Save for SCREEN 7)
Class : Display
Level : Clone

This routine allows you to save a SCREEN 7 (EGA, 320x200, 16
color) display that can be restored using EGARest7.

The array used to hold the screen must contain 32,000 bytes.
For an integer array, this means that you must create the array
by DIM Array%(1 TO 16000).

   CALL EGASave7 (DSeg%, DOfs%)

DSeg%        segment of storage array
DOfs%        offset  of storage array

Name  : EGASave8             (EGA Save for SCREEN 8)
Class : Display
Level : Clone

This routine allows you to save a SCREEN 8 (EGA, 640x200, 16
color) display that can be restored using EGARest8.

The array used to hold the screen must contain 64,000 bytes.
For an integer array, this means that you must create the array
by DIM Array%(1 TO 32000).

   CALL EGASave8 (DSeg%, DOfs%)

DSeg%        segment of storage array
DOfs%        offset  of storage array

Name  : EGASave9             (EGA Save for SCREEN 9)
Class : Display
Level : Clone

This routine allows you to save a SCREEN 9 (EGA, 640x350, 16
color) display that can be restored using EGARest9.

Two arrays must be used to hold the screen, for a total of
112,000 bytes.  If you use integer arrays, each array must be
created by DIM Array%(1 TO 28000).

   CALL EGASave9 (DSeg%, DOfs%)

DSeg1%       segment of storage array #1
DOfs1%       offset  of storage array #1
DSeg2%       segment of storage array #2
DOfs2%       offset  of storage array #2

Name  : EMSBuffer            (EMS Buffer size)
Class : Memory
Level : BIOS

EMSBuffer tells you how many bytes are needed to save the state
of the EMS array routines.  Used in conjunction with EMSSave
and EMSRest, it allows you to preserve EMS arrays across a
CHAIN to another part of your program.

   CALL EMSBuffer (Bytes%)
   EMSState$ = SPACE$(Bytes%)
   CALL EMSSave (EMSState$)

-------
Bytes%       bytes needed to save EMS array state

Name  : EMSClose             (EMS Close)
Class : Memory
Level : BIOS

The EMSClose routine is used when you are finished with an EMS
array.  It frees the array handle and EMS memory for other
uses.  If you don't close all EMS arrays before your program
ends, the memory will be lost until the system is rebooted, so
it is important to remember EMSClose.

   CALL EMSClose (ArrayHandle%)

ArrayHandle%    handle of an EMS array

Name  : EMSGet               (EMS Get)
Class : Memory
Level : BIOS

This routine gets an element from an EMS array created by
EMSOpen.  Element numbers start at 0.  Be sure to use the right
numeric type for the array-- for instance, if you opened the
array for SINGLE precision, use "Value!".

   CALL EMSGet (ArrayHandle%, ElementNr%, Value

ArrayHandle%    handle of an EMS array
ElementNr%      element number to get
-------
Value           result (must be correct type for array)

Name  : EMSOpen              (EMS Open)
Class : Memory
Level : BIOS

This routine allows you to open a block of EMS (expanded)
memory which can then be accessed like a numeric array.  The
array size is limited only by available EMS memory (use GetLIMM
to find out how much is available).  You may specify any
numeric type:

    1   INTEGER
    2   SINGLE
    3   DOUBLE

When the array is opened, you are returned an "array handle"
which is used to access that array.  Access to the array is
done via EMSGet and EMSPut.  When you are finished with the
array, you must close it with EMSClose.

As many as 25 EMS arrays can be in use at one time, subject to
limitations which may be imposed by your EMS driver (each array
requires one EMS handle).

   CALL EMSOpen (Elements, ElementType%, ArrayHandle%, _
      ErrCode%)

Elements%       number of elements in array (like DIM size)
ElementType%    numeric type of array (see above)
-------
ArrayHandle%    handle of an EMS array
ErrCode%        whether an error occurred (0 no)

Name  : EMSPut               (EMS Put)
Class : Memory
Level : BIOS

This routine puts an element into an EMS array created by
EMSOpen.  Element numbers start at 0.  Be sure to use the right
numeric type for the array-- for instance, if you opened the
array for SINGLE precision, use "Value!".

   CALL EMSPut (ArrayHandle%, ElementNr%, Value)

ArrayHandle%    handle of an EMS array
ElementNr%      element number to set
Value           value to store (must be correct type for array)

Name  : EMSRest              (EMS Restore state)
Class : Memory
Level : BIOS

This routine allows you to restore the state of the EMS array
handler.  Used in conjunction with EMSBuffer and EMSSave, it
allows you to preserve EMS arrays across a CHAIN to another
part of your program.

   CALL EMSRest (EMSState$)

EMSState$    saved EMS array state

Name  : EMSSave              (EMS Save state)
Class : Memory
Level : BIOS

This routine allows you to save the state of the EMS array
handler.  Used in conjunction with EMSBuffer and EMSRest, it
allows you to preserve EMS arrays across a CHAIN to another
part of your program.

   CALL EMSBuffer (Bytes%)
   EMSState$ = SPACE$(Bytes%)
   CALL EMSSave (EMSState$)

-------
EMSState$    saved EMS array state

Name  : EnhKbd               (Enhanced Keyboard)
Class : Input
Level : BIOS

By default, the PBBack routines assume an old-style keyboard is
in use, for greatest compatibility.  EnhKbd allows you to turn
on enhanced keyboard handling for the current generation of
(usually) 101-key keyboards.  This allows access to the F11 and
F12 function keys as well as codes for key combinations that
used to be ignored, among other things.

The KbdType or KbdType2% routine can be used to determine if an
enhanced keyboard is available (recommended).

Note that EnhKbd works by intercepting the BIOS keyboard
handler.  All calls to the BIOS keyboard interrupt are
converted from the old keyboard functions to the new ones.  YOU
MUST DISABLE EnhKbd BEFORE YOUR PROGRAM ENDS, so it can restore
the old setup.  Otherwise, the computer will most probably
crash.

A list of the new key codes is given in PBBACK.DOC.

   CALL EnhKbd (Enable%)

Enable%     turn on enhanced keyboard support (0 disable)

Name  : Equipment            (Equipment information)
Class : Equipment
Level : BIOS

This routine gives you some information about the basic
equipment in your computer.  Note that the "game port"
information is not reliable, due to changes in the meaning of
this particular area of the BIOS over many years.

   CALL Equipment (Memory%, Parallel%, Serial%, Game%)

-------
Memory%    kilobytes of conventional memory installed (16 - 640)
Parallel%  parallel (printer) ports installed (0-4)
Serial%    serial (communications) ports installed (0-4)
Game%      game (joystick) ports installed (0-1).  See remarks, above.

Name  : Exist                (file Existence)
Class : Disk
Level : DOS

Most versions of BASIC give you no way of seeing if a file
exists before you try to OPEN it, so you end up taking your
chances.  The Exist routine allows you to test to see if the
file exists beforehand.  It isn't really necessary for the
PBBack file routines, which will return an appropriate error
code, but it's an important safeguard when using the BASIC OPEN
statement.

The Exist routine does not support wildcards.  If you need that
feature, try the FindFirstF and FindNextF routines instead.

   CALL Exist (FileName$, Found%)

FileName$   name of the file to look for
-------
Found%      whether the file was found (0 if no)

Name  : EXQPrintC            (EGA Extended Quick Print, Char)
Class : Display
Level : Clone

This routine provides a rather crude, but very fast, display
capability.  It works like the PRINT statement in BASIC, except
that it doesn't move the cursor or process control codes.  It
works in EGA and VGA graphics modes (SCREEN 7 through SCREEN
12).  Note that you can control both foreground and background
colors, unlike BASIC.

   CALL EXQPrintC (St$, Row%, Column%, Fore%, Back%)

St$       string to display
Row%      starting row
Column%   starting column
Fore%     foreground color
Back%     background color

Name  : ExtMem               (Extended Memory)
Class : Memory / Equipment
Level : BIOS (AT)

This routine allows you to find out how much extended memory is
available. It should only be used on AT-class computers, since
older PCs do not support extended memory.

The amount of memory returned may be either the total amount of
extended memory installed or just the amount available at this
time, depending on how previously-installed programs (if any)
make use of extended memory. Unfortunately, there is no
standard which defines how a program should use extended memory
as there is with EMS (expanded memory), so there is no way for
a program to determine whether or how another program is using
extended memory.  Microsoft is trying to clear up this
situation with its HIMEM driver (available at your local BBS,
or [last I looked] free from Microsoft), but this approach
hasn't really become standard yet.

   CALL ExtMem (KBytes%)

-------
KBytes%     the number of kilobytes of extended memory

Name  : FadeOut              (Fade Out)
Class : Display
Level : Clone

Like CLS, but a bit more fancy, this routine provides an
interesting way to clear the screen.  See also Dissolve.

   CALL FadeOut (VAttr%)

VAttr%   color/attribute to which to clear (see CalcAttr)

Name  : FarPoke              (Far memory Poke)
Class : Memory
Level : Clone

This is like the BASIC POKE statement, but expects both a
segment and an offset, thus doing away with the need for DEF
SEG.  This is especially handy for use in subprograms which
might otherwise inadvertently change the DEF SEG value expected
by the main program.

   CALL FarPoke (DSeg%, DOfs%, Value%)

DSeg%    segment of the location to look at
DOfs%    offset of the location to look at
Value%   value to store in the given memory posn (byte: 0-255)

Name  : FarPokeI             (Far memory Poke Integer)
Class : Memory
Level : Clone

This is like the BASIC POKE statement, but expects both a
segment and an offset, thus doing away with the need for DEF
SEG.  This is especially handy for use in subprograms which
might otherwise inadvertently change the DEF SEG value expected
by the main program.  Unlike POKE, this routine stores a word
or integer.

   CALL FarPokeI (DSeg%, DOfs%, Value%)

DSeg%    segment of the location to look at
DOfs%    offset of the location to look at
Value%   value to store in the given memory posn (word)

Name  : FClose1              (File Close)
Class : Disk
Level : DOS

This routine closes a file that was opened by FOpen1 or
FCreate.  It can also be used to close any of the predefined
device handles.

These are the predefined device handles that are always
available:

   0    CON     stdin     standard input, normally the keyboard
   1    CON     stdout    standard output, normally the display
   2    CON     stderr    standard error, almost always display
   3    AUX     stdaux    auxiliary device, generally COM1
   4    PRN     stdprn    standard printer, generally LPT1

If you are running short of handles, you can always close
stdaux to free up a handle.  The stdprn device can also be
closed as long as you don't use the printer or if you only
access the printer through LPRINT.  It is not a good idea to
close stdin, stdout, or stderr under normal circumstances.

   CALL FClose1 (Handle%)

Handle%    handle of the file to close

Name  : FCreate              (File Create)
Class : Disk
Level : DOS

This routine creates a file and opens it for use by the PBBack
file handling routines.  If the file already existed, it will
be wiped out, so you may want to check beforehand if this is a
problem.  Try the Exist routine.

The file is opened in read/write mode, allowing both input and
output.

You may create the file using any of the following attributes:

   Normal          0      (nothing special)
   Read Only       1      file can be read, but not written to
   Hidden          2      file is "invisible"
   System          4      special DOS system file

The attributes can be combined by adding them together.  Don't
use the System attribute unless you know what you're doing!

Note that this routine does not support file sharing.  If that
is a problem, close the file just after it is created and
reopen it using FOpen1.

   CALL FCreate (FileName$, FAttr%, Handle%, ErrCode%)

FileName$  name of the file to create
FAttr%     attribute(s) of the file
-------
Handle%    handle by which to access the file (if no error)
ErrCode%   error code: 0 if no error, else DOS Error

Name  : FileCount            (File Count)
Class : Disk
Level : DOS

This routine returns the number of files which match a given
file specification and attribute.  You need to use this routine
before LoadDir or LoadDirAll in order to DIM the array to the
appropriate size.

The attribute can be any of the usual file attributes:
   1   Read-Only
   2   Hidden
   4   System
  16   Directory

You can combine attributes by adding their values.  For
instance, to search for hidden directories, you'd use an
attribute of 18.  By default, DOS returns normal files as well
as files which have the specified attributes, so an attribute
of 18 would get you normal files, hidden files, directories,
and hidden directories.  However, FileCount can be made to
screen out unwanted files-- just negate the attribute to force
only files of that attribute to be counted.  For example, an
attribute of -18 would return only hidden subdirectories.

   CALL FileCount (FileSpec$, FilAttr%, Count%, ErrCode%)

We use FilAttr% instead of FileAttr%, since BASIC has a
built-in FILEATTR function in some versions.

FileSpec$   search filename (may contain wildcards)
FilAttr%    search file attribute
-------
Count%      number of matching files found
ErrCode%    error code (0 if no error)

Name  : FindFirstF           (Find First File)
Class : Disk
Level : DOS

The FindFirstF routine is used to find the first file that
matches search parameters which you specify.  Various
information about the file that matches (if any) can be
retrieved by other routines.  See also FindNextF.

The file name specified may contain a drive and subdirectory
specification. Wildcards are also allowed.

Possible search attributes are as follows:

   Normal          0      (nothing special)
   Hidden          2      file is "invisible"
   System          4      special DOS system file
   Subdirectory   16      subdirectory

You can combine the attributes by adding them together.  All
searches will match if any of the specified attributes are
found, so if you're looking only for a specific attribute, you
will need to test the results using GetAttrF.

Routines in this series include:
   FindFirstF, FindNextF, GetNameF, GetAttrF, GetDateF,
   GetTimeF

   CALL FindFirstF (FileName$, FAttr%, ErrCode%)

FileName$   name of file(s) for which to search
FAttr%      file attribute(s) to seek
-------
ErrCode%    error code (0 if no error, else no matching files)

Name  : FindNextF            (Find Next File)
Class : Disk
Level : DOS

This routine is for use after FindFirstF, to find any
additional files which may match your search specifications.

Routines in this series include:
   FindFirstF, FindNextF, GetNameF, GetAttrF, GetDateF,
   GetTimeF

   CALL FindNextF (ErrCode%)

-------
ErrCode%    error code (0 if no error, else no matching files)

Name  : Floppies             (Floppies installed)
Class : Equipment / Disk
Level : BIOS

The Floppies routine tells you how many floppy drives are
installed (0-4).

   CALL Floppies (Drives%)

-------
Drives%  number of floppy disk drives installed

Name  : FloppyType           (Floppy drive Type)
Class : Equipment / Disk
Level : Clone (AT)

This routine tells you what kinds of floppy drives are
installed, if any.  A code is returned for each drive, as
follows:

   0    no drive
   1    5 1/4"    360K
   2    5 1/4"    1.2M
   3    3 1/2"    720K
   4    3 1/2"    1.44M

Result codes of 5-7 are available, but not yet defined.  One
might guess that the 2.88M drive supported by DOS 5.0 will be
drive type 5.

Note that this routine supports a maximum of only two drives.
It is possible for a machine to have up to four drives, but
there is not currently any good way to find out about them.

FloppyType should only be used on AT-class machines.  It will
not work on PC/XT computers and may cause unusual results if
used on such machines.  It will also not work on some of the
earliest AT machines which didn't adhere to the standard CMOS
format.

   CALL FloppyType (DriveA%, DriveB%)

-------
DriveA%    drive type of first floppy drive
DriveB%    drive type of second floppy drive

Name  : FlushToDisk          (Flush file buffers To Disk)
Class : Disk
Level : DOS

This is a "file safety" routine for use with files opened by
FOpen1 or FCreate.  Files are normally buffered by DOS, which
makes file handling faster but creates the danger of losing the
file if there is a crash or power outage.  By flushing the file
to disk, you insure that it is updated to the current moment.

Note: this routine will need to temporarily create a new file
handle if DOS versions before 4.0 are used.

   CALL FlushToDisk (Handle%, ErrCode%)

Handle%    handle of the file to flush
-------
ErrCode%   error code: 0 if none, else DOS Error

Name  : FOpen1               (File Open)
Class : Disk
Level : DOS

This routine opens an existing file for use with the PBBack
file handling routines.  If you need to create a file that
doesn't already exist, use the FCreate routine instead.

The file may be opened for reading, writing, or both:

   0   Read
   1   Write
   2   Read/Write

You may specify a file sharing mode for use with networks and
multitaskers. This will only take effect if the DOS version is
3.0 or later and if the DOS SHARE utility has been executed.
Otherwise, it will be ignored.

   0   Normal       compatibility mode: no file sharing
   1   Exclusive    no one else may access the file
   2   Deny Write   no one else may write to the file
   3   Deny Read    no one else may read from the file
   4   Deny None    anyone else may read from or write to file

Most of the time, "Deny Write" will be appropriate.  This
allows others to read the file, but not to modify the file on
you unexpectedly.

See the discussion of predefined device handles at FClose1.

   CALL FOpen1 (FileName$, ReadWrite%, Sharing%, Handle%, _
      ErrCode%)

FileName$   name of the file to open
ReadWrite%  whether you want input, output, or both (see above)
Sharing%    file sharing mode (see above)
-------
Handle%    handle by which to access the file (if no error)
ErrCode%   error code: 0 if no error, else DOS Error

Name  : FSetEnd              (File Set to End)
Class : Disk
Level : DOS

This moves the file pointer to the end of the file.  It is for
use with files opened by FOpen1 or FCreate.  The usual purpose
for this is to append information to an existing file.

Note that some text files may have a Control-Z or CHR$(26) on
the end.  For historical reasons, this character is sometimes
used as an "end of file" marker.  When dealing with text files,
you may want to examine the last character of the file to make
sure it isn't a Control-Z.

Some Microsoft BASICs are among the programs which,
unfortunately, put a Control-Z at the end of a file (if you
OPEN for OUTPUT).

   CALL FSetEnd (Handle%)

Handle%    handle of the file

Name  : FSetRec              (File Set location to Record)
Class : Disk
Level : DOS

This sets the file pointer to a specific record in the file.
It is for use with files opened by FOpen1 or FCreate.

   CALL FSetRec (Handle%, RecSize%, RecNr%)

Handle%    handle of the file
RecSize%   number of bytes per record
RecNr%     number of record (starting at 1)

Name  : Get4DOSv             (Get 4DOS Version)
Class : Equipment
Level : DOS

The Get4DOSv routine returns the version of 4DOS being used.
It returns the results as two integers containing the major and
minor version numbers. For instance, 4DOS 4.0 would return a
major number of 4, minor 0.  If 4DOS is not installed, both
version numbers will be zero.

If you're not familiar with 4DOS, it's a terrific improved
replacement for COMMAND.COM.  For more information, write JP
Software Inc., P.O. Box 1470, Arlington MA 02174, or call your
local BBS.

   CALL Get4DOSv (MajorV%, MinorV%)

-------
MajorV%   major part of the 4DOS version
MinorV%   minor part of the 4DOS version

Name  : GetAttrF             (Get Attribute of File)
Class : Disk
Level : DOS

The GetAttrF routine returns the attributes of a file matched
by FindFirstF or FindNextF.

   Normal          0      (nothing special)
   Read Only       1      file can be read, but not written to
   Hidden          2      file is "invisible"
   System          4      special DOS system file
   Subdirectory   16      subdirectory
   Archive        32      (used by some backup utilities)

You can see if a certain value is set using the AND operator:

   IF FAttr% AND 16 THEN PRINT "Subdirectory"

Since the values are all powers of two, the AND operator makes
for a convenient way of decoding the results.

Routines in this series include:
   FindFirstF, FindNextF, GetNameF, GetAttrF, GetDateF,
   GetTimeF

   CALL GetAttrF (FAttr%)

-------
FAttr%   attributes that are set

Name  : GetCommAddr          (Get Comm Address)
Class : Serial
Level : Clone

This routine allows you to determine the base port address of a
serial port. You tell it the COM port number (1-4) and it
returns the port address.  If there is no port installed, zero
will be returned.

Note that ports are "supposed" to be assigned sequentially-- in
other words, if you find a "zero" port address, there will be
no ports after that.  This is not necessarily the case,
however.  Some semi-standard machines may have a COM2 without a
COM1, for instance.  QuickBASIC gets confused in that case, but
it's no problem with my libraries.

Aside from purely informational purposes, this routine can be
useful in conjunction with SetCommAddr in manipulating the
serial ports.

   CALL GetCommAddr (PortNr%, PortAddr%)

PortNr%     COM port number (1-4)
-------
PortAddr%   port address

Name  : GetCRT               (Get CRT)
Class : Display / Equipment
Level : Clone

The GetCRT routine simply tells you whether the current display
is capable of handling colors or not.  An unsophisticated
routine, GetCRT assumes that if the display is an MDA/Hercules,
it can't do color, but otherwise it can.

See also GetEGA, GetHGA and GetVGA.

   CALL GetCRT (Colour%)

-------
Colour%   whether the display is color (0 if no)

Name  : GetDateAT            (Get Date from AT clock)
Class : Time
Level : BIOS (AT)

This routine gets the date from the hardware real-time clock in
AT-class computers.  Depending on the DOS version, this date
may be partially or completely independent of the date kept by
DOS in software.  DOS always reads the date from the hardware
clock when it starts up.  However, use of the DATE command in
DOS (and the DATE$ function in QuickBASIC) may relate only to
the software copy of the date, which is not always guaranteed
to be the same as the date in the hardware clock due to certain
discrepancies in DOS.

   CALL GetDateAT (MonthNr%, DayNr%, YearNr%, ErrCode%)

-------
MonthNr%     month number (1-12)
DayNr%       day (1-31)
YearNr%      year (1980-2079)
ErrCode%     error code: 0 if no error, else clock has stopped

Name  : GetDateF             (Get Date of File)
Class : Disk / Time
Level : DOS

The GetDateF routine returns the date of a file matched by
FindFirstF or FindNextF.

Routines in this series include:
   FindFirstF, FindNextF, GetNameF, GetAttrF, GetDateF,
   GetTimeF

   CALL GetDateF (MonthNr%, DayNr%, YearNr%)

-------
MonthNr%    month
DayNr%      day
YearNr%     year

Name  : GetDOSv              (Get DOS Version)
Class : Equipment
Level : DOS

The GetDOSv routine tells you what version of DOS you're
using.  It returns the results as two integers containing the
major and minor version numbers. For instance, MS-DOS 2.11
would return a major number of 2, minor 11.

The OS/2 compatibility box returns version numbers beginning at
10.00.  For instance, OS/2 v1.1 returns 10.10 and OS/2 v2.0
returns 20.00.

   CALL GetDOSv (MajorV%, MinorV%)

-------
MajorV%   major part of the DOS version
MinorV%   minor part of the DOS version

Name  : GetDrv               (Get default Drive)
Class : Disk
Level : DOS

This routine tells you the letter of the current default drive.

   Drive$ = "x"
   CALL GetDrv (Drive$)

-------
Drive$    default drive letter.  Init to at least one character.

Name  : GetDView             (Get DESQview version)
Class : Miscellaneous
Level : DOS

The GetDView routine tells you what version of DESQview is
loaded.  It returns the results as two integers containing the
major and minor version numbers.  For instance, DESQview 2.0
would return a major number of 2 and a minor number of 0.  If
DESQview is not loaded, zeroes are returned.

See also GetTView, GetTVScreen, UpdTVScreen.

   CALL GetDView (MajorV%, MinorV%)

-------
MajorV%   major part of the DESQview version (0 if no DESQview)
MinorV%   minor part of the DESQview version

Name  : GetEGA               (Get EGA information)
Class : Display / Equipment
Level : BIOS

This routine tells you whether an EGA (or VGA) is available,
and if so, what kind.  It tells you whether the attached
display is monochrome or color, and how many kilobytes of RAM
are installed in the adapter.

Many early EGAs had only 64K of RAM.  Current adapters have
256K or more. Since there are some limitations attached to
having only 64K, it's a good idea to see if this is the case--
most PBBack EGA routines won't work properly on 64k adapters.

See also GetCRT and GetVGA.

   CALL GetEGA (Display%, KBytes%)

-------
Display%  EGA display type: 0 no EGA, 1 EGA color, 2 EGA mono
KBytes%   kilobytes of display memory

Name  : GetExecPath          (Get Execution Path of program)
Class : Disk
Level : DOS 3.0+

This routine returns the full path of your program, i.e., the
drive, subdirectory, and name of the program.  It does not rely
on the current drive and subdirectory settings or look at the
PATH setting-- DOS tells it directly.  This makes it an
excellent way to find the program's "home" directory, where
(hopefully) any data files associated with the program will
also be stored.

   SelfName$ = SPACE$(80)
   CALL GetExecPath (SelfName$, SelfLen%)
   SelfName$ = LEFT$(SelfName$, SelfLen%)

-------
SelfName$   full path for current program.  Init to 80+ chars.
SelfLen%    length of the full path spec.

Name  : GetExtM              (Get Extended Memory)
Class : Memory / Equipment
Level : BIOS (AT)

This routine allows you to find out how much extended memory is
available. It should only be used on AT-class computers, since
older PCs do not support extended memory.  Note that some of
the very early AT machines will return erroneous results.

The amount of memory returned may be either the total amount of
extended memory installed or just the amount available at this
time, depending on how previously-installed programs (if any)
make use of extended memory. Unfortunately, there is no
standard which defines how a program should use extended memory
as there is with EMS (expanded memory), so there is no way for
a program to determine whether or how another program is using
extended memory.  Microsoft is trying to clear up this
situation with its HIMEM driver (available at your local BBS,
or [last I looked] free from Microsoft), but this approach
hasn't really become standard yet.

   CALL GetExtM (KBytes%)

-------
KBytes%    the number of kilobytes of extended memory

Name  : GetFAttr             (Get File Attribute)
Class : Disk
Level : DOS

This routine lets you read the attributes of a file or
subdirectory.  The attributes may contain a combination of any
of the following:

   Normal          0      (nothing special)
   Read Only       1      file can be read, but not written to
   Hidden          2      file is "invisible"
   System          4      special DOS system file
   Subdirectory   16      subdirectory
   Archive        32      (used by some backup utilities)

You can see if a certain value is set by using the AND operator:

   IF FAttr% AND 2 THEN PRINT "Hidden file"

Since the values are all powers of two, the AND operator makes
for a convenient way of decoding the results.

   CALL GetFAttr (FileName$, FAttr%)

FileName$   name of the file (or subdirectory) to examine
-------
FAttr%      attributes that are set

Name  : GetFDate             (Get File Date)
Class : Disk / Time
Level : DOS

This routine gets the date of a file.

   CALL GetFDate (FileName$, MonthNr%, DayNr%, YearNr%)

FileName$   name of the file to examine
-------
MonthNr%    month
DayNr%      day
YearNr%     year

Name  : GetFTime             (Get File Time)
Class : Disk / Time
Level : DOS

This routine gets the time of a file.

   CALL GetFTime (FileName$, HourNr%, MinuteNr%, SecondNr%)

FileName$     name of the file to examine
-------
HourNr%       hour
MinuteNr%     minute
SecondNr%     second (always even, due to DOS storage techniques)

Name  : GetKbd               (Get Keyboard toggles)
Class : Input
Level : Clone

The GetKbd routine allows you to get the state of the four
keyboard toggles: Insert, Caps lock, Num lock, and Scroll Lock.

   CALL GetKbd (Insert%, Caps%, Num%, Scrl%)

-------
Insert%    whether "insert" mode is on (0 if no)
Caps%      whether "caps lock" is on (0 if no)
Num%       whether "num lock" is on (0 if no)
Scrl%      whether "scroll lock" is on (0 if no)

Name  : GetKbd1              (Get Keyboard Shifts)
Class : Input
Level : Clone

The GetKbd1 routine allows you to get the state of the four
keyboard shift keys: Left shift, Right shift, Control and Alt.

   CALL GetKbd1 (LShift%, RShift%, Control%, Alt%)

-------
LShift%    whether the left shift key is depressed (0 if no)
RShift%    whether the right shift key is depressed (0 if no)
Control%   whether a control key is depressed (0 if no)
Alt%       whether an alt key is depressed (0 if no)

Name  : GetKbd2              (Get Keyboard Shifts)
Class : Input
Level : AT BIOS

The GetKbd2 routine allows you to get the state of the six
keyboard shift keys on an "enhanced" keyboard: Left shift,
Right shift, Left Control, Right Control, Left Alt and Right
Alt.

Normally, the BIOS only lets you see one key at a time, which
can be a barrier when you need more input.  This is a
particular problem with action games and other real-time
applications which have complex input requirements. Due to the
special way the BIOS treats shift keys, GetKbd2 can tell if the
the various shift keys are pressed simultaneously, allowing
more flexibility.

   CALL GetKbd2 (LShift%, RShift%, LCtrl%, RCtrl%, LAlt%, _
      RAlt%)

-------
LShift%    whether the left shift key is depressed (0 if no)
RShift%    whether the right shift key is depressed (0 if no)
LCtrl%     whether the left control key is depressed (0 if no)
RCtrl%     whether the right control key is depressed (0 if no)
LAlt%      whether the left alt key is depressed (0 if no)
RAlt%      whether the right alt key is depressed (0 if no)

Name  : GetKey               (Get Key or mouse)
Class : Input, Mouse
Level : BIOS

This routine is kind of an extended version of INPUT$.  It
waits until a key is available at the keyboard and returns the
key pressed.  At your option, it can also return if a mouse
button is pressed.

   CALL GetKey (Mouse%, ASCIIcode%, ScanCode%, LButton%, _
      RButton%)

Mouse%        whether to check the mouse (0: no)
-------
ASCIIcode%    ASCII code of the key pressed
ScanCode%     scan code of the key pressed (0 if none)
LButton%   whether the left  mouse button was pressed
RButton%  whether the right mouse button was pressed

Name  : GetKey3              (Get Key or 3-button mouse)
Class : Input, Mouse
Level : BIOS

This routine is kind of an extended version of INPUT$.  It
waits until a key is available at the keyboard and returns the
key pressed.  At your option, it can also return if a mouse
button is pressed.

   CALL GetKey3 (Mouse%, ASCIIcode%, ScanCode%, LButton%, _
      MButton%, RButton%)

Mouse%        whether to check the mouse (0: no)
-------
ASCIIcode%    ASCII code of the key pressed
ScanCode%     scan code of the key pressed (0 if none)
LButton%      whether the left   mouse button is pressed
MButton%      whether the middle mouse button is pressed
RButton%      whether the right  mouse button is pressed

Name  : GetLabel             (Get disk volume Label)
Class : Disk
Level : DOS

This routine gets the volume label for a specified disk.

   Label$ = SPACE$(11)
   CALL GetLabel (Drive$, Label$, LabelLen%, ErrCode%)
   Label$ = LEFT$(Label$, LabelLen%)

Drive$     letter of the drive to examine
-------
Label$     volume label of disk.  Init to >= 11 chars.
LabelLen%  length of the volume label
ErrCode%   error code: 0 if no error, else DOS Error

Name  : GetLIMHandles        (Get L/I/M expanded mem Handles)
Class : Memory
Level : DOS

Early Lotus/Intel/Microsoft expanded memory revisions provided
a limited number of "handles" which could be used to access
expanded memory-- often as few as 15 or so.  If your program
uses expanded memory and the EMS driver is one of the older
versions, you may want to make sure that enough handles are
available.  This routine tells you how many handles are in use.

Note that this routine expects an EMS driver to be installed.
If you can't be sure of that, use GetLIMM first to avoid an
unpleasant surprise.

   CALL GetLIMHandles (Handles%)

-------
Handles%  number of EMS handles in use

Name  : GetLIMM              (Get L/I/M expanded Memory)
Class : Memory / Equipment
Level : DOS

This routine tells you how much expanded memory is installed.
If there is none, or if the EMS driver hasn't been installed,
it returns zeroes.  You should use this routine before any
other of the PBBack routines that access expanded memory,
since the other routines expect EMS to be available.

The results are returned in terms of EMS pages.  Each page is
16 kilobytes.

   CALL GetLIMM (TotalPages%, FreePages%)

-------
TotalPages%  number of EMS pages installed
FreePages%   number of EMS pages available for use

Name  : GetLIMV              (Get L/I/M expanded mem Version)
Class : Memory / Equipment
Level : DOS

The GetLIMV routine tells you the version of EMS driver that is
being used. The version number is separated into major and
minor parts.  For example, an EMS 3.1 driver would return a
major number of 3 and minor number of 1.

Note that this routine expects an EMS driver to be installed.
If you can't be sure of that, use GetLIMM first to avoid an
unpleasant surprise.

   CALL GetLIMV (MajorVer%, MinorVer%)

-------
MajorVer%  major part of the EMS version number
MinorVer%  minor part of the EMS version number

Name  : GetLine              (Get Line of text)
Class : Display
Level : Any

This routine retrieves a row of text from a saved (or virtual)
screen.

You can use GetLine with a saved screen of any size.  The St$
parameter must be initialized to the width of the saved screen
(in columns).

   St$ = SPACE$(ScrWidth)
   CALL GetLine (DSeg%, DOfs%, Row%, St$, SLen%)
   St$ = LEFT$(St$, SLen%)

DSeg%      segment of saved screen
DOfs%      offset of saved screen
Row%       row of saved screen (starting at 1)
-------
St$        text at given row (init to width of saved screen)
SLen       logical length of text

Name  : GetMouseLoc          (Get Mouse Location)
Class : Mouse
Level : BIOS

This routine allows you to get the current location of the
mouse cursor.  It doesn't matter if the cursor is visible or
invisible.  GetMouseLoc is only for use in text mode.

This routine will not work properly if there is no mouse
available.  Use the MMCheck routine if you are not sure.

See also MMGetLoc, which returns the coordinates for graphics
mode.

   CALL GetMouseLoc (Row%, Column%)

-------
Row%       mouse cursor row
Column%    mouse cursor column

Name  : GetMouseVer          (Get Mouse driver Version)
Class : Mouse
Level : BIOS

This routine retrieves various information about the mouse,
including the driver version number, mouse type, and IRQ used
by the mouse.

Note that this is among the mouse routines that makes you
wonder what Microsoft was thinking when they designed the mouse
driver.  The mouse driver has no provision for error codes and
the "get version" function was added comparatively recently, so
there is no way of knowing with certainty whether this routine
worked or what the mouse driver version is.  If that could be a
problem, you can reduce the risk by checking the returned
values to make sure they appear reasonable.

This routine will not work properly if there is no mouse
available.  Use the MMCheck routine if you are not sure.

The mouse type may be any of the following:
   1   bus mouse
   2   serial mouse
   3   InPort mouse
   4   PS/2 mouse
   5   Hewlett-Packard mouse

The IRQ will be 0 on the PS/2.  Otherwise, it will be 2-5 or 7
on Microsoft mice.  A mouse designed to take advantage of the
AT interrupt controller may use higher IRQs (to perhaps 15, I'm
not sure), so be generous if you do range checking here.

The version number is divided into two parts.  For instance,
mouse driver 8.20 would return a major version number of 8 and
a minor version number of 20.

   CALL GetMouseVer (MajorV%, MinorV%, MType%, IRQ%)

-------
MajorV%    mouse driver major version number
MinorV%    mouse driver minor version number
MType%     mouse type
IRQ%       IRQ used by mouse

Name  : GetNameF             (Get Name of File)
Class : Disk
Level : DOS

The GetNameF routine returns the name of a file matched by
FindFirstF or FindNextF.  The name will not contain a drive or
subdirectory specification.

Routines in this series include:
   FindFirstF, FindNextF, GetNameF, GetAttrF, GetDateF,
   GetTimeF

   FileName$ = SPACE$(12)
   CALL GetNameF (FileName$, NameLen%)
   FileName$ = LEFT$(FileName$, NameLen%)

-------
FileName$   file name (init to at least 12 characters)
NameLen%    length of file name

Name  : GetPrtAddr           (Get Printer Address)
Class : Printer
Level : Clone

This routine allows you to determine the base port address of a
parallel port.  You tell it the LPT port number (1-4) and it
returns the port address. If there is no port installed, zero
will be returned.

Note that up to four printer ports are (theoretically)
supported on most machines.  On PS/2 computers, only three
ports are allowed, and the fourth port data area is used for
other purposes.  So, it would probably be a good idea to
restrict your program to ports 1-3.

Aside from purely informational purposes, this routine can be
useful in conjunction with SetPrtAddr in manipulating the
parallel ports.

   CALL GetPrtAddr (PortNr%, PortAddr%)

PortNr%     LPT port number (1-4 or 1-3 [see above])
-------
PortAddr%   port address

Name  : GetRows              (Get Rows on screen)
Class : Display
Level : Clone

This routine tells you how many rows are on the display.  This
is normally 25, but it may be greater on an EGA or VGA.  Only
text modes are supported.

   CALL GetRows (Rows%)

-------
Rows%    text rows on the display

Name  : GetScreen            (Get Screen)
Class : Display
Level : Clone

This routine saves any portion of the display to an array.
Only text modes are supported.  If your program uses multiple
display pages, you can get an image from any of those pages.  A
special "slow" mode is supported for the CGA, to prevent
flickering (a problem only with some CGAs).

The size of the integer array needed to store a specific area
of the screen can be calculated using the CalcSize routine
(see).

If you wish to save the entire screen, you may find ScrSave
easier (see).

   CALL GetScreen (Array%(), TRow%, LCol%, BRow%, RCol%, _
      Page%, Fast%)

TRow%      top row of the desired screen area
LCol%      left column of the desired screen area
BRow%      bottom row of the desired screen area
RCol%      right column of the desired screen area
Page%      page from which to get the display area
Fast%      whether to use fast mode (0 no)
-------
Array%()   stored image of the selected area of the screen

Name  : GetSub               (Get default Subdirectory)
Class : Disk
Level : DOS

The GetSub routine gets the current subdirectory on the default
drive.  It does not put a backslash at the start of the
subdirectory, so you should add this yourself.

See also GetSub1, which is a more advanced version of this
routine.

   SubDir$ = SPACE$(64)
   CALL GetSub (SubDir$, SubLen%)
   SubDir$ = "\" + LEFT$(SubDir$, SubLen%)

-------
SubDir$    name of the current subdirectory. Init to 64+ chars
SubLen%    length of the subdirectory name

Name  : GetSub1              (Get default Subdirectory)
Class : Disk
Level : DOS

The GetSub1 routine gets the current subdirectory on a
specified drive. Unlike GetSub, it places a backslash at the
start of the name.  It also returns an error code, which allows
you to see if there was a disk error.

   SubDir$ = SPACE$(65)
   CALL GetSub1 (Drive$, SubDir$, SubLen%, ErrCode%)
   SubDir$ = LEFT$(SubDir$, SubLen%)

Drive$     letter of the drive to check
-------
SubDir$    name of the current subdirectory. Init to 65+ chars
SubLen%    length of the subdirectory name
ErrCode%   error code: 0 if no error, else DOS Error

Name  : GetSwitch            (Get Switch character)
Class : Miscellaneous
Level : DOS

An undocumented capability in many DOS versions allows you to
set the DOS "switch character", which is the delimiter used to
identify a switch on the DOS command line.  This is normally a
slash, as in "DIR /W".  However, many people prefer to change
it to a "-", which is the switch character used by Unix.

With the normal "/" delimiter, a backslash "\" is used in
subdirectory specifications.  DOS itself will recognize either
one as a subdirectory delimiter, but the command line won't
unless the switch char was changed.

The upshot of all this is, whereas you might normally use a
command like:
   DIR /W C:\GAMES

Someone with a different switch character might use something
like this:
   DIR -W C:/GAMES

This is exactly the sort of syntax that Unix commands use.

If you design your program to recognize the different
delimiters, you will make some people very happy!  The
GetSwitch routine will detect changed delimiters on those
versions of DOS which support it, and will return an ordinary
"/" on those versions of DOS which don't.

   Switch$ = "x"
   CALL GetSwitch (Switch$)

-------
Switch$    the DOS switch character.  Init to one character.

Name  : GetTime              (Get Time)
Class : Time
Level : DOS

This routine tells you the time according to DOS.

The main difference between getting the time from BASIC and
getting it from DOS is the "hundredths of seconds" value.
However, this value is not available on some machines, in which
case it will be set to zero.  It is not accurate on most
machines, being calculated instead using a semi-random
approach; it is more of a novelty than a useful value.

   CALL GetTime (HourNr%, MinuteNr%, SecondNr%, Hundredth%)

-------
HourNr%      hour (0-23)
MinuteNr%    minute
SecondNr%    second
Hundredth%   hundredth of a second.  See remarks, above.

Name  : GetTimeAT            (Get Time from AT clock)
Class : Time
Level : BIOS (AT)

This routine gets the time from the hardware real-time clock in
AT-class computers.  Depending on the DOS version, this time
may be partially or completely independent of the time kept by
DOS in software.  DOS always reads the time from the hardware
clock when it starts up.  However, use of the TIME command in
DOS (and the TIME$ function in QuickBASIC) may relate only to
the software copy of the time, which is not always guaranteed
to be the same as the time in the hardware clock due to certain
discrepancies in DOS.

   CALL GetTimeAT (HourNr%, MinuteNr%, SecondNr%, ErrCode%)

-------
HourNr%      hour (0-23)
MinuteNr%    minute
SecondNr%    second
ErrCode%     error code: 0 if no error, else clock has stopped

Name  : GetTimeF             (Get Time of File)
Class : Disk / Time
Level : DOS

The GetTimeF routine returns the time of a file matched by
FindFirstF or FindNextF.

Routines in this series include:
   FindFirstF, FindNextF, GetNameF, GetAttrF, GetDateF,
   GetTimeF

   CALL GetTimeF (HourNr%, MinuteNr%, SecondNr%)

-------
HourNr%     hour
MinuteNr%   minute
SecondNr%   second

Name  : GetTView             (Get TopView)
Class : Miscellaneous
Level : BIOS

This routine tells you whether TopView or a compatible
multitasker (such as TaskView or DESQview) is loaded.

See also GetDView, GetTVScreen, UpdTVScreen.

   CALL GetTView (Installed%)

-------
Installed%   whether a TopView-type multitasker is loaded

Name  : GetTVScreen          (Get TopView Screen address)
Class : Display / Miscellaneous
Level : BIOS

GetTVScreen returns the address of the screen buffer used by a
TopView-type multitasker.  This allows you to use direct screen
access while remaining within the windows allocated to your
program by the multitasker.

You must tell the multitasker the address of the screen you
would be writing to if the multitasker was not installed.
Specify a segment of &HB000 if using an MDA or Hercules, or a
segment of &HB800 for CGA, EGA, MCGA or VGA. The offset should
always be 0.  This is for use in text modes.

The routine will return with the new segment and offset for you
to use. These values can be used with any PBBack screen routine
that accepts a segment and offset-- DQPrint and DXQPrint, for
example.

Note that not all TopView-compatible multitaskers will
automatically update the screen from the buffer.  The
UpdTVScreen routine allows you to force a screen update.

See also GetDView, GetTView, UpdTVScreen.

   CALL GetTVScreen (DSeg%, DOfs%)

DSeg%       segment of desired screen
DOfs%       offset of desired screen
-------
DSeg%       segment of screen buffer
DOfs%       offset of screen buffer

Name  : GetValidKey          (Get Valid Key)
Class : Input
Level : DOS

This one is useful for getting one of a list of keys from the
keyboard.  You give it a list of keys (letters should be
uppercase) to accept.  It will wait until one of the listed
keys is pressed; for letters, it will accept either lowercase
or uppercase keys, but will convert the letter to uppercase
before it returns to you.  If you pass it a blank list, it will
accept any key.

This routine is handy for when you want to allow one of a list
of choices from a menu, for instance.

   CALL GetValidKey (GoodList$, Result$)

GoodList$    list of acceptable keys.  See above for remarks.
-------
Result$      the key that was accepted (uppercase if letter)

Name  : GetVerify            (Get Verify setting)
Class : Disk
Level : DOS

The GetVerify routine tells you the state of the DOS VERIFY
flag.  When VERIFY is on, some checking is done to make sure
that writing to the disk works as requested.  The checks are
not very good, however, and VERIFY slows down disk handling, so
it is usually better to have VERIFY off.

You can change the state of VERIFY by using the DOS VERIFY
command or with the SetVerify routine in PBBack.

   CALL GetVerify (VerifyOn%)

-------
VerifyOn%   whether VERIFY is on (0 if no)

Name  : GetVGA               (Get VGA information)
Class : Display / Equipment
Level : BIOS

This routine tells you whether a VGA is available.

See also GetCRT, GetEGA and GetHGA.

   CALL GetVGA (IsVGA%)

-------
IsVGA%    whether a VGA is installed (0 if no)

Name  : GetVGAColor          (Get VGA Color)
Class : Display
Level : BIOS

This routine gets the components of a single VGA palette color.
It returns the color value associated with a given color number.

If you are dealing with more than one color at a time, you may
find GetVGAPalette more appropriate.

   CALL GetVGAColor (ColorNr%, Red%, Green%, Blue%)

ColorNr%   color number (1-16 or 1-255, depending on VGA mode)
-------
Red%       red intensity (0-63)
Green%     green intensity (0-63)
Blue%      blue intensity (0-63)

Name  : GetVidMode           (Get Video Mode)
Class : Display
Level : BIOS

The GetVidMode routine tells you about the current display
status from the BIOS' point of view.  Note that the BIOS
display mode is not the same as the BASIC SCREEN mode (a direct
translation between the two is messy, because BASIC
conglomerates several BIOS modes into a single SCREEN mode in
several instances).

   CALL GetVidMode (BIOSMode%, ScreenWidth%, ActivePage%)

-------
BIOSMode%     BIOS video mode
ScreenWidth%  number of columns per row
ActivePage%   active (visible) display page

Name  : GLoad                (Graphics Load)
Class : Disk
Level : DOS

A replacement for the BASIC BLOAD statement, this routine loads
a binary memory image from a file into the area of memory it
formerly occupied.  This is most often used to restore a screen
display from a file, although PBBack offers more flexible
alternatives.

   CALL GLoad (FileName$)

FileName$    name of the file to load into memory

Name  : GQPrint              (Graphics Quick Print)
Class : Display
Level : Clone

This is a simple high-speed replacement for the PRINT statement
which works in CGA graphics mode (SCREEN 2).  It does not
interpret control codes, support graphics characters (ASCII
128-255), or update the cursor position, in return for which it
is much faster than PRINT.

The Fast% parameter is ignored at the moment-- top speed is
always used, which may cause flickering on some CGAs.

   CALL GQPrint (St$, Row%, Column%, Fast%)

St$      string to display
Row%     row (1-25)
Column%  column (1-80)
Fast%    not used

Name  : GrafRest             (Graphics Restore)
Class : Display
Level : Clone

This routine allows you to restore a SCREEN 1 (CGA, 320x200, 4
color) or SCREEN 2 (CGA, 640x200, 2 color) display that was
saved using GrafSave (see).

   CALL GrafRest (DSeg%, DOfs%)

DSeg%      segment of storage array
DOfs%      offset  of storage array

Name  : GrafSave             (Graphics Save)
Class : Display
Level : Clone

This routine allows you to save a SCREEN 1 (CGA, 320x200, 4
color) or SCREEN 2 (CGA, 640x200, 2 color) display that can be
restored using GrafRest (see).

The array used to hold the screen must contain 16,000 bytes.
For an integer array, this means that you must create the array
by DIM Array%(1 TO 8000).

   CALL GrafSave (DSeg%, DOfs%)

DSeg%      segment of storage array
DOfs%      offset  of storage array

Name  : GXQPrint             (Graphics Extended Quick Print)
Class : Display
Level : Clone

This is a simple high-speed replacement for the PRINT statement
which works in CGA graphics mode (SCREEN 1).  It does not
interpret control codes, support graphics characters (ASCII
128-255), or update the cursor position, in return for which it
is much faster than PRINT.

This routine can also be used in SCREEN 2, where it will
display the string in shades instead of in color (using 40
columns/row).

The Fast% parameter is ignored at the moment-- top speed is
always used, which may cause flickering on some CGAs.

   CALL GXQPrint (St$, Row%, Column%, Fore%, Fast%)

St$      string to display
Row%     row (1-25)
Column%  column (1-40)
Fore%    foreground color (0-3)
Fast%    not used

Name  : GXQPrint1            (Graphics Extended Quick Print)
Class : Display
Level : Clone

This is a high-speed replacement for the PRINT statement which
works in CGA graphics mode (SCREEN 1).  It does not interpret
control codes or update the cursor position, in return for
which it is much faster than PRINT.

This routine can also be used in SCREEN 2, where it will
display the string in shades instead of in color (using 40
columns/row).

The Fast% parameter is ignored at the moment-- top speed is
always used, which may cause flickering on some CGAs.

   CALL GXQPrint1 (St$, Row%, Column%, Fore%, Back%, Fast%)

St$      string to display
Row%     row (1-25)
Column%  column (1-40)
Fore%    foreground color (0-3)
Back%    background color (0-3)
Fast%    not used

Name  : HandleInfo           (Handle Information)
Class : Miscellaneous
Level : DOS

HandleInfo tells you whether a file handle refers to a file or
to a device. If the handle does not exist, an error code will
be returned.

This is for file handles as returned by FOpen1 and FCreate. It
can also be used with file numbers associated with OPEN, via a
BASIC function that was introduced with QuickBASIC 4.0:

   Handle% = FILEATTR(FileNumber%, 2)

See FClose1 for a list of predefined handles.

   CALL HandleInfo (Handle%, Device%, ErrCode%)

Handle%    file handle
-------
Device%    whether the handle refers to a device (0 no)
ErrCode%   whether there was an error (0 no)

Name  : HCls                 (Hercules CLS)
Class : Display
Level : Clone

This routine clears a Hercules graphics screen to the specified
color.

Routines in this series are:
   HCls, HLine, HMode, HPrint, HSetPixel

   CALL HCls (Colour%)

Colour%    color (0-1)

Name  : HiLite               (Highlight)
Class : Display
Level : Clone

This routine allows you to highlight text on the screen.  It
works in text modes only and always displays to the visible
screen page.

See also ReColorArea, which lets you highlight any rectangular
area of the screen.

   CALL HiLite (Row%, LCol%, RCol%, VAttr%)

Row%       row on which to highlight
LCol%      left column (where highlight starts)
RCol%      right column (where highlight ends)
VAttr%     new color (see CalcAttr)

Name  : HLine                (Hercules LINE)
Class : Display
Level : Clone

This routine draws a line on a Hercules graphics screen.

Routines in this series are:
   HCls, HLine, HMode, HPrint, HSetPixel

   CALL HLine (X1%, Y1%, X2%, Y2%, Colour%)

X1%        starting graphics column (0-719)
Y1%        starting graphics row (0-347)
X2%        ending graphics column (0-719)
Y2%        ending graphics row (0-347)
Colour%    color (0-1)

Name  : HMode                (Hercules Mode)
Class : Display
Level : Clone

This routine switches between text mode and Hercules graphics
mode.  Use HInit first to initialize the graphics mode
appropriately.

HMode will clear page 0 when graphics mode is entered.  Page 1,
if it exists, is not cleared.  PBBack does not support page 1
in any respect.

Routines in this series are:
   HCls, HLine, HMode, HPrint, HSetPixel

   CALL HMode (Graphics%)

Graphics%    display mode to set (0 text, else graphics)

Name  : HPrint               (Hercules Print)
Class : Display
Level : Clone

This routine displays text in Hercules graphics mode.   It uses
the full resolution of the screen, so text is 90 columns by 43
rows.  This gives you more space than even the largest EGA text
mode, which is only 80x43.

Routines in this series are:
   HCls, HLine, HMode, HPrint, HSetPixel

   CALL HPrint (St$, Row%, Column%)

St$        text to display
Row%       row (1-43)
Column%    column (1-90)

Name  : HSetPixel            (Hercules Set Pixel)
Class : Display
Level : Clone

This routine draws a dot on a Hercules graphics screen.

Routines in this series are:
   HCls, HLine, HMode, HPrint, HSetPixel

   CALL HSetPixel (X%, Y%, Colour%)

X%         graphics column (0-719)
Y%         graphics row (0-347)
Colour%    color (0-1)

Name  : InitPtr              (Initialize Pointers)
Class : Array management
Level : Any

This routine initializes an array of pointers for use with the
pointer sort routines (PSortD, et al).  It may also be useful
for other purposes.  Each element of the array is set equal to
its index (the first element is set to 1, the second to 2, and
so forth).  Arrays are expected to begin at element 1.  You may
specify the last element to initialize, allowing you to use
only part of an array.

   CALL InitPtr (Ptr%(), Elements%)

Ptr%()      array to initialize
Elements%   number of elements to initialize
-------
Ptr%()      initialized array

Name  : InsChr               (Insert Character)
Class : Display
Level : Clone

The InsChr routine inserts a space at the specified screen
location.

   InsChr Row%, Column%

Row%      row of character
Column%   column of character

Name  : InsLine              (Insert Line)
Class : Display
Level : BIOS

This routine inserts a blank line at the specified row of the
screen.

   CALL InsLine (Row%, VAttr%)

Row%      row to insert
VAttr%    color/attribute to use on new row (see CalcAttr)

Name  : Int2Date             (Integer to Date)
Class : Time
Level : Any

This routine undoes the results of the Date2Int routine.  It
expands a single integer into month, day, and year values.

The storage format is identical to that used by DOS for file
dates, by the way, so this routine makes an apt companion for
LoadDirFull.

   CALL Int2Date (MonthNr%, DayNr%, YearNr%, IntDate%)

IntDate%     date compressed into an integer
-------
MonthNr%     month number (1-12)
DayNr%       day (1-31)
YearNr%      year (1980-2079; see above for two-digit years)

Name  : Int2Time             (Integer to Time)
Class : Time
Level : Any

This routine undoes the results of the Time2Int routine.  It
expands a single integer into hour, minute, and second values.

Note that the seconds will always be even, due to the storage
format.  The storage format is identical to that used by DOS
for file times, by the way, so this routine makes an apt
companion for LoadDirFull.

   CALL Int2Time (HourNr%, MinuteNr%, SecondNr%, IntTime%)

IntTime%     time compressed into an integer
-------
HourNr%      hour (0-23)
MinuteNr%    minute
SecondNr%    second

Name  : IntVector            (Interrupt Vector)
Class : Miscellaneous
Level : DOS

The IntVector routine retrieves the address of a specified
interrupt handler. If there is no interrupt handler, the
results will normally be zero, although early DOS versions did
not always have the sense to initialize unused vectors that way.

   CALL IntVector (DSeg%, DOfs%, Interrupt%)

Interrupt%   interrupt number to examine
-------
DSeg%        segment of the interrupt handler
DOfs%        offset of the interrupt handler

Name  : IRead                (Integer Read)
Class : Disk
Level : DOS

This routine reads an integer (two binary bytes) from a file.

The file must have been opened using FCreate or FOpen1.

   CALL IRead (Handle%, Value%, ErrCode%)

Handle%    file handle
-------
Value%     integer read from file
ErrCode%   DOS error code (0 if no error)

Name  : IWrite               (Integer Write)
Class : Disk
Level : DOS

This routine writes an integer (two binary bytes) to a file.

The file must have been opened using FCreate or FOpen1.

   CALL IWrite (Handle%, Value%, ErrCode%)

Handle%    file handle
Value%     integer to write to file
-------
ErrCode%   DOS error code (0 if no error)

Name  : KbdType              (Keyboard Type)
Class : Input / Equipment
Level : Clone

This routine tells you if an enhanced (101-key) keyboard is
available.

If KbdType is not entirely sure that an enhanced keyboard is
available, it plays safe and assumes there isn't one.  This
avoids possible disaster on older PCs.

   CALL KbdType (Enhanced%)

-------
Enhanced%    whether keyboard is of the enhanced type (0 no)

Name  : KeyPress             (detect Key Press)
Class : Input
Level : DOS

This routine works like the Turbo/Power BASIC function INSTAT.
It tells you whether there is a key waiting to be processed.

   CALL KeyPress (KeyHit%)

-------
KeyHit%   whether a key is waiting (0 if no)

Name  : LClose               (L/I/M Close)
Class : Memory
Level : BIOS

This routine closes a block of expanded memory that was opened
for access by LOpen.  It is important to close the block when
you are finished with it, to return it to the free memory pool.

Routines in this suite include: LOpen, LGet, LPut, LClose.

   CALL LClose (EMSHandle%)

EMSHandle%    handle of the expanded memory block

Name  : LGet                 (L/I/M Get)
Class : Memory
Level : BIOS

This routine gets a block of data from expanded memory that was
opened for access by LOpen.  The amount of data is specified in
words; one word is the same as two bytes.  An integer takes up
a word, single precision numbers require two words, and double
precision numbers take four.

Routines in this suite include: LOpen, LGet, LPut, LClose.

   CALL LGet (EMSHandle%, DSeg%, DOfs%, Words%)

EMSHandle%    handle of the expanded memory block
DSeg%         segment of place to store data
DOfs%         offset of place to store data
Words%        words to get from expanded memory

Name  : LoadDir              (Load Directory)
Class : Disk
Level : DOS

Given a filespec with wildcards and a file attribute, this
routine loads a list of all matching files into an array.  The
array must be of fixed-length string type, with 12 characters
for each filename.  You can find out how large to DIM the array
by using the FileCount routine.

The attribute can be any of the usual file attributes:
   1   Read-Only
   2   Hidden
   4   System
  16   Directory

You can combine attributes by adding their values.  For
instance, to search for hidden directories, you'd use an
attribute of 18.  By default, DOS returns normal files as well
as files which have the specified attributes, so an attribute
of 18 would get you normal files, hidden files, directories,
and hidden directories.  However, LoadDir can be made to screen
out unwanted files-- just negate the attribute to force only
files of that attribute to be counted.  For example, an
attribute of -18 would return only hidden subdirectories.

NOTE:  we use FilAttr%, not FileAttr%, because BASIC has an
internal function named FILEATTR in some versions.

   CALL LoadDir (FileSpec$, FilAttr%, DSeg%, DOfs%, ErrCode%)

FileSpec$    search file specification (may contain wildcards)
FilAttr%     search file attribute
DSeg%        segment of array
DOfs%        offset of array
-------
ErrCode%     error code (0 if no error)

Name  : Locase               (Lowercase)
Class : String
Level : Any

This routine, like BASIC's LCASE$ function, converts a string
to lowercase. Since it doesn't have to create a new return
string (a fairly slow process), it's faster than the BASIC
equivalent.  Also, older versions of BASIC do not always
provide the LCASE$ function.

See also Locase1.

   CALL Locase (St$)

St$     string to be put into lowercase
-------
St$     lowercase string

Name  : Locase1              (Lowercase)
Class : String
Level : Any

This routine, like BASIC's LCASE$ function (in some versions),
converts a string to lowercase. It converts letters in the
extended character set as well as the usual letters, making it
well suited for text which may not be in English.

Note that DOS 5.0 and later versions provide National Language
Support which includes conversion to uppercase (not lowercase,
unfortunately).  So, if you merely need the characters in a
known state, rather than lowercase, you would do better to use
the Upcase1 routine.  Locase1 assumes the U.S. character set,
which may well not be appropriate.

See also Locase.

   CALL Locase1 (St$)

St$     string to be put into lowercase
-------
St$     lowercase string

Name  : LOpen                (L/I/M Open)
Class : Memory
Level : BIOS

This routine opens a block of expanded memory for access.  The
size of the block is specified in words; one word is the same
as two bytes.  An integer takes up a word, single precision
numbers require two words, and double precision numbers take
four.  This allows you to store up to 64K in each EMS block
that you open.

Note that LOpen expects an EMS driver to be available.  If you
are not certain on this point, use GetLIMM beforehand to make
sure.

Routines in this suite include: LOpen, LGet, LPut, LClose.

   CALL LOpen (Words%, EMSHandle%, ErrCode%)

Words%        size of expanded memory block to allocate
-------
EMSHandle%    handle of the expanded memory block
ErrCode%      error code (0 if no error)

Name  : LPut                 (L/I/M Put)
Class : Memory
Level : BIOS

This routine puts a block of data into expanded memory that was
opened for access by LOpen.  The amount of data is specified in
words; one word is the same as two bytes.  An integer takes up
a word, single precision numbers require two words, and double
precision numbers take four.

Routines in this suite include: LOpen, LGet, LPut, LClose.

   CALL LPut (EMSHandle%, DSeg%, DOfs%, Words%)

EMSHandle%    handle of the expanded memory block
DSeg%         segment of place from which to get data
DOfs%         offset of place from which to get data
Words%        words to put into expanded memory

Name  : LRotate              (Left Rotate string)
Class : String
Level : Any

Many years ago, I wrote one of the first terminal programs for
the PC.  It died a horrible death when Qmodem came out...
sigh.  This routine comes from that experience.  It rotates the
characters in a string left once (e.g., "ABCDE" becomes
"BCDEA").  I used this in my routine to dial a list of BBSes,
skipping to the next one if the current one was busy.

LRotate can also be handy for things like scrolling a long
message across the screen (you just PRINT LEFT$(Message$, 80);
delay a bit, LRotate and do it again).

See also RRotate.

   CALL LRotate (St$)

St$     string to be rotated left once
-------
St$     string after being rotated left once

Name  : LScroll              (Left Scroll)
Class : Display
Level : Clone

This routine scrolls any selected part of the display left.
You may scroll as many times as you like, or scroll "zero"
times to totally clear the selected part of the display.

   CALL LScroll (TopRow%, LeftCol%, BottomRow%, RightCol%, _
      Times%)

TopRow%      top row of the area to scroll
LeftCol%     left column of the area to scroll
BottomRow%   top row of the area to scroll
RightCol%    left column of the area to scroll
Times%       number of times (or rows) to scroll

Name  : MakeSub              (Make Subdirectory)
Class : Disk
Level : DOS

Like the DOS MD (or MKDIR) command, this routine creates a new
subdirectory.

   CALL MakeSub (SubDir$, ErrCode%)

SubDir$    name of new subdirectory
-------
ErrCode%   error code: 0 if none, else DOS Error

Name  : MatchFile            (Match File)
Class : Disk / String
Level : Any

The MatchFile routine tells you whether a given filename
matches a file specification which may contain wildcards.  The
filename itself should not contain wildcards.  Neither the
filename nor filespec should include drive or subdirectory
specifications.

One way of using this is in processing file exclusion lists.
The FindFirstF routine allows you to find files that match a
given filespec; to this, you could add a MatchFile-based
routine which would screen out files that match a different
filespec.  Such a routine would allow you to create utilities
to do things like "DIR *.* /EXCEPT=*.BAS".

   CALL MatchFile (FileSpec$, FileName$, IsMatch%)

FileSpec$   master file pattern (may contain wildcards)
FileName$   name of file to test against the master pattern
-------
IsMatch%    0 if the filename doesn't match the filespec

Name  : MemSwap              (Memory Swap)
Class : Memory
Level : Any

MemSwap swaps the contents of one area of memory with another.
This can be used for a variety of things, from swapping a saved
screen with the actual screen to exchanging the contents of two
arrays.

   CALL MemSwap (DSeg1%, DOfs1%, DSeg2%, DOfs2%, Bytes%)

DSeg1%     segment of first memory area
DOfs1%     offset of first memory area
DSeg2%     segment of second memory area
DOfs2%     offset of second memory area
Bytes%     bytes to swap

Name  : MMButton             (Mouse Button)
Class : Mouse
Level : BIOS

The MMButton routine allows you to find out which mouse buttons
are pressed. Although it will work with any mouse, it is
designed specifically for a mouse with two buttons (see also
MMButton3).  If you want to find out which buttons were pressed
in the past, rather than being pressed now, try MMClick instead.

This routine will not work properly if there is no mouse
available.  Use the MMCheck routine if you are not sure.

   CALL MMButton (LeftB%, RightB%)

-------
LeftB%     whether the left button is pressed
RightB%    whether the right button is pressed

Name  : MMButton3            (Mouse Button for 3-button mouse)
Class : Mouse
Level : BIOS

The MMButton3 routine allows you to find out which mouse
buttons are pressed. Although it will work with any mouse, it
is designed specifically for a mouse with three buttons (see
also MMButton).  If you want to find out which buttons were
pressed in the past, rather than being pressed now, try
MMClick3 instead.

This routine will not work properly if there is no mouse
available.  Use the MMCheck routine if you are not sure.

   CALL MMButton3 (LeftB%, MiddleB%, RightB%)

-------
LeftB%     whether the left button is pressed
MiddleB%   whether the middle button is pressed
RightB%    whether the right button is pressed

Name  : MMCheck              (Mouse Check and initialize)
Class : Mouse
Level : BIOS

This routine does a number of things.  Primarily, it is
intended to let you check to see if a mouse is available.  It
returns a zero if there is no mouse; if there is a mouse, the
number of mouse buttons is returned.  The mouse status is also
initialized, so this is best used once at the beginning of your
program.

All of the other mouse routines assume that a mouse is
available, so you should definitely use MMCheck if you're not
sure.  Otherwise, results will be unusual at best, and the
computer may even lock up under some DOS versions.

   CALL MMCheck (Buttons%)

-------
Buttons%   number of mouse buttons (0 if no mouse is installed)

Name  : MMClick              (Mouse Click)
Class : Mouse
Level : BIOS

The MMClick routine allows you to find out which mouse buttons
have been pressed since you last checked, and how many times
they were pressed. Although it will work with any mouse, it is
designed specifically for a mouse with two buttons (see also
MMClick3).  If you want to find out which buttons are currently
being pressed, try MMButton instead.

This routine will not work properly if there is no mouse
available.  Use the MMCheck routine if you are not sure.

   CALL MMClick (LeftB%, RightB%)

-------
LeftB%     # of times left button was pressed since last check
RightB%    # of times right button was pressed since last check

Name  : MMClick3             (Mouse Click for 3-button mouse)
Class : Mouse
Level : BIOS

The MMClick3 routine allows you to find out which mouse buttons
have been pressed since you last checked, and how many times
they were pressed. Although it will work with any mouse, it is
designed specifically for a mouse with three buttons (see also
MMClick).  If you want to find out which buttons are currently
being pressed, try MMButton3 instead.

This routine will not work properly if there is no mouse
available.  Use the MMCheck routine if you are not sure.

   CALL MMClick3 (LeftB%, MiddleB%, RightB%)

-------
LeftB%     # of times left button was pressed since last check
MiddleB%   # of times middle button was pressed since last look
RightB%    # of times right button was pressed since last check

Name  : MMCursorOff          (Mouse Cursor Off)
Class : Mouse
Level : BIOS

This routine makes the mouse cursor invisible.  The mouse
cursor will still function as a location indicator, in the same
way that the normal cursor still functions when you make it
invisible.

Note that the mouse cursor is somewhat bizarre in that an
"invisibility level" is kept.  Every time you use MMCursorOff,
the invisibility depth is increased; subsequent attempts to
make the cursor visible will not actually do so until the
invisibility depth reaches zero.  In other words, if you call
MMCursorOff when the cursor is already invisible, the cursor
will not reappear until you've told it to reappear as many
times as you told it to disappear.  This is fairly demented,
but that's the way Microsoft made it.

This routine will not work properly if no mouse is installed.
See MMCheck.

   CALL MMCursorOff

Name  : MMCursorOn           (Mouse Cursor On)
Class : Mouse
Level : BIOS

This routine makes the mouse cursor visible, or tries to do
so...

The mouse cursor is somewhat bizarre in that an "invisibility
level" is kept.  Every time you use MMCursorOff, the
invisibility depth is increased; subsequent attempts to make
the cursor visible will not actually do so until the
invisibility depth reaches zero.  In other words, if you call
MMCursorOff when the cursor is already invisible, the cursor
will not reappear until you've told it to reappear (with
MMCursorOn) as many times as you told it to disappear.  This is
fairly demented, but that's the way Microsoft made it.

This routine will not work properly if no mouse is installed.
See MMCheck.

   CALL MMCursorOn

Name  : MMGetLoc             (Mouse Get Location)
Class : Mouse
Level : BIOS

This routine allows you to get the current location of the
mouse cursor.  It doesn't matter if the cursor is visible or
invisible.

The mouse cursor location is somewhat perverse in CGA and text
modes, due to the sloppy design of Microsoft's original mouse
driver.  In text modes and both CGA graphics modes, the cursor
is returned as if the screen is 640x200. To correct this for
SCREEN 1, divide the X coordinate by two.  To correct this for
text modes, divide each coordinate by eight.

This routine will not work properly if there is no mouse
available.  Use the MMCheck routine if you are not sure.

See also GetMouseLoc, which returns the appropriate coordinates
for text mode.

   CALL MMGetLoc (X%, Y%)

-------
X%         X coordinate ("column")
Y%         Y coordinate ("row")

Name  : MMSetLoc             (Mouse Set Location)
Class : Mouse
Level : BIOS

This routine allows you to set the current location of the
mouse cursor.  It doesn't matter if the cursor is visible or
invisible.

The mouse cursor location is somewhat perverse in CGA and text
modes, due to the sloppy design of Microsoft's original mouse
driver.  In text modes and both CGA graphics modes, the cursor
is returned as if the screen is 640x200. To correct this for
SCREEN 1, double the X coordinate.  To correct this for text
modes, multiply each coordinate by eight and add four.

This routine will not work properly if there is no mouse
available.  Use the MMCheck routine if you are not sure.

See also SetMouseLoc, which does the coordinate conversions for
you in text mode.

   CALL MMSetLoc (X%, Y%)

X%         X coordinate ("column")
Y%         Y coordinate ("row")

Name  : MMSetRange           (Mouse Set Range)
Class : Mouse
Level : BIOS

This routine allows you to set the allowable range of mouse
cursor locations. The mouse cursor will not be permitted to go
outside this range.  It doesn't matter if the cursor is visible
or invisible.

The mouse cursor location is somewhat perverse in CGA and text
modes, due to the sloppy design of Microsoft's original mouse
driver.  In text modes and both CGA graphics modes, the cursor
is returned as if the screen is 640x200. To correct this for
SCREEN 1, double the X coordinate.  To correct this for text
modes, multiply each coordinate by eight and add four.

This routine will not work properly if there is no mouse
available.  Use the MMCheck routine if you are not sure.

   CALL MMSetRange (X1%, Y1%, X2%, Y2%)

X1%       left   X coordinate (upper left "column")
Y1%       top    Y coordinate (upper left "row")
X2%       right  X coordinate (lower right "column")
Y2%       bottom Y coordinate (lower right "row")

Name  : Month0               (Month)
Class : String / Time
Level : Any

Given a month number, this routine tells you the name of the
month.

   MonthName$ = SPACE$(9)
   CALL Month0 (MonthName$, NameLen%, MonthNr%)
   MonthName$ = LEFT$(MonthName$, NameLen)

MonthNr%    month number (1-12)
-------
MonthName$  name of the month.  Init to at least 9 characters.
NameLen%    length of the month name

Name  : MouseBuffer          (Mouse Buffer size)
Class : Mouse
Level : BIOS

This routine is used before MouseSave in order to find out how
many bytes are needed to save the mouse state.

This routine will not work properly if there is no mouse
available.  Use the MMCheck routine if you are not sure.

   CALL MouseBuffer (Bytes%)
   St$ = SPACE$(Bytes%)
   CALL MouseSave (St$)

-------
Bytes%     number of bytes needed to save the state of the mouse

Name  : MouseCursor          (Mouse Cursor type)
Class : Mouse
Level : BIOS

The MouseCursor routine allows you to select one of a number of
graphics mouse cursors.  The following types are supported:

    0   hourglass ("please wait" symbol)
    1   standard arrow pointer
    2   pointing hand
    3   crosshair
    4   target (box-in-a-box pointer)
    5   grabbing hand

If you'd like other shapes, please suggest a few!  I'll be glad
to add them.

   CALL MouseCursor (CursorNr%)

CursorNr%    type of mouse graphics cursor to use (see above)

Name  : MousePen             (Mouse light Pen emulation)
Class : Mouse
Level : BIOS

The mouse can be made to emulate a light pen, allowing you to
use BASIC's light pen routines to provide a certain minimal
level of support for both light pens and mice.  This emulation
is on by default, but you can turn it off in case there is an
actual light pen attached.

This routine will not work properly if there is no mouse
available.  Use the MMCheck routine if you are not sure.

   CALL MousePen (EmulatePen%)

EmulatePen%   whether mouse should emulate light pen (0 no)

Name  : MouseRest            (Mouse status Restore)
Class : Mouse
Level : BIOS

This routine is for use in conjunction with MouseSave.  It
allows you to restore the mouse settings to a state that was
saved in the past.

This routine will not work properly if there is no mouse
available.  Use the MMCheck routine if you are not sure.

   CALL MouseRest (St$)

St$        mouse state to restore

Name  : MouseSave            (Mouse status Save)
Class : Mouse
Level : BIOS

This one is handy for use in subprograms or when SHELLing to
other programs that may use the mouse.  It allows you to save
the current mouse settings as a string.  To find out how long
the string should be, use MouseBuffer.

This routine will not work properly if there is no mouse
available.  Use the MMCheck routine if you are not sure.

   CALL MouseBuffer (Bytes%)
   St$ = SPACE$(Bytes%)
   CALL MouseSave (St$)

-------
St$        saved mouse state.  Init as shown above.

Name  : MPrint               (MS-DOS Print)
Class : Display
Level : BIOS

The MPrint routine displays text using mostly DOS services.
This allows it to handle ANSI codes if an ANSI driver is
installed.  In addition, the output of MPrint is confined to a
region of the screen that you may select with MWindow.  By
default, the region is 1,1 to 25,80: a full 80x25 text screen.

Using MPrint is similar to using PRINT followed by a semicolon.
It does not automatically move to the next line.  To do so, you
must MPrint a carriage return and linefeed: CHR$(13) + CHR$(10).

To clear the MWindow region, MPrint a formfeed: CHR$(12).

   CALL MPrint (St$)

St$         string to display

Name  : MulMatI              (Multiply Matrix by Integer)
Class : Array management
Level : Any

This routine multiplies as many elements of an integer array as
you like by a given number, starting at a specified place in
the array.  If there was a numeric overflow at any point in the
operation, an error code will be returned.

   CALL MulMatI (DSeg%, DOfs%, Elements%, Value%, ErrCode%)

DSeg%      segment of the array element to start at
DOfs%      offset of the array element to start at
Elements%  number of array elements to process
Value%     value to multiply each array element by
-------
ErrCode%   error code: 0 if no error

Name  : MultiAND             (Multiple AND)
Class : String
Level : Any

The MultiAND routine performs an arithmetic "AND" operation on
each character in a string.

Among the varied uses for MultiAND is stripping the high bit
from characters, as you might want to do in telecommunications
or in converting WordStar files.  In that case, you would use a
BitMask% of 127.

   CALL MultiAND (St$, BitMask%)

St$        string to process
BitMask%   bit mask (0-255) with which to AND each character
-------
St$        processed string

Name  : MultiOR              (Multiple OR)
Class : String
Level : Any

The MultiOR routine performs an arithmetic "OR" operation on
each character in a string.

   CALL MultiOR (St$, BitMask%)

St$        string to process
BitMask%   bit mask (0-255) with which to OR each character
-------
St$        processed string

Name  : MultiXOR             (Multiple XOR)
Class : String
Level : Any

The MultiXOR routine performs an arithmetic "XOR" operation on
each character in a string.

   CALL MultiXOR (St$, BitMask%)

St$        string to process
BitMask%   bit mask (0-255) with which to XOR each character
-------
St$        processed string

Name  : MWindow              (MS-DOS Window)
Class : Display
Level : Any

The MWindow routine works in conjunction with MPrint.  It
defines an area of the screen in which text displayed by MPrint
must stay.  The default window is 1,1 to 25,80.

   CALL MWindow (TopRow%, LeftCol%, BottomRow%, RightCol%)

TopRow%     top row
LeftCol%    left column
BottomRow%  bottom row
RightCol%   right column

Name  : NumProc              (Numeric Processor)
Class : Equipment
Level : Any

NumProc returns the type of numeric coprocessor installed.  I
haven't tried it with a 80486, but I would guess an 80486
always appears to have an 80387 (unless it's one of those
brain-damaged 80486SX chips).

Results are returned as follows:

   0    no math chip
   1    8087
   2    80287
   3    80387

If anyone can tell me how to better handle a 486 here, I'd
appreciate it.

   CALL NumProc (ProcType%)

-------
ProcType%    type of numeric coprocessor (see above)

Name  : OrSt                 (OR String)
Class : String
Level : Any

This routine ORs each byte in one string with the corresponding
byte in a second string.  The strings must be the same length.

   CALL OrSt (St1$, St2$)

St1$      string to OR
St2$      string to OR with
-------
St1$      result

Name  : PCDate               (PC Date)
Class : Equipment
Level : Clone

The PCDate routine tells you the date of the BIOS ROM chip.
This date is not always available on some (mostly older)
clones, in which case "No Date " is returned.

   ROMDate$ = SPACE$(8)
   CALL PCDate (ROMDate$)

-------
ROMDate$   date of the BIOS ROM (xx/xx/xx).  Init to 8+ chars.

Name  : PCType               (PC Type)
Class : Equipment
Level : Clone

This routine returns the machine I.D. code.  This code may not
be one of the listed values for some (mostly older) clones, but
the following is usually correct:

   I.D.  ....Machine....
   255   PC or XT
   254   XT
   253   PCjr
   252   PC AT
   251   XT
   250   PS/2 Model 30
   249   PC Convertible
   248   PS/2 Model 70 or 80
   154   Compaq Portable
    45   Compaq Portable

Note that, for identification purposes, a PC and XT are
essentially the same. The XT is simply a PC with an auto-boot
hard drive.  New I.D. numbers come out more or less at random
from IBM, although they aren't as capricious about it as they
used to be.  It is useful to identify Compaq Portables as
separate from PCs because those machines had an unusual
display, which acts like a CGA but has the resolution (in text
modes) of an MDA.  Hence, the cursor size of a Compaq Portable
is MDA-sized in text mode, but CGA-sized in graphics modes,
even though ordinary tests will tell your program that a CGA is
attached.  If you intend to alter the cursor size, this is an
important distinction, since the Compaq Portable was a great
success and is still in wide use.  Current Compaq machines,
like most other clones, follow the standard IBM I.D. codes.

   CALL PCType (MachineID%)

-------
MachineID%   type of computer

Name  : PrinterInit          (Printer Initialize)
Class : Printer
Level : BIOS

This routine initializes a printer in the same way as if the
computer had been rebooted.

Note that this will not work on serial printers, even if the
MODE command was used to redirect the port.  It works at the
BIOS level, so it doesn't know about any fooling around DOS
does.

   CALL PrinterInit (Port%)

Port%         parallel port number (1-3)

Name  : PrintScreen          (Print Screen)
Class : Display / Printer
Level : BIOS

Just like pressing the PrtSc/PrintScrn key on the keyboard,
this routine sends the contents of the display to the printer.
It is mostly designed for text modes, but use of the GRAPHICS
TSR provided with DOS will allow it to print out CGA graphics
displays as well.  For some reason, the GRAPHICS utility does
not handle Hercules, EGA or VGA displays; however, alternative
utilities which provide such features may be obtained from your
local BBS.

   CALL PrintScreen

Name  : Processor            (Processor)
Class : Equipment
Level : Any

Processor returns the type of processor (CPU) installed.

Results are returned as follows:

   0    NEC V20
   1    8088 or 8086
   2    80186
   3    80286
   4    80386
   5    80486

Note that, for most practical purposes, a NEC V20 works just
like an 80186.

   CALL Processor (ProcType%)

-------
ProcType%    type of CPU (see above)

Name  : PrtSc                (Print Screen key)
Class : Input / Printer
Level : BIOS

This routine allows you to disable the "print screen" key.
This only affects the keyboard, not the PrintScreen routine in
PBBack.

If you disable the "print screen" key, be sure to enable it
again before your program ends.  Otherwise, the "print screen"
key will be left in an undefined state, probably causing the
computer to crash when it is next pressed.

   CALL PrtSc (Enable%)

Enable%   whether "print screen" should be enabled (0 no)

Name  : PrtSwap              (Printer Swap)
Class : Printer
Level : Clone

It's handy to use LPRINT, but it isn't always practical.
LPRINT only works on the first printer available (PRN or
LPT1).  With this routine, it doesn't matter.  PrtSwap allows
you to swap any two printer ports.

Note that it's a good idea to swap the ports back to their
original locations before exiting your program.  You could
cause major confusion otherwise!

   CALL PrtSwap (Port1%, Port2%)

Port1%    number of the first port (1-3)
Port2%    number of the second port (1-3)

Name  : PutScreen            (Put Screen)
Class : Display
Level : Clone

This routine restores a portion of the display (which was saved
to an array by DGetScreen or GetScreen) to the screen.  Only
text modes are supported. If your program uses multiple display
pages, you can put the image onto any of those pages.  A
special "slow" mode is supported for the CGA, to prevent
flickering (a problem only with some CGAs).

If you wish to restore the entire screen, you may find ScrRest
easier (see).

   CALL PutScreen (Array%(), TRow%, LCol%, BRow%, RCol%, _
      Page%, Fast%)

Array%()   array from which to restore the image
TRow%      top row of the desired screen area
LCol%      left column of the desired screen area
BRow%      bottom row of the desired screen area
RCol%      right column of the desired screen area
Page%      page on which to restore the display
Fast%      whether to use fast mode (0 no)

Name  : QPrint               (Quick Print)
Class : Display
Level : Clone

This is a replacement for the PRINT statement.  It is less
flexible in that it does not move the cursor or interpret
control codes, and because it uses the color that is already on
the screen instead of a specified color value. It also works
only in text modes.

In exchange, QPrint gives you much faster display speeds.

See also XQPrint, which is a bit more flexible (and somewhat
slower).

   CALL QPrint (St$, Row%, Column%, Page%, Fast%)

St$        text to display
Row%       starting row
Column%    starting column
Page%      page on which to display
Fast%      whether to use fast mode (0 no)

Name  : ReadBitF             (Read Bit Field)
Class : Numeric
Level : Any

This routine allows you to get an element of a virtual array.
The actual array can be any numeric type, as it is just being
used as a storage area. The virtual array is composed of
numbers of a bit length that you specify (1-8).  This provides
efficient storage for numbers which have a limited range.

See also WriteBitF.

   CALL ReadBitF (DSeg%, DOfs%, ElementNr%, BitLen%, Value%)

DSeg%        segment of actual array
DOfs%        offset of actual array
ElementNr%   virtual element number (starts at 0)
BitLen%      bits per virtual element (1-8)
-------
Value%       result (0-255 or less, depending on BitLen%)

Name  : Reboot               (Reboot)
Class : Miscellaneous
Level : Clone

This routine restarts the computer, just like typing
Control-Alt-Del at the keyboard.

   CALL Reboot

Name  : Recolor              (Recolor)
Class : Display
Level : Clone

The Recolor routine changes all text in one color to another
color.  It works only in text modes.  The colors are specified
as attributes (see CalcAttr).

   CALL Recolor (OldAttr%, NewAttr%)

OldAttr%   color to be changed
NewAttr%   color to which to change

Name  : RecolorArea          (Recolor Area)
Class : Display
Level : Clone

The RecolorArea routine changes a specified area of the screen
to a specified color.  It works only in text modes.  The color
is specified as an attribute (see CalcAttr).

See also HiLite, which provides an easier way of highlighting
between two columns on a single row.

   CALL RecolorArea (TRow%, LCol%, BRow%, RCol%, VAttr%, _
      Page%, Fast%)

TRow%       top row of area to recolor
LCol%       left column of area to recolor
BRow%       bottom row of area to recolor
RCol%       right column of area to recolor
VAttr%      desired color
Page%       display page (normally zero)
Fast%       whether to use fast mode (0 no)

Name  : Rename               (Rename file)
Class : Disk
Level : DOS

This routine allows you to rename an ordinary file.  See also
RenSub.

   CALL Rename (CurrentName$, NewName$, ErrCode%)

CurrentName$   current name of the file
NewName$       desired name of the file
-------
ErrCode%       error code: 0 if no error, else DOS Error

Name  : RenSub               (Rename Subdirectory)
Class : Disk
Level : DOS

This routine provides a service that was inexplicably left out
of the DOS command shell.  It allows you to rename a
subdirectory.

Note that renaming a subdirectory is only possible using
old-style FCB file handling.  This means that the subdirectory
which you specify must be in the current directory (the routine
doesn't really understand subdirectories per se, but treats
them like any other file).  In this implementation, no drive
specification is allowed either.  Finally, if there is an
error, the error code may be a simple "255" instead of a useful
disk error number.

   CALL RenSub (CurrentSub$, NewSub$, ErrCode%)

CurrentSub$   current name of the subdirectory
NewSub$       desired name of the subdirectory
-------
ErrCode%      error code: 0 if no error, else DOS Error

Name  : Replace              (Replace character)
Class : String
Level : Any

This routine replaces all occurrences of a given character in a
string with another character.

   CALL Replace (St$, CurCh$, NewCh$)

St$         string to process
CurCh$      character to be replaced
NewCh$      character to replace with
-------
St$         processed string

Name  : Retries              (Retries)
Class : Disk
Level : DOS 3.1+

This routine allows you to adjust the handling of file-sharing
errors.  When such an error occurs, DOS normally retries 3
times, with a wait of 1 between tries.  This allows temporary
conditions, such as someone else using the file you want to
access, to clear up.  In many cases, though, you may want to
change this delay.  A shorter delay will improve response time,
allowing your program to handle the error more quickly.  A
longer delay may be more suited for a busy network, allowing
the request to proceed after a reasonable waiting period.

The delay period between each retry is unfortunately
machine-dependent, i.e., you will need larger delays on faster
machines to achieve the same effect.  This can only be
considered a flaw in DOS.

Note that shorter waiting periods will improve response time
for your program, but may adversely affect the network.
Normally, you should use the longest waiting period with which
you feel comfortable.

   CALL Retries (Times%, WaitTime%)

Times%     # of times to retry if file-sharing violation occurs
WaitTime%  amount of time to delay between retries

Name  : Reverse              (Reverse)
Class : String
Level : Any

This little fellow reverses the order of the characters in a
string.  It is one of the vital components of RInstr, but other
than that I see no real use for it.  On the other hand, George
Boole thought that Boolean logic was of solely theoretical
interest, and yet without it there would be no computers. I
leave it to you to find the earth-shattering possibilities of
Reverse!

   CALL Reverse (St$)

St$      string to be reversed
-------
St$      reversed string

Name  : RotateL              (Rotate Left)
Class : Numeric
Level : Any

This routine rotates the bits in an integer left by a desired
amount.

   CALL RotateL (Value%, Count%)

Value%    number to rotate left
Count%    bits by which to rotate
-------
Value%    rotated number

Name  : RotateR              (Rotate Right)
Class : Numeric
Level : Any

This routine rotates the bits in an integer right by a desired
amount.

   CALL RotateR (Value%, Count%)

Value%    number to rotate right
Count%    bits by which to rotate
-------
Value%    rotated number

Name  : RRotate              (Right Rotate string)
Class : String
Level : Any

This routine rotates the characters in a string right once.
I'll admit that I haven't found a use for this myself, but
people are always coming up with new uses for things... and it
complements the more useful LRotate routine.

See also LRotate.

   CALL RRotate (St$)

St$      string to be rotated right once
-------
St$      string after being rotated right once

Name  : RScroll              (Right Scroll)
Class : Display
Level : Clone

This routine scrolls any selected part of the display right.
You may scroll as many times as you like, or scroll "zero"
times to totally clear the selected part of the display.

   CALL RScroll (TopRow%, LeftCol%, BottomRow%, RightCol%, _
      Times%)

TopRow%      top row of the area to scroll
LeftCol%     left column of the area to scroll
BottomRow%   top row of the area to scroll
RightCol%    left column of the area to scroll
Times%       number of times (or rows) to scroll

Name  : ScanKey              (Scan Keyboard)
Class : Input
Level : BIOS

This one's like INKEY$, but a little bit more subtle.  It will
tell you if there's a key waiting (and if so, what key it is)
without actually getting the key.  The key will remain
available for later retrieval.

Among the more common uses for this routine is to handle keys
like Control-S (pause the display) and Control-C (abort).  You
can see if these keys have been pressed without disturbing
anything else the user might have typed.  DOS uses exactly this
technique for handling these keys.  Since BASIC doesn't go
through DOS I/O, though, the only way for you to support such
nice features is to write them into your program with ScanKey.

   CALL ScanKey (CharCode%, CharType%)

-------
CharType%   key type: 0 none, 1 normal, 2 extended (scan code)
CharCode%   key ASCII or scan code

Name  : Scroll               (Scroll)
Class : Display
Level : BIOS

This routine scrolls any selected part of the display up.  You
may scroll as many times as you like, or scroll "zero" times to
totally clear the selected part of the display.

Note that BIOS-level scrolling can cause the screen to flicker
on some CGAs due to a combination of unfortunate design factors.

   CALL Scroll (TopRow%, LeftCol%, BottomRow%, RightCol%, _
      Times%)

TopRow      top row of the area to scroll
LeftCol%    left column of the area to scroll
BottomRow   top row of the area to scroll
RightCol%   left column of the area to scroll
Times%      number of times (or rows) to scroll

Name  : ScrRest              (Screen Restore)
Class : Display
Level : Clone

The ScrRest routine restores a display that was saved using
ScrSave or a similar routine.  It only works in text modes, and
expects an 80x25 screen.  See PutScreen or DPutScreen if you
need to work with other screen sizes.

   CALL ScrRest (Array%(), Page%, Fast%)

Array%()   array holding the display information
Page%      page on which to restore the display
Fast%      whether to use fast mode (0 no)

Name  : ScrSave              (Screen Save)
Class : Display
Level : Clone

The ScrSave routine saves the display to an integer array.
Only text modes are supported.  For an 80x25 display, the array
must hold 4,000 bytes, so you would use DIM Array%(1 TO 2000).

ScrSave expects an 80x25 screen.  Use GetScreen or DGetScreen
if you need to work with other screen sizes.

   CALL ScrSave (Array%(), Page%, Fast%)

Page%      display page to get
Fast%      whether to use fast mode (0 no)
-------
Array%()   saved display information

Name  : SCrunch              (Screen Crunch)
Class : Display
Level : Any

This routine is designed to be used in conjunction with ScrSave
and the other routines which store an entire 80x25 text screen
in an array.  It performs a "screen crunch", compressing the
original data into a new array.  The average result is about 8x
smaller than the original screen, resulting in a vast savings
in memory (4,000 bytes vs 500 or so).  The compression
algorithm is very fast and will not take any noticeable amount
of time for most purposes.

Besides saving main memory, this is great for storing screens
as disk files! The compression will not only make the file(s)
smaller, but will make disk access faster since there is less
information to transfer.

   CALL SCrunch (DSeg%, DOfs%, CSeg%, COfs%, Bytes%)

DSeg%     segment of the original screen image
DOfs%     offset of the original screen image
CSeg%     segment of array in which to store compressed image
COfs%     offset of array in which to store compressed image
-------
Bytes%    number of bytes in the compressed image

Name  : SetBit               (Set Bit)
Class : Numeric
Level : Any

This routine sets a single bit "on" in an integer.  Bits are
numbered 0-15, with 0 being the least significant bit.

   CALL SetBit (Number%, BitNr%)

Number%    number for which to set bit
BitNr%     bit number (0-15) to set
-------
Number%    number with the specified bit set

Name  : SetCGAColor          (Set CGA Color)
Class : Display
Level : Clone

This routine allows you to set certain aspects of CGA colors
which aren't available otherwise.  It is very CGA-specific,
however, and may not work on EGA or VGA systems.

The color specified has different meanings in different CGA
modes.  In the SCREEN 1 graphics mode, it changes the
background and border color.  In SCREEN 2, however, it allows
you to change the foreground color.  While you are still stuck
with a single foreground color, you can choose what that color
will be.

   CALL SetCGAColor (Colour%)

Colour%    color to set (see above)

Name  : SetComm              (Set Comm port)
Class : Serial
Level : DOS

Although QuickBASIC has a fair range of communications support,
it doesn't do the capabilities of the PC full justice.  It's
also impossible to change the serial parameters "on the fly"
without risking disconnection, if BASIC alone is used.  SetComm
gets around those limitations.  It should be used -after- the
appropriate comm port is OPENed by BASIC.

Note that the true upper limits of the comm speed are
determined by your program and by the hardware being used.
Some PC/XTs may have trouble with 9,600 bps, for instance.  The
ability to set the serial port to a high speed doesn't
guarantee that the hardware can handle it!

   CALL SetComm (CommPort%, Bps%, Parity%, WordLength%, _
      StopBits%)

CommPort%    serial port (1-4, though BASIC only uses 1-2)
Bps%         bits per second ("baud rate"):
                0 for   300       5 for   9,600
                1 for   600       6 for  19,200
                2 for 1,200       7 for  38,400
                3 for 2,400       8 for  57,600
                4 for 4,800       9 for 115,200
Parity%      parity:
                0  none
                1  odd            3  mark  (always on)
                2  even           4  space (always off)
WordLength%  word length (5-8)
StopBits%    stop bits (1-2; if WordLength=5, "2" means 1 1/2)

Name  : SetCommAddr          (Set Comm Address)
Class : Serial
Level : Clone

This routine allows you to set the base port address of a
serial port.

One use for SetCommAddr is to give QuickBASIC access to the
comm port on those unusual machines which have a COM2 but no
COM1.  Use GetCommAddr to get the address of COM2, set the COM1
address accordingly, and tell QuickBASIC to use COM1.

BASIC will normally handle COM1 and COM2, but not COM3 or
COM4.  Although there is no way to use more two ports at once,
you can fool BASIC into using COM3 by swapping it with COM1, or
COM4 by swapping it with COM2.

Don't forget to set the ports back to their original values
before your program ends!

   CALL SetCommAddr (PortNr%, PortAddr%)

PortNr%     COM port number (1-4)
PortAddr%   port address

Name  : SetDateAT            (Set Date of AT clock)
Class : Time
Level : BIOS (AT)

This routine sets the date of the hardware real-time clock in
AT-class computers.  Depending on the DOS version, this date
may be partially or completely independent of the date kept by
DOS in software.  DOS always reads the date from the hardware
clock when it starts up.  However, use of the DATE command in
DOS (and the DATE$ function in QuickBASIC) may relate only to
the software copy of the date, which is not always guaranteed
to be the same as the date in the hardware clock due to certain
discrepancies in DOS.

You may express the year as either a two-digit or four-digit
number.

The ProBas and PBBack versions of this routine do not work the
same way in regards to the year.  ProBas assumed that any
two-digit year was in the 1900s.  In contrast, PBBack assumes
that years 80-99 should be converted to 1980-1999 and that 0-79
should be converted to 2000-2079.  I consider the PBBack method
more appropriate, with the turn of the century moving closer.
The date format used does not allow dates before 1980 anyway,
so nothing is being lost by this change.

   CALL SetDateAT (MonthNr%, DayNr%, YearNr%)

MonthNr%    month number (1-12)
DayNr%      day (1-31)
YearNr%     year (1980-2079; see above for two-digit years)

Name  : SetDrv               (Set default Drive)
Class : Disk
Level : DOS

This routine sets the default disk drive.

If the specified drive does not exist, the current default
drive will remain the default.

   CALL SetDrv (Drive$)

Drive$    drive letter

Name  : SetError             (Set Error code)
Class : Miscellaneous
Level : DOS

The SetError routine allows you to set the "error level" to be
returned by DOS when your program ends.  This is particularly
handy for returning information to batch files.

Note that SetError is best used just before your program ENDs,
to avoid complications.

   CALL SetError (ErrorLevel%)

ErrorLevel%   exit code to be returned by your program

Name  : SetFAttr             (Set File Attribute)
Class : Disk
Level : DOS

This routine allows you to set the attribute of a file or
subdirectory.  Any combination of the following may be set:

   Normal          0      (nothing special)
   Read Only       1      file can be read, but not written to
   Hidden          2      file will be "invisible"
   System          4      (for special DOS files-- leave alone)
   Archive        32      (used by some backup utils- leave be)

To set more than one attribute, just add the numbers for the
desired attributes together.  The attributes marked "leave
alone" shouldn't be used casually, but if you're sure you know
what you're doing...

   CALL SetFAttr (FileName$, FAttr%)

FileName$   name of the file (or subdirectory) to manipulate
FAttr%      attribute(s) to set

Name  : SetFTD               (Set File Time and Date)
Class : Disk
Level : DOS

This routine lets you set the time and date of a specified
file.  You may give the year either as two digits or four
digits.

The ProBas and PBBack versions of this routine do not work the
same way in regards to the year.  ProBas assumed that any
two-digit year was in the 1900s.  In contrast, PBBack assumes
that years 80-99 should be converted to 1980-1999 and that 0-79
should be converted to 2000-2079.  I consider the PBBack method
more appropriate, with the turn of the century moving closer.
The DOS date format does not allow dates before 1980 anyway, so
nothing is being lost by this change.

Note that the Second% value, if odd, will be rounded down to an
even number. This is due to the way DOS compresses the time
format, rather than any limitation in this routine.

   CALL SetFTD (File$, MonthNr%, DayNr%, YearNr%, HourNr%, _
      MinuteNr%, SecondNr%)

File$        name of file for which to set the time and date
MonthNr%     month number (1-12)
DayNr%       day (1-31)
YearNr%      year (1980-2079; see above for two-digit years)
HourNr%      hour (0-23)
MinuteNr%    minute (0-59)
SecondNr%    second (0-59; if odd, rounded down to even number)
-------
MonthNr%     -1 if there was an error, else unchanged

Name  : SetKbd               (Set Keyboard toggles)
Class : Input
Level : Clone

The SetKbd routine allows you to set the state of any of the
four keyboard toggles: Insert, Caps lock, Num lock, and Scroll
Lock.  You can give your input routines a professional touch by
setting this toggles instead of making the user remember to do
so.

It's considered proper to restore the original keyboard toggles
before your program exits, unless of course the purpose of the
program is to leave the toggles in a particular state!  The
GetKbd routine can be used in conjunction with SetKbd to do
this.

   CALL SetKbd (Insert%, Caps%, Num%, Scrl%)

Insert%    whether to turn on "insert" mode (0 if no)
Caps%      whether to turn on "caps lock" (0 if no)
Num%       whether to put the keypad into numeric mode (0 no)
Scrl%      whether to turn on "scroll lock" (0 if no)

Name  : SetMatI              (Set Matrix to Integer)
Class : Numeric
Level : Any

This routine sets as many elements of an integer array as you
like, starting at a specified place in the array.  A good use
for it is to initialize an array (or a portion of it) to a
given value.

   CALL SetMatI (DSeg%, DOfs%, Elements%, Value%)

DSeg%      segment of the first array element to add
DOfs%      offset of the first array element to add
Elements%  number of array elements to which to add
Value%     value to which to set each array element

Name  : SetMouseLoc          (Set Mouse Location)
Class : Mouse
Level : BIOS

This routine allows you to set the current location of the
mouse cursor.  It doesn't matter if the cursor is visible or
invisible.  SetMouseLoc is only for use in text mode.

This routine will not work properly if there is no mouse
available.  Use the MMCheck routine if you are not sure.

See also MMSetLoc, which is for use in graphics modes.

   CALL SetMouseLoc (Row%, Column%)

Row%       mouse cursor row
Column%    mouse cursor column

Name  : SetPrtAddr           (Set Printer Address)
Class : Printer
Level : Clone

This routine allows you to set the base port address of a
parallel port.

One use for this routine is to fool BASIC into using a
different port than LPT1 for LPRINT.  See also PRTSWAP.

Note that PS/2 systems only have ports 1-3 available.  They use
the fourth port data area for holding other information.  It
may be a good idea to restrict yourself to ports 1-3 for
compatibility purposes, although other computers allow ports
1-4.

Don't forget to set the ports back to their original values
before your program ends!

   CALL SetPrtAddr (PortNr%, PortAddr%)

PortNr%     LPT port number (1-4 or 1-3 [see above])
PortAddr%   port address

Name  : SetSub               (Set default Subdirectory)
Class : Disk
Level : DOS

Just like the DOS CD (or CHDIR) command, this routine allows
you to change the current subdirectory.  Unlike the
corresponding DOS command, you may not use a period or double
period as shorthand for a directory.  However, you may specify
either an absolute or relative path, as usual, and can also use
either slashes or backslashes as delimiters.

   CALL SetSub (SubDir$, ErrCode%)

SubDir$    subdirectory name
-------
ErrCode%   error code: 0 if no error, else a DOS Error number

Name  : SetTimeAT            (Set Time of AT clock)
Class : Time
Level : BIOS (AT)

This routine sets the time to the hardware real-time clock in
AT-class computers.  Depending on the DOS version, this time
may be partially or completely independent of the time kept by
DOS in software.  DOS always reads the time from the hardware
clock when it starts up.  However, use of the TIME command in
DOS (and the TIME$ function in QuickBASIC) may relate only to
the software copy of the time, which is not always guaranteed
to be the same as the time in the hardware clock due to certain
discrepancies in DOS.

   CALL SetTimeAT (HourNr%, MinuteNr%, SecondNr%)

HourNr%      hour (0-23)
MinuteNr%    minute
SecondNr%    second

Name  : SetVerify            (Set Verify state)
Class : Disk
Level : DOS

The SetVerify routine allows you to set the state of the DOS
VERIFY flag. When VERIFY is on, some checking is done to make
sure that writing to the disk works as requested.  The checks
are not very good, however, and VERIFY slows down disk
handling, so it is usually better to have VERIFY off.

   CALL SetVerify (VerifyOn%)

VerifyOn%   whether to turn VERIFY on (0 if no)

Name  : SetVGAColor          (Set VGA Color)
Class : Display
Level : BIOS

This routine sets the color associated with a given color
number.  The color is specified as a combination of red, green,
and blue intensities.  Each intensity may range from off (0) to
very bright (63).

   CALL SetVGAColor (ColorNr%, Red%, Green%, Blue%)

ColorNr%   color number (1-16 or 1-255, depending on VGA mode)
Red%       red intensity (0-63)
Green%     green intensity (0-63)
Blue%      blue intensity (0-63)

Name  : SFRead               (String File Read)
Class : Disk / String
Level : DOS

This routine reads a string from a file that was opened by
FOpen1 or FCreate. The length of the string you provide
determines how many characters should be read.  If it wasn't
possible to read all the characters desired, an error code will
be returned and the BytesRead% value will tell you how many
characters were actually retrieved.

   St$ = SPACE$(BytesToRead%)
   CALL SFRead (Handle%, St$, BytesRead%, ErrCode%)

Handle%     handle of the file from which to read
-------
St$         data read from the file.  Init to # of chars wanted
BytesRead%  number of bytes read from the file (if error)
ErrCode%    error code: 0 if no error, else DOS Error

Name  : SFWrite              (String File Write)
Class : Disk / String
Level : DOS

This routine writes a string to a file that was opened by
FOpen1 or FCreate.  The length of the string you provide
determines how many characters will be written.  If it wasn't
possible to write the entire string to the file, an error code
will be returned and the BytesWrit% value will tell you how
many characters were actually written.

   CALL SFWrite (Handle%, St$, BytesWrit%, ErrCode%)

Handle%     handle of the file to which to write
St$         data to write to the file.
-------
BytesWrit%  number of bytes written to the file (if error)
ErrCode%    error code: 0 if no error, else DOS Error

Name  : ShiftL               (Shift Left)
Class : Numeric
Level : Any

This routine shifts the bits in an integer left by a desired
amount.  The effect of this is similar to multiplying the
number by a power of two, if the number is positive, but is
much faster.

   CALL ShiftL (Value%, Count%)

Value%    number to shift left
Count%    bits by which to shift
-------
Value%    shifted number

Name  : ShiftR               (Shift Right)
Class : Numeric
Level : Any

This routine shifts the bits in an integer right by a desired
amount.  The effect of this is similar to dividing the number
by a power of two, if the number is positive, but is much
faster.

   CALL ShiftR (Value%, Count%)

Value%    number to shift right
Count%    bits by which to shift
-------
Value%    shifted number

Name  : ShlSt                (Shift Left String of bits)
Class : String
Level : Any

This routine shifts the bits in a string left by a desired
amount.  This may be helpful for manupulating strings
containing bit flags, images, et al.

   CALL ShlSt (St$, Count%)

St$       string to shift left
Count%    bits by which to shift
-------
St$       shifted string

Name  : ShrSt                (Shift Right String of bits)
Class : String
Level : Any

This routine shifts the bits in a string right by a desired
amount.  This may be helpful for manupulating strings
containing bit flags, images, et al.

   CALL ShrSt (St$, Count%)

St$       string to shift right
Count%    bits by which to shift
-------
St$       shifted string

Name  : SortI                (Sort Integer)
Class : Array management
Level : Any

This routine sorts the elements in an array of integers.

The array is assumed to start at element 1.  You may specify
the last element in the array, allowing you to sort only part
of an array if you like.

If you would like the results to be largest-to-smallest, rather
than smallest-to-largest, just call ReverseI after this routine.

   CALL SortI (Array%(), Elements%)

Array%()    array to be sorted
Elements%   number of elements in array
-------
Array%()    sorted array

Name  : Soundex              (Soundex code)
Class : String
Level : Any

This is a string comparison routine which returns a code that
is loosely based on the "sound" of a word.  It removes the
vowels and repeated characters from a word, then converts it
into a numeric code.  Any words with the same code are
considered to sound alike.

While not perfect, this algorithm does a fast and reasonably
good job.  It can be helpful in applications like spelling
checkers and phone books, where a search based on exact text
may not be appropriate.

   Code$ = St$
   CALL Soundex (St$, Code$, CodeLen%)
   Code$ = LEFT$(St$, CodeLen%)

St$       string to be encoded
-------
Code$     result code.  Init to >= length of original string.
CodeLen%  length of the result code

Name  : SpeedKey             (Speed up Keyboard)
Class : Input
Level : BIOS (AT)

This routine provides control over the keyboard repeat rate for
AT-class machines.  Increasing the repeat rate can make the
computer seem a lot more responsive and pleasant to deal with.

  RepDelay%   Delay Time
     0        250 milliseconds
     1        500 ms
     2        750 ms
     3        1 second

  RepRate% is the key repeat rate, 0-31 (from around 30 cps to
  around 2 cps)

   CALL SpeedKey (RepDelay%, RepRate%)

RepDelay%   delay before starting to repeat (0-3, default 1)
RepRate%    rate at which to repeat key (0-31, default 11)

Name  : Split                (Split screen image)
Class : Display
Level : Clone

This provides an elegant way to clear a text-mode screen.  It
splits the display into four parts, scrolling each part up or
down until it slides off the screen.

   CALL Split

Name  : Spooler              (check for print Spooler)
Class : Printer
Level : DOS

The Spooler routine allows you to see whether the print spooler
(installed by the DOS PRINT utility) is available.

   CALL Spooler (Status%)

-------
Status%   spooler status:
             -1   it's installed
              0   it isn't installed, but can be
              1   it isn't installed, and can't be

Name  : StrDel               (String Delete)
Class : String
Level : Any

StrDel deletes a character from a string.  Actually, it doesn't
make the string any shorter, but it acts like a delete.  The
end of the string is filled with a space.

   CALL StrDel (St$, Posn%)

St$       string from which to delete a character
Posn%     position of the character to delete (1-LEN(St$))
-------
St$       processed string

Name  : StrIns               (String Insert)
Class : String
Level : Any

StrIns inserts a space into a string.  Actually, it doesn't
make the string any longer, but it acts like an insert.  The
former end of the string is discarded.

   CALL StrIns (St$, Posn%)

St$       string in which to insert a space
Posn%     where to insert the space (1-LEN(St$))
-------
St$       processed string

Name  : StripBlanks          (Strip Blanks)
Class : String
Level : Any

This routine strips leading and/or trailing white space from a
string.  This includes control characters as well as blanks
(anything below CHR$(33)).

See also StripSpaces.

   CALL StripBlanks (St$, Which%, StLen%)
   St$ = LEFT$(St$, StLen%)

St$      string to process
Which%   1: strip left, 2: strip right, 3: strip left and right
-------
St$      processed string
StLen    length of processed string

Name  : StripChar            (Strip Characters)
Class : String
Level : Any

This routine strips all occurrences of a given list of
characters out of a string.  Among the uses for this are
cleaning up user-entered values.  For instance, a strip list of
"$," would remove commas and dollar signs from a number, and
"()- " will remove telephone delimiters.

   CALL StripChar (St$, StripList$, StLen%)
   St$ = LEFT$(St$, StLen%)

St$         string to process
StripList$  characters to remove from the string
-------
St$         processed string
StLen%      length of processed string

Name  : StripRange           (Strip Range of characters)
Class : String
Level : Any

This routine strips an inclusive range of characters out of a
string.  The range is specified as the first and last ASCII
codes to strip.  For instance, using a low character of "0" and
a high of "9" would remove all digits from a string.

   CALL StripRange (St$, ASC(LowChar$), ASC(HighChar$), StLen%)
   St$ = LEFT$(St$, StLen%)

St$         string to process
LowChar$    lowest character to strip
HighChar$   highest character to strip
-------
St$         processed string
StLen%      length of processed string

Name  : StripSpaces          (Strip Spaces)
Class : String
Level : Any

This routine strips leading and/or trailing spaces from a
string.

See also StripBlanks.

   CALL StripSpaces (St$, Which%, StLen%)
   St$ = LEFT$(St$, StLen%)

St$      string to process
Which%   1: strip left, 2: strip right, 3: strip left and right
-------
St$      processed string
StLen%   length of processed string

Name  : SubExist             (Subdirectory Existence)
Class : Disk
Level : DOS

This routine lets you see if a given drive and/or subdirectory
actually exists.

   CALL SubExist (SubDir$, Found%)

SubDir$   name of the path to check
-------
Found%    whether the path exists (0 if no, -1 if yes)

Name  : Time2Int             (Time to Integer)
Class : Time
Level : Any

This routine compresses a time into a single integer.  Note
that this integer is not in a format that lends itself to
simple computation-- you cannot subtract one from another to
find out the length of time between them.  If that's what you
want, try the Elapsed routine.

Note that odd numbers of seconds will be rounded down to the
previous even number.  This is a result of the storage format
used.

   CALL Time2Int (HourNr%, MinuteNr%, SecondNr%, IntTimeNr%)

HourNr%      hour (0-23)
MinuteNr%    minute
SecondNr%    second
-------
IntTime%     time compressed into an integer

Name  : TimeN2S              (Time Numbers to String)
Class : Time
Level : Any / DOS

Many of the PBBack routines return the time as a set of
numbers.  This routine provides an easy way to convert those
numbers into string form.  The time format used (whether
seconds are included) will be based on the length of the string
which you pass to the routine.  For instance, a string like
"xx:xx" would return a time like "21:35", whereas "xx:xx:xx"
would return "21:35:08".

   TimeSt$ = "xx:xx:xx"
   CALL TimeN2S (HourNr%, MinuteNr%, SecondNr%, TimeSt$)

HourNr%     hour (0-23)
MinuteNr%   minute
SecondNr%   second
-------
TimeSt$     time string.  Init to 5 or 8 characters (see above).

Name  : TimeS2N              (Time String to Numbers)
Class : Time
Level : Any

Many of the PBBack routines need to be passed the time as a set
of numbers. This routine provides an easy way to convert a time
from string form into numbers.  You may use either "xx:xx:xx"
or "xx:xx" form to specify the time (the string length is
important, but the delimiter and contents of the string are
ignored).  If the 5-character short form is used, the Second%
value will be zero.

   CALL TimeS2N (HourNr%, MinuteNr%, SecondNr%, TimeSt$)

TimeSt$     time string.  Init to 5 or 8 characters (see above).
-------
HourNr%     hour (0-23)
MinuteNr%   minute
SecondNr%   second (0 if 5-char format)

Name  : TInstr               (Typed INSTR)
Class : String
Level : Any

As you might guess from the "Instr" part of the name, this
routine searches a string.  Instead of searching for a specific
character or substring, though, it looks for a specific type of
character-- letters, numbers, control codes, or whatever.  You
can search for the first of a combination of types, too, which
also allows searching for "anything but" a specific type.

The character type code is specified by adding any of the
following:

    1    alphabetic
    2    numeric
    4    symbolic
    8    control
   16    graphics
   32    space

The TInstr routine is handy for parsing and cleaning up user
input, among other uses.

   CALL TInstr (St$, ChrType%, Place%)

St$          string to search
ChrType%     type of character(s) to search for
-------
Place%       position of first char of desired type, or 0

Name  : TypeIn               (Type In)
Class : Input
Level : Clone

This is an unusual routine which combines both output and
input.  It sends a string to the keyboard buffer, where it acts
as if it had been typed in by someone.  The string may be up to
15 key codes in length (anything past 15 keys will be ignored,
due to the limited length of the keyboard buffer).

Normal keys can be put into the string simply as characters.
Extended keys, like Alt-key combinations, arrow keys, and
function keys, must be encoded as CHR$(0) + CHR$(ScanCode),
where the ScanCode is the key's scan code.  You can look up
such scan codes in your BASIC manual or use GetKey to find out
what they are.  Extended keys, although apparently taking up
two characters, only take up one space in the keyboard buffer.
The TypeIn routine allows for this fact.

Among other things, this routine can be used to provide default
answers to input routines, or to execute another program once
your program exits.

   CALL TypeIn (St$)

St$     keys to be "typed" into the keyboard buffer

Name  : UnCalcAttr           (Undo Calculated Attribute)
Class : Display
Level : Any

Many of the display routines in this library require an
"attribute" rather than foreground and background colors.  An
attribute is a combination of the foreground and background
colors in a format which is used by all types of displays when
in text mode.  The UnCalcAttr routine allows you to decode the
original colors given the attribute.

Foreground colors are usually specified as 0-31, with
backgrounds as 0-7.  If you turn blinking off (see Blink), it
may be more convenient to express the same thing as foreground
0-15, background 0-15.  The CalcAttr routine will accept either
way of expressing it.

Note, however, that UnCalcAttr will always return the former
pair of results, since it has no way of knowing whether Blink
has been used (foreground 0-31, background 0-15).  The below
routine shows how to get around this, if needed.

   CALL UnCalcAttr (Foreground%, Background%, VAttr%)
   ' the following is optional and may not be desired...
   ' it converts colors to "no blink" equivalents (see above)
   IF Foreground% AND 16 THEN _
      Foreground% = Foreground% - 16: _
      Background% = Background% + 8

VAttr%        color "attribute"
-------
Foreground%   foreground color
Background%   background color

Name  : UnSCrunch            (Undo Screen Crunch)
Class : Display
Level : Any

This routine is designed to be used in conjunction with ScrRest
and the other routines which restore an entire 80x25 text
screen from an array.  It expands screens that were compressed
by Scrunch to their full original size. The uncompression
algorithm is very fast and will not take any noticeable amount
of time for most purposes.

The array must be large enough to hold an 80x25 screen-- 4,000
bytes, or 2,000 integers: DIM FullScreen%(2000) will do it.

   CALL UnSCrunch (DSeg%, DOfs%, CSeg%, COfs%)

DSeg%     segment of array in which to store expanded image
DOfs%     offset of array in which to store expanded image
CSeg%     segment of the compressed image
COfs%     offset of the compressed image

Name  : Upcase               (Uppercase)
Class : String
Level : Any

This routine, like BASIC's UCASE$ function (in some versions),
converts a string to uppercase.  Since it doesn't have to
create a new return string (a fairly slow process), it's faster
than the BASIC equivalent, and it works in any version of
BASIC.

The Upcase routine is designed for the U.S. character set.  If
your program is intended for distribution, you would be well
advised to use Upcase1 instead, as it supports international
character sets.

   CALL Upcase (St$)

St$     string to be capitalized
-------
St$     capitalized string

Name  : Upcase1              (Uppercase)
Class : String
Level : DOS

This routine, like BASIC's UCASE$ function (in some versions),
converts a string to uppercase. It converts letters in the
extended character set as well as the usual letters, making it
well suited for text which may not be in English.

Note that DOS 5.0 is required for optimal performance.  With
older DOS versions, this routine makes assumptions about the
character set which may not be appropriate.

   CALL Upcase1 (St$)

St$     string to be capitalized
-------
St$     capitalized string

Name  : UpdTVScreen          (Update TopView Screen)
Class : Display
Level : BIOS

UpdTVScreen tells a TopView-compatible multitasker to update
the screen using a specified screen buffer (use GetTVScreen to
get the buffer location).  Some multitaskers will do this
automatically, but some won't.  It's safe to use this routine
either way.

See also GetDView, GetTView, GetTVScreen.

   CALL UpdTVScreen (DSeg%, DOfs%)

DSeg%       segment of screen buffer
DOfs%       offset of screen buffer

Name  : VGARest13            (VGA Restore for SCREEN 13)
Class : Display
Level : Clone

This routine allows you to restore a SCREEN 13 (VGA, 320x200,
256 color) display that was saved using VGASave13 (see).

   CALL VGARest13 (DSeg%, DOfs%)

DSeg%        segment of storage array
DOfs%        offset  of storage array

Name  : VGASave13            (VGA Save of SCREEN 13)
Class : Display
Level : Clone

This routine allows you to save a SCREEN 13 (VGA, 320x200, 256
color) display that can be restored using VGARest13 (see).

The array used to hold the screen must contain 64,000 bytes.
For an integer array, this means that you must create the array
by DIM Array%(1 TO 32000).

   CALL VGASave13 (DSeg%, DOfs%)

DSeg%        segment of storage array
DOfs%        offset  of storage array

Name  : WeekDay0             (Week Day)
Class : Time
Level : DOS

This routine tells you what the day of the week is, just the
thing for calendar programs and whatnot.  The day is returned
as a number from 1-7, which identifies a day from Sunday
through Saturday.

   CALL WeekDay0 (DayNr%)

-------
DayNr%     current day

Name  : WinCheck             (Windows Check)
Class : Equipment
Level : BIOS

The WinCheck routine tells you what version of Microsoft
Windows is in use, if any.  It returns the results as two
integers containing the major and minor version numbers.  For
instance, Windows 3.0 would return a major number of 3, minor
0.  Windows/386 v2.x will be identified as 2.0.  If Windows is
not running, 0.0 will be returned.  NOTE that this routine is
not able to detect Windows 1.x versions!

   CALL WinCheck (MajorV%, MinorV%)

-------
MajorV%   major part of the Windows version
MinorV%   minor part of the Windows version

Name  : WriteBitF            (Write Bit Field)
Class : Numeric
Level : Any

This routine allows you to set an element of a virtual array.
The actual array can be any numeric type, as it is just being
used as a storage area. The virtual array is composed of
numbers of a bit length that you specify (1-8).  This provides
efficient storage for numbers which have a limited range.

Here's how you DIM the actual array, assuming an integer array
is used:
   DIM Array%(1 TO (VirtElements * VirtBits + 15) \ 16)

"VirtElements" is the number of elements in the virtual array
and "VirtBits" is the number of bits per element.

See also ReadBitF.

   CALL WriteBitF (DSeg%, DOfs%, ElementNr%, BitLen%, Value%)

DSeg%        segment of actual array
DOfs%        offset of actual array
ElementNr%   virtual element number (starts at 0)
BitLen%      bits per virtual element (1-8)
Value%       value to set element to (range depends on BitLen%)

Name  : Xlate                (Translate)
Class : String
Level : Any

The Xlate routine allows for translating a string, character by
character, very quickly.  It uses a translation table that you
provide.  This table is 256 bytes long, one byte for each
character in the ASCII table.  The translation is done by
position-- for instance, if the original character was "A"
(ASCII 65), the translated character will be whatever is in the
translation table at position 66.  Why 66, when "A" is 65?
Because ASCII runs from 0-255, but the translation string is
1-256: everything is one higher in the string than the ASCII
character it represents.

Translation capabilities are handy in communications software.
They can also be used in other things.  One simple use would be
to set up a translation table where all lowercase characters
would be converted to uppercase.  You might ask why, since
BASIC has a UCASE$ function (in later versions, anyway) and
PBBack has an Upcase routine. Well, Upcase is faster than
UCASE$, since it doesn't have to create a return string; but
Xlate would be even faster, since it translates every character
directly instead of deciding whether it's a lowercase letter!

Simple encoding, WordStar file decryption, string reversal,
uppercase / lowercase conversion, and many other things can be
done with Xlate.

Remember to initialize all 256 characters in the translation
table!

   CALL Xlate (St$, XlateTable$)

St$          string to translate
XlateTable$  translation table
-------
St$          translated string

Name  : XMPrint              (Translate and MS-DOS Print)
Class : Display
Level : DOS

A combination of the Xlate and DMPrint routines, this 'un
allows you to display using DOS services while being able to
translate or screen out characters.  Each character of the
string to display is passed through a translation table you
provide (256 bytes, where each position corresponds directly to
the ASCII code of the same number [0-255]).  If the result is
0, the character is not displayed.  Otherwise, the translated
character is displayed using DOS display services.  The new
cursor position is returned so you can inform BASIC about it.

Note that the new cursor position may not be accurate!  Some
ANSI drivers do not update the BIOS cursor position info, in
which case the results won't be useful.  That's a hazard of
using DOS output.

   CALL XMPrint (St$, XlateTable$, Row%, Column%)
   LOCATE Row%, Column%

St$          string to display
XlateTable$  translation table
-------
Row%         current row
Column%      current column

Name  : XorSt                (XOR String)
Class : String
Level : Any

This routine XORs each byte in one string with the
corresponding byte in a second string.  The strings must be the
same length.

   CALL XorSt (St1$, St2$)

St1$      string to XOR
St2$      string to XOR with
-------
St1$      result

Name  : XQPrint              (Extended Quick Print)
Class : Display
Level : Clone

This routine provides a rather crude, but very fast, display
capability.  It works like the PRINT statement in BASIC, except
that it doesn't move the cursor or process control codes.  It
works only in text modes.

See also QPrint, a slightly less flexible (but even faster)
routine.

   CALL XQPrint (St$, Row%, Column%, VAttr%, Page%, Fast%)

St$       string to display
Row%      starting row
Column%   starting column
VAttr%    color/attribute (see CalcAttr)
Page%     display page (unused on MDA/Herc; normally 0)
Fast%     whether to use fast mode (0 no)

Name  : XQPrintOver          (Extended Quick Print Overwrite)
Class : Display
Level : Clone

This routine provides a rather crude, but very fast, display
capability.  It works like the PRINT statement in BASIC, except
that it doesn't move the cursor or process control codes.  It
works only in text modes.

This is a slightly unusual variant on a print routine.  It
displays all characters except spaces.  If your string contains
a space, that position on the screen will be skipped.  In other
words, it acts kind of like an overlay. This can be handy when
you have text in alternating colors.

I came up with this routine when I designed a program with a
function key display at the bottom of the screen-- the names of
the function keys were one color and the associated definitions
were another color.  It was obvious that the easiest way of
handling that would be to use an "overlay" approach.  The
function key definitions were laid down with XQPrint.  I then
overlaid the line with the function key names in a different
color, using XQPrintOver.

If you need a "solid" space, rather than a "transparent" space,
use CHR$(255) instead of CHR$(32).

   CALL XQPrintOver (St$, Row%, Column%, VAttr%, Page%, Fast%)

St$       string to display
Row%      starting row
Column%   starting column
VAttr%    color/attribute (see CalcAttr)
Page%     display page (unused on MDA/Herc; normally 0)
Fast%     whether to use fast mode (0 no)

