/* Modified by Shamim Islam to demonstrate switch45.ch, switch45.obj        */
/* NOTE: Switch assumes non C_LIKE syntax unless this macro is defined  */
/* Therefore there is no need for a break between individual cases      */
/* Please see switch v4.5 documentation (current revision level) for    */
/* more information                                                     */
/*                                                                      */
/* Original routine: copyright (c) CA Intl (sample directory)           */
/*                                                                      */
#include "switch45.ch"
/*                                                                      */
/* Switch is only compatible with Clipper v5.0 and above                */
/* Non C_LIKE demo                                                      */

/***
*
*  AMPM( <cTime> ) --> cTime
*
*  Convert a time string to 12-hour format
*
*/
FUNCTION AMPM( cTime )

    Local t

    switch(t:=Val(ctime))

        case 0: cTime := "12" + SUBSTR( cTime, 3 ) + " am"

        case 12: cTime += " pm"

        case 24: cTime := "12" + SUBSTR( cTime, 3 ) + " am"

        default: cTime += if(t<12," am"," pm")

   endswitch

RETURN cTime












