/* Modified by Shamim Islam to demonstrate switch45.ch, switch45.obj        */
/* NOTE: Switch assumes non C_LIKE syntax unless this macro is defined  */
/* Therefore there is no need for a break between individual cases      */
/* Please see switch v4.5 documentation (current revision level) for    */
/* more information                                                     */
/*                                                                      */
/* Original routine: copyright (c) CA Intl (sample directory)           */
/*                                                                      */
#include "switch45.ch"
/*                                                                      */
/* Switch is only compatible with Clipper v5.0 and above                */
/* Non C_LIKE demo                                                      */

#include "Inkey.ch"


/***
*
*	READKEY()
*
*	Return a number representing the key pressed to exit from full-screen mode
*
*	Note: Differences between dBASE's READKEY() and Clipper's LASTKEY():
*
*         Exit Key:      dBASE:      Clipper:
*         ---------      ------      --------
*         Backspace         0        no exit
*         ^D, ^L            1        no exit
*         Lt arrow          2        no exit
*         Rt arrow          3        no exit
*         Up arrow          4        no exit
*         Dn arrow          5        no exit
*         PgUp              6          18
*         PgDn              7           3
*         Esc, ^Q          12          27 (Esc only)
*         ^End, ^W         14          23 (^W only)
*         type past end    15        ascii of last char typed
*         Enter            15          13
*         ^Home            33        no exit
*         ^PgUp            34        no exit
*         ^PgDn            35        no exit
*         F1               36        no exit
*
*         dBASE III adds 256 to the exit code if the user changed anything.
*         Clipper uses its UPDATED() function to determine if anything
*         has changed.
*/
FUNCTION READKEY()

    switch LASTKEY()
        CASE K_UP       : SWRETURN  ( 4 + IF( UPDATED(), 256, 0 ))
        CASE K_DOWN     : SWRETURN  ( 5 + IF( UPDATED(), 256, 0 ))
        CASE K_PGUP     : SWRETURN  ( 6 + IF( UPDATED(), 256, 0 ))
        CASE K_PGDN     : SWRETURN  ( 7 + IF( UPDATED(), 256, 0 ))
        CASE K_ESC      : SWRETURN ( 12 + IF( UPDATED(), 256, 0 ))
        CASE K_CTRL_W   : SWRETURN ( 14 + IF( UPDATED(), 256, 0 ))
        CASE K_ENTER    : SWRETURN ( 15 + IF( UPDATED(), 256, 0 ))
        CASE K_CTRL_PGUP: SWRETURN ( 34 + IF( UPDATED(), 256, 0 ))
        CASE K_CTRL_PGDN: SWRETURN ( 35 + IF( UPDATED(), 256, 0 ))
        DEFAULT:
            IF LASTKEY()>=K_SPACE            // Type past end
                SWRETURN ( 15 + IF( UPDATED(), 256, 0 ))
            ENDIF
    endswitch

RETURN ( 0 )
