/*
 * File......: BARBOX.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_BARBOX()
 *  $CATEGORY$
 *      Video
 *  $ONELINER$
 *      Display a box containing a bar area
 *  $SYNTAX$
 *      GT_BarBox( nTop , nLeft , cTitle )
 *  $ARGUMENTS$
 *      nTop   - Top row of box
 *      nLeft  - Left column of box (-1 to centre)
 *      cTitle - Title of box
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      Similar to GT_BarInit(), but doesn't clear the screen.  This function
 *      displays a shadowed box containing the bar area, with the title
 *      written over the top left side of the box
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_lib.ch"

FUNCTION GT_BarBox( nTop , nLeft , cTitle )

/*****************************************************************************
 Purpose - Initialise a moving bar chart box
 Returns - None
 Author  - Martin Colloby
 Created - 05/08/91
******************************************************************************
 Parameters - nTop
              nLeft
              cTitle - Title for screen
 Privates   - None
 Locals     - None
 Externals  - None
*****************************************************************************/

LOCAL nRight
LOCAL nBottom

DEFAULT nTop  TO MAXROW() - 5
DEFAULT nLeft TO 20

nLeft := IIF( nLeft > MAXCOL() - 47 , 20 , nLeft )
nLeft := IIF( nLeft == -1 , 20 , nLeft )

nRight  := nLeft + 46
nBottom := nTop  + 4

cTitle := LEFT( cTitle , 27 )

GT_ColorSet( C_NORMAL )
* Output a blank box with a title
@ nTop , nLeft  CLEAR TO nBottom , nRight
@ nTop , nLeft , nBottom , nRight BOX B_DOUBLE
@ nTop , nLeft + 2 SAY cTitle
GT_Shadow( nTop , nLeft , nBottom , nRight )

* Output the skeleton of the bar chart
@ nBottom - 3 , nLeft + 2 SAY "                                           "
@ nBottom - 2 , nLeft + 2 SAY "Ŀ   "
@ nBottom - 1 , nLeft + 2 SAY "0      20      40      60      80      100%"

RETURN NIL
*
