/*
 * File......: BREAK.C
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

// NOTE: This code has been written for and compiled with Borland C++
//       Version 3.1
//

#include <extend.h>

Boolean GetBreak(void);
void    SetBreak(char);

/*  $DOC$
 *  $FUNCNAME$
 *      GT_BREAK()
 *  $CATEGORY$
 *      Environment
 *  $ONELINER$
 *      Set/Get the DOS break flag.
 *  $SYNTAX$
 *      GT_Break([<lNewSetting>]) --> lOldSetting
 *  $ARGUMENTS$
 *      <lNewSetting> is an optional logical parameter. If true (.T.)
 *      the DOS break flag will be turned on, if false (.F.) it will be
 *      turned off. If not passed GT_Break() just returns the current
 *      setting.
 *  $RETURNS$
 *      The status of the break flag. If a new setting is passed then
 *      the previous setting is returned. If a new setting is not
 *      passed then the current setting is returned.
 *  $DESCRIPTION$
 *      GT_Break() can be used to set and get the status of the DOS break
 *      flag.
 *  $EXAMPLES$
 *      // Set the DOS break flag on.
 *
 *      GT_Break(TRUE)
 *
 *      // Display the current DOS break flag setting.
 *
 *      ? GT_Break()
 *  $SEEALSO$
 *      GT_VERIFY()
 *  $END$
 */

CLIPPER GT_Break()
{
        Boolean OldSetting = GetBreak();

        if (PCOUNT == 1 && ISLOG(1))
        {
                SetBreak((char) _parl(1));
        }
        _retl(OldSetting);
}

/*****************************************************************************
* Function: GetBreak()                                                       *
* Syntax..: Boolean GetBreak(void)                                           *
* Usage...: Internal function to get the break flag.                         *
* By......: David A Pearson                                                  *
*****************************************************************************/

static Boolean GetBreak(void)
{
        asm     Mov     AH,0x33
        asm     Mov     AL,0
        asm     Int     0x21
        return(_DL);
}

/*****************************************************************************
* Function: SetBreak()                                                       *
* Syntax..: void SetBreak(void)                                              *
* Usage...: Internal function to set the break flag.                         *
* By......: David A Pearson                                                  *
*****************************************************************************/

static void SetBreak(char NewSetting)
{
        asm     Mov     AH,0x33
        asm     Mov     AL,1
        asm     Mov     DL,NewSetting
        asm     Int     0x21
}
