/*
 * File......: COLORTON.C
 * Author....: Ian 'UnNamedDude' Day (L&W Computer Services Ltd.)
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Ian Day
 * Date......: 02-25-92
 * Revision..: 1.0
 * Log file..: N/A
 *
 * This is an original work by Ian Day and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * 04-30-93
 * Initial Release
 */

/*  $DOC$
 *  $FUNCNAME$
 *     GT_COLORTON()
 *  $CATEGORY$
 *     Video
 *  $ONELINER$
 *     Converts Clipper colour string to numeric attribute
 *  $SYNTAX$
 *     GT_ColorToN(<cColourString>) --> <nAttribute>
 *  $ARGUMENTS$
 *     <cColourString> is the Clipper colour string to convert to an
 *                     numeric attribute
 *  $RETURNS$
 *     NIL
 *  $DESCRIPTION$
 *     Converts a Clipper colour string into an attribute numeric.  It only
 *     looks at the first parameter of the string.  ie:
 *
 *     nAttribute := GT_ColorToN("W+/B,N/W")
 *                             -This is used
 *
 *     Note: The module also includes a C/ASM callable function equivelant
 *           in the form of:
 *
 *              void int gt_ColorToN (char *string);
 *  $EXAMPLES$
 *     nAttribute := GT_ColorToN("W+/B")     // Result: 31
 *  $SEEALSO$
 *     GT_NTOCOLOR()
 *  $INCLUDE$
 *
 *  $END$
 */

#include "extend.h"
#include "string.h"

int gt_ColorToN (char *string);

/*͸
  Function GT_ColorToN(<cColorString>) --> <nColorAttribute>               
  Purpose  Convert clipper colour string into an attribute number          
  Author   Ian Day                                                         
  Date&Time04-30-93 05:23pm                                                
  ;*/
CLIPPER gt_colorto()
{
   if (ISCHAR(1))
      _retni (gt_ColorToN (_parc (1)));
   else
      _retni (0);
}

int gt_ColorToN (char *string)
{
   int ret = 0, loop, flag = FALSE, len = strlen (string);

   for (loop = 0 ; loop < len; loop++)
      {
      if (string[loop] == ',')      /* End of colour string */
         break;

      if (string[loop] >= 'a' && string[loop] <='z')
         string[loop] -= 32;        /* Upper case please */

      switch (string[loop])
         {
         case '/': flag = TRUE; break;
         case 'W': ret += 7 * (flag ? 16 : 1); break;  /* White */
         case 'B': ret += 1 * (flag ? 16 : 1); break;  /* Blue */
         case 'G': ret += 2 * (flag ? 16 : 1); break;  /* Green */
         case 'R': ret += 4 * (flag ? 16 : 1); break;  /* Red */
         case '+':                                     /* Intense Forground */
         case '*': ret += 8 * (flag ? 16 : 1); break;  /* Intense Background|Blinking */
         }
      }
   return (ret);
}
