/*
 * File......: DATEPACK.PRG
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: 31/03/93
 * Revision..: 1.0
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "GT_Lib.Ch"

/*  $DOC$
 *  $FUNCNAME$
 *      GT_DATEPACK()
 *  $CATEGORY$
 *      Compression
 *  $ONELINER$
 *      Pack a Clipper date value down to 50% it's original size.
 *  $SYNTAX$
 *      GT_DatePack([<dDate>]) --> cPackedDate
 *  $ARGUMENTS$
 *      <dDate> is the date value to be packed. If not passed it defaults
 *      to the system date.
 *  $RETURNS$
 *      A character string that is a packed version of the date.
 *  $DESCRIPTION$
 *      GT_DatePack() can be used to pack a date value into half it's
 *      original size. This can be a help when trying to reduce the size
 *      requirements of your database files.
 *  $EXAMPLES$
 *      // Place a couple of packed date values into a database.
 *
 *      Customer->Entry_Date := GT_DatePack()   // Todays date.
 *      Customer->Call_Date  := GT_DatePack(dCallDate)
 *  $SEEALSO$
 *      GT_DateUnPack()
 *  $END$
 */

function GT_DatePack(dDate)
default dDate to date()
return(chr(day(dDate))+chr(month(dDate))+i2bin(year(dDate)))

/*  $DOC$
 *  $FUNCNAME$
 *      GT_DATEUNPACK()
 *  $CATEGORY$
 *      Compression
 *  $ONELINER$
 *      Un-Pack a packed date created to GT_DatePack().
 *  $SYNTAX$
 *      GT_DateUnPack(<cPackedDate>) --> dDate
 *  $ARGUMENTS$
 *      <cPackedDate> is a date value in it's packed format.
 *  $RETURNS$
 *      A Clipper date value.
 *  $DESCRIPTION$
 *      GT_DateUnPack() is used to create a Clipper date value from a
 *      packed date created with GT_DatePack().
 *  $EXAMPLES$
 *      // Retrieve a date value from a database.
 *
 *      dCallDate := GT_DateUnPack(Customer->Call_Date)
 *  $SEEALSO$
 *      GT_DatePack()
 *  $END$
 */

function GT_DateUnPack(cDate)
local dDate := ctod(NULL)
default cDate to NULL
if !empty(cDate) .and. (len(cDate) == 4)
   dDate := GT_SToD(padl(alltrim(str(bin2w(right(cDate,2)))),4,"0") +;
                    padl(alltrim(str(asc(substr(cDate,2,1)))),2,"0")+;
                    padl(alltrim(str(asc(left(cDate,1)))),2,"0"))
endif
return(dDate)
