/*
 * File......: DAYSMONT.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_DAYSINMONTH()
 *  $CATEGORY$
 *      Date
 *  $ONELINER$
 *      Return the number of days in a month
 *  $SYNTAX$
 *      GT_DaysInMonth( dDate )
 *  $ARGUMENTS$
 *      dDate - Date to be considered
 *  $RETURNS$
 *      Number of days in given month
 *  $DESCRIPTION$
 *      Returns the number of days in a month
 *  $EXAMPLES$
 *      Find the last day in February 1993 :
 *
 *          nDay := GT_DaysInMonth( CTOD( "01/02/93" ) )
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

*
FUNCTION GT_DaysInMonth( dDate )

/*****************************************************************************
 Purpose - Return number of days in month
 Returns - None
 Author  - Martin Colloby
 Created - 27/06/91
******************************************************************************
 Parameters - p_date      - Date to consider
 Privates   - None
 Locals     - None
 Externals  - None
*****************************************************************************/

LOCAL nDays  := 0
LOCAL nMonth := 0
LOCAL lLeap  := .F.

IF VALTYPE( dDate ) != "D"
    GT_Warning( "Invalid date type passed to GT_DaysInMonth ! ")
    RETURN NIL
ENDIF

nMonth := MONTH( dDate )

lLeap := GT_LeapYear( dDate )

DO CASE
    CASE nMonth == 2 .AND. lLeap  ; nDays := 29
    CASE nMonth == 2 .AND. !lLeap ; nDays := 28
    CASE nMonth == 4  ; nDays := 30
    CASE nMonth == 6  ; nDays := 30
    CASE nMonth == 9  ; nDays := 30
    CASE nMonth == 11 ; nDays := 30
    OTHERWISE         ; nDays := 31
ENDCASE

RETURN( nDays )
*
