/*
 * File......: DEFEXT.PRG
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "gt_lib.ch"

/*  $DOC$
 *  $FUNCNAME$
 *      GT_DEFEXT()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Give a file name a default extension.
 *  $SYNTAX$
 *      GT_DefExt(<cFileName>,[<cDefExt>]) --> cNewFileName
 *  $ARGUMENTS$
 *      <cFileName> is the file name to be checked.
 *
 *      <cDefExt> is an optional character paramater which is the
 *      extension to add to the file. This can be in the format of
 *      `.xxx' or just `xxx'. If not supplied the default is "".
 *  $RETURNS$
 *      The file name as it was if it had an extension, or the file name
 *      with the default extension if it didn't have one.
 *  $DESCRIPTION$
 *      GT_DefExt() can be used to supply a default extension to a file.
 *      This can be of use in file i/o functions or for tidying up user
 *      input.
 *  $EXAMPLES$
 *      // Get a file name form the user and default the extension.
 *
 *      cFileName := space(12)
 *      @ 10,10 say "File To Open:" get cFileName picture "!!!!!!!!!!!!"
 *      read
 *      cFileName := GT_DefExt(cFileName,"DBF")
 *  $END$
 */

function GT_DefExt(cFileName,cExt)
local nLoopCount := 0,;
      lExtFound  := FALSE
if valtype(cFileName) == TYPE_CHAR
   default cExt to NULL
   cExt      := alltrim(cExt)
   cFileName := alltrim(cFileName)
   for nLoopCount := len(cFileName) to 1 step -1
      if substr(cFileName,nLoopCount,1) == "\"
         exit
      endif
      if substr(cFileName,nLoopCount,1) == "."
         lExtFound := TRUE
         exit
      endif
   next
   if !lExtFound
      cFileName += if("." $ cExt,cExt,if(!empty(cExt),".",NULL)+cExt)
   endif
endif
return(cFileName)
