/*
 * GT CLIPPER STANDARD HEADER
 *
 * File......: fgetlr.prg
 * Author....: Andy M Leighton
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Andy Leighton
 * Date......: $Date$
 * Revision..: $Revision$
 *
 * This is an original work by Andy Leighton and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *       GT_FGETLR()
 *  $CATEGORY$
 *       File I/O
 *  $ONELINER$
 *       File GET Logical Record.
 *  $SYNTAX$
 *       GT_FGetLR(<fp>, [<cCont>]) --> cBuff
 *  $ARGUMENTS$
 *       <fp>          - file pointer
 *       <cCont>       - continuation character (will default to \ the
 *                       standard C (and UNIX) continuity character)
 *  $RETURNS$
 *       cBuff         - Line of text excluding cont. characters and
 *                       any CHR(13)+CHR(10) pairs
 *  $DESCRIPTION$
 *       Reads the next logical record from stream 'fp' into a
 *       buffer until next unescaped newline, end of file or read
 *       error.
 *       A logical record may span several physical records (lines)
 *       by having each newline escaped with the standard C escape
 *       character (for those who don't know it is the \).  This
 *       character may be overridden by any other character eg. a
 *       semi-colon if you are trying to read clipper source.
 *  $EXAMPLES$
 *       See Test Harness in source.
 *       compile with -DTESt
 *  $CAVEATS$
 *       Poor error handling for files, will return what has been
 *       read up until the file error.
 *
 *       Assumes that CHR(13) does not occur by itself and is always
 *       paired with a CHR(10)
 *  $END$
 */

#include "gt_LIB.ch"
/*
 * TEST HARNESS
 *
 *    Create a file with some normal lines and some continued lines.
 *    and try and read it back and compare with what is expected
 */

#ifdef TEST

function main()

   local aTestFil := { "Line 1",                                ;
                       "Line 2 with a \ continuation \",        ;
                       "more of line 2",                        ;
                       "Line 3 the same file can have ;",       ;
                       "more than one cont. character",         ;
                       "Line 4 a normal line.",                 ;
                       "Line 5" }
   local i
   local cLine    := chr(255)
   local fp

   clear

   fp := fcreate("FGETLR.TST")

/* write out the file, don't bother error checking */

   for i := 1 to len(aTestFil)
      fwrite(fp, aTestFil[i] + chr(13) + chr(10))
   next

   fclose(fp)

   fp := fopen("FGETLR.TST")

   if ferror() == 0

   /* get 1st line */
      cLine := GT_fGetLR(fp)
      ? cLine
      ?

   /* get 2nd line */
      cLine := GT_fGetLR(fp)
      ? cLine
      ?

   /* get 3rd line */
      cLine := GT_fGetLR(fp, ';')
      ? cLine
      ?

   /* get 4th line */
      cLine := GT_fGetLR(fp)
      ? cLine
      ?

   /* get 5th line */
      cLine := GT_fGetLR(fp)
      ? cLine
      ?

      inkey(0)
   endif

return NIL

#endif
/**/
function GT_FGetLR(fp, cCont)

   local cBuff  := ""
   local cTBuff := " "
   local ignore := " "

   default cCont to "\"

   do while fread(fp, @cTBuff, 1) > 0
      if ferror() != 0
         exit
      endif

      if ctBuff == chr(13)

         fread(fp, @ignore, 1)                            // ignore chr(10)

         if substr(cBuff, len(cBuff), 1) == cCont
            cBuff := substr(cBuff, 1, len(cBuff) - 1)     // del cont. char
         else
            exit                                          // got proper EOL
         endif
      else
         cBuff := cBuff + ctBuff
      endif
   enddo

return cBuff
