/*
 * File......: FLOPNAME.C
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: 30/03/93
 * Revision..: 1.0
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

// NOTE: This code has been written for and compiled with Borland C++
//       Version 3.1
//

#include "gt_mem.h"
#include <Extend.H>

/*  $DOC$
 *  $FUNCNAME$
 *      GT_FLOPNAM()
 *  $CATEGORY$
 *      Disk Drive
 *  $ONELINER$
 *      Get the name of the floppy drive on a single floppy system.
 *  $SYNTAX$
 *      GT_FlopNam() --> cFloppyName
 *  $ARGUMENTS$
 *      None.
 *  $RETURNS$
 *      Name of the floppy drive on a single floppy system.
 *  $DESCRIPTION$
 *      GT_FlopNam() can be used to get the name of the floppy drive on
 *      single floppy drive systems.
 *
 *      Some systems have just one floppy drive that can ``act'' as either
 *      drive A: or B:. If your system attempts to access either of these
 *      drives while it is ``acting'' as the other, DOS will display a
 *      message in screen asking the user to place the disk in the drive
 *      and press any key.
 *
 *      Use GT_FlopCnt() to see if this could be a problem. If the machine
 *      has only one floppy drive, use GT_FlopNam() to see if the floppy
 *      drive is acting as A: or B:.
 *  $EXAMPLES$
 *      // This example function will copy a file to the floppy drive.
 *      // Before doing so it checks that the name of the drive is ok.
 *
 *      function CopyToFloppy(cFileName)
 *      local cFloppy := "A:"
 *      if GT_FlopCnt() == 1
 *         cFloppy := GT_FlopNam()+":"
 *      endif
 *      copy (cFileName) to (cFloppy+cFileName)
 *      return(NIL)
 *  $SEEALSO$
 *      GT_FLOPCNT()
 *  $END$
 */

CLIPPER GT_FlopNam()
{
        _retc(_GT_peekb(0x50,0x04) == 1 ? "B" : "A");
}
