/*
 * File......: GTMATH04
 * Author....: Philip Ide
 * BBS.......: Dark Knight Returns
 * Net/Node..:
 * User Name.: Philip Ide
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Philip Ide and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *      GT_HTOD()
 *  $CATEGORY$
 *      Maths
 *  $ONELINER$
 *      Turns a Hex string into a decimal integer
 *  $SYNTAX$
 *      GT_HtoD(<cHex>) --> <nDec>
 *  $ARGUMENTS$
 *      <cHex>  is a hexadecimal number, held as a string
 *  $RETURNS$
 *      <nDec>  is a decimal integer
 *  $DESCRIPTION$
 *      This function allows hex numbers to be converted into decimals.
 *      This allows calculations to be applied on hex values
 *      (e.g. incrementing).
 *  $EXAMPLES$
 *      ? GT_HtoD('FF')       // 255
 *
 *      ? GT_HtoD('F')+1      // 16
 *
 *      ? GT_HtoD('A')*2      // 20
 *
 *  $SEEALSO$
 *      GT_DTOH()
 *  $INCLUDE$
 *
 *  $END$
 */

STATIC hex := '0123456789ABCDEF'

FUNCTION GT_HtoD( n )    // n=hexnum
LOCAL x, y := 0, z, a := 1
FOR x := 1 TO Len(n)                        // once per byte
    z := AT(SubStr(n,-x,1),hex)-1           // get 1 byte, start at far end
    IF x > 1                                // miss this the first time...
       a *= 16                              // exponentiate by 16
    Endif
    y += (a*z)                              // exponentiate the byte,
Next                                        //  add to result.
Return (y)
