/*
 * File......: GTMATH05
 * Author....: Philip Ide
 * BBS.......: Dark Knight Returns
 * Net/Node..:
 * User Name.: Philip Ide
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Philip Ide and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *      GT_DTOH()
 *  $CATEGORY$
 *      Maths
 *  $ONELINER$
 *      Turn a decimal number into hex
 *  $SYNTAX$
 *      GT_DtoH(<n> [,<nLength>]) --> <cHex>
 *  $ARGUMENTS$
 *      <n>       is a decimal integer to convert
 *
 *      <nLength> is the ^bMINIMUM^b length string to return.  If the
 *                return string <cHex> is already longer than this, it
 *                is not truncated.  If shorter, it is padded with leading
 *                zero's.
 *  $RETURNS$
 *      <cHex>    is a string representing a hexadecimal number.
 *  $DESCRIPTION$
 *      This function allows you to convert from decimal to hex easily.  There
 *      are many uses for hex numbres in Clipper.
 *  $EXAMPLES$
 *      ? GT_DtoH(255)         // 'FF'
 *
 *      // This code builds attribute bytes...
 *      //
 *      // Attribute color table:
 *      // 0  = Black       8 = Grey
 *      // 1  = Blue        9 = Bright Blue
 *      // 2  = Green      10 = Bright Green
 *      // 3  = Cyan       11 = Bright Cyan
 *      // 4  = Red        12 = Bright Red
 *      // 5  = Magenta    13 = Bright Magenta
 *      // 6  = Brown      14 = Yellow
 *      // 7  = White      15 = Bright White
 *
 *      cAttribute := SubStr(SaveScreen(0,0,0,0),2,1) // get att. byte
 *      cAttribute := GT_DtoH(Asc(cAttribute))        // make 2bytes
 *
 *      /* now change background byte to bright/blinking white*/
 *      cAttribute := GT_DtoH(15)+SubStr(cAttribute,-1)
 *  $SEEALSO$
 *      GT_HTOD()
 *  $INCLUDE$
 *      gt_lib.ch
 *  $END$
 */

#xcommand DEFAULT <a> TO <y> [,<b> TO <z>] ;
     => <a> := IF(<a> == NIL, <y>, <a>) ;
     [; <b> := IF(<b> == NIL, <z>, <b>)]

STATIC hex := '0123456789ABCDEF'

FUNCTION GT_DtoH(n,l) // n=Decnum, l=length of hex string to return
LOCAL retval := "", x, y

DEFAULT l TO 4
While (n>0)                                 // while we got a number...
   x := n%16                                // get modulus
   n := Int(n/16)                           // remove an exponent
   retval := SubStr(hex, x+1, 1)+retval     // add result to return string
End
l := Max(l,Len(retval))
Return (SubStr(Replicate('0',l)+retval,-l)) // ret padded with leading zero's
