/*
    File......: GT_Capitalise.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 11/03/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 11/03/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *       GT_CAPITALISE()
 *  $CATEGORY$
 *       String
 *  $ONELINER$
 *       Capitalise a string.
 *  $SYNTAX$
 *       GT_Capitalise(<cText>) -> cNewString
 *  $ARGUMENTS$
 *       <cText> is the text to capitalise.
 *  $RETURNS$
 *       cNewString
 *  $DESCRIPTION$
 *       Capitalise a string
 *  $EXAMPLES$
 *       // Capitalise
 *       GT_Capitalise('hello?')  // Hello?
 *  $END$
 */

#include "GtClippe.ch"

FUNCTION GT_Capitalise(cText)

LOCAL cChar := ''
LOCAL cNewString := ''
LOCAL lLastAlpha := .F.
LOCAL nLen := 0
LOCAL nCount := 0

Default cText to ''

nLen := LEN(cText)

FOR nCount := 1 TO nLen

    cChar := SUBSTR(cText,nCount,1)
    IF ISALPHA(cChar)
        cChar := IF(lLastAlpha,LOWER(cChar),UPPER(cChar))
    ENDIF
    cNewString += cChar
    lLastAlpha := ISALPHA(cChar)

NEXT

/*
    End of GT_Capitalise()
*/
RETURN(cNewString)
