/*
 * File......: GT_Cent.prg
 * Author....: Niall Scott
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Niall Scott
 * Date......: 29/6/93
 * Revision..: 1.0
 * Log file..: $Logfile$
 *
 * This is an original work by Niall R Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * Rev 1.0  29/6/93
 * Initial Revision
 */

/*  $DOC$
 *  $FUNCNAME$
 *     GT_CENT()
 *  $CATEGORY$
 *     String
 *  $ONELINER$
 *     Get start of string to center it in an area
 *  $SYNTAX$
 *     nPos := GT_Cent(<cStr>, <nLen>)
 *  $ARGUMENTS$
 *     cStr := String to be centered
 *	   nLen := Length of area to center string in
 *  $RETURNS$
 *     Starting postion
 *  $DESCRIPTION$
 *     To ascertain the the starting position of a string to
 *     enable it to be centered in a given area
 *  $EXAMPLES$
 *	   nPos := GT_Cent( space(20), 40 )
 *     nPos will equal 10
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

FUNCTION GT_Cent( cMsg, nLen )
RETURN (INT( (nLen -Len(cMsg )) /2))
