/*
    File......: GT_DelRec.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 04/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 04/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_DELREC()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Mark a record as deleted
 *  $SYNTAX$
 *      GT_DelRec(<lMove>) => lSuccess
 *  $ARGUMENTS$
 *      <lMove> should the system move to another record
 *      after the deletion ?
 *  $RETURNS$
 *      .T. / .F.
 *  $DESCRIPTION$
 *      Mark a record as deleted
 *  $EXAMPLES$
 *      IF .NOT. GT_DelRec(.T.)
 *          ? 'Error'
 *      ENDIF
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

FUNCTION GT_DelRec(lMoveAfter)

LOCAL lSuccess := .F.

Default lMoveAfter to .F.

//  Lock, delete, unlock
IF GT_Locking(.F.)
    DBDELETE()
    DBUNLOCK()
    lSuccess := DELETED()
ENDIF

// Move to an undeleted record ?
IF lMoveAfter
    DBSKIP(1)
    IF EOF()
        DBGOTOP()
    ENDIF
ENDIF

/*
    End of GT_DelRec()
*/
RETURN(lSuccess)

