/*
    File......: GT_GetPath.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 05/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 05/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_GETPATH()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Check a path to see that it is of a legal format
 *  $SYNTAX$
 *      GT_GetPath(<oGet>)
 *  $ARGUMENTS$
 *      <oGet> is the Get object passed in the :Postblock.
 *  $RETURNS$
 *      lValid
 *  $DESCRIPTION$
 *      Function to act as a validation clause on a get. It
 *      checks the path specification to see that it is of a
 *      legal format.
 *  $EXAMPLES$
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

FUNCTION GT_GetPath(oGet,cPath)

LOCAL cCharacter := ''
LOCAL cLegalString := ;
    'ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_\:'

LOCAL lSuccess := .T.
LOCAL nLength := 0
LOCAL nCount := 0

Default oGet to NIL
Default cPath to ''

//  Get Path if from a get
IF oGet != NIL
    cPath := EVAL(oGet:block,NIL)
ENDIF

nLength :=  LEN(cPath)
lSuccess := (AT(':',cPath) = RAT(':',cPath)) .AND. .NOT. ;
    ('\\' $ cPath)

IF lSuccess
    FOR nCount := 1 TO nLength
        cCharacter := SUBSTR(cPath,nCount,1)
        IF .NOT. (cCharacter $ cLegalString)
            lSuccess := .F.
            EXIT
        ENDIF
    NEXT
ENDIF

IF lSuccess

    IF (SUBSTR(cPath,nLength,1) != '\') .AND. (oGet != NIL)
        EVAL(oGet:Block,cPath + '\')
    ENDIF

ELSE

    GT_Error('Invalid Path. Must be of the form  C:\  or  ' + ;
        'D:\DOS\  or  A:\DIR\TEST\')

ENDIF

/*
    End of GT_GetPath()
*/
RETURN(lSuccess)

