/*
    File......: GT_IsData.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 12/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 12/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_ISDATA()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      IsData validates a number as being ASCII Text.
 *  $SYNTAX$
 *      GT_IsData(<nKey>) -> lData
 *  $ARGUMENTS$
 *      <nKey> is the ASCII value to test.
 *  $RETURNS$
 *      lData
 *  $DESCRIPTION$
 *      IsData validates a number as being ASCII Text.
 *  $EXAMPLES$
 *      // Trim out control chars
 *      IF .NOT. GT_IsData(nKey)
 *          ? 'Error'
 *      ENDIF
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

FUNCTION GT_IsData(nData)
/*
    End of GT_IsData()
*/
RETURN(nData >= 32 .AND. nData < 127 .AND. Chr(nData) != ";")
