/*
    File......: GT_Progress.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 15/03/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 15/03/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *       GT_PROGRESS()
 *  $CATEGORY$
 *       General
 *  $ONELINER$
 *       Display a progress bar and allow Esc option.
 *  $SYNTAX$
 *       GT_Progress(<nCounter>,<lSetup>, ;
 *           <lAllowEsc>,<nMax>) -> lContinue
 *  $ARGUMENTS$
 *       <nCounter> is the value to base the bar on.
 *       <lSetup> Initialise !
 *       <lAllowEsc> Can User Press Esc ?
 *       <nMax> Max value to close on.
 *  $RETURNS$
 *       lContinue
 *  $DESCRIPTION$
 *       Display a progress bar and allow Esc option.
 *  $EXAMPLES$
 *       // Setup allowing Esc
 *       GT_Progress(NIL,.T.,.T.,LASTREC())
 *
 *       // Use it
 *       DO WHILE GT_Progress(RECNO())
 *           Update()
 *       ENDDO
 *  $END$
 */

#include "GtClippe.ch"

FUNCTION GT_Progress(nCounter,lSetup,lAllowEsc,nMax)

STATIC cScreen := ''
STATIC lStop := .F.
STATIC nLeft := 02
STATIC nMid := 0
STATIC nWidth := 0
STATIC nTotal := 0

LOCAL lContinue := .T.

Default nCounter to -1
Default lSetup to .F.
Default lAllowEsc to .F.
Default nMax to 1

DO CASE
    CASE nCounter == nTotal
        // Complete
        IF .NOT. EMPTY(cScreen)
            RESTSCREEN(00,00,MAXROW(),MAXCOL(),cScreen)
            cScreen := ''
        ENDIF

    CASE nCounter >= 0
        // Active
        @ nMid,nLeft SAY REPLICATE('', ;
            INT(nCounter*nWidth))
        IF lStop
            IF INKEY() = K_ESC
                IF .NOT. EMPTY(cScreen)
                    RESTSCREEN(00,00,MAXROW(),MAXCOL(),cScreen)
                    cScreen := ''
                ENDIF
                lContinue := .F.
            ENDIF
        ENDIF

    CASE lSetup
        // Setup
        nMid := INT(MAXROW()/2) - 01
        lStop := lAllowEsc
        nTotal := nMax
        cScreen := SAVESCREEN(00,00,MAXROW(),MAXCOL())

        GT_Window(nMid-01,nLeft-01,nMid+02,MAXCOL()-02, ;
            BOX_SS,SETCOLOR(),IF(lAllowEsc,'EscStop', ;
            'Working:'))

        // Use middle row
        nWidth := MAXCOL() - 05
        @ nMid+01, nLeft SAY REPLICATE('.',nWidth)
        @ nMid+01, nLeft SAY '0'
        @ nMid+01, MAXCOL() - 05 SAY '100'
        @ nMid+01, nLeft + (nWidth/2) - 01 SAY '50'
        nWidth /= nMax

    OTHERWISE

ENDCASE

/*
    End of GT_Progress()
*/
RETURN(lContinue)


