/*
 * File......: PEEKSTRN.C
 * Author....: David Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: 25/03/93
 * Revision..: 1.0
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "GT_Mem.H"
#include <Extend.H>

/*
 *  $DOC$
 *  $FUNCNAME$
 *      GT_PEEKSTN()
 *  $CATEGORY$
 *      Memory
 *  $ONELINER$
 *      Get a specific length string from memory.
 *  $SYNTAX$
 *      GT_PeekStN(<nSegment>,<nOffset>,<nLength>) --> cString
 *  $ARGUMENTS$
 *      <nSegment> is the segment of the string in memory.
 *
 *      <nOffset>  is the offset of the string in memory.
 *
 *      <nLength>  is the length of the string.
 *  $RETURNS$
 *      The string found at <nSegment>:<nOffset>.
 *  $DESCRIPTION$
 *      GT_PeekStN() can be used for getting strings from specific areas
 *      of memory that are not NULL terminated.
 *  $EXAMPLES$
 *      // Print the ROM BIOS date.
 *
 *      ? GT_PeekStN(61440,65525,8)
 *  $SEEALSO$
 *      GT_PEEKSTZ()
 *  $END$
 */

CLIPPER GT_PeekStN()
{
        if (PCOUNT == 3 && ISNUM(1) && ISNUM(2) && ISNUM(3))
        {
                _retclen((char *)_GT_MK_FP(_parni(1),_parni(2)),_parni(3));
        }
        else
        {
                _retc("");
        }
}
