/*
 * File......: PRINSCRN.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_PRINTSCREEN()
 *  $CATEGORY$
 *      Video
 *  $ONELINER$
 *      Output a screen to the printer
 *  $SYNTAX$
 *      GT_PrintScreen( cScreen )
 *  $ARGUMENTS$
 *      cScreen - Screen saved by GT_SaveScr()
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      Outputs a screen to the printer.  The screen should be saved using
 *      the GT Library function GT_SaveScr, and then passed to this function
 *  $EXAMPLES$
 *      GT_PrintScreen( GT_SaveScr( 0 , 0 , MAXROW() , MAXCOL() )
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */
*
FUNCTION GT_PrintScreen( cScreen )

/*****************************************************************************
 Purpose - Dump an area of the screen to the printer
 Returns - None
 Author  - Log
 Created - 18/12/92
******************************************************************************
 Parameters - cScreen - Screen to dump - Must be saved with GT_SaveScr
 Privates   - None
 Locals     - nWidth  - Width of screen area
              nSubscript - Subscript of character
 Externals  - None
*****************************************************************************/

LOCAL nTop    := ASC( SUBSTR( cScreen , 1 , 1 ) )
LOCAL nLeft   := ASC( SUBSTR( cScreen , 2 , 1 ) )
LOCAL nBottom := ASC( SUBSTR( cScreen , 3 , 1 ) )
LOCAL nRight  := ASC( SUBSTR( cScreen , 4 , 1 ) )

LOCAL cLine      := ""
LOCAL nCount     := 0
LOCAL nCount1    := 0
LOCAL nSubscript := 0
LOCAL nWidth     := nRight - nLeft + 1

cScreen := RIGHT( cScreen , LEN( cScreen ) - 4 )

FOR nCount := nTop TO nBottom
    cLine := ""
    FOR nCount1 := nLeft TO nRight + 1
        nSubscript := ( ( nCount1 - nLeft ) * 2 ) + 1
        cLine += SUBSTR( cScreen , ( ( nCount - nTop ) * nWidth * 2 ) + nSubscript , 1 )
    NEXT nCount1

    cLine := LEFT( cLine , LEN( cLine ) - 1 )

    * Print this line
    GT_NextRow( 1 , cLine , 5 )

NEXT nCount

RETURN NIL
*
