/*
 * File......: PSAMEROW.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_SAMEROW()
 *  $CATEGORY$
 *      Printer
 *  $ONELINER$
 *      Output text to the current printer row
 *  $SYNTAX$
 *      GT_SameRow( nColPos , cWhat , nLeftMgn )
 *  $ARGUMENTS$
 *      nColPos  - Colum to output text at
 *      cWhat    - Text to be output
 *      nLeftMgn - Left margin of text
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      Outputs text to the current printer row
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */
*
#include "GT_LIB.CH"

FUNCTION GT_SameRow( nColPos , cWhat , nLeftMgn )

/*****************************************************************************
 Purpose - Output text to printer on current row
 Returns - None
 Author  - Martin Colloby
 Created - March 1992
 Edited  - 25/4/92 by Martin Colloby - Tidied up
******************************************************************************
 Parameters - nColPos  - Colum to output text at
              cWhat    - Text to be output
              nLeftMgn - Left margin of text
 Privates   - None
 Locals     - None
 Externals  - None
*****************************************************************************/

DEFAULT nColPos TO 0
DEFAULT cWhat   TO ""

@ PROW(), PCOL() + ( nLeftMgn + nColPos - PCOL() ) SAY cWhat

RETURN NIL
*
