/*
 * File......: THEWALL.PRG
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "gt_lib.ch"

#define TW_ODD_BRICK  ""
#define TW_EVEN_BRICK ""

/*  $DOC$
 *  $FUNCNAME$
 *      GT_THEWALL()
 *  $CATEGORY$
 *      Video
 *  $ONELINER$
 *      Draws a wall on screen. For Floyd fans only! <g>
 *  $SYNTAX$
 *      GT_TheWall([<nTop>],[<nLeft>],[<nBottom>],[<nRight>],;
 *                 [<cColour>]) --> NIL
 *  $ARGUMENTS$
 *      <nTop>, <nLeft>, <nBottom> and <nRight> are the screen co-ordinates
 *      at which to draw the wall. The defaults are 0, 0, maxrow(), maxcol().
 *
 *      <cColour> is an optional string parameter that is the colour if the
 *      wall. If not supplied this defaults to the current colour.
 *  $RETURNS$
 *      Nothing.
 *  $DESCRIPTION$
 *      GT_TheWall() draws a wall on your screen. It could be nice as a
 *      background for your applications.
 *  $EXAMPLES$
 *      // Draw a wall on the screen fitting inside a border.
 *
 *      dispbox(0,0,maxrow(),maxcol(),"w+/b")
 *      GT_TheWall(1,1,maxrow()-1,maxcol()-1,"w/r")
 *  $END$
 */

function GT_TheWall(nTop,nLeft,nBottom,nRight,cColour)
local nLineCount := 0,;
      cOldColour := setcolor()
default nTop    to 0
default nLeft   to 0
default nBottom to maxrow()
default nRight  to maxcol()
default cColour to setcolor()
dispbegin()
setcolor(cColour)
for nLineCount := nTop to nBottom
   devpos(nLineCount,nLeft)
   if nRight-nLeft > len(TW_ODD_BRICK)
      devout(replic(if((nLineCount % 2) != 0,TW_ODD_BRICK,TW_EVEN_BRICK),int((nRight-nLeft)/len(TW_ODD_BRICK))))
   endif
   devout(substr(if((nLineCount % 2) != 0,TW_ODD_BRICK,TW_EVEN_BRICK),1,(nRight-col())+1))
next
setcolor(cOldColour)
dispend()
return(NIL)
